/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.AssignStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.MaiyouExportOrderCenterSaleOrderVO;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSaleOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_maiyou_sale_order")
public class ExportMaiyouSaleOrderServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ExportMaiyouSaleOrderServiceImpl.class);
    @Resource
    private OrderCenterSaleOrderService orderCenterSaleOrderService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetSaleOrderListPageEsParams params = new GetSaleOrderListPageEsParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSaleOrderListPageEsParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderListPageEsParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.orderCenterSaleOrderService.getSaleOrderListPage((GetSaleOrderListPageEsParams)re));
            PageInfo page = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)page);
            List<Object> list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list = respDtoPageInfo.getList().stream().map(o -> {
                    List stringList = o.getOrderTags().stream().map(OrderTagRecordRespDto::getTagName).collect(Collectors.toList());
                    String strip = StringUtils.strip((String)stringList.toString(), (String)"[]");
                    MaiyouExportOrderCenterSaleOrderVO vo = new MaiyouExportOrderCenterSaleOrderVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setAssignStatus(AssignStatusEnum.getDescByCode(o.getAssignStatus()));
                    try {
                        if (Objects.nonNull(o.getAllotType())) {
                            vo.setAllotTypeStr(AllotTypeEnum.enumOf((String)o.getAllotType()).getDesc());
                        }
                    }
                    catch (Exception e) {
                        vo.setAllotTypeStr(o.getAllotType());
                    }
                    vo.setOrderAddress(o.getOrderAddress().getDetailAddress());
                    vo.setProvince(o.getOrderAddress().getProvince());
                    vo.setCity(o.getOrderAddress().getCity());
                    vo.setDistrict(o.getOrderAddress().getDistrict());
                    vo.setGoodsTotalNum(o.getGoodsTotalNum() == null ? null : o.getGoodsTotalNum().intValue() + "");
                    vo.setAllowSplitFlag(Objects.equals(o.getAllowSplitFlag(), "1") ? "\u662f" : "\u5426");
                    vo.setVolume(o.getVolume());
                    vo.setWeight(vo.getWeight());
                    vo.setDocumentNo(vo.getDocumentNo());
                    vo.setDeliveryLogicalWarehouseName(o.getLogicalWarehouseName());
                    vo.setOnlineFlag(Objects.equals(o.getIsOnline(), 0) ? "\u7ebf\u4e0b" : "\u7ebf\u4e0a");
                    vo.setPhysicsWarehouseName(o.getPhysicsWarehouseName());
                    vo.setDeliveryTime(o.getDeliveryTime());
                    vo.setStoragePlaceName(o.getStoragePlaceName());
                    vo.setAllotOutWarehouseName(o.getAllotOutWarehouseName());
                    vo.setAllotInWarehouseName(o.getAllotInWarehouseName());
                    try {
                        vo.setSaleOrderStatus(SaleOrderStatusEnum.forCode((String)o.getSaleOrderStatus()).getDesc());
                    }
                    catch (Exception e) {
                        logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                        vo.setSaleOrderStatus(o.getSaleOrderStatus());
                    }
                    vo.setSplitSourceOrder(o.getOriginalOrderNo());
                    try {
                        vo.setOrderType(SaleOrderTypeEnum.enumOf((String)o.getOrderType()).getDesc());
                    }
                    catch (Exception e) {
                        logger.debug("\u5bfc\u51fa\u9500\u552e\u5355\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                        vo.setOrderType(o.getOrderType());
                    }
                    return vo;
                }).collect(Collectors.toList());
            }
            page.setList((List)list);
            return page;
        }, params, MaiyouExportOrderCenterSaleOrderVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }
}

