/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.dto.response.PlateformOrderSpExtRepeatRespDto;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportOrderCenterPlatformOrderVO;
import com.dtyunxi.cis.pms.biz.model.GetPlatformOrderCountParams;
import com.dtyunxi.cis.pms.biz.model.GetPlatformOrderGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.OrderCenterGoodsVO;
import com.dtyunxi.cis.pms.biz.model.OrderOperationVO;
import com.dtyunxi.cis.pms.biz.model.PlatformOrderCountVO;
import com.dtyunxi.cis.pms.biz.model.PlatformOrderGoodsNumVO;
import com.dtyunxi.cis.pms.biz.service.OrderCenterPlatformOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.CodeGenerateUtil;
import com.dtyunxi.cis.search.api.dto.response.PlatformOrderVO;
import com.dtyunxi.cis.search.api.query.trade.EsPlatformOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.PlatformOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.GetPlatformOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.PlatformOrderCountRespDto;
import com.dtyunxi.tcbj.api.query.IPlatformOrderReportQueryApi;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.IPlatformOrderAddrApi;
import com.dtyunxi.yundt.cube.center.transform.api.IPlatformOrderSpExtApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformTransformOrderStatus;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAuditOptReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderPcpExtendReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpAuditPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpExtReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpAuditRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpExtRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderAddrQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderSpAuditQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderSpExtQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_platform_order")
public class OrderCenterPlatformOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements OrderCenterPlatformOrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderCenterPlatformOrderServiceServiceImpl.class);
    @Value(value="${platformOrderEsQuery:true}")
    private Boolean platformOrderEsQuery;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private IPlatformOrderAddrQueryApi platformOrderAddrQueryApi;
    @Resource
    private IPlatformOrderItemQueryApi platformOrderItemQueryApi;
    @Resource
    private IPlatformOrderReportQueryApi platformOrderReportQueryApi;
    @Resource
    private EsPlatformOrderQueryApi esPlatformOrderQueryApi;
    @Resource
    private IPcpOrderApi pcpOrderApi;
    @Resource
    private IChannelInventoryExposedApi channelInventoryExposedApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private TradeEsReportQueryApi tradeEsReportQueryApi;
    @Resource
    private IPlatformOrderAddrApi platformOrderAddrApi;
    @Resource
    private IPlatformOrderSpAuditQueryApi platformOrderSpAuditQueryApi;
    @Resource
    private IPlatformOrderSpExtQueryApi platformOrderSpExtQueryApi;
    @Resource
    private IPlatformOrderSpExtApi platformOrderSpExtApi;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;
    public static final String SALE_ORDER_NO_KEY = "platform-sale-order";

    @Override
    public RestResponse<PlatformOrderCountVO> getPlatformOrderCount(@Valid GetPlatformOrderCountParams getPlatformOrderCountParams) {
        String[] orderNos;
        PlatformOrderReqDto reqDto = new PlatformOrderReqDto();
        if (Strings.isNotBlank((String)getPlatformOrderCountParams.getEasOrderNo())) {
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setEasOrderNo(getPlatformOrderCountParams.getEasOrderNo());
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                String saleOrderNos = saleOrderRespDtos.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.joining(","));
                if (Strings.isNotBlank((String)getPlatformOrderCountParams.getOrderNo())) {
                    getPlatformOrderCountParams.setOrderNo(getPlatformOrderCountParams.getOrderNo() + "," + saleOrderNos);
                } else {
                    getPlatformOrderCountParams.setOrderNo(saleOrderNos);
                }
            }
        }
        BeanUtils.copyProperties((Object)getPlatformOrderCountParams, (Object)reqDto);
        if (StringUtils.isNotBlank((CharSequence)getPlatformOrderCountParams.getPlatformCreateTimeStart())) {
            reqDto.setPlatformCreateTimeStart(DateUtil.parse((String)(getPlatformOrderCountParams.getPlatformCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getPlatformOrderCountParams.getPlatformCreateTimeEnd())) {
            reqDto.setPlatformCreateTimeEnd(DateUtil.parse((String)(getPlatformOrderCountParams.getPlatformCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getPlatformOrderCountParams.getSaleOrderCreateTimeStart())) {
            reqDto.setSaleOrderCreateTimeStart(DateUtil.parse((String)(getPlatformOrderCountParams.getSaleOrderCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getPlatformOrderCountParams.getSaleOrderCreateTimeEnd())) {
            reqDto.setSaleOrderCreateTimeEnd(DateUtil.parse((String)(getPlatformOrderCountParams.getSaleOrderCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        reqDto.setReceiveName(getPlatformOrderCountParams.getDeliveryName());
        reqDto.setReceivePhone(getPlatformOrderCountParams.getDeliveryPhone());
        reqDto.setTransferOrderStatus(StringUtils.isNotBlank((CharSequence)getPlatformOrderCountParams.getTransferOrderStatus()) ? Integer.valueOf(getPlatformOrderCountParams.getTransferOrderStatus()) : null);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo()) && (orderNos = RptUtil.regExSplit((String)reqDto.getOrderNo())).length > 1) {
            reqDto.setOrderNoList(Arrays.asList(orderNos));
            reqDto.setOrderNo(null);
        }
        PlatformOrderCountRespDto countRespDto = (PlatformOrderCountRespDto)RestResponseHelper.extractData((RestResponse)this.platformOrderReportQueryApi.queryByCount(reqDto));
        PlatformOrderCountVO vo = new PlatformOrderCountVO();
        if (countRespDto != null) {
            BeanUtils.copyProperties((Object)countRespDto, (Object)vo);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<com.dtyunxi.cis.pms.biz.model.PlatformOrderVO> getPlatformOrderDetail(@ApiParam(value="\u5e73\u53f0\u8ba2\u5355\u53f7") @Valid @RequestParam(value="no", required=false) String no, @ApiParam(value="\u5e73\u53f0\u8ba2\u5355id") @Valid @RequestParam(value="id", required=false) String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5e73\u53f0\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PlatformOrderRespDto platformOrderRespDto = (PlatformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryById(Long.valueOf(id)));
        if (platformOrderRespDto == null) {
            return new RestResponse();
        }
        com.dtyunxi.cis.pms.biz.model.PlatformOrderVO platformOrderVO = new com.dtyunxi.cis.pms.biz.model.PlatformOrderVO();
        PlatformOrderAddrRespDto platformOrderAddrRespDto = (PlatformOrderAddrRespDto)RestResponseHelper.extractData((RestResponse)this.platformOrderAddrQueryApi.queryByOrderId(platformOrderRespDto.getId()));
        this.exchangePOrderRespDto2VO(platformOrderRespDto, platformOrderAddrRespDto, platformOrderVO);
        return new RestResponse((Object)platformOrderVO);
    }

    private void exchangePOrderRespDto2VO(PlatformOrderRespDto platformOrderRespDto, PlatformOrderAddrRespDto platformOrderAddrRespDto, com.dtyunxi.cis.pms.biz.model.PlatformOrderVO platformOrderVO) {
        AddressVO addressVO = new AddressVO();
        CubeBeanUtils.copyProperties((Object)platformOrderAddrRespDto, (Object)platformOrderAddrRespDto, (String[])new String[0]);
        CubeBeanUtils.copyProperties((Object)addressVO, (Object)platformOrderAddrRespDto, (String[])new String[0]);
        CubeBeanUtils.copyProperties((Object)platformOrderVO, (Object)platformOrderRespDto, (String[])new String[0]);
        platformOrderVO.setCreateTime(DateUtil.format((Date)platformOrderRespDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        if (platformOrderRespDto.getUpdateTime() != null) {
            platformOrderVO.setUpdateTime(DateUtil.format((Date)platformOrderRespDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (platformOrderRespDto.getPayTime() != null) {
            platformOrderVO.setPayTime(DateUtil.format((Date)platformOrderRespDto.getPayTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (platformOrderRespDto.getTransferOrderTime() != null) {
            platformOrderVO.setTransferOrderTime(DateUtil.format((Date)platformOrderRespDto.getTransferOrderTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (platformOrderRespDto.getSaleCreateTime() != null) {
            platformOrderVO.setSaleOrderCreateTime(DateUtil.format((Date)platformOrderRespDto.getSaleCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (platformOrderRespDto.getPlatformCreateTime() != null) {
            platformOrderVO.setPlatformCreateTime(DateUtil.format((Date)platformOrderRespDto.getPlatformCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (platformOrderRespDto.getObsoleteTime() != null) {
            platformOrderVO.setObsoleteTime(DateUtil.format((Date)platformOrderRespDto.getObsoleteTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        platformOrderVO.setDeliveryName(platformOrderAddrRespDto.getReceiveName());
        platformOrderVO.setDeliveryPhone(platformOrderAddrRespDto.getReceivePhone());
        addressVO.setDistrict(platformOrderAddrRespDto.getCounty());
        addressVO.setDistrictCode(platformOrderAddrRespDto.getCountyCode());
        addressVO.setDetailAddress(platformOrderAddrRespDto.getReceiveAddress());
        platformOrderVO.setOrderAddress(addressVO);
        platformOrderVO.setPayableAmount(platformOrderRespDto.getPayAmount());
        platformOrderVO.setSkuTotalNum(platformOrderRespDto.getGoodsSkuTotalNum());
        platformOrderVO.setOnlineFlag(new BigDecimal(platformOrderRespDto.getIsOnline()));
        platformOrderVO.setTransferOrderStatus(ParamConverter.convertToString((Object)platformOrderRespDto.getTransferOrderStatus()));
        platformOrderVO.setPayStatus(ParamConverter.convertToString((Object)platformOrderRespDto.getPayStatus()));
        platformOrderVO.setOrderChannelName(platformOrderRespDto.getOrderChannelName());
        platformOrderVO.setDefaultLogicalWarehouseName(platformOrderRespDto.getDefaultWarehouseName());
        platformOrderVO.setChannelWarehouseName(platformOrderRespDto.getChannelWarehouseName());
        if (StringUtils.isNotEmpty((CharSequence)platformOrderVO.getSaleOrderNo())) {
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setSaleOrderNo(platformOrderVO.getSaleOrderNo());
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                String saleOrderStatus = ((SaleOrderRespDto)saleOrderRespDtos.get(0)).getOrderStatus();
                if (Objects.nonNull(SaleOrderStatusEnum.forCode((String)saleOrderStatus))) {
                    platformOrderVO.setOrderStatusName(SaleOrderStatusEnum.forCode((String)saleOrderStatus).getDesc());
                }
                platformOrderVO.setOrderStatus(saleOrderStatus);
            }
        }
        if (Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), platformOrderRespDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), platformOrderRespDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), platformOrderRespDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), platformOrderRespDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.BB_TRANSFER_CLAIM_NOT_REISSUE.getType(), platformOrderRespDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.DS_TRANSFER_CLAIMS_NOT_REISSUE.getType(), platformOrderRespDto.getOrderType())) {
            PlatformOrderSpExtRespDto platformOrderSpExtRespDto = (PlatformOrderSpExtRespDto)RestResponseHelper.extractData((RestResponse)this.platformOrderSpExtQueryApi.queryByPlatformOrderId(platformOrderVO.getId()));
            platformOrderVO.setSpExtRespDto(platformOrderSpExtRespDto);
        }
    }

    @Override
    public RestResponse<PageInfo<OrderCenterGoodsVO>> getPlatformOrderGoodsListPage(@Valid GetPlatformOrderGoodsListPageParams getPlatformOrderGoodsListPageParams) {
        PlatformOrderItemReqDto platformOrderItemReqDto = new PlatformOrderItemReqDto();
        platformOrderItemReqDto.setOrderId(Long.valueOf(getPlatformOrderGoodsListPageParams.getOrderId()));
        if (Objects.nonNull(getPlatformOrderGoodsListPageParams.getReplacementFlag())) {
            platformOrderItemReqDto.setReplacementFlag(getPlatformOrderGoodsListPageParams.getReplacementFlag());
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.platformOrderItemQueryApi.queryByPage(JSON.toJSONString((Object)platformOrderItemReqDto), getPlatformOrderGoodsListPageParams.getPageNum(), getPlatformOrderGoodsListPageParams.getPageSize()));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<OrderCenterGoodsVO> dtoList = new ArrayList<OrderCenterGoodsVO>();
        List list = respDtoPageInfo.getList();
        list.sort(Comparator.comparing(PlatformOrderItemRespDto::getSkuCode));
        this.packageOrderCenterGoodsVO(dtoList, list);
        dtoPageInfo.setList(dtoList);
        log.info("\u6e20\u9053\u5546\u54c1\u4fe1\u606f\u5217\u8868:{}", (Object)((Object)dtoList).toString());
        return new RestResponse((Object)dtoPageInfo);
    }

    private void packageOrderCenterGoodsVO(List<OrderCenterGoodsVO> dtoList, List<PlatformOrderItemRespDto> respDtos) {
        respDtos.forEach(dto -> {
            OrderCenterGoodsVO orderCenterGoodsVO = new OrderCenterGoodsVO();
            CubeBeanUtils.copyProperties((Object)orderCenterGoodsVO, (Object)dto, (String[])new String[0]);
            orderCenterGoodsVO.setGoodsCode(dto.getItemCode());
            orderCenterGoodsVO.setGoodsNum(dto.getItemNum());
            orderCenterGoodsVO.setGoodsSku(dto.getSkuCode());
            orderCenterGoodsVO.setGoodsPrice(dto.getSalePrice());
            orderCenterGoodsVO.setGoodsName(dto.getItemName());
            log.info("\u6279\u6b21\u4fe1\u606f\u4e3a:{}", (Object)dto.getBatchNo());
            orderCenterGoodsVO.setBatch(dto.getBatchNo());
            orderCenterGoodsVO.setIsGiftFlag(new BigDecimal(dto.getGift()));
            dtoList.add(orderCenterGoodsVO);
        });
    }

    @Override
    public RestResponse<PlatformOrderGoodsNumVO> getPlatformOrderGoodsNum(@ApiParam(value="\u5e73\u53f0\u8ba2\u5355\u53f7") @Valid @RequestParam(value="orderNo", required=false) String orderNo, @ApiParam(value="\u5e73\u53f0\u8ba2\u5355id") @Valid @RequestParam(value="id", required=false) String id) {
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<com.dtyunxi.cis.pms.biz.model.PlatformOrderVO>> getPlatformOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) com.dtyunxi.cis.search.api.dto.request.GetPlatformOrderListPageParams getPlatformOrderListPageParams) {
        if (Strings.isNotBlank((String)getPlatformOrderListPageParams.getEasOrderNo())) {
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setEasOrderNo(getPlatformOrderListPageParams.getEasOrderNo());
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                String saleOrderNos = saleOrderRespDtos.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.joining(","));
                if (Strings.isNotBlank((String)getPlatformOrderListPageParams.getOrderNo())) {
                    getPlatformOrderListPageParams.setOrderNo(getPlatformOrderListPageParams.getOrderNo() + "," + saleOrderNos);
                } else {
                    getPlatformOrderListPageParams.setOrderNo(saleOrderNos);
                }
            } else {
                return new RestResponse();
            }
        }
        PageInfo platformOrderRespDtoPageInfo = new PageInfo();
        if (!this.platformOrderEsQuery.booleanValue()) {
            GetPlatformOrderListPageParams params = new GetPlatformOrderListPageParams();
            BeanUtils.copyProperties((Object)getPlatformOrderListPageParams, (Object)params);
            PageInfo pageInfoRestResponse = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tradeEsReportQueryApi.queryPlatformOrderListPage(params));
            CubeBeanUtils.copyProperties((Object)platformOrderRespDtoPageInfo, (Object)pageInfoRestResponse, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList lists = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageInfoRestResponse.getList())) {
                pageInfoRestResponse.getList().forEach(resp -> {
                    PlatformOrderVO vo = new PlatformOrderVO();
                    BeanUtils.copyProperties((Object)resp, (Object)vo);
                    if (ObjectUtil.isNotEmpty((Object)resp.getOrderAddress())) {
                        com.dtyunxi.cis.search.api.dto.response.AddressVO addressVO = new com.dtyunxi.cis.search.api.dto.response.AddressVO();
                        BeanUtils.copyProperties((Object)resp.getOrderAddress(), (Object)addressVO);
                        vo.setOrderAddress(addressVO);
                    }
                    lists.add(vo);
                });
            }
            platformOrderRespDtoPageInfo.setList(lists);
        } else {
            platformOrderRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esPlatformOrderQueryApi.queryPlatformOrderListPage(getPlatformOrderListPageParams));
        }
        if (platformOrderRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)platformOrderRespDtoPageInfo.getList())) {
            Set platformOrderNoSet = platformOrderRespDtoPageInfo.getList().stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getPlatformOrderNo())).map(PlatformOrderVO::getPlatformOrderNo).collect(Collectors.toSet());
            HashMap<String, Set> saleOrderStatusMap = new HashMap<String, Set>();
            HashMap<String, Set> saleOrderEasMap = new HashMap<String, Set>();
            HashMap<String, List> saleOrderEasOutMap = new HashMap<String, List>();
            if (!platformOrderNoSet.isEmpty()) {
                SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
                saleOrderQueryReqDto.setPlatformOrderNoList(new ArrayList(platformOrderNoSet));
                List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
                if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                    for (SaleOrderRespDto dto2 : saleOrderRespDtos) {
                        saleOrderStatusMap.computeIfAbsent(dto2.getPlatformOrderNo(), k -> new HashSet()).add(dto2.getOrderStatus());
                        if (dto2.getEasOrderNo() != null) {
                            saleOrderEasMap.computeIfAbsent(dto2.getPlatformOrderNo(), k -> new HashSet()).add(dto2.getEasOrderNo());
                        }
                        if (dto2.getEasOutOrderNo() == null) continue;
                        saleOrderEasOutMap.computeIfAbsent(dto2.getPlatformOrderNo(), k -> new ArrayList()).add(dto2.getEasOutOrderNo());
                    }
                }
            }
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)platformOrderRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            HashMap<String, Set> finalSaleOrderStatusMap = saleOrderStatusMap;
            HashMap<String, Set> finalEasOrderMap = saleOrderEasMap;
            List list = platformOrderRespDtoPageInfo.getList().stream().map(o -> {
                com.dtyunxi.cis.pms.biz.model.PlatformOrderVO vo = new com.dtyunxi.cis.pms.biz.model.PlatformOrderVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                AddressVO addressVO = new AddressVO();
                if (o.getOrderAddress() != null) {
                    com.dtyunxi.cis.search.api.dto.response.AddressVO orderAddress = o.getOrderAddress();
                    BeanUtils.copyProperties((Object)orderAddress, (Object)addressVO);
                }
                vo.setOrderAddress(addressVO);
                if (o.getPlatformCreateTime() != null) {
                    vo.setPlatformCreateTime(DateUtil.format((Date)o.getPlatformCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (o.getSaleOrderCreateTime() != null) {
                    vo.setSaleOrderCreateTime(DateUtil.format((Date)o.getSaleOrderCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (o.getObsoleteTime() != null) {
                    vo.setObsoleteTime(DateUtil.format((Date)o.getObsoleteTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                if (!finalSaleOrderStatusMap.isEmpty() && finalSaleOrderStatusMap.containsKey(vo.getPlatformOrderNo()) && CollectionUtils.isNotEmpty((Collection)((Collection)finalSaleOrderStatusMap.get(vo.getPlatformOrderNo())))) {
                    Set saleOrderStatusSet = (Set)finalSaleOrderStatusMap.get(vo.getPlatformOrderNo());
                    String saleOrderStatus = String.join((CharSequence)",", saleOrderStatusSet);
                    vo.setOrderStatus(saleOrderStatus);
                    SaleOrderStatusEnum saleOrderStatusEnum = SaleOrderStatusEnum.forCode((String)saleOrderStatus);
                    if (Objects.nonNull(saleOrderStatusEnum)) {
                        vo.setOrderStatusName(saleOrderStatusEnum.getDesc());
                    }
                }
                if (!finalEasOrderMap.isEmpty() && finalEasOrderMap.containsKey(vo.getPlatformOrderNo()) && CollectionUtils.isNotEmpty((Collection)((Collection)finalEasOrderMap.get(vo.getPlatformOrderNo())))) {
                    Set easOrderNoSet = (Set)finalEasOrderMap.get(vo.getPlatformOrderNo());
                    vo.setEasOrderNo(String.join((CharSequence)",", easOrderNoSet));
                }
                if (!saleOrderEasOutMap.isEmpty() && saleOrderEasOutMap.containsKey(vo.getPlatformOrderNo()) && CollectionUtils.isNotEmpty((Collection)((Collection)saleOrderEasOutMap.get(vo.getPlatformOrderNo())))) {
                    List easOutOrderNoList = (List)saleOrderEasOutMap.get(vo.getPlatformOrderNo());
                    vo.setSaleOrderEasOut(String.join((CharSequence)",", easOutOrderNoList));
                }
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> obsoletePlatformOrder(@ApiParam(value="") @Valid @RequestBody(required=false) OrderOperationVO orderOperationVO) {
        orderOperationVO.getOrderIdList().forEach(id -> {
            PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
            pcpOrderReqDto.setId(ParamConverter.convertToLong((Object)id));
            pcpOrderReqDto.setObsoleteReason(orderOperationVO.getCancelReason());
            this.pcpOrderApi.abolishPcpOrder(pcpOrderReqDto);
        });
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> reTransferPlatfromOrder(@ApiParam(value="") @Valid @RequestBody(required=false) OrderOperationVO orderOperationVO) {
        orderOperationVO.getOrderIdList().forEach(id -> this.pcpOrderApi.transformPcpOrder(ParamConverter.convertToLong((Object)id)));
        return new RestResponse();
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        com.dtyunxi.cis.search.api.dto.request.GetPlatformOrderListPageParams params = new com.dtyunxi.cis.search.api.dto.request.GetPlatformOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (com.dtyunxi.cis.search.api.dto.request.GetPlatformOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), com.dtyunxi.cis.search.api.dto.request.GetPlatformOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.getPlatformOrderListPage((com.dtyunxi.cis.search.api.dto.request.GetPlatformOrderListPageParams)re));
            PageInfo page = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)page);
            List<Object> list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list = respDtoPageInfo.getList().stream().map(o -> {
                    ExportOrderCenterPlatformOrderVO vo = new ExportOrderCenterPlatformOrderVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setPlatformOrderNo(o.getPlatformOrderNo());
                    vo.setSaleOrderNo(o.getSaleOrderNo());
                    String transferOrderStatus = "";
                    transferOrderStatus = "0".equals(o.getTransferOrderStatus()) ? "\u6b63\u5e38" : ("1".equals(o.getTransferOrderStatus()) ? "\u5f02\u5e38" : ("2".equals(o.getTransferOrderStatus()) ? "\u4f5c\u5e9f" : ("3".equals(o.getTransferOrderStatus()) ? "\u5df2\u5408\u5e76" : ("-1".equals(o.getTransferOrderStatus()) ? "\u5f85\u4e0a\u6e38\u5ba1\u6838" : ("4".equals(o.getTransferOrderStatus()) ? "\u5f85\u7269\u6d41\u521d\u5ba1" : ("5".equals(o.getTransferOrderStatus()) ? "\u5f85\u4ed3\u5e93\u590d\u5ba1" : ("6".equals(o.getTransferOrderStatus()) ? "\u5df2\u5ba1\u6838" : o.getTransferOrderStatus())))))));
                    vo.setTransferOrderStatus(transferOrderStatus);
                    vo.setExceptionReason(o.getExceptionReason());
                    vo.setCustomerName(o.getCustomerName());
                    vo.setOrderChannelName(o.getOrderChannelName());
                    vo.setChannelWarehouseName(o.getChannelWarehouseName());
                    vo.setRegionCode(o.getRegionCode());
                    vo.setRegionName(o.getRegionName());
                    vo.setOrganizationName(o.getOrganizationName());
                    vo.setSellerRemark(o.getSellerRemark());
                    if (o.getSaleCreateTime() == null) {
                        vo.setSaleOrderCreateTime("");
                    } else {
                        vo.setSaleOrderCreateTime(DateUtil.format((Date)o.getSaleCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                    vo.setOnlineFlag(Objects.equals(o.getIsOnline(), 0) ? "\u5426" : "\u662f");
                    if (o.getPlatformCreateTime() == null) {
                        vo.setPlatformCreateTime("");
                    } else {
                        vo.setPlatformCreateTime(o.getPlatformCreateTime());
                    }
                    if (o.getCreateTime() == null) {
                        vo.setCreateTime("");
                    } else {
                        vo.setCreateTime(o.getCreateTime());
                    }
                    vo.setSaleChannel(o.getSaleChannel());
                    vo.setCustomerCode(o.getCustomerCode());
                    vo.setDeliveryName(o.getDeliveryName());
                    vo.setDeliveryPhone(o.getDeliveryPhone());
                    vo.setProvince(o.getOrderAddress().getProvince());
                    vo.setCity(o.getOrderAddress().getCity());
                    vo.setDistrict(o.getOrderAddress().getDistrict());
                    vo.setOrderAddress(o.getOrderAddress().getDetailAddress());
                    vo.setGoodsTotalNum(new BigDecimal(o.getGoodsTotalNum().intValue()));
                    vo.setCreateTime(o.getCreateTime());
                    try {
                        vo.setSaleOrderStatus(SaleOrderStatusEnum.forCode((String)o.getOrderStatus()).getDesc());
                    }
                    catch (Exception e) {
                        log.debug("\u5bfc\u51fa\u6e20\u9053\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                        vo.setSaleOrderStatus(o.getOrderStatus());
                    }
                    try {
                        vo.setOrderType(SaleOrderTypeEnum.enumOf((String)o.getOrderType()).getDesc());
                    }
                    catch (Exception e) {
                        log.debug("\u5bfc\u51fa\u9500\u552e\u5355\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                        vo.setOrderType(o.getOrderType());
                    }
                    return vo;
                }).collect(Collectors.toList());
            }
            page.setList((List)list);
            return page;
        }, params, ExportOrderCenterPlatformOrderVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    private void getParams(com.dtyunxi.cis.search.api.dto.request.GetPlatformOrderListPageParams params, PlatformOrderRespDto queryDto) {
        BeanUtils.copyProperties((Object)params, (Object)queryDto);
        queryDto.setPlatformOrderNo(params.getOrderNo());
    }

    @Override
    public RestResponse<Object> modifyPlatformOrderAddress(@ApiParam(value="") @Valid @RequestBody(required=false) PlatformOrderAddrReqDto reqDto) {
        this.platformOrderAddrApi.modifyPlatformOrderAddr(reqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> logisticsAudit(@ApiParam(value="") @Valid @RequestBody(required=false) PlatformOrderAuditOptReqDto reqDto) {
        RestResponseHelper.checkOrThrow((RestResponse)this.pcpOrderApi.logisticsAudit(reqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> warehouseAudit(@ApiParam(value="") @Valid @RequestBody(required=false) PlatformOrderAuditOptReqDto reqDto) {
        RestResponseHelper.checkOrThrow((RestResponse)this.pcpOrderApi.warehouseAudit(reqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<PlatformOrderSpAuditRespDto>> getPlatformOrderAuditPage(@RequestBody PlatformOrderSpAuditPageQueryReqDto queryReqDto) {
        PageInfo platformOrderSpAuditRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.platformOrderSpAuditQueryApi.queryByPage(queryReqDto));
        return new RestResponse((Object)platformOrderSpAuditRespDtoPageInfo);
    }

    @Override
    public RestResponse<Object> updateTargetLogistics(@ApiParam(value="") @Valid @RequestBody(required=false) PlatformOrderSpExtReqDto modifyReqDto) {
        RestResponseHelper.checkOrThrow((RestResponse)this.platformOrderSpExtApi.updateTargetLogistics(modifyReqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<PlatformOrderRespDto> addPlatformSpOrder(PcpOrderReqDto pcpOrderReqDto) {
        pcpOrderReqDto.setOrderChannelCode("CSP");
        pcpOrderReqDto.setCanSplitFlag(Integer.valueOf(0));
        if (!SaleOrderTypeEnum.CLAIM_POSTING.getType().equals(pcpOrderReqDto.getOrderType()) && !SaleOrderTypeEnum.CLAIM_REISSUE.getType().equals(pcpOrderReqDto.getOrderType())) {
            return null;
        }
        pcpOrderReqDto.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_4.getCode()));
        String platformOrderNo = this.codeGenerateUtil.generateNoWithSplit("SPSGD", 6, "_");
        pcpOrderReqDto.setPlatformOrderNo(platformOrderNo);
        AssertUtil.assertNotBlank(pcpOrderReqDto.getDefaultWarehouseCode(), "\u7d22\u8d54\u8ba2\u5355\u6307\u5b9a\u53d1\u8d27\u4ed3\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Map channelWarehouseMap = (Map)RestResponseHelper.extractData((RestResponse)this.channelWarehouseApi.queryByLogicWarehouseCodes((Set)Sets.newHashSet((Object[])new String[]{pcpOrderReqDto.getDefaultWarehouseCode()})));
        AssertUtil.assertNotCollection((Collection)channelWarehouseMap.get(pcpOrderReqDto.getDefaultWarehouseCode()), "\u7d22\u8d54\u8ba2\u5355\u6307\u5b9a\u53d1\u8d27\u4ed3\u5bf9\u5e94\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (CollectionUtils.isNotEmpty((Collection)((Collection)channelWarehouseMap.get(pcpOrderReqDto.getDefaultWarehouseCode())))) {
            log.info("\u7d22\u8d54\u8ba2\u5355\u83b7\u53d6\u6e20\u9053\u4ed3\u5e93\u4fe1\u606f\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)channelWarehouseMap), (Object)pcpOrderReqDto.getDefaultWarehouseCode());
            List channelWarehouseRespDtos = (List)channelWarehouseMap.get(pcpOrderReqDto.getDefaultWarehouseCode());
            pcpOrderReqDto.setChannelWarehouseId(((ChannelWarehouseRespDto)channelWarehouseRespDtos.get(0)).getId());
            pcpOrderReqDto.setChannelWarehouseCode(((ChannelWarehouseRespDto)channelWarehouseRespDtos.get(0)).getWarehouseCode());
            pcpOrderReqDto.setChannelWarehouseName(((ChannelWarehouseRespDto)channelWarehouseRespDtos.get(0)).getWarehouseName());
        }
        String saleOrderNo = this.getSaleOrderNo(pcpOrderReqDto.getPlatformOrderNo());
        pcpOrderReqDto.setSaleOrderNo(saleOrderNo);
        PreemptDto csInventoryOperateReqDto = new PreemptDto();
        csInventoryOperateReqDto.setExternalOrderNo(pcpOrderReqDto.getPlatformOrderNo());
        csInventoryOperateReqDto.setSourceType("orderType");
        csInventoryOperateReqDto.setSourceNo(saleOrderNo);
        csInventoryOperateReqDto.setDetails(this.getItemDtoList(pcpOrderReqDto));
        log.info("\u65b0\u589e\u9500\u552e\u5355\u9884\u5360\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)csInventoryOperateReqDto));
        if (SaleOrderTypeEnum.CLAIM_REISSUE.getType().equals(pcpOrderReqDto.getOrderType())) {
            RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApi.preempt(csInventoryOperateReqDto));
        }
        PlatformOrderPcpExtendReqDto orderExt = new PlatformOrderPcpExtendReqDto();
        String msgStr = JSON.toJSONString((Object)pcpOrderReqDto);
        orderExt.setCspExtendJson(msgStr);
        BeanUtil.copyProperties((Object)pcpOrderReqDto, (Object)orderExt, (String[])new String[0]);
        PlatformOrderAddrReqDto orderAddrDto = new PlatformOrderAddrReqDto();
        BeanUtil.copyProperties((Object)pcpOrderReqDto.getPlatformOrderAddrReqDto(), (Object)orderAddrDto, (String[])new String[0]);
        PlatformOrderSpExtReqDto platformOrderSpExtReqDto = new PlatformOrderSpExtReqDto();
        BeanUtil.copyProperties((Object)pcpOrderReqDto.getSpExtReqDto(), (Object)platformOrderSpExtReqDto, (String[])new String[0]);
        List itemList = pcpOrderReqDto.getItemReqDtoList().stream().map(items -> {
            PlatformOrderItemReqDto dto = new PlatformOrderItemReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            if (Objects.isNull(dto.getPrice())) {
                dto.setPrice(dto.getSaleUnitPrice());
                if (!Objects.isNull(dto.getEasPromotionActivityAmount())) {
                    dto.setPrice(dto.getSalePrice().divide(dto.getEasPromotionActivityAmount(), 2, RoundingMode.HALF_UP));
                }
            }
            dto.setCspItemExtendJson(JSON.toJSONString((Object)items));
            BigDecimal taxRate = BigDecimal.ZERO;
            if (Objects.nonNull(items.getTaxRate())) {
                taxRate = new BigDecimal(items.getTaxRate().toString());
            }
            dto.setTaxRate(taxRate);
            if (Objects.nonNull(items.getOrderTotalAmount())) {
                dto.setEasOrderTotalAmount(new BigDecimal(items.getOrderTotalAmount().toString()));
            }
            return dto;
        }).collect(Collectors.toList());
        List itemReplaceFlagList = itemList.stream().map(i -> {
            PlatformOrderItemReqDto replaceDto = new PlatformOrderItemReqDto();
            BeanUtil.copyProperties((Object)i, (Object)replaceDto, (String[])new String[0]);
            replaceDto.setReplacementFlag(Integer.valueOf(1));
            return replaceDto;
        }).collect(Collectors.toList());
        itemList.addAll(itemReplaceFlagList);
        pcpOrderReqDto.setItemReqDtoList(itemList);
        pcpOrderReqDto.setCustomerId(platformOrderSpExtReqDto.getApplyClaimLogisticsId());
        pcpOrderReqDto.setCustomerCode(platformOrderSpExtReqDto.getApplyClaimLogisticsCode());
        pcpOrderReqDto.setCustomerName(platformOrderSpExtReqDto.getApplyClaimLogisticsName());
        pcpOrderReqDto.setEasOrgId(pcpOrderReqDto.getOrganizationCode());
        pcpOrderReqDto.setPlatformOrderPcpExtendReqDto(orderExt);
        pcpOrderReqDto.setPlatformOrderAddrReqDto(orderAddrDto);
        pcpOrderReqDto.setSpExtReqDto(platformOrderSpExtReqDto);
        pcpOrderReqDto.setPlatformCreateTime(new Date());
        StringBuffer sb = new StringBuffer();
        sb.append(platformOrderSpExtReqDto.getClaimLogisticsNo());
        if (Strings.isNotBlank((String)platformOrderSpExtReqDto.getClaimLogisticsReason())) {
            sb.append(" _ ").append(platformOrderSpExtReqDto.getClaimLogisticsReason());
        }
        sb.append(" _ ").append(platformOrderSpExtReqDto.getApplyClaimLogisticsName());
        if (platformOrderSpExtReqDto.getClaimLogisticsDate() != null) {
            String claimLogisticsDate = ParamConverter.convertToString((Object)DateUtil.format((Date)platformOrderSpExtReqDto.getClaimLogisticsDate(), (String)DatePattern.DATE_PATTERN.getPattern()));
            sb.append(" _ ").append(claimLogisticsDate);
        }
        pcpOrderReqDto.setSellerRemark(sb.toString());
        Long orderNo = (Long)RestResponseHelper.extractData((RestResponse)this.pcpOrderApi.savePcpOrder(pcpOrderReqDto));
        PlatformOrderRespDto respDto = new PlatformOrderRespDto();
        BeanUtil.copyProperties((Object)pcpOrderReqDto, (Object)respDto, (String[])new String[0]);
        respDto.setId(orderNo);
        return new RestResponse((Object)respDto);
    }

    private String getSaleOrderNo(String platformOrderNo) {
        String redisKey = platformOrderNo;
        String saleOrderNo = (String)this.cacheService.getCache(SALE_ORDER_NO_KEY, redisKey, String.class);
        if (StringUtils.isEmpty((CharSequence)saleOrderNo)) {
            saleOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.getSaleOrderNo());
            this.cacheService.setCache(SALE_ORDER_NO_KEY, redisKey, (Object)saleOrderNo);
            return saleOrderNo;
        }
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setSaleOrderNo(saleOrderNo);
        saleOrderQueryReqDto.setOrderStatus(SaleOrderStatusEnum.OBSOLETE.getCode());
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
        if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
            log.info("\u6709\u5df2\u4f5c\u5e9f\u72b6\u6001\u9500\u552e\u5355\uff0c\u91cd\u65b0\u751f\u6210\u5355\u636e\u53f7");
            saleOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.getSaleOrderNo());
            this.cacheService.setCache(SALE_ORDER_NO_KEY, redisKey, (Object)saleOrderNo);
        }
        return saleOrderNo;
    }

    private List<OperationDetailDto> getItemDtoList(PcpOrderReqDto pcpOrderReqDto) {
        ArrayList itemList = Lists.newArrayList();
        List platfromOrderItems = pcpOrderReqDto.getItemReqDtoList();
        for (PlatformOrderItemReqDto item : platfromOrderItems) {
            OperationDetailDto cargoReqDto = new OperationDetailDto();
            if (Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), pcpOrderReqDto.getOrderType())) continue;
            cargoReqDto.setNum(item.getItemNum());
            cargoReqDto.setSkuCode(item.getSkuCode());
            cargoReqDto.setWarehouseCode(pcpOrderReqDto.getChannelWarehouseCode());
            itemList.add(cargoReqDto);
        }
        return itemList;
    }

    @Override
    public RestResponse<PlateformOrderSpExtRepeatRespDto> getPlatformOrderSameSpList(PlatformOrderSpExtReqDto queryReqDto) {
        Integer pageNum = 1;
        Integer pageSize = 100;
        PlateformOrderSpExtRepeatRespDto repeatDto = new PlateformOrderSpExtRepeatRespDto();
        String filter = ObjectHelper.bean2Json((Object)queryReqDto);
        PlatformOrderSpExtRespDto platformOrderSpExtDto = new PlatformOrderSpExtRespDto();
        HashMap mapResp = new HashMap();
        PageInfo platformOrderSpExtPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.platformOrderSpExtQueryApi.queryByPage(filter, pageNum, pageSize));
        if (CollectionUtils.isNotEmpty((Collection)platformOrderSpExtPageInfo.getList())) {
            Map spExtLossInsuranceMap;
            PageInfo spExtLossInsurancePageInfo;
            platformOrderSpExtDto = (PlatformOrderSpExtRespDto)platformOrderSpExtPageInfo.getList().get(0);
            repeatDto.setPlatformOrderId(platformOrderSpExtDto.getPlatformOrderId());
            repeatDto.setPlatformOrderNo(platformOrderSpExtDto.getPlatformOrderNo());
            if (StringUtils.isNotBlank((CharSequence)platformOrderSpExtDto.getLossInsuranceCompany()) && platformOrderSpExtDto.getLossInsuranceCompany().length() > 10) {
                repeatDto.setConsignmentNo(platformOrderSpExtDto.getLossInsuranceCompany());
                PlatformOrderSpExtReqDto queryByLossInsuranceReq = new PlatformOrderSpExtReqDto();
                queryByLossInsuranceReq.setLossInsuranceCompany(platformOrderSpExtDto.getLossInsuranceCompany());
                String lossInsuranceFilter = ObjectHelper.bean2Json((Object)queryByLossInsuranceReq);
                spExtLossInsurancePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.platformOrderSpExtQueryApi.queryByPage(lossInsuranceFilter, pageNum, pageSize));
                if (CollectionUtils.isNotEmpty((Collection)spExtLossInsurancePageInfo.getList())) {
                    spExtLossInsuranceMap = spExtLossInsurancePageInfo.getList().stream().collect(Collectors.toMap(PlatformOrderSpExtRespDto::getPlatformOrderId, Function.identity()));
                    mapResp.putAll(spExtLossInsuranceMap);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)platformOrderSpExtDto.getClaimLogisticsNo()) && platformOrderSpExtDto.getClaimLogisticsNo().length() > 10) {
                repeatDto.setClaimLogisticsNo(platformOrderSpExtDto.getClaimLogisticsNo());
                PlatformOrderSpExtReqDto queryByClaimLogisticsReq = new PlatformOrderSpExtReqDto();
                queryByClaimLogisticsReq.setClaimLogisticsNo(platformOrderSpExtDto.getClaimLogisticsNo());
                String claimLogisticsFilter = ObjectHelper.bean2Json((Object)queryByClaimLogisticsReq);
                spExtLossInsurancePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.platformOrderSpExtQueryApi.queryByPage(claimLogisticsFilter, pageNum, pageSize));
                if (CollectionUtils.isNotEmpty((Collection)spExtLossInsurancePageInfo.getList())) {
                    spExtLossInsuranceMap = spExtLossInsurancePageInfo.getList().stream().collect(Collectors.toMap(PlatformOrderSpExtRespDto::getPlatformOrderId, Function.identity()));
                    mapResp.putAll(spExtLossInsuranceMap);
                }
            }
        }
        mapResp.remove(platformOrderSpExtDto.getPlatformOrderId());
        ArrayList<PlatformOrderSpExtRespDto> listResp = new ArrayList<PlatformOrderSpExtRespDto>();
        listResp.addAll(mapResp.values());
        repeatDto.setSpExtList(listResp);
        if (CollectionUtils.isNotEmpty(listResp)) {
            repeatDto.setRepeatFlag(true);
        }
        return new RestResponse((Object)repeatDto);
    }
}

