/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.export.IExportExcelHelper;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.MaiyouWarehouseAreaMappingExportVo;
import com.dtyunxi.cis.pms.biz.model.MaiyouWarehouseAreaMappingImportVo;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.MaiyouWarehouseAreaMappingTypeEnum;
import com.yunxi.dg.base.center.inventory.api.entity.IMaiyouWarehouseAreaMappingApi;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingPageReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_maiyou_warehouse_area_mapping")
public class ExportMaiyouWareHouseAreaMappingServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ExportMaiyouWareHouseAreaMappingServiceImpl.class);
    @Resource
    private IMaiyouWarehouseAreaMappingApi maiyouWarehouseAreaMappingApi;
    @Resource
    private IExportExcelHelper exportExcelHelper;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        logger.info("\u9ea6\u4f18\u53d1\u8d27\u89c4\u5219\u914d\u7f6e\u5bfc\u5165\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)result.getList()));
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), MaiyouWarehouseAreaMappingImportVo.class);
        HashSet<String> logicalNameMap = new HashSet<String>();
        for (MaiyouWarehouseAreaMappingImportVo v : list) {
            if (StringUtils.isNotBlank((CharSequence)v.getTransitLogicalWarehouse())) {
                logicalNameMap.add(v.getTransitLogicalWarehouse());
            }
            if (StringUtils.isNotBlank((CharSequence)v.getTransferInLogicalWarehouse())) {
                logicalNameMap.add(v.getTransferInLogicalWarehouse());
            }
            if (!StringUtils.isNotBlank((CharSequence)v.getTransferOutLogicalWarehouse())) continue;
            logicalNameMap.add(v.getTransferOutLogicalWarehouse());
        }
        ArrayList<MaiyouWarehouseAreaMappingImportVo> errorList = new ArrayList<MaiyouWarehouseAreaMappingImportVo>();
        ArrayList<MaiyouWarehouseAreaMappingDto> saveList = new ArrayList<MaiyouWarehouseAreaMappingDto>();
        CsPhysicsWarehouseParamQueryDto queryPhysicsWarehouseDto = new CsPhysicsWarehouseParamQueryDto();
        queryPhysicsWarehouseDto.setWarehouseStatus("enable");
        List physicswarehouseList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedQueryApi.queryParam(queryPhysicsWarehouseDto));
        Map<Object, Object> physicsWarehouseMapByName = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)physicswarehouseList)) {
            physicsWarehouseMapByName = physicswarehouseList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseName, Function.identity(), (k1, k2) -> k1));
            logger.info("\u83b7\u53d6\u7269\u7406\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)physicswarehouseList));
        }
        Map<Object, Object> logicWarehouseMapByName = new HashMap();
        if (CollectionUtils.isNotEmpty(logicalNameMap)) {
            CsLogicWarehouseParamQueryDto logicWarehouseParamQueryDto = new CsLogicWarehouseParamQueryDto();
            logicWarehouseParamQueryDto.setWarehouseStatus("enable");
            logicWarehouseParamQueryDto.setWarehouseNameList(new ArrayList(logicalNameMap));
            List logicWarehouseList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(logicWarehouseParamQueryDto));
            logicWarehouseMapByName = Optional.ofNullable(logicWarehouseList).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(w -> w.getWarehouseName(), Function.identity(), (k1, k2) -> k1));
            logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(logicWarehouseMapByName));
        }
        for (MaiyouWarehouseAreaMappingImportVo importVo : list) {
            MaiyouWarehouseAreaMappingDto reqDto = new MaiyouWarehouseAreaMappingDto();
            StringBuffer errorMsg = new StringBuffer();
            if (ObjectUtil.isEmpty((Object)importVo.getStatusStr())) {
                errorMsg.append("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!Objects.equals(importVo.getStatusStr(), "\u7981\u7528") && !Objects.equals(importVo.getStatusStr(), "\u542f\u7528")) {
                errorMsg.append("\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u586b\u5199'\u542f\u7528/\u7981\u7528';");
            } else {
                reqDto.setStatus(Integer.valueOf(Objects.equals(importVo.getStatusStr(), "\u7981\u7528") ? 0 : 1));
            }
            if (StringUtils.isBlank((CharSequence)importVo.getTypeStr())) {
                errorMsg.append("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!Objects.equals(importVo.getTypeStr(), "bc\u8de8\u7ec4\u7ec7\u8c03\u62e8")) {
                errorMsg.append("\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8bf7\u586b\u5199'bc\u8de8\u7ec4\u7ec7\u8c03\u62e8';");
            } else {
                reqDto.setType(Objects.equals(importVo.getTypeStr(), "bc\u8de8\u7ec4\u7ec7\u8c03\u62e8") ? "maiyou_bc_allot" : "maiyou_cc_allot");
            }
            if (StringUtils.isBlank((CharSequence)importVo.getTransferInLogicalWarehouse())) {
                errorMsg.append("\u8c03\u5165\u903b\u8f91\u4ed3\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!logicWarehouseMapByName.containsKey(importVo.getTransferInLogicalWarehouse())) {
                errorMsg.append("\u8c03\u5165\u903b\u8f91\u4ed3" + importVo.getTransferInLogicalWarehouse() + "\u4e0d\u5b58\u5728;");
            } else {
                CsLogicWarehousePageRespDto transferInLogicalWarehouse = (CsLogicWarehousePageRespDto)logicWarehouseMapByName.get(importVo.getTransferInLogicalWarehouse());
                reqDto.setTransferInLogicalWarehouse(transferInLogicalWarehouse.getWarehouseName());
                reqDto.setTransferInLogicalWarehouseCode(transferInLogicalWarehouse.getWarehouseCode());
            }
            if (StringUtils.isBlank((CharSequence)importVo.getTransitLogicalWarehouse())) {
                errorMsg.append("\u4e2d\u8f6c\u903b\u8f91\u4ed3\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!logicWarehouseMapByName.containsKey(importVo.getTransitLogicalWarehouse())) {
                errorMsg.append("\u4e2d\u8f6c\u903b\u8f91\u4ed3" + importVo.getTransitLogicalWarehouse() + "\u4e0d\u5b58\u5728;");
            } else {
                CsLogicWarehousePageRespDto transitLogicalWarehouse = (CsLogicWarehousePageRespDto)logicWarehouseMapByName.get(importVo.getTransitLogicalWarehouse());
                reqDto.setTransitLogicalWarehouse(transitLogicalWarehouse.getWarehouseName());
                reqDto.setTransitLogicalWarehouseCode(transitLogicalWarehouse.getWarehouseCode());
            }
            if (StringUtils.isBlank((CharSequence)importVo.getDeliveryPhysicalWarehouse()) && StringUtils.isBlank((CharSequence)importVo.getTransferOutLogicalWarehouse())) {
                errorMsg.append("\u53d1\u8d27\u7269\u7406\u4ed3\u548c\u8c03\u51fa\u903b\u8f91\u4ed3\u4e0d\u80fd\u90fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getDeliveryPhysicalWarehouse())) {
                if (!physicsWarehouseMapByName.containsKey(importVo.getDeliveryPhysicalWarehouse())) {
                    errorMsg.append("\u53d1\u8d27\u7269\u7406\u4ed3:" + importVo.getDeliveryPhysicalWarehouse() + "\u4e0d\u5b58\u5728;");
                } else {
                    CsPhysicsWarehousePageRespDto physicsWarehouse = (CsPhysicsWarehousePageRespDto)physicsWarehouseMapByName.getOrDefault(importVo.getDeliveryPhysicalWarehouse(), new CsPhysicsWarehousePageRespDto());
                    reqDto.setDeliveryPhysicalWarehouse(physicsWarehouse.getWarehouseName());
                    reqDto.setDeliveryPhysicalWarehouseCode(physicsWarehouse.getWarehouseCode());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getTransferOutLogicalWarehouse())) {
                if (!logicWarehouseMapByName.containsKey(importVo.getTransferOutLogicalWarehouse())) {
                    errorMsg.append("\u8c03\u51fa\u903b\u8f91\u4ed3:" + importVo.getTransferOutLogicalWarehouse() + "\u4e0d\u5b58\u5728;");
                } else {
                    CsLogicWarehousePageRespDto transferOutLogicWarehouse = (CsLogicWarehousePageRespDto)logicWarehouseMapByName.getOrDefault(importVo.getTransferOutLogicalWarehouse(), new CsLogicWarehousePageRespDto());
                    reqDto.setTransferOutLogicalWarehouse(transferOutLogicWarehouse.getWarehouseName());
                    reqDto.setTransferOutLogicalWarehouseCode(transferOutLogicWarehouse.getWarehouseCode());
                }
            }
            if ((StringUtils.isNotBlank((CharSequence)importVo.getTransferInLogicalWarehouse()) || StringUtils.isNotBlank((CharSequence)importVo.getTransferOutLogicalWarehouse())) && Objects.equals(importVo.getTransferInLogicalWarehouse(), importVo.getTransferOutLogicalWarehouse())) {
                errorMsg.append("\u8c03\u5165\u903b\u8f91\u4ed3\u548c\u8c03\u51fa\u903b\u8f91\u4ed3\u4e0d\u80fd\u90fd\u76f8\u540c;");
            }
            if ((StringUtils.isNotBlank((CharSequence)importVo.getTransferInLogicalWarehouse()) || StringUtils.isNotBlank((CharSequence)importVo.getTransitLogicalWarehouse())) && Objects.equals(importVo.getTransferInLogicalWarehouse(), importVo.getTransitLogicalWarehouse())) {
                errorMsg.append("\u8c03\u5165\u903b\u8f91\u4ed3\u548c\u4e2d\u8f6c\u903b\u8f91\u4ed3\u4e0d\u80fd\u90fd\u76f8\u540c;");
            }
            if ((StringUtils.isNotBlank((CharSequence)importVo.getTransferOutLogicalWarehouse()) || StringUtils.isNotBlank((CharSequence)importVo.getTransitLogicalWarehouse())) && Objects.equals(importVo.getTransferOutLogicalWarehouse(), importVo.getTransitLogicalWarehouse())) {
                errorMsg.append("\u8c03\u51fa\u903b\u8f91\u4ed3\u548c\u4e2d\u8f6c\u903b\u8f91\u4ed3\u4e0d\u80fd\u90fd\u76f8\u540c;");
            }
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                importVo.setMsg(errorMsg.toString());
                errorList.add(importVo);
                continue;
            }
            saveList.add(reqDto);
        }
        HashMap<String, ArrayList<MaiyouWarehouseAreaMappingImportVo>> resultMap = new HashMap<String, ArrayList<MaiyouWarehouseAreaMappingImportVo>>();
        resultMap.put("errorList", errorList);
        resultMap.put("saveList", saveList);
        return resultMap;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        logger.info("\u53d1\u8d27\u89c4\u5219\u914d\u7f6e\u5bfc\u5165\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("errorList");
        ArrayList errorList = new ArrayList();
        if (saveObj != null) {
            List list = (List)saveObj;
            list.forEach(dto -> {
                try {
                    RestResponseHelper.extractData((RestResponse)this.maiyouWarehouseAreaMappingApi.add(dto));
                }
                catch (Exception e) {
                    MaiyouWarehouseAreaMappingImportVo vo = new MaiyouWarehouseAreaMappingImportVo();
                    BeanUtils.copyProperties((Object)dto, (Object)((Object)vo));
                    vo.setTypeStr(Objects.equals(dto.getType(), MaiyouWarehouseAreaMappingTypeEnum.MAIYOU_BC_ALLOT.getCode()) ? MaiyouWarehouseAreaMappingTypeEnum.MAIYOU_BC_ALLOT.getDesc() : dto.getType());
                    vo.setStatusStr(ObjectUtil.isNotEmpty((Object)dto.getStatus()) && dto.getStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
                    vo.setMsg("\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
                    errorList.add(vo);
                }
            });
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List list = (List)msgObj;
            errorList.addAll(list);
        }
        if (CollectionUtil.isNotEmpty(errorList)) {
            String excelName = String.format("%s%s", "\u9ea6\u4f18\u53d1\u8d27\u89c4\u5219\u914d\u7f6e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, MaiyouWarehouseAreaMappingImportVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u53d1\u8d27\u89c4\u5219\u914d\u7f6e\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        MaiyouWarehouseAreaMappingPageReqDto queryPageReqDto = new MaiyouWarehouseAreaMappingPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            queryPageReqDto = (MaiyouWarehouseAreaMappingPageReqDto)JSON.parseObject((String)commonReqDto.getFilter(), MaiyouWarehouseAreaMappingPageReqDto.class);
        }
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.maiyouWarehouseAreaMappingApi.page(queryPageReqDto));
        ArrayList exportVoList = new ArrayList();
        pageInfo.getList().forEach(item -> {
            MaiyouWarehouseAreaMappingExportVo vo = new MaiyouWarehouseAreaMappingExportVo();
            BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
            vo.setStatusStr(ObjectUtil.isNotEmpty((Object)item.getStatus()) && item.getStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
            vo.setTypeStr(MaiyouWarehouseAreaMappingTypeEnum.getByCode((String)item.getCode()).getDesc());
        });
        return this.exportExcelHelper.doExport(exportVoList, MaiyouWarehouseAreaMappingExportVo.class, commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        MaiyouWarehouseAreaMappingPageReqDto queryPageReqDto = new MaiyouWarehouseAreaMappingPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            queryPageReqDto = (MaiyouWarehouseAreaMappingPageReqDto)JSON.parseObject((String)commonReqDto.getFilter(), MaiyouWarehouseAreaMappingPageReqDto.class);
        }
        queryPageReqDto.setPageSize(Integer.valueOf(1));
        queryPageReqDto.setPageNum(Integer.valueOf(1));
        return Math.toIntExact(Optional.ofNullable(this.maiyouWarehouseAreaMappingApi.page(queryPageReqDto).getData()).map(PageSerializable::getTotal).orElse(0L));
    }
}

