/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.DeriveTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ConsignmentOrderReturnVo;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ConsignmentOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IConsignmentOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_export_waybill_list")
public class ExportWaybillListReportServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    @Resource
    private IConsignmentOrderQueryApi iConsignmentOrderQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        ConsignmentOrderQueryReqDto getLogicalInventoryListPageParams = new ConsignmentOrderQueryReqDto();
        getLogicalInventoryListPageParams = (ConsignmentOrderQueryReqDto)JSON.parseObject((String)commonReqDto.getFilter(), ConsignmentOrderQueryReqDto.class);
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            RestResponse pageInfoRestResponse = this.iConsignmentOrderQueryApi.queryWaybillListPage(re);
            PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
            PageInfo im = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)im);
            ArrayList list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list.addAll(respDtoPageInfo.getList().stream().map(o -> {
                    ConsignmentOrderReturnVo vo = new ConsignmentOrderReturnVo();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setBusinessType(Optional.ofNullable(o.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                        if (ObjectUtils.isNotEmpty((Object)DeriveTypeEnum.getMsgByCode(o.getBusinessType()))) {
                            return String.valueOf(DeriveTypeEnum.getMsgByCode(o.getBusinessType()));
                        }
                        return o.getBusinessType();
                    }).orElse(""));
                    return vo;
                }).collect(Collectors.toList()));
            }
            im.setList((List)list);
            return im;
        }, getLogicalInventoryListPageParams, ConsignmentOrderReturnVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        ConsignmentOrderQueryReqDto getLogicalInventoryListPageParams = new ConsignmentOrderQueryReqDto();
        getLogicalInventoryListPageParams = (ConsignmentOrderQueryReqDto)JSON.parseObject((String)commonReqDto.getFilter(), ConsignmentOrderQueryReqDto.class);
        getLogicalInventoryListPageParams.setPageSize(Integer.valueOf(1));
        getLogicalInventoryListPageParams.setPageNum(Integer.valueOf(1));
        RestResponse pageInfoRestResponse = this.iConsignmentOrderQueryApi.queryWaybillListPage(getLogicalInventoryListPageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }
}

