/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.BizExceptionCode;
import com.dtyunxi.cis.pms.biz.model.CancelSourcingOrderParams;
import com.dtyunxi.cis.pms.biz.model.GetSourcingOrderGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetSourcingOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OriginalOrderGoodVO;
import com.dtyunxi.cis.pms.biz.model.SourcingGoodsVO;
import com.dtyunxi.cis.pms.biz.model.SourcingOrderVO;
import com.dtyunxi.cis.pms.biz.service.OrderCenterSourcingOrderService;
import com.dtyunxi.cis.search.api.dto.request.EsSourceOrderListPageParams;
import com.dtyunxi.cis.search.api.dto.response.EsSourceOrderVO;
import com.dtyunxi.cis.search.api.query.source.EsSourceOrderQueryApi;
import com.dtyunxi.cube.center.source.api.IOrderOptApi;
import com.dtyunxi.cube.center.source.api.dto.request.CancelSourceOrderReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.OrderItemResultReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderAddrRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.query.IOrderItemQueryApi;
import com.dtyunxi.cube.center.source.api.query.IOrderItemResultQueryApi;
import com.dtyunxi.cube.center.source.api.query.IOrderQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPcpOrderChannelQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class OrderCenterSourcingOrderServiceServiceImpl
implements OrderCenterSourcingOrderService {
    @Resource
    private EsSourceOrderQueryApi esSourceOrderQueryApi;
    @Resource
    private IOrderQueryApi sourceOrderQueryApi;
    @Resource
    private IOrderItemQueryApi sourceOrderItemQueryApi;
    @Resource
    private IOrderOptApi sourceOrderOptApi;
    @Resource
    private IPcpOrderChannelQueryApi pcpOrderChannelQueryApi;
    @Resource
    private IOrderItemResultQueryApi orderItemResultQueryApi;

    @Override
    public RestResponse<Object> cancelSourcingOrder(@ApiParam(value="") @Valid @RequestBody(required=false) CancelSourcingOrderParams cancelSourcingOrderParams) {
        if (ObjectUtil.isEmpty((Object)cancelSourcingOrderParams)) {
            throw new BizException(BizExceptionCode.REQUEST_PARAM_CANT_EMPTY.getCode(), BizExceptionCode.REQUEST_PARAM_CANT_EMPTY.getMsg());
        }
        List<String> sourcingOrderIds = cancelSourcingOrderParams.getSourcingOrderIds();
        for (String sourcingOrderId : sourcingOrderIds) {
            CancelSourceOrderReqDto cancelSourceOrderReqDto = new CancelSourceOrderReqDto();
            cancelSourceOrderReqDto.setSgOrderId(Long.valueOf(sourcingOrderId));
            cancelSourceOrderReqDto.setCancelRemark(cancelSourcingOrderParams.getCancelRemark());
            this.sourceOrderOptApi.cancelSourceOrder(cancelSourceOrderReqDto);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<SourcingOrderVO> getSourcingOrderDetail(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        Date createTime;
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException(BizExceptionCode.ID_CANT_EMPTY.getCode(), BizExceptionCode.ID_CANT_EMPTY.getMsg());
        }
        SourceOrderResultRespDto sourceOrderResultRespDto = (SourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)this.sourceOrderQueryApi.queryDetailById(Long.valueOf(id)));
        SourcingOrderVO sourcingOrderVO = new SourcingOrderVO();
        BeanUtil.copyProperties((Object)sourceOrderResultRespDto, (Object)sourcingOrderVO, (String[])new String[0]);
        sourcingOrderVO.setSourcingOrderNo(sourceOrderResultRespDto.getSgOrderNo());
        sourcingOrderVO.setBillType(sourceOrderResultRespDto.getLinkOrderType());
        sourcingOrderVO.setSourcingStatus(sourceOrderResultRespDto.getSgStatus());
        sourcingOrderVO.setLogicalWarehouseName(sourceOrderResultRespDto.getLinkOrderLogicWarehouseName());
        sourcingOrderVO.setCancelMessage(sourceOrderResultRespDto.getSgFailResultDesc());
        sourcingOrderVO.setSaleOrderNo(sourceOrderResultRespDto.getLinkOrderNo());
        OrderAddrRespDto orderAddrRespDto = Optional.ofNullable(sourceOrderResultRespDto.getOrderAddrRespDto()).orElse(null);
        String province = Optional.ofNullable(orderAddrRespDto).map(OrderAddrRespDto::getProvince).orElse("");
        String city = Optional.ofNullable(orderAddrRespDto).map(OrderAddrRespDto::getCity).orElse("");
        String country = Optional.ofNullable(orderAddrRespDto).map(OrderAddrRespDto::getCounty).orElse("");
        String recieveAddr = Optional.ofNullable(orderAddrRespDto).map(OrderAddrRespDto::getReceiveAddress).orElse("");
        sourcingOrderVO.setOrderAddress(String.format("%s%s%s%s", province, city, country, recieveAddr));
        sourcingOrderVO.setOrderChannelCode(sourceOrderResultRespDto.getLinkOrderChannelCode());
        sourcingOrderVO.setOrderChannelName(sourceOrderResultRespDto.getLinkOrderChannelName());
        sourcingOrderVO.setExternalOrderNo(sourceOrderResultRespDto.getLinkPlatformOrderNo());
        sourcingOrderVO.setCustomerCode("");
        sourcingOrderVO.setCustomerName(sourceOrderResultRespDto.getLinkOrderCustomerName());
        BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)JSON.parseObject((String)sourceOrderResultRespDto.getLinkOrderSnapshot(), BizSaleOrderRespDto.class);
        Long platformId = Optional.ofNullable(bizSaleOrderRespDto).map(SaleOrderRespDto::getPlatformOrderId).orElse(null);
        sourcingOrderVO.setPlatformOrderId(ParamConverter.convertToString((Object)platformId));
        sourcingOrderVO.setPlatformOrderNo(sourceOrderResultRespDto.getLinkPlatformOrderNo());
        Date updateTime = sourceOrderResultRespDto.getUpdateTime();
        if (ObjectUtil.isNotEmpty((Object)updateTime)) {
            sourcingOrderVO.setUpdateTime(DateUtil.format((Date)updateTime, (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (ObjectUtil.isNotEmpty((Object)(createTime = sourceOrderResultRespDto.getCreateTime()))) {
            sourcingOrderVO.setCreateTime(DateUtil.format((Date)createTime, (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        List orderItemResultRespDtoList = sourceOrderResultRespDto.getOrderItemResultRespDtoList();
        List orderItemRespDtoList = sourceOrderResultRespDto.getOrderItemRespDtoList();
        List<OriginalOrderGoodVO> originalOrderGoodVOArrayList = new ArrayList<OriginalOrderGoodVO>();
        if (CollectionUtil.isNotEmpty((Collection)orderItemRespDtoList)) {
            originalOrderGoodVOArrayList = orderItemRespDtoList.stream().map(o -> {
                OriginalOrderGoodVO vo = new OriginalOrderGoodVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setGoodsName(o.getItemName());
                vo.setGoodsCode(o.getItemCode());
                vo.setGoodsLongCode(o.getItemSkuCode());
                vo.setBillType(o.getItemBatchNo());
                vo.setLogicalWarehouseName(o.getItemDeliveryLogicWarehouseName());
                vo.setTotalQuantity(o.getItemNum() == null ? 0 : o.getItemNum().intValue());
                vo.setDocumentNo(o.getLinkOrderNo());
                vo.setGiftFlag(o.getItemGiftType() == null ? null : new BigDecimal(o.getItemGiftType()));
                return vo;
            }).collect(Collectors.toList());
        }
        sourcingOrderVO.setOriginalOrderGoods(originalOrderGoodVOArrayList);
        List<SourcingGoodsVO> sourcingOrderGoods = new ArrayList<SourcingGoodsVO>();
        if (CollectionUtil.isNotEmpty((Collection)orderItemResultRespDtoList) && CollectionUtil.isNotEmpty((Collection)orderItemRespDtoList)) {
            Map<Long, OrderItemRespDto> orderItemRespDtoMap = orderItemRespDtoList.stream().collect(Collectors.toMap(OrderItemRespDto::getLinkOrderItemId, o -> o, (e1, e2) -> e1));
            sourcingOrderGoods = orderItemResultRespDtoList.stream().map(o -> {
                SourcingGoodsVO vo = new SourcingGoodsVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                OrderItemRespDto orderItemRespDto = Optional.ofNullable(orderItemRespDtoMap.get(o.getLinkOrderItemId())).orElse(new OrderItemRespDto());
                vo.setGoodsName(orderItemRespDto.getItemName());
                vo.setGoodsCode(orderItemRespDto.getItemCode());
                vo.setGoodsLongCode(o.getLinkItemSkuCode());
                vo.setBillType(o.getDeliveryItemBatchNo());
                vo.setLogicalWarehouseName(o.getDeliveryLogicWarehouseName());
                vo.setTotalQuantity(o.getDeliveryItemNum() == null ? 0 : o.getDeliveryItemNum().intValue());
                vo.setDocumentNo(o.getLinkOrderNo());
                return vo;
            }).collect(Collectors.toList());
        }
        sourcingOrderVO.setSourcingOrderGoods(sourcingOrderGoods);
        return new RestResponse((Object)sourcingOrderVO);
    }

    @Override
    public RestResponse<PageInfo<SourcingGoodsVO>> getSourcingOrderGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSourcingOrderGoodsListPageParams getSourcingOrderGoodsListPageParams) {
        if (ObjectUtil.isEmpty((Object)getSourcingOrderGoodsListPageParams)) {
            throw new BizException(BizExceptionCode.REQUEST_PARAM_CANT_EMPTY.getCode(), BizExceptionCode.REQUEST_PARAM_CANT_EMPTY.getMsg());
        }
        Integer pageNum = getSourcingOrderGoodsListPageParams.getPageNum();
        Integer pageSize = getSourcingOrderGoodsListPageParams.getPageSize();
        String sourcingOrderId = getSourcingOrderGoodsListPageParams.getSourcingOrderId();
        OrderItemResultReqDto orderItemResultReqDto = new OrderItemResultReqDto();
        orderItemResultReqDto.setSgOrderId(Long.valueOf(sourcingOrderId));
        PageInfo orderItemResultRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.orderItemResultQueryApi.queryByPage(JSON.toJSONString((Object)orderItemResultReqDto), pageNum, pageSize));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)orderItemResultRespDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)orderItemResultRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = orderItemResultRespDtoPageInfo.getList().stream().map(o -> {
            SourcingGoodsVO vo = new SourcingGoodsVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsName("\u5546\u54c1\u540d\u79f0");
            vo.setGoodsCode("\u5546\u54c1\u7f16\u7801");
            vo.setGoodsLongCode(o.getLinkItemSkuCode());
            vo.setBillType(o.getDeliveryItemBatchNo());
            vo.setLogicalWarehouseName(o.getDeliveryLogicWarehouseName());
            vo.setTotalQuantity(o.getDeliveryItemNum() == null ? 0 : o.getDeliveryItemNum().intValue());
            vo.setDocumentNo(o.getLinkOrderNo());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<SourcingOrderVO>> getSourcingOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetSourcingOrderListPageParams getSourcingOrderListPageParams) {
        EsSourceOrderListPageParams params = new EsSourceOrderListPageParams();
        BeanUtils.copyProperties((Object)getSourcingOrderListPageParams, (Object)params);
        params.setKeyword(getSourcingOrderListPageParams.getOrderNo());
        params.setLinkOrderType(getSourcingOrderListPageParams.getBillType());
        params.setCreateBeginTime(getSourcingOrderListPageParams.getCreateStartTime());
        params.setCreateEndTime(getSourcingOrderListPageParams.getCreateEndTime());
        params.setSgStatus(getSourcingOrderListPageParams.getSourcingStatus());
        params.setLinkOrderCustomerName(getSourcingOrderListPageParams.getCustomerName());
        params.setLinkOrderLogicWarehouseName(getSourcingOrderListPageParams.getLogicalWarehouseName());
        if (StringUtils.isNotEmpty((CharSequence)getSourcingOrderListPageParams.getOrderChannelCode())) {
            params.setLinkOrderChannelCodeList((List)Lists.newArrayList((Object[])new String[]{getSourcingOrderListPageParams.getOrderChannelCode()}));
        }
        PageInfo esSourceOrderVOPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esSourceOrderQueryApi.querySourceOrderListPage(params));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)esSourceOrderVOPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        PcpOrderChannelReqDto reqDto = new PcpOrderChannelReqDto();
        reqDto.setChannelCodes(esSourceOrderVOPageInfo.getList().stream().map(EsSourceOrderVO::getLinkOrderChannelCode).collect(Collectors.toList()));
        List channelList = (List)RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelQueryApi.queryByShopChannel(reqDto));
        HashMap orderChannelMap = CollectionUtils.isNotEmpty((Collection)channelList) ? channelList.stream().collect(Collectors.toMap(PcpOrderChannelRespDto::getChannelCode, PcpOrderChannelRespDto::getChannelName, (e1, e2) -> e1)) : Maps.newHashMap();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)esSourceOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = esSourceOrderVOPageInfo.getList().stream().map(o -> {
            SourcingOrderVO vo = new SourcingOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setSourcingOrderNo(o.getSgOrderNo());
            vo.setSaleOrderNo(o.getLinkOrderNo());
            vo.setPlatformOrderNo(o.getLinkPlatformOrderNo());
            vo.setExternalOrderNo(o.getLinkOrderNo());
            vo.setBillType(o.getLinkOrderType());
            vo.setSourcingStatus(o.getSgStatus());
            vo.setPlatformOrderId(o.getPlatformOrderId());
            vo.setTotalQuantity(o.getLinkOrderTotalItemNum() != null ? o.getLinkOrderTotalItemNum().intValue() : 0);
            vo.setOrderChannelCode(o.getLinkOrderChannelCode());
            vo.setOrderChannelName(orderChannelMap.get(o.getLinkOrderChannelCode()) == null ? o.getLinkOrderChannelCode() : (String)orderChannelMap.get(o.getLinkOrderChannelCode()));
            vo.setCustomerName(o.getLinkOrderCustomerName());
            vo.setLogicalWarehouseName(o.getLinkOrderLogicWarehouseName());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            BigDecimal totalQuantity = BigDecimal.ZERO;
            SourceOrderResultRespDto sourceOrderResultRespDto = (SourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)this.sourceOrderQueryApi.queryDetailById(o.getId()));
            if (Objects.nonNull(sourceOrderResultRespDto) && CollectionUtil.isNotEmpty((Collection)sourceOrderResultRespDto.getOrderItemRespDtoList())) {
                totalQuantity = sourceOrderResultRespDto.getOrderItemRespDtoList().stream().map(OrderItemRespDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            vo.setTotalQuantity(totalQuantity.intValue());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }
}

