/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportQualityInspectionReportMsgDto;
import com.dtyunxi.cis.pms.biz.model.ImportQualityInspectionReportVO;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IQualityInspectionDataApi;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOrderReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.QualityInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionDataReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOrderReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInspectionDataRespDto;
import com.dtyunxi.tcbj.api.query.IInspectionReleaseOrderQueryReportApi;
import com.dtyunxi.tcbj.api.query.IQualityInfoQueryApi;
import com.dtyunxi.tcbj.api.query.IQualityInspectionDataQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_quality_inspection_data")
public class QualityInspectionReportServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    @Resource
    private IQualityInspectionDataQueryApi qualityInspectionDataQueryApi;
    @Resource
    private IQualityInspectionDataApi qualityInspectionDataApi;
    @Resource
    private IInspectionReleaseOrderQueryReportApi inspectionReleaseOrderQueryReportApi;
    @Resource
    private IQualityInfoQueryApi qualityInfoQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportQualityInspectionReportVO.class);
        HashSet codeSet = Sets.newHashSet();
        ArrayList queryList = Lists.newArrayList();
        list.forEach(i -> {
            QualityInspectionDataReqDto queryDto = new QualityInspectionDataReqDto();
            queryDto.setLongCode(i.getItemLongCode());
            queryDto.setBatch(i.getBatch());
            queryList.add(queryDto);
        });
        Map<String, List<InspectionReleaseOrderReportRespDto>> releaseOrderMap = this.queryInspectionReleaseOrder(list);
        Map<String, QualityInspectionDataRespDto> qualityDataMap = this.queryQualityDataMap(queryList);
        Set<String> qualitySet = this.queryQualityListMap(queryList);
        ArrayList updateList = Lists.newArrayList();
        ArrayList msgList = Lists.newArrayList();
        ArrayList resultList = Lists.newArrayList((Object[])new String[]{"\u5408\u683c", "\u4e0d\u5408\u683c"});
        for (ImportQualityInspectionReportVO i2 : list) {
            String uniqueKey = i2.getUniqueKey();
            ImportQualityInspectionReportMsgDto msgDto = new ImportQualityInspectionReportMsgDto();
            BeanUtils.copyProperties((Object)((Object)i2), (Object)((Object)msgDto));
            QualityInspectionDataRespDto queryRespDto = qualityDataMap.get(uniqueKey);
            if (!qualitySet.contains(uniqueKey)) {
                msgDto.setMsg("\u5546\u54c1\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728");
                continue;
            }
            if (codeSet.contains(uniqueKey)) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("\u6570\u636e\u91cd\u590d");
                    continue;
                }
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u6570\u636e\u91cd\u590d"));
                continue;
            }
            codeSet.add(uniqueKey);
            if (!resultList.contains(i2.getResult())) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("\u62a5\u544a\u7ed3\u679c\u683c\u5f0f\u9519\u8bef");
                    continue;
                }
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u62a5\u544a\u7ed3\u679c\u683c\u5f0f\u9519\u8bef"));
                continue;
            }
            if (queryRespDto != null && StringUtils.isNotBlank((CharSequence)queryRespDto.getReportResultUrl()) && Objects.equals(2, queryRespDto.getSource())) {
                if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
                    msgDto.setMsg("\u6279\u6b21\u5df2\u6709\u62a5\u544a\u7ed3\u679c");
                    continue;
                }
                msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), "\u6279\u6b21\u5df2\u6709\u62a5\u544a\u7ed3\u679c"));
                continue;
            }
            if (ObjectUtils.isNotEmpty(releaseOrderMap.get(i2.getUniqueKey()))) {
                msgDto.setMsg("\u5b58\u5728\u5df2\u653e\u884c\u7684\u653e\u884c\u5355");
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)msgDto.getMsg())) {
                msgList.add(msgDto);
                continue;
            }
            QualityInspectionDataReqDto reqDto = new QualityInspectionDataReqDto();
            if (queryRespDto == null || StringUtils.isBlank((CharSequence)queryRespDto.getExternalId())) {
                reqDto.setExternalId(UUID.randomUUID().toString().replace("-", ""));
            } else {
                reqDto.setExternalId(queryRespDto.getExternalId());
            }
            reqDto.setBatch(i2.getBatch());
            reqDto.setLongCode(i2.getItemLongCode());
            reqDto.setReportResult(i2.getResult());
            reqDto.setReportTime(i2.getReportTime());
            updateList.add(reqDto);
        }
        HashMap map = Maps.newHashMap();
        map.put("saveList", updateList);
        map.put("msgList", msgList);
        return map;
    }

    private Map<String, List<InspectionReleaseOrderReportRespDto>> queryInspectionReleaseOrder(List<ImportQualityInspectionReportVO> reportVOList) {
        InspectionReleaseOrderReportReqDto reqDto = new InspectionReleaseOrderReportReqDto();
        reqDto.setOrderStatus(Integer.valueOf(1));
        reqDto.setSkuCodeList(reportVOList.stream().map(ImportQualityInspectionReportVO::getItemLongCode).collect(Collectors.toList()));
        reqDto.setBatchList(reportVOList.stream().map(ImportQualityInspectionReportVO::getBatch).collect(Collectors.toList()));
        List list = (List)RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderQueryReportApi.queryByParams(reqDto));
        Map<String, List<InspectionReleaseOrderReportRespDto>> map = new HashMap<String, List<InspectionReleaseOrderReportRespDto>>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            map = list.stream().collect(Collectors.groupingBy(e -> e.getBatch() + "_" + e.getSkuCode()));
        }
        return map;
    }

    private Set<String> queryQualityListMap(List<QualityInspectionDataReqDto> queryList) {
        QualityInfoReqDto qualityInfoReqDto = new QualityInfoReqDto();
        qualityInfoReqDto.setBatchs(queryList.stream().map(QualityInspectionDataReqDto::getBatch).distinct().collect(Collectors.toList()));
        qualityInfoReqDto.setLongCodes(queryList.stream().map(QualityInspectionDataReqDto::getLongCode).distinct().collect(Collectors.toList()));
        FetchDataService fetchDataService = req -> (PageInfo)this.qualityInfoQueryApi.infoDetailPage(req).getData();
        return fetchDataService.fetchAll(qualityInfoReqDto).stream().map(r -> String.format("%s_%s", r.getBatch(), r.getLongCode())).collect(Collectors.toSet());
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List updateList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(updateList = (List)saveObj))) {
            this.qualityInspectionDataApi.batchSave(updateList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5f85\u68c0\u8f6c\u5408\u683c\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportQualityInspectionReportMsgDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private Map<String, QualityInspectionDataRespDto> queryQualityDataMap(List<QualityInspectionDataReqDto> queryList) {
        RestResponse listRestResponse = this.qualityInspectionDataQueryApi.queryByList(queryList);
        return ((List)RestResponseHelper.extractData((RestResponse)listRestResponse)).stream().collect(Collectors.toMap(QualityInspectionDataRespDto::getUniqueKey, Function.identity(), (k1, k2) -> k1));
    }
}

