/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInventoryLockReportVO;
import com.dtyunxi.cis.pms.biz.model.GetInventoryLockReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.InventoryLockReportVO;
import com.dtyunxi.cis.pms.biz.model.LockInventoryParams;
import com.dtyunxi.cis.pms.biz.service.ReportCenterInventoryReportInventoryLockReportService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsLockOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLockTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_inventory_lock_report")
public class ReportCenterInventoryReportInventoryLockReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterInventoryReportInventoryLockReportService {
    @Resource
    private ICsLockOrderApi csLockOrderQueryApi;
    @Resource
    private ICsLockOrderApi csLockOrderApi;

    @Override
    public RestResponse<PageInfo<InventoryLockReportVO>> getInventoryLockReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInventoryLockReportListPageParams getInventoryLockReportListPageParams) {
        CsLockOrderQueryDto dto = new CsLockOrderQueryDto();
        this.getParams(getInventoryLockReportListPageParams, dto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLockOrderQueryApi.queryByPage(dto));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            InventoryLockReportVO vo = new InventoryLockReportVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsCode(o.getCargoCode());
            vo.setGoodsName(o.getCargoName());
            vo.setLogicalWarehouseCode(o.getWarehouseCode());
            vo.setLogicalWarehouseName(o.getWarehouseName());
            vo.setGoodsType(ParamConverter.convertToString((Object)o.getItemType()));
            vo.setWarehouseProperty(o.getWarehouseProperty());
            vo.setGoodsNum(o.getAvailable());
            vo.setLockNum(ParamConverter.convertToBigDecimal((Object)o.getNumber()));
            vo.setLockCount(o.getCurrentLockQuantity());
            vo.setCargoRightName(o.getOrganizationName());
            vo.setLockReason(o.getRemark());
            if (o.getProduceTime() != null) {
                vo.setProduceTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (o.getExpireTime() != null) {
                vo.setExpireTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (o.getCreateTime() != null) {
                vo.setInWarehouseTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setExpiredFlag(ParamConverter.convertToString((Object)o.getIsNearOverdue()));
            vo.setAtWarehouseDay(ParamConverter.convertToBigDecimal((Object)o.getInventoryDay()));
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    private void getParams(GetInventoryLockReportListPageParams getInventoryLockReportListPageParams, CsLockOrderQueryDto dto) {
        BeanUtils.copyProperties((Object)getInventoryLockReportListPageParams, (Object)dto);
        dto.setLongCode(getInventoryLockReportListPageParams.getGoodsLongCode());
        dto.setCargoName(getInventoryLockReportListPageParams.getGoodsName());
        dto.setItemType(ParamConverter.convertToLong((Object)getInventoryLockReportListPageParams.getGoodsType()));
        dto.setWarehouseCode(getInventoryLockReportListPageParams.getLogicalWarehouseCode());
        dto.setWarehouseName(getInventoryLockReportListPageParams.getLogicalWarehouseName());
        dto.setOrganizationName(getInventoryLockReportListPageParams.getCargoRightName());
        dto.setIsNearOverdue(ParamConverter.convertToInteger((Object)getInventoryLockReportListPageParams.getExpiredFlag()));
        dto.setIsLockInventory(ParamConverter.convertToInteger((Object)getInventoryLockReportListPageParams.getIsLockFlag()));
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetInventoryLockReportListPageParams params = new GetInventoryLockReportListPageParams();
        CsLockOrderQueryDto queryDto = new CsLockOrderQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryLockReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryLockReportListPageParams.class);
            this.getParams(params, queryDto);
        }
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLockOrderQueryApi.queryByPage(queryDto));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetInventoryLockReportListPageParams params = new GetInventoryLockReportListPageParams();
        CsLockOrderQueryDto queryDto = new CsLockOrderQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryLockReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryLockReportListPageParams.class);
            this.getParams(params, queryDto);
        }
        queryDto.setPageNum(commonReqDto.getPageNum());
        queryDto.setPageSize(commonReqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLockOrderQueryApi.queryByPage(queryDto));
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(o -> {
                ExportInventoryLockReportVO vo = new ExportInventoryLockReportVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setGoodsLongCode(o.getLongCode());
                vo.setGoodsName(o.getCargoName());
                vo.setLogicalWarehouseCode(o.getWarehouseCode());
                vo.setLogicalWarehouseName(o.getWarehouseName());
                vo.setGoodsType(ParamConverter.convertToString((Object)o.getItemType()));
                vo.setWarehouseProperty(o.getWarehouseProperty());
                vo.setGoodsNum(ParamConverter.convertToString((Object)o.getAvailable()));
                vo.setLockNum(ParamConverter.convertToString((Object)o.getNumber()));
                vo.setLockCount(ParamConverter.convertToString((Object)o.getCurrentLockQuantity()));
                vo.setCargoRightName(o.getOrganizationName());
                vo.setLockReason(o.getRemark());
                if (o.getProduceTime() != null) {
                    vo.setProduceTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getExpireTime() != null) {
                    vo.setExpireTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getCreateTime() != null) {
                    vo.setInWarehouseTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setExpiredFlag(YesOrNoEnum.getDescByCode(o.getIsNearOverdue()));
                vo.setAtWarehouseDay(ParamConverter.convertToString((Object)o.getInventoryDay()));
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public RestResponse<Object> lockInventory(@ApiParam(value="") @Valid @RequestBody(required=false) LockInventoryParams lockInventoryParams) {
        if (lockInventoryParams.getGoodsList().size() > 1 || null == lockInventoryParams.getHandleNum()) {
            List list = lockInventoryParams.getGoodsList().stream().map(o -> {
                CsLockOrderUpdateReqDto dto = new CsLockOrderUpdateReqDto();
                this.getCsLockOrderUpdateReqDto(lockInventoryParams, (InventoryLockReportVO)o, dto);
                dto.setCurrentLockQuantity(o.getGoodsNum());
                dto.setLockAll(Boolean.valueOf(null == o.getGoodsNum()));
                return dto;
            }).collect(Collectors.toList());
            return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csLockOrderApi.batchUpdateLockInventory(CsLockTypeEnum.LOCK.getCode(), list)));
        }
        InventoryLockReportVO vo = lockInventoryParams.getGoodsList().get(0);
        CsLockOrderUpdateReqDto dto = new CsLockOrderUpdateReqDto();
        this.getCsLockOrderUpdateReqDto(lockInventoryParams, vo, dto);
        dto.setCurrentLockQuantity(lockInventoryParams.getHandleNum() != null ? lockInventoryParams.getHandleNum() : vo.getGoodsNum());
        dto.setLockAll(Boolean.valueOf(null == dto.getCurrentLockQuantity()));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csLockOrderApi.updateLockInventory(CsLockTypeEnum.LOCK.getCode(), dto)));
    }

    private CsLockOrderUpdateReqDto getCsLockOrderUpdateReqDto(@RequestBody(required=false) @ApiParam(value="") @Valid LockInventoryParams lockInventoryParams, InventoryLockReportVO vo, CsLockOrderUpdateReqDto dto) {
        dto.setLongCode(vo.getGoodsLongCode());
        dto.setCargoName(vo.getGoodsName());
        dto.setBatch(vo.getBatch());
        dto.setWarehouseCode(vo.getLogicalWarehouseCode());
        dto.setWarehouseName(vo.getLogicalWarehouseName());
        dto.setCargoCode(vo.getGoodsCode());
        dto.setRemark(lockInventoryParams.getReason());
        return dto;
    }

    @Override
    public RestResponse<Object> unlockInventory(@ApiParam(value="") @Valid @RequestBody(required=false) LockInventoryParams lockInventoryParams) {
        if (lockInventoryParams.getGoodsList().size() > 1 || null == lockInventoryParams.getHandleNum()) {
            List list = lockInventoryParams.getGoodsList().stream().map(o -> {
                CsLockOrderUpdateReqDto dto = new CsLockOrderUpdateReqDto();
                this.getCsLockOrderUpdateReqDto(lockInventoryParams, (InventoryLockReportVO)o, dto);
                dto.setCurrentLockQuantity(o.getLockCount());
                dto.setLockAll(Boolean.valueOf(null == o.getLockCount()));
                return dto;
            }).collect(Collectors.toList());
            return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csLockOrderApi.batchUpdateLockInventory(CsLockTypeEnum.UNLOCK.getCode(), list)));
        }
        InventoryLockReportVO vo = lockInventoryParams.getGoodsList().get(0);
        CsLockOrderUpdateReqDto dto = new CsLockOrderUpdateReqDto();
        this.getCsLockOrderUpdateReqDto(lockInventoryParams, vo, dto);
        dto.setCurrentLockQuantity(lockInventoryParams.getHandleNum() != null ? lockInventoryParams.getHandleNum() : vo.getLockCount());
        dto.setLockAll(Boolean.valueOf(null == dto.getCurrentLockQuantity()));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csLockOrderApi.updateLockInventory(CsLockTypeEnum.UNLOCK.getCode(), dto)));
    }
}

