/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportStorageChargeApportionDetailVO;
import com.dtyunxi.cis.pms.biz.service.IStorageChargeApportionDetailService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionDetailRespDto;
import com.dtyunxi.tcbj.api.query.IStorageChargeApportionDetailQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_storage_charge_apportion_detail")
public class StorageChargeApportionDetailServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements IStorageChargeApportionDetailService {
    @Resource
    private IStorageChargeApportionDetailQueryApi storageChargeApportionDetailQueryApi;
    @Resource
    private IStorageChargeApportionDetailService storageChargeApportionDetailService;

    @Override
    public RestResponse<PageInfo<StorageChargeApportionDetailRespDto>> queryByPage(StorageChargeApportionDetailReqDto dto) {
        return this.storageChargeApportionDetailQueryApi.queryByPage(dto);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        StorageChargeApportionDetailReqDto params = new StorageChargeApportionDetailReqDto();
        params = (StorageChargeApportionDetailReqDto)JSON.parseObject((String)commonReqDto.getFilter(), StorageChargeApportionDetailReqDto.class);
        RestResponse<PageInfo<StorageChargeApportionDetailRespDto>> pageInfoRestResponse = this.storageChargeApportionDetailService.queryByPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dateDayFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateMonthFormat = new SimpleDateFormat("yyyy-MM");
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(o -> {
                ExportStorageChargeApportionDetailVO vo = new ExportStorageChargeApportionDetailVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setApportionAllNum(o.getApportionAllNum());
                vo.setApportionId(o.getApportionId());
                vo.setApportionLogicWarehouseCode(o.getApportionLogicWarehouseCode());
                vo.setApportionLogicWarehouseName(o.getApportionLogicWarehouseName());
                vo.setApportionNum(o.getApportionNum());
                vo.setApportionOperator(o.getApportionOperator());
                vo.setApportionStartTime(dateDayFormat.format(o.getApportionStartTime()));
                vo.setApportionEndTime(dateDayFormat.format(o.getApportionEndTime()));
                vo.setApportionBetweenTime(vo.getApportionStartTime() + "~" + vo.getApportionEndTime());
                vo.setApportionSupport(o.getApportionSupport().stripTrailingZeros().toPlainString());
                vo.setBatch(o.getBatch());
                vo.setBelongOrgId(o.getBelongOrgId());
                vo.setBelongOrgName(o.getBelongOrgName());
                vo.setBillTime(dateDayFormat.format(o.getBillTime()));
                vo.setItemName(o.getItemName());
                vo.setOpLongCode(o.getOpLongCode());
                vo.setRecordMonth(dateDayFormat.format(o.getRecordMonth()));
                vo.setWarehouseCode(o.getWarehouseCode());
                vo.setWarehouseName(o.getWarehouseName());
                vo.setUpdateTime(dateFormat.format(o.getUpdateTime()));
                vo.setApportionOrgId(o.getApportionOrgId().toString());
                vo.setApportionOrgName(o.getApportionOrgName());
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        StorageChargeApportionDetailReqDto params = new StorageChargeApportionDetailReqDto();
        params = (StorageChargeApportionDetailReqDto)JSON.parseObject((String)commonReqDto.getFilter(), StorageChargeApportionDetailReqDto.class);
        params.setPageSize(Integer.valueOf(1));
        params.setPageNum(Integer.valueOf(1));
        RestResponse<PageInfo<StorageChargeApportionDetailRespDto>> pageInfoRestResponse = this.storageChargeApportionDetailService.queryByPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }
}

