/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseTaskItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseTaskReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleaseOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleaseTaskItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleaseTaskRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IInspectionReleaseOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IInspectionReleaseTaskItemQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IInspectionReleaseTaskQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class InspectionTaskCheck
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(InspectionTaskCheck.class);
    @Autowired
    IInspectionReleaseTaskQueryApi inspectionReleaseTaskQueryApi;
    @Autowired
    IInspectionReleaseTaskItemQueryApi inspectionReleaseTaskItemQueryApi;
    @Autowired
    IInspectionReleaseOrderApi inspectionReleaseOrderApi;
    @Autowired
    IInspectionReleaseOrderQueryApi inspectionReleaseOrderQueryApi;
    @Autowired
    ICommonsMqService commonsMqService;

    public void before(TaskMsg taskMsg) {
        log.info("=========\u5f00\u59cb\u6267\u884c\u5f85\u68c0\u8f6c\u5408\u683c\u68c0\u67e5\u4efb\u52a1==========");
    }

    public boolean execute(TaskMsg taskMsg) {
        this.doPreExecInspectionReleaseOrder();
        this.doIngTask();
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("=========\u7ed3\u675f\u6267\u884c\u5f85\u68c0\u8f6c\u5408\u683c\u68c0\u67e5\u4efb\u52a1==========");
    }

    private void doPreExecInspectionReleaseOrder() {
        InspectionReleaseOrderReqDto orderReqDto = new InspectionReleaseOrderReqDto();
        orderReqDto.setOrderStatus(Integer.valueOf(-1));
        List inspectionReleaseOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderQueryApi.queryList(orderReqDto));
        if (CollectionUtils.isEmpty((Collection)inspectionReleaseOrderRespDtoList)) {
            return;
        }
        for (InspectionReleaseOrderRespDto inspectionReleaseOrderRespDto : inspectionReleaseOrderRespDtoList) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)inspectionReleaseOrderRespDto.getInspectionReleaseNo());
            this.commonsMqService.sendSingleMessage("INSPECTION_RELEASE_BUSINESS_TOPIC", "CREATE_INSPECTION_RELEASE_TASK", (Object)messageVo);
        }
    }

    private void doIngTask() {
        try {
            HashSet taskNoSet = Sets.newHashSet();
            InspectionReleaseTaskReqDto taskReqDto = new InspectionReleaseTaskReqDto();
            taskReqDto.setStatus("ing");
            List releaseTaskRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.inspectionReleaseTaskQueryApi.queryList(taskReqDto));
            if (CollectionUtils.isNotEmpty((Collection)releaseTaskRespDtoList)) {
                for (InspectionReleaseTaskRespDto releaseTaskRespDto : releaseTaskRespDtoList) {
                    taskNoSet.add(releaseTaskRespDto.getTaskNo());
                }
            }
            InspectionReleaseTaskItemReqDto reqDto = new InspectionReleaseTaskItemReqDto();
            reqDto.setStatus("ing");
            List respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.inspectionReleaseTaskItemQueryApi.queryList(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
                for (InspectionReleaseTaskItemRespDto respDto : respDtoList) {
                    if ("inspection".equals(respDto.getTaskType()) && StringUtils.isNotBlank((CharSequence)respDto.getExecuteTransferNo())) continue;
                    taskNoSet.add(respDto.getTaskNo());
                }
            }
            if (CollectionUtils.isEmpty((Collection)taskNoSet)) {
                return;
            }
            for (String taskNo : taskNoSet) {
                this.sendDoTaskMq(taskNo);
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5f85\u68c0\u8f6c\u5408\u683c\u8fdb\u884c\u4e2d\u4efb\u52a1\u5f02\u5e38: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private void sendDoTaskMq(String taskNo) {
        log.info("InspectionTaskCheck sendDoTaskMq: {}", (Object)taskNo);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)taskNo);
        this.commonsMqService.sendSingleMessage("INSPECTION_RELEASE_BUSINESS_TOPIC", "DO_INSPECTION_RELEASE_TASK", (Object)messageVo);
    }
}

