/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseAddReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SfHgCalcPlanDaysTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(SfHgCalcPlanDaysTask.class);
    @Autowired
    IOutResultOrderQueryApi outResultOrderQueryApi;
    @Autowired
    ICsOutResultOrderApi csOutResultOrderApi;

    public void before(TaskMsg taskMsg) {
        log.info("\u987a\u4e30\u6d77\u67dc\u5237\u65b0\u9884\u8ba1\u5230\u8fbe\u65f6\u95f4 task==========");
    }

    public boolean execute(TaskMsg taskMsg) {
        ServiceContext.getContext().setAttachment("reqId", String.valueOf(UUID.randomUUID()));
        List outResultOrderNoList = (List)RestResponseHelper.extractData((RestResponse)this.outResultOrderQueryApi.querySfHgResultOrder());
        if (CollectionUtils.isEmpty((Collection)outResultOrderNoList)) {
            return true;
        }
        for (String outResultOrderNo : outResultOrderNoList) {
            log.info("SfHgCalcPlanDaysTask exec outResultOrderNo: {}", (Object)outResultOrderNo);
            CsShipmenetEnterpriseAddReqDto reqDto = new CsShipmenetEnterpriseAddReqDto();
            reqDto.setShipmentEnterpriseType(Long.valueOf(1L));
            RestResponseHelper.extractData((RestResponse)this.csOutResultOrderApi.refreshPlanTime(outResultOrderNo, reqDto));
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

