/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.cis.pms.biz.BizExceptionCode;
import com.dtyunxi.cis.pms.biz.annotation.OptLog;
import com.dtyunxi.cis.pms.biz.constant.OptLogTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.EnableEnum;
import com.dtyunxi.cis.pms.biz.enums.IsAllEnum;
import com.dtyunxi.cis.pms.biz.model.CustomerVO;
import com.dtyunxi.cis.pms.biz.model.DistributionClueActParams;
import com.dtyunxi.cis.pms.biz.model.DistributionClueActVo;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableCustomers;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableDocumentTypes;
import com.dtyunxi.cis.pms.biz.model.SubmitSourcingRuleParamsOldDataApplicableOrganization;
import com.dtyunxi.cis.pms.biz.service.IDistributionClueOptService;
import com.dtyunxi.cis.pms.biz.service.scheduler.biz.BizAutoDistribution;
import com.dtyunxi.cube.center.source.api.IDistributionClueApi;
import com.dtyunxi.cube.center.source.api.IDistributionClueOptApi;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueModifyActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueSuitModifyReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueSuitReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueSuitRespDto;
import com.dtyunxi.cube.center.source.api.query.IDistributionClueQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IOrganizationExpandQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IDistributionClueOptServiceImpl
implements IDistributionClueOptService {
    private static final Logger log = LoggerFactory.getLogger(IDistributionClueOptServiceImpl.class);
    @Autowired
    private IDistributionClueOptApi iDistributionClueOptApi;
    @Autowired
    private IDistributionClueQueryApi iDistributionClueQueryApi;
    @Resource
    private IPCPCustomerQueryApi pcpCustomerQueryApi;
    @Resource
    private IOrganizationExpandQueryApi organizationExpandQueryApi;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private BizAutoDistribution bizAutoDistribution;
    @Resource
    private IDistributionClueApi distributionClueApi;

    @Override
    @OptLog(optOrderType=OptLogTypeEnum.DISTRIBUTION, type=OptLogTypeEnum.ADD)
    public RestResponse<Long> addDistributionClueOpt(DistributionClueActParams addReqDto) {
        DistributionClueActVo submitSourcingRuleParamsData = Optional.ofNullable(addReqDto).map(DistributionClueActParams::getNewData).orElse(null);
        if (ObjectUtil.isEmpty((Object)((Object)submitSourcingRuleParamsData))) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DistributionClueActReqDto clueActReqDto = new DistributionClueActReqDto();
        BeanUtils.copyProperties((Object)((Object)submitSourcingRuleParamsData), (Object)clueActReqDto);
        clueActReqDto.setClueEnableEndTime((Date)DateUtil.parseDateTime((CharSequence)submitSourcingRuleParamsData.getClueEnableEndTime()));
        clueActReqDto.setClueEnableStartTime((Date)DateUtil.parseDateTime((CharSequence)submitSourcingRuleParamsData.getClueEnableStartTime()));
        ArrayList<Object> suitCustomerList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableCustomers applicableCustomers = submitSourcingRuleParamsData.getApplicableCustomers();
        if (ObjectUtil.isNotEmpty((Object)applicableCustomers)) {
            List<CustomerVO> customerVOlist = applicableCustomers.getList();
            String isAll = applicableCustomers.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                DistributionClueSuitReqDto clueCustomerReqDto = new DistributionClueSuitReqDto();
                clueCustomerReqDto.setSgSuitKey("");
                clueCustomerReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
                clueCustomerReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitCustomerList.add(clueCustomerReqDto);
            } else {
                if (CollectionUtil.isEmpty(customerVOlist)) {
                    throw new BizException(BizExceptionCode.CUSTOMER_LIST_EMPTY.getCode(), BizExceptionCode.CUSTOMER_LIST_EMPTY.getMsg());
                }
                for (CustomerVO customerVO : customerVOlist) {
                    DistributionClueSuitReqDto clueCustomerReqDto = new DistributionClueSuitReqDto();
                    clueCustomerReqDto.setSgSuitKey(customerVO.getCustomerId());
                    clueCustomerReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
                    clueCustomerReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitCustomerList.add(clueCustomerReqDto);
                }
            }
        }
        clueActReqDto.setSuitCustomerList(suitCustomerList);
        ArrayList<Object> suitOrderTypeList = new ArrayList<Object>();
        SubmitSourcingRuleParamsOldDataApplicableDocumentTypes applicableDocumentTypes = submitSourcingRuleParamsData.getApplicableDocumentTypes();
        if (ObjectUtil.isNotEmpty((Object)applicableDocumentTypes)) {
            List<String> orderTypelist = applicableDocumentTypes.getList();
            String isAll = applicableDocumentTypes.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                DistributionClueSuitReqDto clueOrderTypeReqDto = new DistributionClueSuitReqDto();
                clueOrderTypeReqDto.setSgSuitKey("");
                clueOrderTypeReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
                clueOrderTypeReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitOrderTypeList.add(clueOrderTypeReqDto);
            } else {
                if (CollectionUtil.isEmpty(orderTypelist)) {
                    throw new BizException(BizExceptionCode.ORDER_TYPE_LIST_EMPTY.getCode(), BizExceptionCode.ORDER_TYPE_LIST_EMPTY.getMsg());
                }
                for (String orderType : orderTypelist) {
                    DistributionClueSuitReqDto clueOrderTypeReqDto = new DistributionClueSuitReqDto();
                    clueOrderTypeReqDto.setSgSuitKey(orderType);
                    clueOrderTypeReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
                    clueOrderTypeReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitOrderTypeList.add(clueOrderTypeReqDto);
                }
            }
        }
        clueActReqDto.setSuitOrderTypeList(suitOrderTypeList);
        ArrayList<DistributionClueSuitReqDto> suitOrganizationList = new ArrayList<DistributionClueSuitReqDto>();
        SubmitSourcingRuleParamsOldDataApplicableOrganization applicableOrganization = submitSourcingRuleParamsData.getApplicableOrganization();
        if (ObjectUtil.isNotEmpty((Object)applicableOrganization)) {
            List<OrganizationDto> applicableOrganizationList = applicableOrganization.getList();
            String isAll = applicableOrganization.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                DistributionClueSuitReqDto clueOrganizationReqDto = new DistributionClueSuitReqDto();
                clueOrganizationReqDto.setSgSuitKey("");
                clueOrganizationReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
                clueOrganizationReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitOrganizationList.add(clueOrganizationReqDto);
            } else {
                if (CollectionUtil.isEmpty(applicableOrganizationList)) {
                    throw new BizException(BizExceptionCode.ORGANIZATION_LIST_EMPTY.getCode(), BizExceptionCode.ORGANIZATION_LIST_EMPTY.getMsg());
                }
                for (OrganizationDto organizationDto : applicableOrganizationList) {
                    DistributionClueSuitReqDto clueWarehouseReqDto = new DistributionClueSuitReqDto();
                    clueWarehouseReqDto.setSgSuitKey(ParamConverter.convertToString((Object)organizationDto.getId()));
                    clueWarehouseReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
                    clueWarehouseReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitOrganizationList.add(clueWarehouseReqDto);
                }
            }
        }
        clueActReqDto.setSuitOrganizationList(suitOrganizationList);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.iDistributionClueOptApi.addDistributionClueOpt(clueActReqDto)));
    }

    @Override
    @OptLog(optOrderType=OptLogTypeEnum.DISTRIBUTION, type=OptLogTypeEnum.UPD, optNo="#id")
    public RestResponse<Long> modifyDistributionClueOpt(String id, DistributionClueActParams addReqDto) {
        DistributionClueActVo oldData = addReqDto.getOldData();
        DistributionClueActVo newData = addReqDto.getNewData();
        DistributionClueModifyActReqDto clueModifyActReqDto = new DistributionClueModifyActReqDto();
        BeanUtils.copyProperties((Object)((Object)newData), (Object)clueModifyActReqDto);
        clueModifyActReqDto.setId(Long.valueOf(id));
        clueModifyActReqDto.setClueEnableStartTime((Date)DateUtil.parseDateTime((CharSequence)newData.getClueEnableStartTime()));
        clueModifyActReqDto.setClueEnableEndTime((Date)DateUtil.parseDateTime((CharSequence)newData.getClueEnableEndTime()));
        DistributionClueSuitModifyReqDto clueSuitCustomerList = new DistributionClueSuitModifyReqDto();
        ArrayList<Object> suitCustomerList = new ArrayList<Object>();
        clueSuitCustomerList.setAdd(suitCustomerList);
        SubmitSourcingRuleParamsOldDataApplicableCustomers applicableCustomers = newData.getApplicableCustomers();
        if (ObjectUtil.isNotEmpty((Object)applicableCustomers)) {
            List<CustomerVO> customerVOlist = applicableCustomers.getList();
            String isAll = applicableCustomers.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                DistributionClueSuitReqDto clueCustomerReqDto = new DistributionClueSuitReqDto();
                clueCustomerReqDto.setSgSuitKey("");
                clueCustomerReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
                clueCustomerReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitCustomerList.add(clueCustomerReqDto);
            } else {
                if (CollectionUtil.isEmpty(customerVOlist)) {
                    throw new BizException(BizExceptionCode.CUSTOMER_LIST_EMPTY.getCode(), BizExceptionCode.CUSTOMER_LIST_EMPTY.getMsg());
                }
                for (CustomerVO customerVO : customerVOlist) {
                    DistributionClueSuitReqDto clueCustomerReqDto = new DistributionClueSuitReqDto();
                    clueCustomerReqDto.setSgSuitKey(customerVO.getCustomerId());
                    clueCustomerReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
                    clueCustomerReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitCustomerList.add(clueCustomerReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitCustomerList(clueSuitCustomerList);
        DistributionClueSuitModifyReqDto clueSuitOrderTypeList = new DistributionClueSuitModifyReqDto();
        ArrayList<Object> suitOrderTypeList = new ArrayList<Object>();
        clueSuitOrderTypeList.setAdd(suitOrderTypeList);
        SubmitSourcingRuleParamsOldDataApplicableDocumentTypes applicableDocumentTypes = newData.getApplicableDocumentTypes();
        if (ObjectUtil.isNotEmpty((Object)applicableDocumentTypes)) {
            List<String> orderTypelist = applicableDocumentTypes.getList();
            String isAll = applicableDocumentTypes.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                DistributionClueSuitReqDto clueOrderTypeReqDto = new DistributionClueSuitReqDto();
                clueOrderTypeReqDto.setSgSuitKey("");
                clueOrderTypeReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
                clueOrderTypeReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitOrderTypeList.add(clueOrderTypeReqDto);
            } else {
                if (CollectionUtil.isEmpty(orderTypelist)) {
                    throw new BizException(BizExceptionCode.ORDER_TYPE_LIST_EMPTY.getCode(), BizExceptionCode.ORDER_TYPE_LIST_EMPTY.getMsg());
                }
                for (String orderType : orderTypelist) {
                    DistributionClueSuitReqDto clueOrderTypeReqDto = new DistributionClueSuitReqDto();
                    clueOrderTypeReqDto.setSgSuitKey(orderType);
                    clueOrderTypeReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
                    clueOrderTypeReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitOrderTypeList.add(clueOrderTypeReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitOrderTypeList(clueSuitOrderTypeList);
        DistributionClueSuitModifyReqDto clueSuitOrganizationList = new DistributionClueSuitModifyReqDto();
        ArrayList<DistributionClueSuitReqDto> suitOrganizationList = new ArrayList<DistributionClueSuitReqDto>();
        clueSuitOrganizationList.setAdd(suitOrganizationList);
        SubmitSourcingRuleParamsOldDataApplicableOrganization applicableOrganization = newData.getApplicableOrganization();
        if (ObjectUtil.isNotEmpty((Object)applicableOrganization)) {
            List<OrganizationDto> applicableOrganizationList = applicableOrganization.getList();
            String isAll = applicableOrganization.getIsAll();
            if (IsAllEnum.ALL.getCode().equals(isAll)) {
                DistributionClueSuitReqDto clueOrganizationReqDto = new DistributionClueSuitReqDto();
                clueOrganizationReqDto.setSgSuitKey("");
                clueOrganizationReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
                clueOrganizationReqDto.setSgSuitSelectType(IsAllEnum.ALL.getStatus());
                suitOrganizationList.add(clueOrganizationReqDto);
            } else {
                if (CollectionUtil.isEmpty(applicableOrganizationList)) {
                    throw new BizException(BizExceptionCode.ORGANIZATION_LIST_EMPTY.getCode(), BizExceptionCode.ORGANIZATION_LIST_EMPTY.getMsg());
                }
                for (OrganizationDto organizationDto : applicableOrganizationList) {
                    DistributionClueSuitReqDto clueOrganizationReqDto = new DistributionClueSuitReqDto();
                    clueOrganizationReqDto.setSgSuitKey(ParamConverter.convertToString((Object)organizationDto.getId()));
                    clueOrganizationReqDto.setSgSuitType(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
                    clueOrganizationReqDto.setSgSuitSelectType(IsAllEnum.SELECT.getStatus());
                    suitOrganizationList.add(clueOrganizationReqDto);
                }
            }
        }
        clueModifyActReqDto.setSuitOrganizationList(clueSuitOrganizationList);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.iDistributionClueOptApi.modifyDistributionClueOpt(clueModifyActReqDto)));
    }

    @Override
    public RestResponse<Void> deleteDistributionClueOpt(List<Long> clueIdList) {
        RestResponseHelper.extractData((RestResponse)this.iDistributionClueOptApi.deleteDistributionClueOpt(clueIdList));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> openEnable(List<Long> clueIds, String enable) {
        for (Long clueId : clueIds) {
            DistributionClueRespDto clueActRespDto = (DistributionClueRespDto)RestResponseHelper.extractData((RestResponse)this.iDistributionClueQueryApi.queryById(clueId));
            if (Objects.equals(clueActRespDto.getClueEnableStatus(), EnableEnum.ENABLE.getStatus()) && Objects.equals(enable, EnableEnum.ENABLE.getStatus())) continue;
            String schedulerId = "";
            if (Objects.equals(enable, EnableEnum.ENABLE.getStatus()) && Objects.equals(clueActRespDto.getClueSettings(), 1)) {
                Integer waitPickTime = clueActRespDto.getWaitPickTime();
                List<Long> tasksIds = this.bizAutoDistribution.createTasks(waitPickTime, clueActRespDto.getId());
                if (CollectionUtils.isNotEmpty(tasksIds)) {
                    schedulerId = tasksIds.stream().map(x -> x.toString()).collect(Collectors.joining(","));
                }
            } else {
                String oldSchedulerId = clueActRespDto.getSchedulerId();
                if (StringUtils.isNotBlank((CharSequence)oldSchedulerId)) {
                    String[] idArray = oldSchedulerId.split(",");
                    List<String> taskIdList = Arrays.asList(idArray);
                    for (String taskId : taskIdList) {
                        try {
                            RestResponseHelper.checkOrThrow((RestResponse)this.taskApi.disableById(Long.valueOf(taskId), ""));
                        }
                        catch (NumberFormatException e) {
                            log.info("\u5220\u9664\u8c03\u5ea6\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        }
                    }
                }
            }
            DistributionClueReqDto updateDto = new DistributionClueReqDto();
            updateDto.setSchedulerId(schedulerId);
            updateDto.setId(clueId);
            updateDto.setClueEnableStatus(enable);
            this.distributionClueApi.modifyDistributionClue(updateDto);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<DistributionClueRespDto>> queryByPage(DistributionClueReqDto dto) {
        return this.iDistributionClueQueryApi.queryByPage(dto);
    }

    @Override
    public RestResponse<DistributionClueActVo> queryClueDetailById(Long id) {
        DistributionClueActRespDto clueActRespDto = (DistributionClueActRespDto)RestResponseHelper.extractData((RestResponse)this.iDistributionClueQueryApi.queryClueDetailById(id));
        DistributionClueActVo vo = new DistributionClueActVo();
        if (clueActRespDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)clueActRespDto, (Object)((Object)vo));
        vo.setClueEnableStartTime(DateUtil.formatDate((Date)clueActRespDto.getClueEnableStartTime()));
        vo.setClueEnableEndTime(DateUtil.formatDate((Date)clueActRespDto.getClueEnableEndTime()));
        SubmitSourcingRuleParamsOldDataApplicableDocumentTypes applicableOrderType = new SubmitSourcingRuleParamsOldDataApplicableDocumentTypes();
        vo.setApplicableDocumentTypes(applicableOrderType);
        List<String> orderTypeList = new ArrayList<String>();
        applicableOrderType.setList(orderTypeList);
        List suitOrderTypeList = clueActRespDto.getSuitOrderTypeList();
        if (CollectionUtils.isNotEmpty((Collection)suitOrderTypeList) && IsAllEnum.SELECT.getStatus().equals(((DistributionClueSuitRespDto)suitOrderTypeList.get(0)).getSgSuitSelectType())) {
            applicableOrderType.setIsAll(IsAllEnum.SELECT.getCode());
            orderTypeList = suitOrderTypeList.stream().map(o -> o.getSgSuitKey()).collect(Collectors.toList());
            applicableOrderType.setList(orderTypeList);
        } else {
            applicableOrderType.setIsAll(IsAllEnum.ALL.getCode());
        }
        SubmitSourcingRuleParamsOldDataApplicableCustomers applicableCustomer = new SubmitSourcingRuleParamsOldDataApplicableCustomers();
        vo.setApplicableCustomers(applicableCustomer);
        ArrayList<CustomerVO> orderCustomerVOList = new ArrayList<CustomerVO>();
        applicableCustomer.setList(orderCustomerVOList);
        List suitCustomerList = clueActRespDto.getSuitCustomerList();
        if (CollectionUtils.isNotEmpty((Collection)suitCustomerList) && IsAllEnum.SELECT.getStatus().equals(((DistributionClueSuitRespDto)suitCustomerList.get(0)).getSgSuitSelectType())) {
            applicableCustomer.setIsAll(IsAllEnum.SELECT.getCode());
            List suitCustomerIdList = suitCustomerList.stream().map(o -> Long.valueOf(o.getSgSuitKey())).collect(Collectors.toList());
            PCPCustomerSearchReqDto pcpCustomerSearchReqDto = new PCPCustomerSearchReqDto();
            pcpCustomerSearchReqDto.setIdList(suitCustomerIdList);
            List pcpCustomerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpCustomerQueryApi.queryPCPCustomerDetail(pcpCustomerSearchReqDto));
            if (CollectionUtil.isNotEmpty((Collection)pcpCustomerRespDtoList)) {
                for (PCPCustomerRespDto pCPCustomerRespDto : pcpCustomerRespDtoList) {
                    CustomerVO customerVO = new CustomerVO();
                    BeanUtil.copyProperties((Object)pCPCustomerRespDto, (Object)customerVO, (String[])new String[0]);
                    customerVO.setId(pCPCustomerRespDto.getId());
                    customerVO.setCustomerName(pCPCustomerRespDto.getCustomerName());
                    customerVO.setCustomerCode(pCPCustomerRespDto.getCustomerCode());
                    orderCustomerVOList.add(customerVO);
                }
                applicableCustomer.setList(orderCustomerVOList);
            }
        } else {
            applicableCustomer.setIsAll(IsAllEnum.ALL.getCode());
        }
        SubmitSourcingRuleParamsOldDataApplicableOrganization applicableOrganization = new SubmitSourcingRuleParamsOldDataApplicableOrganization();
        ArrayList<OrganizationDto> organizationDtoList = new ArrayList<OrganizationDto>();
        applicableOrganization.setList(organizationDtoList);
        List suitOrganizationList = clueActRespDto.getSuitOrganizationList();
        if (CollectionUtils.isNotEmpty((Collection)suitOrganizationList) && IsAllEnum.SELECT.getStatus().equals(((DistributionClueSuitRespDto)suitOrganizationList.get(0)).getSgSuitSelectType())) {
            applicableOrganization.setIsAll(IsAllEnum.SELECT.getCode());
            List suitOrganizationIdList = suitOrganizationList.stream().map(o -> Long.valueOf(o.getSgSuitKey())).collect(Collectors.toList());
            List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationExpandQueryApi.queryOrgDtoByIds(suitOrganizationIdList));
            if (CollectionUtil.isNotEmpty((Collection)organizationDtos)) {
                applicableOrganization.setList(organizationDtos);
            }
        } else {
            applicableOrganization.setIsAll(IsAllEnum.ALL.getCode());
        }
        vo.setApplicableOrganization(applicableOrganization);
        return new RestResponse((Object)vo);
    }
}

