/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.utils;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.app.ServiceContext;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TasksUtils {
    private static final Logger log = LoggerFactory.getLogger(TasksUtils.class);
    public static final String REGENERATE_TASKS_ID = "regenerate_tasks_id";

    public static void setTasksId(Object tasksId) {
        if (Objects.isNull(tasksId)) {
            return;
        }
        MDC.put((String)REGENERATE_TASKS_ID, (String)StrUtil.toString((Object)tasksId));
    }

    public static void removeTasksId() {
        MDC.remove((String)REGENERATE_TASKS_ID);
    }

    public static String getTasksId() {
        try {
            String tasksId = MDC.get((String)REGENERATE_TASKS_ID);
            if (StrUtil.isBlank((CharSequence)tasksId)) {
                return TasksUtils.getTasksIdByContext();
            }
            return tasksId;
        }
        catch (Exception e) {
            log.error("getTasksIdError:{}", (Object)e.getMessage());
            return TasksUtils.getTasksIdByContext();
        }
    }

    public static String getTasksIdByContext() {
        try {
            return ServiceContext.getContext().getAttachment(REGENERATE_TASKS_ID);
        }
        catch (Exception e) {
            log.error("getTasksIdByContextError:{}", (Object)e.getMessage());
            return "";
        }
    }
}

