/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BSOtherDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.WarehouseCorrespondingSystemEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExternalE3ParamsBuild {
    private static final Logger logger = LoggerFactory.getLogger(ExternalE3ParamsBuild.class);
    @Resource
    private IItemExtendQueryApi itemExtendQueryApi;

    public List<E3BSOtherDetailAddReqDto> buildDetailList2(List<CsTransferOrderDetailRespDto> detail, WarehouseCorrespondingSystemEnum systemEnum) {
        List<CsOutNoticeOrderDetailRespDto> collect = detail.stream().map(d -> {
            CsOutNoticeOrderDetailRespDto dto = new CsOutNoticeOrderDetailRespDto();
            dto.setLongCode(d.getLongCode());
            dto.setPlanQuantity(d.getQuantity());
            return dto;
        }).collect(Collectors.toList());
        return this.buildDetailList(collect, systemEnum);
    }

    public List<E3BSOtherDetailAddReqDto> buildDetailList(List<CsOutNoticeOrderDetailRespDto> detail, WarehouseCorrespondingSystemEnum systemEnum) {
        logger.info("\u6784\u5efa\u8bf7\u6c42E3\u5bf9\u63a5\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(detail));
        logger.info("\u6784\u5efa\u8bf7\u6c42E3\u7cfb\u7edf\uff1a{}", (Object)systemEnum.getDesc());
        Map<Object, Object> itemThirdCodeMap = new HashMap();
        if (systemEnum.equals((Object)WarehouseCorrespondingSystemEnum.E3_MY)) {
            ItemExtendReqDto reqDto = new ItemExtendReqDto();
            reqDto.setItemCodeList(detail.stream().map(CsOutNoticeOrderDetailRespDto::getLongCode).collect(Collectors.toList()));
            List itemThirdCodeList = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(reqDto));
            AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)itemThirdCodeList), "\u627e\u4e0d\u5230\u5546\u54c1\u660e\u7ec6");
            itemThirdCodeMap = itemThirdCodeList.stream().collect(Collectors.toMap(ItemExtendRespDto::getItemCode, Function.identity(), (k1, k2) -> k1));
        }
        HashMap finalItemThirdCodeMap = itemThirdCodeMap;
        List<E3BSOtherDetailAddReqDto> collect = detail.stream().map(item -> {
            E3BSOtherDetailAddReqDto detailAddReqDto = new E3BSOtherDetailAddReqDto();
            switch (systemEnum) {
                case E3_BS: {
                    detailAddReqDto.setSku(item.getLongCode().substring(item.getLongCode().lastIndexOf(".") + 1));
                    break;
                }
                case E3_MY: {
                    AssertUtil.isFalse(ObjectUtil.isEmpty(finalItemThirdCodeMap.get(item.getLongCode())) || StringUtils.isBlank((CharSequence)((ItemExtendRespDto)finalItemThirdCodeMap.get(item.getLongCode())).getE3ItemCode()), "\u627e\u4e0d\u5230\u5546\u54c1\u5bf9\u5e94\u7684\u5916\u90e8\u7f16\u53f7\uff1a" + item.getLongCode());
                    detailAddReqDto.setSku(((ItemExtendRespDto)finalItemThirdCodeMap.get(item.getLongCode())).getE3ItemCode());
                }
            }
            detailAddReqDto.setSl(item.getPlanQuantity().toString());
            return detailAddReqDto;
        }).collect(Collectors.toList());
        return collect;
    }
}

