/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportStorageChargeDetailVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.IStorageChargeDetailService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.BeanPropertyNullUtil;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IStorageChargeBillApi;
import com.dtyunxi.tcbj.api.IStorageChargeDetailApi;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionTradeTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsExceptionStorageBill;
import com.dtyunxi.tcbj.api.dto.request.AdjustStorageApportionDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.BizImportDataReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.BizImportRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeDetailRespDto;
import com.dtyunxi.tcbj.api.query.IStorageChargeDetailQueryApi;
import com.dtyunxi.tcbj.api.vo.ImportStorageChargeDetailChangeVo;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="abstractFileOperationCommonService_storage_charge_detail")
public class StorageChargeDetailServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements IStorageChargeDetailService {
    private final Logger LOGGER = LoggerFactory.getLogger(StorageChargeDetailServiceImpl.class);
    @Resource
    private IStorageChargeDetailQueryApi storageChargeDetailQueryApi;
    @Resource
    private IStorageChargeDetailApi storageChargeDetailApi;
    @Resource
    private IStorageChargeDetailService storageChargeDetailService;
    @Resource
    private IStorageChargeBillApi storageChargeBillApi;
    @Resource
    private IContext context;

    @Override
    public RestResponse<PageInfo<StorageChargeDetailRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return this.storageChargeDetailQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportStorageChargeDetailChangeVo.class);
        this.LOGGER.info("result.getList() = {}", (Object)JSONObject.toJSONString((Object)result.getList()));
        this.LOGGER.info("list = {}", (Object)JSONObject.toJSONString((Object)list));
        Map bizMap = commonReqDto.getExtFields();
        this.LOGGER.info("verifyImportFileOperationCommon bizMap = {}", (Object)JSONObject.toJSONString((Object)bizMap));
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        list.forEach(i -> {
            if (i.getStorageTime() == null) {
                this.setErrorMsg((ImportStorageChargeDetailChangeVo)i, "\u65e5\u671f\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)i.getOpLongCode())) {
                this.setErrorMsg((ImportStorageChargeDetailChangeVo)i, "\u5546\u54c1\u957f\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)i.getLogicWarehouseCode())) {
                this.setErrorMsg((ImportStorageChargeDetailChangeVo)i, "\u903b\u8f91\u4ed3\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)i.getBatch())) {
                this.setErrorMsg((ImportStorageChargeDetailChangeVo)i, "\u6279\u6b21\u4e3a\u7a7a");
            }
            if (i.getAdjustDeliveryNum() == null) {
                this.setErrorMsg((ImportStorageChargeDetailChangeVo)i, "\u8c03\u6574\u6570\u91cf\u4e3a\u7a7a");
            }
            if (i.getAdjustType() == null) {
                this.setErrorMsg((ImportStorageChargeDetailChangeVo)i, "\u8c03\u6574\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)i.getResult())) {
                msgList.add(i);
            } else {
                saveList.add(i);
            }
        });
        this.LOGGER.info("msgList = {}", (Object)JSON.toJSONString((Object)msgList));
        this.LOGGER.info("saveList = {}", (Object)JSON.toJSONString((Object)saveList));
        ArrayList queryList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)queryList, (Collection)saveList, StorageChargeDetailReqDto.class);
        this.LOGGER.info("\u67e5\u8be2\u4ed3\u50a8\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)queryList));
        HashMap map = new HashMap();
        saveList.forEach(dto -> map.put(dto.getStorageTime() + dto.getOpLongCode() + dto.getLogicWarehouseCode() + dto.getBatch(), dto));
        ArrayList saveList1 = Lists.newArrayList();
        List dtos = (List)RestResponseHelper.extractData((RestResponse)this.storageChargeDetailQueryApi.importPage((List)queryList));
        dtos.forEach(dto -> {
            this.LOGGER.info("dto = {}", (Object)JSON.toJSONString((Object)dto));
            ImportStorageChargeDetailChangeVo vo = (ImportStorageChargeDetailChangeVo)map.get(dto.getStorageTime() + dto.getOpLongCode() + dto.getLogicWarehouseCode() + dto.getBatch());
            if (dto.getPlacedFlag() != null && dto.getPlacedFlag() == 1) {
                this.setErrorMsg(vo, "\u66f4\u65b0\u5931\u8d25\uff1a\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
                msgList.add(vo);
            } else {
                saveList1.add(vo);
            }
        });
        this.LOGGER.info("msgList2 = {}", (Object)JSON.toJSONString((Object)msgList));
        this.LOGGER.info("saveList2 = {}", (Object)JSON.toJSONString((Object)saveList1));
        HashMap map1 = Maps.newHashMap();
        map1.put("saveList", saveList1);
        map1.put("msgList", msgList);
        return map1;
    }

    private void setErrorMsg(ImportStorageChargeDetailChangeVo msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getResult())) {
            msgDto.setResult(errorMsg);
        } else {
            msgDto.setResult(String.format("%s\u3001%s", msgDto.getResult(), errorMsg));
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null) {
            List saveList = (List)saveObj;
            BizImportDataReqDto bizImportDataReqDto = new BizImportDataReqDto();
            bizImportDataReqDto.setTenantId(this.context.tenantId());
            bizImportDataReqDto.setExcelImportResult(saveList);
            RestResponse bizImportRespDtoRestResponse = this.storageChargeDetailApi.importStorageChargeDetail(bizImportDataReqDto);
            RestResponseHelper.extractData((RestResponse)bizImportRespDtoRestResponse);
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List msgList = (List)msgObj;
            this.LOGGER.info("\u9519\u8bef\u4fe1\u606f\u662ferrorList\uff1a{}", (Object)JSON.toJSONString((Object)msgList));
            if (CollectionUtil.isNotEmpty((Collection)msgList)) {
                String excelName = String.format("%s%s", "\u4ed3\u50a8\u660e\u7ec6\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
                errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportStorageChargeDetailChangeVo.class, null, excelName);
            }
        }
        return errorMsgUrl;
    }

    @Override
    public RestResponse<BizImportRespDto> importStorageChargeDetail(MultipartFile file) {
        BizImportDataReqDto bizImportDataReqDto = new BizImportDataReqDto();
        bizImportDataReqDto.setTenantId(this.context.tenantId());
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), ImportStorageChargeDetailChangeVo.class, (ImportParams)importParams);
            List collect = result.getList().stream().filter(c -> !BeanPropertyNullUtil.isAllFieldNull(c)).collect(Collectors.toList());
            bizImportDataReqDto.setExcelImportResult(collect);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        return this.storageChargeDetailApi.importStorageChargeDetail(bizImportDataReqDto);
    }

    @Override
    public RestResponse<Void> adjustStorageApportionDetail(AdjustStorageApportionDetailReqDto detailReqDto) {
        return this.storageChargeDetailApi.adjustStorageApportionDetail(detailReqDto);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        RestResponse<PageInfo<StorageChargeDetailRespDto>> pageInfoRestResponse = this.storageChargeDetailService.queryByPage(commonReqDto.getFilter(), commonReqDto.getPageNum(), commonReqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(o -> {
                ExportStorageChargeDetailVO vo = new ExportStorageChargeDetailVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBizType(ApportionTradeTypeEnum.keyOfEnum((Integer)o.getBizType()).getDesc());
                vo.setStorageTime(dateFormat.format(o.getStorageTime()));
                String zhTrayNum = o.getZhTrayNum().equals(IsExceptionStorageBill.IS_EXCEPTION.getVal()) ? IsExceptionStorageBill.IS_EXCEPTION.getDesc() : o.getZhTrayNum().toString();
                vo.setZhTrayNum(zhTrayNum);
                String allDaySupport = o.getAllDaySupport().equals(IsExceptionStorageBill.IS_EXCEPTION.getVal()) ? IsExceptionStorageBill.IS_EXCEPTION.getDesc() : o.getAllDaySupport().toString();
                vo.setAllDaySupport(allDaySupport);
                String organizationSupport = o.getOrganizationSupport().compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0 ? IsExceptionStorageBill.IS_EXCEPTION.getDesc() : o.getOrganizationSupport().toString();
                vo.setOrganizationSupport(organizationSupport);
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        RestResponse<PageInfo<StorageChargeDetailRespDto>> pageInfoRestResponse = this.storageChargeDetailService.queryByPage(commonReqDto.getFilter(), commonReqDto.getPageNum(), commonReqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }
}

