/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.AreaEnum;
import com.dtyunxi.cis.pms.biz.enums.LevelEnum;
import com.dtyunxi.cis.pms.biz.model.ExportAreaVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetBaseAreaListPageParams;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ModifyAnnotation;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_area_city")
public class BasedataCenterAreaCityServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetBaseAreaListPageParams getBaseAreaListPageParams = new GetBaseAreaListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            getBaseAreaListPageParams = (GetBaseAreaListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetBaseAreaListPageParams.class);
        }
        PcpRegionReqDto reqDto = new PcpRegionReqDto();
        reqDto.setLevelId(LevelEnum.CITY.getCode());
        reqDto.setName(getBaseAreaListPageParams.getName());
        reqDto.setCode(getBaseAreaListPageParams.getCode());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), commonReqDto.getPageNum(), commonReqDto.getPageSize()));
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(o -> {
                ExportAreaVO vo = new ExportAreaVO();
                try {
                    ModifyAnnotation.modifyAnnotationName(((Object)((Object)vo)).getClass(), Excel.class, AreaEnum.getFieldByCode(reqDto.getLevelId() * 2), AreaEnum.getDescByCode(reqDto.getLevelId() * 2));
                    ModifyAnnotation.modifyAnnotationName(((Object)((Object)vo)).getClass(), Excel.class, AreaEnum.getFieldByCode(reqDto.getLevelId() * 2 + 1), AreaEnum.getDescByCode(reqDto.getLevelId() * 2 + 1));
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setLongitude(o.getLocationX());
                vo.setLatitude(o.getLocationY());
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetBaseAreaListPageParams getBaseAreaListPageParams = new GetBaseAreaListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            getBaseAreaListPageParams = (GetBaseAreaListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetBaseAreaListPageParams.class);
        }
        PcpRegionReqDto reqDto = new PcpRegionReqDto();
        reqDto.setLevelId(LevelEnum.CITY.getCode());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), getBaseAreaListPageParams.getPageNum(), getBaseAreaListPageParams.getPageSize()));
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }
}

