/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.TransferOrderStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.InspectionReleaseRecordVo;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseRecordReqDto;
import com.dtyunxi.tcbj.api.query.IInspectionReleaseOrderQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_export_release_records")
public class ReleaseRecordsServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    @Autowired
    private IInspectionReleaseOrderQueryApi iInspectionReleaseOrderQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        InspectionReleaseRecordReqDto getLogicalInventoryListPageParams = new InspectionReleaseRecordReqDto();
        getLogicalInventoryListPageParams = (InspectionReleaseRecordReqDto)JSON.parseObject((String)commonReqDto.getFilter(), InspectionReleaseRecordReqDto.class);
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            RestResponse pageInfoRestResponse = this.iInspectionReleaseOrderQueryApi.queryPage(re);
            PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
            PageInfo im = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)im);
            ArrayList list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list.addAll(respDtoPageInfo.getList().stream().map(o -> {
                    InspectionReleaseRecordVo vo = new InspectionReleaseRecordVo();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setReleaseNum(o.getReleaseNum().intValue());
                    vo.setCreateTime(DateUtil.formatDateTime((Date)o.getCreateTime()));
                    vo.setExecuteTransferNoStatus(Optional.ofNullable(TransferOrderStatusEnum.getDescByCode(o.getExecuteTransferNoStatus())).orElse(o.getExecuteTransferNoStatus()));
                    vo.setInspectionTransferNoStatus(Optional.ofNullable(TransferOrderStatusEnum.getDescByCode(o.getInspectionTransferNoStatus())).orElse(o.getInspectionTransferNoStatus()));
                    return vo;
                }).collect(Collectors.toList()));
            }
            im.setList((List)list);
            return im;
        }, getLogicalInventoryListPageParams, InspectionReleaseRecordVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        InspectionReleaseRecordReqDto getLogicalInventoryListPageParams = new InspectionReleaseRecordReqDto();
        getLogicalInventoryListPageParams = (InspectionReleaseRecordReqDto)JSON.parseObject((String)commonReqDto.getFilter(), InspectionReleaseRecordReqDto.class);
        getLogicalInventoryListPageParams.setPageSize(Integer.valueOf(1));
        getLogicalInventoryListPageParams.setPageNum(Integer.valueOf(1));
        RestResponse pageInfoRestResponse = this.iInspectionReleaseOrderQueryApi.queryPage(getLogicalInventoryListPageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }
}

