/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl.opt;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.OptLogTypeEnum;
import com.dtyunxi.cis.pms.biz.dto.request.OptLogReqDto;
import com.dtyunxi.cis.pms.biz.model.GoodsVO;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterGoodsService;
import com.dtyunxi.cis.pms.biz.service.opt.AbstractOptLogService;
import com.dtyunxi.cis.pms.biz.service.opt.IOptLogService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductDataLogServiceImpl
implements AbstractOptLogService {
    private static final Logger logger = LoggerFactory.getLogger(ProductDataLogServiceImpl.class);
    @Resource
    private BasedataCenterGoodsService basedataCenterGoodsService;
    @Autowired
    private IOptLogService optLogService;

    @Override
    public String getOptLogTypeCode() {
        return OptLogTypeEnum.PRODUCT_DATA_LOG.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void addOptLog(OptLogReqDto optLogReqDto) {
        String optNo = optLogReqDto.getOptNo();
        if (StringUtils.isEmpty((CharSequence)optNo)) {
            logger.info("\u5546\u54c1\u64cd\u4f5c\u65e5\u5fd7\u5546\u54c1id\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        GoodsVO goodsVO = (GoodsVO)RestResponseHelper.extractData(this.basedataCenterGoodsService.getGoodsDetail(optNo));
        if (Objects.isNull(goodsVO)) {
            logger.info("\u5546\u54c1\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)optNo);
            return;
        }
        optLogReqDto.setSnapshot(JSON.toJSONString((Object)goodsVO));
        this.optLogService.addOptLog(optLogReqDto);
    }
}

