/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportReportCenterMaiyouSaleOrderDetailReportVO;
import com.dtyunxi.cis.pms.biz.model.GetSaleOrderDetailReportListPageParams;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSaleOrderDetailReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.search.api.dto.request.SaleOrderContrastPageParams;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_maiyou_sale_order_detail")
public class ExportMaiyouSaleOrderDetailServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ExportMaiyouSaleOrderDetailServiceImpl.class);
    @Resource
    ReportCenterSaleOrderDetailReportService reportCenterSaleOrderDetailReportService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u9ea6\u6709\u9500\u552e\u5217\u8868\u5bfc\u51faexportFileOperationCommon");
        GetSaleOrderDetailReportListPageParams params = new GetSaleOrderDetailReportListPageParams();
        SaleOrderContrastPageParams query = new SaleOrderContrastPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSaleOrderDetailReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderDetailReportListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(req -> {
            PageInfo saleOrderItemRespVoPageInfo = (PageInfo)RestResponseHelper.extractData(this.reportCenterSaleOrderDetailReportService.getSaleOrderDetailReportListPage((GetSaleOrderDetailReportListPageParams)req));
            PageInfo re = new PageInfo();
            BeanUtils.copyProperties((Object)saleOrderItemRespVoPageInfo, (Object)re);
            if (CollectionUtils.isNotEmpty((Collection)saleOrderItemRespVoPageInfo.getList())) {
                re.setList(saleOrderItemRespVoPageInfo.getList().stream().map(o -> {
                    ExportReportCenterMaiyouSaleOrderDetailReportVO vo = new ExportReportCenterMaiyouSaleOrderDetailReportVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setSaleOrderNo(o.getSaleOrderNo());
                    try {
                        vo.setOrderStatus(SaleOrderStatusEnum.forCode((String)o.getOrderStatus()).getDesc());
                    }
                    catch (Exception e) {
                        vo.setOrderStatus(o.getOrderStatus());
                    }
                    vo.setOrderSource(SaleOrderSourceEnum.enumOf((Integer)Integer.valueOf(o.getOrderSource())).getDesc());
                    vo.setCargoRightCode(o.getCargoRightCode());
                    vo.setCargoRightName(o.getCargoRightName());
                    vo.setDeliveryPhysicalWarehouseName(o.getDeliveryPhysicalWarehouseName());
                    vo.setItemNum(o.getGoodsTotalNum() == null ? null : o.getGoodsTotalNum().setScale(0, 1));
                    vo.setOutWarehouseNum(o.getOutWarehouseNum() == null ? null : o.getOutWarehouseNum().setScale(0, 1));
                    vo.setLogicalWarehouseName(o.getLogicalWarehouseName());
                    vo.setBatchNo(o.getDeliveryOutBatchNo());
                    if (o.getCreateTime() != null) {
                        vo.setCreateTime(o.getCreateTime());
                    }
                    if (o.getUpdateTime() != null) {
                        vo.setUpdateTime(o.getUpdateTime());
                    }
                    if (StringUtils.isNotBlank((CharSequence)o.getOrderType())) {
                        vo.setIsPointGoods(Objects.equals(o.getIntegral(), 1) ? "\u662f" : "\u5426");
                    }
                    vo.setDetailAddress(this.getAddress(o.getOrderAddress()));
                    if (Objects.nonNull(o.getDeliveryAddress())) {
                        vo.setDeliveryCityName(o.getDeliveryAddress().getCity());
                        vo.setOrderProvinceName(o.getDeliveryAddress().getProvince());
                        vo.setOrderCityName(o.getDeliveryAddress().getCity());
                    }
                    try {
                        vo.setOrderTypeStr(SaleOrderTypeEnum.enumOf((String)o.getOrderType()).getDesc());
                    }
                    catch (Exception e) {
                        vo.setOrderTypeStr(o.getOrderType());
                    }
                    try {
                        vo.setAllotTypeStr(AllotTypeEnum.enumOf((String)o.getAllotType()).getDesc());
                    }
                    catch (Exception e) {
                        vo.setAllotTypeStr(o.getAllotType());
                    }
                    vo.setAllotOutWarehouseName(vo.getAllotOutWarehouseName());
                    vo.setAllotInWarehouseName(vo.getAllotInWarehouseName());
                    return vo;
                }).collect(Collectors.toList()));
            } else {
                re.setList(new ArrayList(0));
            }
            return re;
        }, params, ExportReportCenterMaiyouSaleOrderDetailReportVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u9ea6\u6709\u9500\u552e\u5217\u8868\u5bfc\u51faexportTotal");
        GetSaleOrderDetailReportListPageParams params = new GetSaleOrderDetailReportListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetSaleOrderDetailReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetSaleOrderDetailReportListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.reportCenterSaleOrderDetailReportService.getSaleOrderDetailReportListPage(params));
        if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)pageInfo.getList().size());
    }

    private String getAddress(AddressVO o) {
        String province = StringUtils.isNotEmpty((CharSequence)o.getProvince()) ? o.getProvince() : "";
        String city = StringUtils.isNotEmpty((CharSequence)o.getCity()) ? o.getCity() : "";
        String district = StringUtils.isNotEmpty((CharSequence)o.getDistrict()) ? o.getDistrict() : "";
        String detailAddress = StringUtils.isNotEmpty((CharSequence)o.getDetailAddress()) ? o.getDetailAddress() : "";
        return province + city + district + detailAddress;
    }
}

