/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.effective.EffectiveLoseStrategy;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cis.pms.biz.service.helper.TransferAddBaseDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicWarehouseReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsLockOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLockTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class EffectiveTransferOrderTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(EffectiveTransferOrderTask.class);
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private InventoryTransferHelper inventoryTransferHelper;
    @Resource
    private ICsLockOrderApi csLockOrderApi;
    @Resource
    private EffectiveLoseStrategy effectiveLoseStrategy;
    @Value(value="${effectice.transfer.log:true}")
    private boolean enable;

    public void before(TaskMsg taskMsg) {
        log.info("\u8fd1\u6548\u671f\u8c03\u62e8task==========");
    }

    public boolean execute(TaskMsg taskMsg) {
        CompletableFuture.runAsync(() -> {
            ServiceContext.getContext().setAttachment("reqId", String.valueOf(UUID.randomUUID()));
            if (!this.executor().booleanValue()) {
                log.info("\u672c\u6b21\u8fd1\u6548\u671f\u8c03\u62e8\u672a\u5339\u914d\u5355\u636e");
            }
        });
        return true;
    }

    private Boolean executor() {
        return Optional.ofNullable(this.effectiveLoseStrategy.loadEffectiveLoseInventory()).filter(CollectionUtils::isNotEmpty).map(list -> {
            this.log("\u83b7\u53d6\u8fd1\u6548\u671f\u5e93\u5b58:{}", JSONObject.toJSONString((Object)list));
            Map<String, List<LogicInventoryRespDto>> map = list.stream().collect(Collectors.groupingBy(LogicInventoryRespDto::getWarehouseCode));
            Map<String, LogicWarehouseRespDto> transferWarehouseMap = this.loadTargetWarehouse((List<LogicInventoryRespDto>)list);
            this.log("\u5339\u914d\u5230\u4ed3\u5e93:{}", JSONObject.toJSONString(transferWarehouseMap));
            map.forEach((sourceWarehouse, inventoryList) -> {
                LogicWarehouseRespDto inLogicWarehouseRespDto = (LogicWarehouseRespDto)transferWarehouseMap.get(sourceWarehouse);
                if (inLogicWarehouseRespDto != null) {
                    this.addTransfer((String)sourceWarehouse, (List<LogicInventoryRespDto>)inventoryList, inLogicWarehouseRespDto);
                } else {
                    this.lockInventory((List<LogicInventoryRespDto>)inventoryList);
                }
            });
            return true;
        }).orElse(false);
    }

    private void lockInventory(List<LogicInventoryRespDto> inventoryList) {
        List lockList = inventoryList.stream().map(vo -> {
            CsLockOrderUpdateReqDto dto = new CsLockOrderUpdateReqDto();
            dto.setLongCode(vo.getItemLongCode());
            dto.setBatch(vo.getBatch());
            dto.setWarehouseCode(vo.getWarehouseCode());
            dto.setCargoCode(vo.getItemLongCode());
            dto.setRemark("\u8fd1\u6548\u671f\u8c03\u62e8\u51fa\u5e93\u5b58\u672a\u8bbe\u7f6e\u5165\u5e93\u903b\u8f91\u4ed3");
            dto.setCurrentLockQuantity(vo.getAvailable());
            return dto;
        }).collect(Collectors.toList());
        try {
            RestResponseHelper.extractData((RestResponse)this.csLockOrderApi.batchUpdateLockInventory(CsLockTypeEnum.LOCK.getCode(), lockList));
        }
        catch (Exception e) {
            this.log("\u8fd1\u6548\u671f\u8c03\u62e8\u9501\u5e93\u5f02\u5e38:{}", e.getMessage());
            e.printStackTrace();
        }
    }

    private Map<String, LogicWarehouseRespDto> loadTargetWarehouse(List<LogicInventoryRespDto> list) {
        Map refWarehouseCode = list.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getInNearExpireWarehouse())).collect(Collectors.groupingBy(LogicInventoryRespDto::getInNearExpireWarehouse, Collectors.mapping(LogicInventoryRespDto::getWarehouseCode, Collectors.toList())));
        if (refWarehouseCode.isEmpty()) {
            return Maps.newHashMap();
        }
        LogicWarehouseReqDto logicWarehouseReqDto = new LogicWarehouseReqDto();
        logicWarehouseReqDto.setWarehouseCodes(new ArrayList<String>(refWarehouseCode.keySet()));
        FetchDataService fetchDataService = req -> (PageInfo)this.logicWarehouseQueryApi.queryByPageByPost(req).getData();
        return fetchDataService.fetchAll(logicWarehouseReqDto).stream().flatMap(l -> Optional.ofNullable(refWarehouseCode.get(l.getWarehouseCode())).filter(CollectionUtils::isNotEmpty).map(codes -> codes.stream().map(code -> new TwoTuple(code, l))).orElse(null)).collect(Collectors.toMap(TwoTuple::getFirst, TwoTuple::getSecond, (o, o1) -> o));
    }

    private void log(String prefix, String data) {
        if (this.enable) {
            log.info(prefix, (Object)data);
        }
    }

    private void addTransfer(String sourceWarehouse, List<LogicInventoryRespDto> inventoryList, LogicWarehouseRespDto ware) {
        try {
            TransferAddBaseDto transferAddBaseDto = new TransferAddBaseDto(sourceWarehouse, inventoryList, ware, CsPcpBusinessTypeEnum.ALLOT_LOSE_EFFICACY.getCode(), null);
            transferAddBaseDto.setAutoAudit(true);
            this.inventoryTransferHelper.doAddTransfer(transferAddBaseDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8fd1\u6548\u671f\u8c03\u62e8\u5931\u8d25:{},{},{}", new Object[]{sourceWarehouse, ware.getWarehouseCode(), e.getMessage()});
        }
    }

    public void after(TaskMsg taskMsg) {
    }
}

