/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportLogisticsDetailChargingVO;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.LogisticDetailChargingReportService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.tcbj.api.IFinLogisticDetailChargingApi;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailChargingDto;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_logistics_detail_charging_place_export")
public class LogisticsDetailChargingPlaceExportServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsDetailChargingPlaceExportServiceImpl.class);
    @Resource
    private LogisticDetailChargingReportService logisticDetailChargingReportService;
    @Resource
    private IFinLogisticDetailChargingApi finLogisticDetailChargingApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        log.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5165\u53c2\uff1a{}", (Object)commonReqDto);
        this.getDate(commonReqDto);
        log.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u65e5\u671f\u8f6c\u6362\u540e\u7684\u53c2\u6570\uff1a{}", (Object)commonReqDto);
        FinLogisticDetailChargingDto getLogicalInventoryListPageParams = new FinLogisticDetailChargingDto();
        getLogicalInventoryListPageParams = (FinLogisticDetailChargingDto)JSON.parseObject((String)commonReqDto.getFilter(), FinLogisticDetailChargingDto.class);
        AssertUtil.isFalse(StringUtils.isBlank((CharSequence)getLogicalInventoryListPageParams.getBookkeepingDate()), "\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u65e5\u671f\u8f6c\u6362\u540e\uff0c\u7c7b\u578b\u8f6c\u6362\u540e\u7684\u53c2\u6570\uff1a{}", (Object)commonReqDto);
        ArrayList<Long> waitPlaceIdList = new ArrayList<Long>();
        List<String> urls = null;
        AtomicReference<String> errorMsg = new AtomicReference<String>("");
        try {
            urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
                PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.logisticDetailChargingReportService.queryPage((FinLogisticDetailChargingDto)re));
                PageInfo pageInfo = new PageInfo();
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List list = BeanUtil.copyToList((Collection)respDtoPageInfo.getList(), ExportLogisticsDetailChargingVO.class);
                waitPlaceIdList.addAll(respDtoPageInfo.getList().stream().map(BaseDto::getId).filter(Objects::nonNull).collect(Collectors.toList()));
                pageInfo.setList(list);
                return pageInfo;
            }, getLogicalInventoryListPageParams, ExportLogisticsDetailChargingVO.class, commonReqDto.getFileName());
            AssertUtil.isFalse(CollectionUtils.isEmpty(urls), "\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff0c\u6ca1\u6709\u751f\u6210\u6587\u4ef6\u94fe\u63a5");
        }
        catch (Exception e) {
            errorMsg.set("\u5bfc\u51fa\u6267\u884c\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.placeCallBack(commonReqDto, errorMsg, String.join((CharSequence)",", urls), waitPlaceIdList, list -> {
                try {
                    ListUtils.partition((List)waitPlaceIdList, (int)2000).forEach(slice -> {
                        FeeReportPlaceUpdateReqDto feeReportPlaceUpdateReqDto = new FeeReportPlaceUpdateReqDto();
                        feeReportPlaceUpdateReqDto.setModuleRecordIdList(slice);
                        feeReportPlaceUpdateReqDto.setPlacedFlag(Integer.valueOf(1));
                        log.info("\u66f4\u65b0\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)slice.size());
                        this.finLogisticDetailChargingApi.updatePlaceStatus(feeReportPlaceUpdateReqDto);
                    });
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    errorMsg.set("\u66f4\u65b0\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        FinLogisticDetailChargingDto params = new FinLogisticDetailChargingDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (FinLogisticDetailChargingDto)JSON.parseObject((String)commonReqDto.getFilter(), FinLogisticDetailChargingDto.class);
        }
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.logisticDetailChargingReportService.queryPage(params));
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)pageInfo.getTotal());
    }

    private void getDate(ExportFileOperationCommonReqDto commonReqDto) {
        if (StringUtils.isBlank((CharSequence)commonReqDto.getFilter())) {
            return;
        }
        Map filterMap = (Map)JSON.parseObject((String)commonReqDto.getFilter(), Map.class);
        Object params = filterMap.get("params");
        if (ObjectUtil.isNotEmpty(params)) {
            String[] split;
            Object physicalWarehouse;
            Map paramsMap = (Map)JSON.parseObject((String)params.toString(), Map.class);
            if (ObjectUtil.isNotEmpty(paramsMap.get("placedFlagDate"))) {
                filterMap.put("bookkeepingDate", paramsMap.get("placedFlagDate"));
            }
            if (ObjectUtil.isNotEmpty(paramsMap.get("warehouseNameList"))) {
                physicalWarehouse = paramsMap.get("warehouseNameList");
                split = physicalWarehouse.toString().split(",");
                filterMap.put("warehouseNameList", Arrays.asList(split));
            }
            if (ObjectUtil.isNotEmpty(paramsMap.get("logisticCompanyCodeList"))) {
                physicalWarehouse = paramsMap.get("logisticCompanyCodeList");
                split = physicalWarehouse.toString().split(",");
                filterMap.put("logisticCompanyCodeList", Arrays.asList(split));
            }
            if (ObjectUtil.isNotEmpty(paramsMap.get("transportTypeList"))) {
                physicalWarehouse = paramsMap.get("transportTypeList");
                split = physicalWarehouse.toString().split(",");
                filterMap.put("transportTypeList", Arrays.asList(split));
            }
        }
        commonReqDto.setFilter(JSON.toJSONString((Object)filterMap));
    }
}

