/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.express.ExpressCostChargingExportDto;
import com.dtyunxi.cis.pms.biz.service.ExpressCostOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IExpressCostChargingApi;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostChargingRespDto;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_express_cost_charging_place_export")
public class ExpressCostChargingPlaceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExpressCostOrderService {
    private static final Logger log = LoggerFactory.getLogger(ExpressCostChargingPlaceServiceImpl.class);
    private static final BigDecimal EER_NUM = new BigDecimal("-1");
    @Resource
    private IExpressCostChargingApi expressCostChargingApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        log.info("\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa1\uff1a{}", (Object)JSON.toJSONString((Object)commonReqDto.getFilter()));
        this.getDate(commonReqDto);
        ExpressCostReportQueryDto getLogicalInventoryListPageParams = (ExpressCostReportQueryDto)JSON.parseObject((String)commonReqDto.getFilter(), ExpressCostReportQueryDto.class);
        log.info("\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa2\uff1a{}", (Object)JSON.toJSONString((Object)getLogicalInventoryListPageParams));
        ArrayList<Long> waitPlaceIdList = new ArrayList<Long>();
        List<String> urls = null;
        AtomicReference<String> errorMsg = new AtomicReference<String>("");
        try {
            urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
                log.info("\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)re));
                RestResponse pageInfoRestResponse = this.expressCostChargingApi.queryByPage(re);
                PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
                log.info("\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
                PageInfo pageInfo = new PageInfo();
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
                List<Object> list = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                    list = respDtoPageInfo.getList().stream().map(o -> {
                        ExpressCostChargingExportDto vo = new ExpressCostChargingExportDto();
                        BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                        vo.setFirstPrice(this.formatValue(o.getFirstPricePer()));
                        vo.setContinuedOne(this.formatValue(o.getContinuedOnePer()));
                        vo.setContinuedTwo(this.formatValue(o.getContinuedTwoPer()));
                        vo.setContinuedThree(this.formatValue(o.getContinuedThreePer()));
                        vo.setContinuedFour(this.formatValue(o.getContinuedFourPer()));
                        vo.setContinuedFreight(this.formatValue(o.getContinuedFreight()));
                        vo.setTotalFreight(this.formatValue(o.getTotalFreight()));
                        vo.setApportionWeight(this.formatValue(o.getApportionWeight()));
                        vo.setAllocationQuantity(this.formatValue(o.getAllocationQuantity()));
                        vo.setOrgTotalFreight(this.formatValue(o.getOrgTotalFreight()));
                        return vo;
                    }).collect(Collectors.toList());
                    waitPlaceIdList.addAll(respDtoPageInfo.getList().stream().map(ExpressCostChargingRespDto::getId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                pageInfo.setList((List)list);
                return pageInfo;
            }, getLogicalInventoryListPageParams, ExpressCostChargingExportDto.class, commonReqDto.getFileName());
            AssertUtil.isFalse(CollectionUtils.isEmpty(urls), "\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff0c\u6ca1\u6709\u751f\u6210\u6587\u4ef6\u94fe\u63a5");
        }
        catch (Exception e) {
            errorMsg.set("\u5bfc\u51fa\u6267\u884c\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.placeCallBack(commonReqDto, errorMsg, String.join((CharSequence)",", urls), waitPlaceIdList, list -> {
                try {
                    FeeReportPlaceUpdateReqDto feeReportPlaceUpdateReqDto = new FeeReportPlaceUpdateReqDto();
                    feeReportPlaceUpdateReqDto.setModuleRecordIdList(waitPlaceIdList);
                    feeReportPlaceUpdateReqDto.setPlacedFlag(Integer.valueOf(1));
                    log.info("\u66f4\u65b0\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)waitPlaceIdList.size());
                    this.expressCostChargingApi.updatePlaceStatus(feeReportPlaceUpdateReqDto);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    errorMsg.set("\u66f4\u65b0\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        this.getDate(commonReqDto);
        ExpressCostReportQueryDto param = (ExpressCostReportQueryDto)JSON.parseObject((String)commonReqDto.getFilter(), ExpressCostReportQueryDto.class);
        param.setPageSize(Integer.valueOf(1));
        param.setPageNum(Integer.valueOf(1));
        RestResponse pageInfoRestResponse = this.expressCostChargingApi.queryByPage(param);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }

    private void getDate(ExportFileOperationCommonReqDto commonReqDto) {
        if (StringUtils.isBlank((CharSequence)commonReqDto.getFilter())) {
            return;
        }
        Map filterMap = (Map)JSON.parseObject((String)commonReqDto.getFilter(), Map.class);
        Object params = filterMap.get("params");
        if (ObjectUtil.isNotEmpty(params)) {
            Map paramsMap = (Map)JSON.parseObject((String)params.toString(), Map.class);
            filterMap.putAll(paramsMap);
        }
        commonReqDto.setFilter(JSON.toJSONString((Object)filterMap));
    }

    private String formatValue(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.compareTo(EER_NUM) == 0 ? "\u5f02\u5e38" : value.stripTrailingZeros().toPlainString();
    }
}

