/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportOutNoticeReportVO;
import com.dtyunxi.cis.pms.biz.model.GetOutNoticeOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutNoticeOrderVO;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillOutNoticeOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.WmsTrackStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_out_notice_sheet")
public class ExportOutNoticeServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    @Resource
    private InventoryCenterBillOutNoticeOrderService inventoryCenterBillOutNoticeOrderService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetOutNoticeOrderListPageParams params = new GetOutNoticeOrderListPageParams();
        params = (GetOutNoticeOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetOutNoticeOrderListPageParams.class);
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            RestResponse<PageInfo<OutNoticeOrderVO>> pageInfoRestResponse = this.inventoryCenterBillOutNoticeOrderService.getOutNoticeOrderListPage((GetOutNoticeOrderListPageParams)re);
            PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
            PageInfo im = new PageInfo();
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)im);
            ArrayList list = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                list.addAll(respDtoPageInfo.getList().stream().map(o -> {
                    ExportOutNoticeReportVO vo = new ExportOutNoticeReportVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setBusinessType(Optional.ofNullable(o.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                        if (ObjectUtils.isNotEmpty((Object)CsInventorySourceTypeEnum.getByCode((String)o.getBusinessType()))) {
                            return String.valueOf(CsInventorySourceTypeEnum.getByCode((String)o.getBusinessType()).getDesc());
                        }
                        if (ObjectUtils.isNotEmpty((Object)ExpressBusinessTypeEnum.getNameByType(o.getBusinessType()))) {
                            return String.valueOf(ExpressBusinessTypeEnum.getNameByType(o.getBusinessType()));
                        }
                        if (o.getBusinessType() == "baijian_direct_sales") {
                            return "\u4f70\u5065\u76f4\u9500";
                        }
                        return o.getBusinessType();
                    }).orElse(""));
                    vo.setDocumentStatus(Optional.ofNullable(o.getDocumentStatus()).filter(StringUtils::isNotBlank).map(documentStatus -> {
                        switch (documentStatus) {
                            case "oro_done_out": {
                                return "\u5df2\u51fa\u5e93";
                            }
                            case "oro_hang_up": {
                                return "\u6302\u8d77";
                            }
                            case "ono_total_out": {
                                return "\u5168\u90e8\u51fa\u5e93";
                            }
                            case "ono_wait_out": {
                                return "\u5f85\u51fa\u5e93";
                            }
                            case "ono_portion_out": {
                                return "\u90e8\u5206\u51fa\u5e93";
                            }
                            case "ono_cancel": {
                                return "\u5df2\u53d6\u6d88";
                            }
                            case "dno_wait_delivery": {
                                return "\u5f85\u53d1\u8d27";
                            }
                            case "finish": {
                                return "\u5df2\u5b8c\u6210";
                            }
                        }
                        return o.getDocumentStatus();
                    }).orElse(""));
                    if (StringUtils.isNotEmpty((CharSequence)o.getWmsStatus())) {
                        try {
                            vo.setWmsStatisStr(WmsTrackStatusEnum.getByType((String)o.getWmsStatus()).getDesc());
                        }
                        catch (Exception e) {
                            vo.setWmsStatisStr(o.getWmsStatus());
                        }
                    }
                    return vo;
                }).collect(Collectors.toList()));
            }
            im.setList((List)list);
            return im;
        }, params, ExportOutNoticeReportVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetOutNoticeOrderListPageParams params = new GetOutNoticeOrderListPageParams();
        params = (GetOutNoticeOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetOutNoticeOrderListPageParams.class);
        params.setPageSize(1);
        params.setPageNum(1);
        RestResponse<PageInfo<OutNoticeOrderVO>> pageInfoRestResponse = this.inventoryCenterBillOutNoticeOrderService.getOutNoticeOrderListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }
}

