/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.express.ExpressCostReportEditCostImportDto;
import com.dtyunxi.cis.pms.biz.service.ExpressCostOrderBackRemakeService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IExpressCostDetailApi;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDetailRespDto;
import com.dtyunxi.tcbj.api.query.IExpressCostDetailQueryApi;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_express_cost_report_edit_cost")
public class ExpressCostOrderEditCostServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExpressCostOrderBackRemakeService {
    private static final Logger logger = LoggerFactory.getLogger(ExpressCostOrderEditCostServiceImpl.class);
    @Resource
    private IExpressCostDetailQueryApi expressCostDetailQueryApi;
    @Resource
    private IExpressCostDetailApi expressCostDetailApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        logger.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\uff0c\u7f16\u8f91\u8d39\u7528verifyImportFileOperationCommon\uff1a{}", (Object)JSON.toJSONString((Object)result.getList()));
        List importDtoList = BeanUtil.copyToList((Collection)result.getList(), ExpressCostReportEditCostImportDto.class);
        List expressNoList = importDtoList.stream().map(ExpressCostReportEditCostImportDto::getExpressNo).collect(Collectors.toList());
        ExpressCostDetailReqDto reqDto = new ExpressCostDetailReqDto();
        reqDto.setExpressNoList(expressNoList);
        List expressCostDetailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.expressCostDetailQueryApi.queryList(reqDto));
        Map outboundCodeGroupMap = Optional.ofNullable(expressCostDetailRespDtoList).map(m -> m.stream().collect(Collectors.toMap(f -> f.getExpressNo() + f.getOutboundCode(), Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        Map e3CodeGroupMap = Optional.ofNullable(expressCostDetailRespDtoList).map(m -> m.stream().collect(Collectors.toMap(f -> f.getExpressNo() + f.getE3No(), Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        Map codeGroupMap = Optional.ofNullable(expressCostDetailRespDtoList).map(m -> m.stream().collect(Collectors.groupingBy(ExpressCostDetailRespDto::getExpressNo))).orElse(new HashMap());
        importDtoList.forEach(dto -> {
            StringBuffer errorMsg = new StringBuffer();
            if (ObjectUtil.isNotEmpty((Object)dto.getReturnFee()) && dto.getReturnFee().scale() > 2) {
                errorMsg.append("\u3010\u8fd4\u56de\u8d39\u7528\u3011\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u8d85\u8fc72\u4f4d\uff1b");
            }
            if (ObjectUtil.isNotEmpty((Object)dto.getInsureAmount()) && dto.getInsureAmount().scale() > 6) {
                errorMsg.append("\u3010\u6295\u4fdd\u91d1\u989d\u3011\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u8d85\u8fc76\u4f4d\uff1b");
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getOutboundCode()) && outboundCodeGroupMap.containsKey(dto.getExpressNo() + dto.getOutboundCode())) {
                ExpressCostDetailRespDto detailRespDto = (ExpressCostDetailRespDto)outboundCodeGroupMap.get(dto.getExpressNo() + dto.getOutboundCode());
                dto.setId(detailRespDto.getId());
                dto.setReportId(detailRespDto.getReportId());
            } else if (StringUtils.isNotBlank((CharSequence)dto.getOutboundCode()) && e3CodeGroupMap.containsKey(dto.getExpressNo() + dto.getOutboundCode())) {
                ExpressCostDetailRespDto detailRespDto = (ExpressCostDetailRespDto)e3CodeGroupMap.get(dto.getExpressNo() + dto.getOutboundCode());
                dto.setId(detailRespDto.getId());
                dto.setReportId(detailRespDto.getReportId());
            } else if (StringUtils.isBlank((CharSequence)dto.getOutboundCode()) && codeGroupMap.containsKey(dto.getExpressNo())) {
                List expressCostDetailRespList = (List)codeGroupMap.get(dto.getExpressNo());
                if (expressCostDetailRespList.size() == 1) {
                    ExpressCostDetailRespDto detailRespDto = (ExpressCostDetailRespDto)expressCostDetailRespList.get(0);
                    dto.setId(detailRespDto.getId());
                    dto.setReportId(detailRespDto.getReportId());
                } else {
                    errorMsg.append("\u627e\u4e0d\u5230\u552f\u4e00\u5355\u636e\uff1b");
                }
            } else {
                errorMsg.append("\u5355\u53f7\u4e0d\u5b58\u5728\uff1b");
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg.toString())) {
                dto.setErrorMsg(errorMsg.toString());
            }
        });
        return importDtoList;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        logger.info("\u5feb\u9012\u8d39\u7528\u62a5\u8868\uff0c\u7f16\u8f91\u8d39\u7528executeImportFileOperationCommon\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        List importDtoList = (List)obj;
        importDtoList.forEach(save -> {
            try {
                if (StringUtils.isEmpty((CharSequence)save.getErrorMsg())) {
                    ExpressCostDetailReqDto reqDto = new ExpressCostDetailReqDto();
                    reqDto.setId(save.getId());
                    reqDto.setReportId(save.getReportId());
                    reqDto.setPackingFreight(save.getPackingFreight());
                    reqDto.setReturnFee(save.getReturnFee());
                    reqDto.setIncrementFreight(save.getIncrementFreight());
                    reqDto.setInsureAmount(save.getInsureAmount());
                    reqDto.setPremium(save.getPremium());
                    reqDto.setAdjustmentType(save.getAdjustmentType());
                    reqDto.setAdjustmentAmount(save.getAdjustmentAmount());
                    reqDto.setRemark(save.getRemark());
                    RestResponseHelper.extractData((RestResponse)this.expressCostDetailApi.editCost(reqDto));
                }
            }
            catch (Exception e) {
                logger.error("\u5feb\u9012\u8d39\u7528\u62a5\u8868\uff0c\u7f16\u8f91\u8d39\u7528\u5bfc\u5165\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)save), (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
                save.setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff1a" + (e.getMessage().contains("\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c") ? "\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c" : e.getMessage()));
            }
        });
        String errorMsgUrl = null;
        List errorList = importDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        logger.info("\u9519\u8bef\u4fe1\u606f\u662ferrorList\uff1a{}", (Object)JSON.toJSONString(errorList));
        if (CollectionUtil.isNotEmpty(errorList)) {
            String excelName = String.format("%s%s", "\u5176\u4ed6\u8d39\u7528\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, ExpressCostReportEditCostImportDto.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

