/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cis.pms.biz.constant.PmsCsShipmentLogisticsTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportExpressReportVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.IImportCostReportDataCheckCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IExpressCostDetailApi;
import com.dtyunxi.tcbj.api.IExpressCostReportApi;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.query.IExpressCostDetailQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_express_report")
public class ImportExpressReportImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ImportExpressReportImpl.class);
    private final String ADD = "\u65b0\u589e";
    private final String UPD = "\u8986\u76d6";
    @Resource
    private IImportCostReportDataCheckCommonService dataCheckCommonService;
    @Resource
    private IExpressCostReportApi expressCostReportApi;
    @Resource
    private IExpressCostDetailQueryApi expressCostDetailQueryApi;
    @Resource
    private IExpressCostDetailApi expressCostDetailApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportExpressReportVO.class);
        log.info("\u5feb\u9012\u660e\u7ec6\u5bfc\u5165verifyImportFileOperationCommon\uff1a{}", (Object)list);
        this.addListCheck(list);
        this.updListCheck(list);
        return list;
    }

    private void addListCheck(List<ImportExpressReportVO> list) {
        List addList = list.stream().filter(f -> f.getImportType().equals("\u65b0\u589e")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(addList)) {
            log.info("\u65e0\u65b0\u589e\u6570\u636e\u6821\u9a8c");
            return;
        }
        Map<String, BaseAreaVO> areaMap = this.dataCheckCommonService.getAreaMap();
        Map<String, EasCostOrgRespDto> costOrg = this.dataCheckCommonService.getCostOrg();
        Map<String, CsPhysicsWarehouseRespDto> physicsWarehouse = this.dataCheckCommonService.getPhysicsWarehouse();
        List<String> logicalWarehouseNameList = addList.stream().flatMap(vo -> Stream.of(vo.getOutWarehouseName(), vo.getInWarehouseName())).distinct().collect(Collectors.toList());
        Map<String, LogicWarehouseRespDto> logicalWarehouse = this.dataCheckCommonService.getLogicalWarehouse(logicalWarehouseNameList);
        Map<String, CsShipmenetEnterpriseRespDto> carrierMap = this.dataCheckCommonService.getCarrier();
        for (ImportExpressReportVO vo2 : list) {
            if (!vo2.getImportType().equals("\u65b0\u589e")) continue;
            EasCostOrgRespDto easCostOrgRespDto = costOrg.get(vo2.getFreightOrg());
            if (ObjectUtil.isNotEmpty((Object)easCostOrgRespDto)) {
                vo2.setFreightOrgCode(easCostOrgRespDto.getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutOrg()) && ObjectUtil.isNotEmpty((Object)costOrg.get(vo2.getOutOrg()))) {
                vo2.setOutOrgCode(costOrg.get(vo2.getOutOrg()).getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getInOrg()) && ObjectUtil.isNotEmpty((Object)costOrg.get(vo2.getInOrg()))) {
                vo2.setInOrgCode(costOrg.get(vo2.getInOrg()).getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutPhysicsWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)physicsWarehouse.get(vo2.getOutPhysicsWarehouseName()))) {
                    vo2.setErrorMsg("\u51fa\u5e93\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setOutPhysicsWarehouseCode(physicsWarehouse.get(vo2.getOutPhysicsWarehouseName()).getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)physicsWarehouse.get(vo2.getWarehouseName()))) {
                    vo2.setErrorMsg("\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setWarehouseCode(physicsWarehouse.get(vo2.getWarehouseName()).getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)logicalWarehouse.get(vo2.getOutWarehouseName()))) {
                    vo2.setErrorMsg("\u51fa\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setOutWarehouseCode(logicalWarehouse.get(vo2.getOutWarehouseName()).getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getInWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)logicalWarehouse.get(vo2.getInWarehouseName()))) {
                    vo2.setErrorMsg("\u5165\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setInWarehouseCode(logicalWarehouse.get(vo2.getInWarehouseName()).getWarehouseCode());
            }
            if (!ObjectUtil.isNotEmpty((Object)carrierMap.get(vo2.getLogisticCompany()))) {
                vo2.setErrorMsg("\u7269\u6d41\u5546\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            vo2.setLogisticCode(carrierMap.get(vo2.getLogisticCompany()).getShipmentEnterpriseCode());
            vo2.setLogisticCompanyTransportType(carrierMap.get(vo2.getLogisticCompany()).getLogisticsType());
            Integer shippingTypeCode = PmsCsShipmentLogisticsTypeEnum.getTypeByDesc(vo2.getTransportType());
            if (ObjectUtil.isEmpty((Object)shippingTypeCode)) {
                vo2.setErrorMsg("\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            vo2.setTransportTypeCode(shippingTypeCode.toString());
            if (!vo2.getLogisticCompanyTransportType().contains(vo2.getTransportTypeCode())) {
                vo2.setErrorMsg("\u8be5\u7269\u6d41\u5546\u4e0b\u4e0d\u5b58\u5728\u8be5\u627f\u8fd0\u65b9\u5f0f\uff1b");
                continue;
            }
            String checkError = this.dataCheckCommonService.checkArea(areaMap, vo2.getProvince(), vo2.getCity(), vo2.getArea());
            if (!StringUtils.isNotBlank((CharSequence)checkError)) continue;
            vo2.setErrorMsg(checkError);
        }
    }

    private void updListCheck(List<ImportExpressReportVO> list) {
        List updList = list.stream().filter(f -> f.getImportType().equals("\u8986\u76d6")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(updList)) {
            log.info("\u65e0\u7f16\u8f91\u6570\u636e\u6821\u9a8c");
            return;
        }
        List expressNoList = updList.stream().map(ImportExpressReportVO::getExpressNo).collect(Collectors.toList());
        ExpressCostDetailReqDto detailReqDto = new ExpressCostDetailReqDto();
        detailReqDto.setExpressNoList(expressNoList);
        List detailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.expressCostDetailQueryApi.queryList(detailReqDto));
        if (CollectionUtil.isEmpty((Collection)detailRespDtoList)) {
            log.info("\u65e0\u5e93\u5185\u5feb\u9012\u660e\u7ec6\u6570\u636e");
            list.forEach(vo -> {
                if (vo.getImportType().equals("\u8986\u76d6")) {
                    vo.setErrorMsg("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff1b");
                }
            });
            return;
        }
        log.info("\u67e5\u8be2\u5e93\u5185\u5feb\u9012\u660e\u7ec6\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)detailRespDtoList));
        Map<String, List<ExpressCostDetailRespDto>> detailRespDtoMap = detailRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getExpressNo())).collect(Collectors.groupingBy(ExpressCostDetailRespDto::getExpressNo));
        for (ImportExpressReportVO vo2 : list) {
            if (!vo2.getImportType().equals("\u8986\u76d6")) continue;
            List<ExpressCostDetailRespDto> costDetailRespDtoList = detailRespDtoMap.get(vo2.getExpressNo());
            if (CollectionUtil.isEmpty(costDetailRespDtoList)) {
                vo2.setErrorMsg("\u65e0\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            ExpressCostDetailRespDto respDto = null;
            int i = 0;
            for (ExpressCostDetailRespDto detailRespDto : costDetailRespDtoList) {
                if (StringUtils.isNotBlank((CharSequence)vo2.getOutDocumentNo()) && !vo2.getOutDocumentNo().equals(detailRespDto.getOutNoticeNo())) continue;
                ++i;
                respDto = detailRespDto;
            }
            if (ObjectUtil.isEmpty(respDto)) {
                vo2.setErrorMsg("\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            if (i > 1) {
                vo2.setErrorMsg("\u627e\u4e0d\u5230\u552f\u4e00\u660e\u7ec6\u4fe1\u606f");
                continue;
            }
            vo2.setId(respDto.getId());
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        log.info("\u5feb\u9012\u660e\u7ec6\u5bfc\u5165executeImportFileOperationCommon\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        List list = (List)obj;
        for (ImportExpressReportVO vo : list) {
            ExpressCostDetailReqDto reqDto;
            if (StringUtils.isNotBlank((CharSequence)vo.getErrorMsg())) continue;
            if (vo.getImportType().equals("\u8986\u76d6")) {
                try {
                    reqDto = new ExpressCostDetailReqDto();
                    reqDto.setId(vo.getId());
                    reqDto.setOcsSystemWeight(vo.getOcsSystemWeight());
                    reqDto.setChargedWeight(vo.getChargedWeight());
                    reqDto.setVolumeWeight(vo.getVolumeWeight());
                    reqDto.setVolumeRemark(vo.getVolumeRemark());
                    reqDto.setFirstPrice(vo.getFirstPrice());
                    reqDto.setContinuedOne(vo.getContinuedOne());
                    reqDto.setContinuedTwo(vo.getContinuedTwo());
                    reqDto.setContinuedThree(vo.getContinuedThree());
                    reqDto.setContinuedFour(vo.getContinuedFour());
                    reqDto.setContinuedFreight(vo.getContinuedFreight());
                    reqDto.setFloatAmount(vo.getFloatAmount());
                    reqDto.setPackingFreight(vo.getPackingFreight());
                    reqDto.setReturnFee(vo.getReturnFee());
                    reqDto.setIncrementFreight(vo.getIncrementFreight());
                    reqDto.setInsureAmount(vo.getInsureAmount());
                    reqDto.setPremium(vo.getPremium());
                    if (StringUtils.isNotBlank((CharSequence)vo.getAdjustmentType())) {
                        reqDto.setAdjustmentType(vo.getAdjustmentType().equals("\u589e\u52a0") ? "1" : "2");
                    }
                    reqDto.setAdjustmentAmount(vo.getAdjustmentAmount());
                    reqDto.setRemark(vo.getRemark());
                    reqDto.setTotalFreight(vo.getTotalFreight());
                    reqDto.setExpressBackRemake(vo.getExpressBackRemake());
                    if (ObjectUtils.isNotEmpty((Object)reqDto.getExpressBackRemake()) && ObjectUtil.isNotEmpty((Object)reqDto.getOcsSystemWeight())) {
                        reqDto.setWeightDifference(vo.getExpressBackRemake().subtract(reqDto.getOcsSystemWeight()));
                    }
                    this.expressCostDetailApi.updExpressCostDetailByImport(reqDto);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)((Object)vo)), (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    vo.setErrorMsg("\u66f4\u65b0\u5f02\u5e38" + e.getMessage());
                }
                continue;
            }
            try {
                reqDto = (ExpressCostDetailReqDto)BeanUtil.copyProperties((Object)((Object)vo), ExpressCostDetailReqDto.class, (String[])new String[0]);
                reqDto.setPlacedFlag(Integer.valueOf(0));
                reqDto.setFirstPricePre(vo.getFirstPrice());
                reqDto.setContinuedOnePre(vo.getContinuedOne());
                reqDto.setContinuedTwoPre(vo.getContinuedTwo());
                reqDto.setContinuedThreePre(vo.getContinuedThree());
                reqDto.setContinuedFourPre(vo.getContinuedFour());
                reqDto.setOutNoticeNo(vo.getOutDocumentNo());
                if (StringUtils.isNotBlank((CharSequence)vo.getRepeatStr())) {
                    reqDto.setIfRepeat(Integer.valueOf(vo.getRepeatStr().equals("\u662f") ? 1 : 0));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getAdjustmentType())) {
                    reqDto.setAdjustmentType(vo.getAdjustmentType().equals("\u589e\u52a0") ? "1" : "2");
                }
                if (ObjectUtils.isNotEmpty((Object)reqDto.getExpressBackRemake()) && ObjectUtil.isNotEmpty((Object)reqDto.getOcsSystemWeight())) {
                    reqDto.setWeightDifference(vo.getExpressBackRemake().subtract(reqDto.getOcsSystemWeight()));
                }
                reqDto.setAbnormal(Integer.valueOf(0));
                RestResponseHelper.extractData((RestResponse)this.expressCostDetailApi.addExpressCostDetailByImport((List)Lists.newArrayList((Object[])new ExpressCostDetailReqDto[]{reqDto})));
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)((Object)vo)), (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                vo.setErrorMsg("\u65b0\u589e\u5f02\u5e38" + e.getMessage());
            }
        }
        String errorMsgUrl = null;
        List errorList = list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorList)) {
            log.info("\u5feb\u9012\u660e\u7ec6\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString(errorList));
            String excelName = String.format("%s%s", "\u5feb\u9012\u660e\u7ec6\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, ImportExpressReportVO.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

