/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerDataManageMsgVO;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerDataManageVO;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryReportMsgVO;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryReportVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_report_center_daily_delivery_report")
public class ImportDailyDeliveryReportImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportDailyDeliveryReportImpl.class);
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportDailyDeliveryReportVO.class);
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u975e\u7535\u5546\u5355\u5bfc\u5165\u96c6\u5408\uff0clist\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashSet checkRepeatData = Sets.newHashSet();
        Map<String, DailyDeliveryReportDto> respDtoMap = this.getcodesMap(list);
        log.info("respDtoMap=={}", (Object)JSON.toJSONString(respDtoMap));
        for (ImportDailyDeliveryReportVO reportVO : list) {
            this.checkForm(reportVO);
            if (checkRepeatData.contains(reportVO.getDocumentNo())) {
                reportVO.setErrorMsg("\u6570\u636e\u91cd\u590d");
                continue;
            }
            checkRepeatData.add(reportVO.getDocumentNo());
            try {
                List dailyDeliveryReportDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.queryByDocumentNo((List)Lists.newArrayList((Object[])new String[]{reportVO.getDocumentNo()})));
                if (CollectionUtil.isEmpty((Collection)dailyDeliveryReportDtoList)) {
                    reportVO.setErrorMsg("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
                    continue;
                }
                DailyDeliveryReportDto reportDto = null;
                int i = 0;
                for (DailyDeliveryReportDto report : dailyDeliveryReportDtoList) {
                    if (!report.getDocumentNo().equals(reportVO.getDocumentNo()) || StringUtils.isNotBlank((CharSequence)reportVO.getTransportNo()) && !reportVO.getTransportNo().equals(report.getTransportNo())) continue;
                    reportDto = report;
                    ++i;
                }
                if (i == 0) {
                    reportVO.setErrorMsg("\u627e\u4e0d\u5230\u6570\u636e");
                    continue;
                }
                if (i > 1) {
                    reportVO.setErrorMsg("\u627e\u4e0d\u5230\u552f\u4e00\u6570\u636e");
                    continue;
                }
                reportVO.setId(reportDto.getId());
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5355\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                reportVO.setErrorMsg("\u67e5\u8be2\u5355\u636e\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u975e\u7535\u5546\u5355\u5bfc\u5165verifyImportFileOperationCommon\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)list));
        return list;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        List list = (List)obj;
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u975e\u7535\u5546\u5355\u5bfc\u5165executeImportFileOperationCommon\uff1a{}", (Object)JSON.toJSONString((Object)list));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (ImportDailyDeliveryReportVO v : list) {
                try {
                    DailyDeliveryReportDto reportDto = new DailyDeliveryReportDto();
                    reportDto.setId(v.getId());
                    reportDto.setShippingCompany(v.getShippingCompany());
                    reportDto.setShippingCompanyName(v.getShippingCompanyName());
                    reportDto.setShipmentEnterpriseCode(reportDto.getShippingCompany());
                    reportDto.setShipmentEnterpriseName(reportDto.getShippingCompanyName());
                    reportDto.setTransportStyle(v.getTransportStyle());
                    reportDto.setReceivingAddressProvince(v.getReceivingAddressProvince());
                    reportDto.setReceivingAddressCity(v.getReceivingAddressCity());
                    reportDto.setReceivingAddressDistrict(v.getReceivingAddressDistrict());
                    reportDto.setReceivingAddress(v.getReceivingAddress());
                    reportDto.setBillingCartons(v.getBillingCartons());
                    reportDto.setBillingVolume(v.getBillingVolume());
                    reportDto.setBillingWeight(v.getBillingWeight());
                    reportDto.setTransportNo(v.getTransportNoUpd());
                    reportDto.setOrderShippingTime(v.getOrderShippingTimeImport());
                    RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.modifyDailyDeliveryReport(reportDto));
                }
                catch (Exception e) {
                    log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u975e\u7535\u5546\u5355\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)((Object)v)), (Object)e.getMessage());
                    v.setErrorMsg("\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
        String errorMsgUrl = null;
        List errorMsgList = list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorMsgList)) {
            String excelName = String.format("%s%s", "\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u975e\u7535\u5546\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorMsgList, ImportDailyDeliveryReportVO.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private Map<String, DailyDeliveryReportDto> getcodesMap(List<ImportDailyDeliveryReportVO> list) {
        HashMap codesMap = Maps.newHashMap();
        for (ImportDailyDeliveryReportVO vo : list) {
            log.info("vo\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
            String wms = vo.getDocumentNo();
            log.info("vo\u5bf9\u8c61\u7684wms\u51fa\u5e93\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)wms));
            DailyDeliveryReportDto deliveryReport = (DailyDeliveryReportDto)this.dailyDeliveryReportApi.queryByWMS(wms).getData();
            if (deliveryReport == null) continue;
            codesMap.put(wms, deliveryReport);
        }
        return codesMap;
    }

    private void checkCode(ImportCustomerDataManageVO i, Map<String, PCPCustomerRespDto> codesMap, ImportCustomerDataManageMsgVO msgDto) {
        PCPCustomerRespDto pcpCustomerRespDto = codesMap.get(i.getCode());
        if (ObjectUtils.isNotEmpty((Object)pcpCustomerRespDto)) {
            i.setId(pcpCustomerRespDto.getId());
        }
    }

    private void checkEasCode(ImportCustomerDataManageVO i, Map<String, EasCostOrgRespDto> codesMap, ImportCustomerDataManageMsgVO msgDto) {
        EasCostOrgRespDto easCostOrgRespDto;
        if (StringUtils.isNotBlank((CharSequence)i.getThirdParentPartyId()) && ObjectUtils.isEmpty((Object)(easCostOrgRespDto = codesMap.get(i.getThirdParentPartyId())))) {
            msgDto.setErrorMsg("\u6240\u5c5e\u8d22\u52a1\u7f16\u7801\u4e0d\u5b58\u5728");
        }
    }

    private void checkForm(ImportDailyDeliveryReportVO msgDto) {
        if (msgDto.getDocumentNo() == null || msgDto.getDocumentNo().equals("")) {
            msgDto.setErrorMsg("WMS\u51fa\u5e93\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (!(StringUtils.isNotBlank((CharSequence)msgDto.getReceivingAddressProvince()) && StringUtils.isNotBlank((CharSequence)msgDto.getReceivingAddressCity()) || StringUtils.isBlank((CharSequence)msgDto.getReceivingAddressProvince()) && StringUtils.isBlank((CharSequence)msgDto.getReceivingAddressCity()))) {
            msgDto.setErrorMsg("\u7701\u5e02\u5fc5\u987b\u540c\u65f6\u586b\u5199\u6216\u8005\u90fd\u4e0d\u586b\u5199");
        }
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, ImportDailyDeliveryReportMsgVO msgDto) {
        if (StringUtils.isBlank((CharSequence)msgDto.getDocumentNo())) {
            msgDto.setErrorMsg("WMS\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(msgDto, "\u6570\u636e\u91cd\u590d");
            return;
        }
        checkRepeatData.add(uniqueKey);
        try {
            DailyDeliveryReportDto dailyDeliveryReportDto = (DailyDeliveryReportDto)this.dailyDeliveryReportApi.queryByWMS(msgDto.getDocumentNo()).getData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setErrorMsg(ImportDailyDeliveryReportMsgVO msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    public static String validateNumber(BigDecimal number, int i) {
        if (i == 1) {
            if (number.signum() <= 0 && number.scale() == 0) {
                return "\u8ba1\u8d39\u7bb1\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570";
            }
        } else {
            String numberStr = number.toPlainString();
            int integerPartLength = numberStr.contains(".") ? numberStr.substring(0, numberStr.indexOf(".")).length() : numberStr.length();
            int scale = number.stripTrailingZeros().scale();
            if (integerPartLength > 9 || scale > 6 || number.signum() <= 0) {
                return "\u5fc5\u987b\u4e3a\u6b63\u6570\u4e14\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e9\u4f4d,\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e6\u4f4d";
            }
        }
        return "";
    }
}

