/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.helper.SaleAllotMqHelper;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.common.wms.WmsOrderBaseDto;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleaseTaskApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderTagRecordApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferExtApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordAddBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="TRANSFER_AUDIT_FAIL", msgType="publish")
public class TransferOrderAuditNoPassProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderAuditNoPassProcessor.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleTransferOrderApi saleTransferOrderApi;
    @Resource
    private IOrderTagRecordApi orderTagRecordApi;
    @Resource
    private SaleAllotMqHelper saleAllotMqHelper;
    @Autowired
    ISaleTransferExtApi saleTransferExtApi;
    @Autowired
    private IInspectionReleaseTaskApi inspectionReleaseTaskApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u8c03\u62e8\u5355\u5ba1\u6838\u4e0d\u901a\u8fc7\u901a\u77e5\uff1a{}", (Object)JSON.toJSONString((Object)message));
        CsTransferOrderRespDto respDto = (CsTransferOrderRespDto)JSON.parseObject((String)message.getData().toString(), CsTransferOrderRespDto.class);
        BizSaleOrderRespDto saleOrderRespDto = null;
        try {
            logger.info("\u9500\u552e\u8c03\u62e8\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u9500\u552e\u5355\u81ea\u52a8\u89e3\u6302\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
            if (respDto.getType().equals(CsPcpBusinessTypeEnum.ALLOT_SALE.getCode())) {
                saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(respDto.getSaleOrderNo()));
                AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)saleOrderRespDto), (String)"\u627e\u4e0d\u5230\u9500\u552e\u5355");
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.doPcpStatusUnLockAndSystem(saleOrderRespDto.getSaleOrderNo()));
                OrderTagRecordAddBatchReqDto tagReqDto = new OrderTagRecordAddBatchReqDto();
                tagReqDto.setModel(OrderTagRecordAddBatchReqDto.ActionModel.DELETE);
                tagReqDto.setTagCodes((List)Lists.newArrayList((Object[])new String[]{"GSDB"}));
                tagReqDto.setSaleOrderIds((List)Lists.newArrayList((Object[])new Long[]{saleOrderRespDto.getId()}));
                this.orderTagRecordApi.addBatchOrderTagRecord(tagReqDto);
                this.saleTransferExtApi.delByOrderId(saleOrderRespDto.getId());
            } else {
                logger.info("\u975e\u9500\u552e\u8c03\u62e8\u4e0d\u505a\u5904\u7406");
            }
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8c03\u62e8\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u9500\u552e\u5355\u81ea\u52a8\u89e3\u6302\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            logger.info("\u9500\u552e\u8c03\u62e8\u6216\u9500\u552e\u8865\u8d27\u8c03\u62e8\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u8bf7\u6c42\u9500\u552e\u8c03\u62e8\u5173\u8054\u8bb0\u5f55");
            if (respDto.getType().equals(CsPcpBusinessTypeEnum.ALLOT_SALE.getCode()) || respDto.getType().equals(CsPcpBusinessTypeEnum.ALLOT_SALE_BH.getCode())) {
                SaleTransferOrderReqDto reqDto = new SaleTransferOrderReqDto();
                reqDto.setTransferOrderNo(respDto.getTransferOrderNo());
                RestResponseHelper.extractData((RestResponse)this.saleTransferOrderApi.removeSaleTransferOrderByParam(reqDto));
            } else {
                logger.info("\u975e\u9500\u552e\u8c03\u62e8\u6216\u9500\u552e\u8865\u8d27\u8c03\u62e8\u4e0d\u505a\u5904\u7406");
            }
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8c03\u62e8\u6216\u9500\u552e\u8865\u8d27\u8c03\u62e8\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u8bf7\u6c42\u9500\u552e\u8c03\u62e8\u5173\u8054\u8bb0\u5f55\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (Objects.nonNull(saleOrderRespDto)) {
                logger.info("\u9500\u552e\u8c03\u62e8\u5ba1\u6838\u4e0d\u901a\u8fc7\u5224\u65ad\u662f\u5426\u6700\u540e\u4e00\u4e2a\u9500\u552e\u5b50\u5355");
                WmsOrderBaseDto wmsOrderBaseDto = new WmsOrderBaseDto();
                wmsOrderBaseDto.setBusinessType(CsPcpBusinessTypeEnum.ALLOT_SALE.getCode());
                this.saleAllotMqHelper.sendOrderMergeMq(wmsOrderBaseDto, saleOrderRespDto);
            }
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8c03\u62e8\u5ba1\u6838\u4e0d\u901a\u8fc7\u53d1\u9001\u5408\u5355\u6307\u4ee4\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

