/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.FinishedGoodsInventoryTypeEnum;
import com.dtyunxi.cis.pms.biz.service.impl.ExternalE3ParamsBuild;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalE3Api;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BSOtherAddReqDto;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.WarehouseCorrespondingSystemEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="IN_NOTICE_TO_E3")
public class StockInToE3Processor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(StockInToE3Processor.class);
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ICsTransferOrderDetailApi csTransferOrderDetailQueryApi;
    @Resource
    private IExternalE3Api externalE3Api;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ExternalE3ParamsBuild externalE3ParamsBuild;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        log.info("\u5165\u5e93\u901a\u77e5\u5355\u5b8c\u6210\uff0c\u901a\u77e5E3\uff1a{}", (Object)JSON.toJSONString((Object)message));
        try {
            this.transferOrderInToE3(message);
        }
        catch (Exception e) {
            log.error("\u5165\u5e93\u901a\u77e5\u5355\u5b8c\u6210\uff0c\u901a\u77e5E3\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }

    private void transferOrderInToE3(MessageVo message) {
        CsOutNoticeOrderRespDto respDto = (CsOutNoticeOrderRespDto)JSON.parseObject((String)message.getData().toString(), CsOutNoticeOrderRespDto.class);
        if (!respDto.getOrderStatus().equals(BaseOrderStatusEnum.INO_WAIT_IN.getCode())) {
            log.info("\u975e\u5165\u5e93\u901a\u77e5");
            return;
        }
        if (!(respDto.getBusinessType().equals(FinishedGoodsInventoryTypeEnum.CC_ALLOT.getCode()) || respDto.getBusinessType().equals(FinishedGoodsInventoryTypeEnum.BC_ALLOT.getCode()) || respDto.getBusinessType().equals(FinishedGoodsInventoryTypeEnum.MAIYOU_BC_ALLOT.getCode()))) {
            log.info("\u975eE3\u5bf9\u63a5\u5355\u636e");
            return;
        }
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(respDto.getRelevanceNo()));
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)transferOrder), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
        CsOutNoticeOrderQueryDto csOutNoticeOrderQueryDto = new CsOutNoticeOrderQueryDto();
        csOutNoticeOrderQueryDto.setDocumentNo(respDto.getDocumentNo());
        csOutNoticeOrderQueryDto.setPageNum(Integer.valueOf(1));
        csOutNoticeOrderQueryDto.setPageSize(Integer.valueOf(1000));
        PageInfo csOutNoticeOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryDetailByPage(csOutNoticeOrderQueryDto));
        List transferOrderItems = csOutNoticeOrderDetailRespDtoPageInfo.getList();
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)transferOrderItems), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355\u660e\u7ec6");
        CsLogicWarehouseRespDto warehouse = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(transferOrder.getInLogicWarehouseCode()));
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)warehouse), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5165\u5e93\u4ed3\u5e93");
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)(!CsWarehouseTypeEnum.TCBJ_C.getCode().equals(warehouse.getWarehouseType()) ? 1 : 0)), (String)"\u5355\u636e\u7c7b\u578b\u5f02\u5e38\uff0c\u8c03\u62e8\u5165\u4ed3\u975eC\u4ed3");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)warehouse.getWarehouseCorrespondingSystem()), (String)"\u8c03\u62e8\u5165\u5e93\u4ed3\u5e93\u672a\u6807\u8bc6\u5bf9\u5e94E3\u7cfb\u7edf");
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)WarehouseCorrespondingSystemEnum.getByCode((String)warehouse.getWarehouseCorrespondingSystem())), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684E3\u7cfb\u7edf\u6807\u8bc6");
        WarehouseCorrespondingSystemEnum systemEnum = WarehouseCorrespondingSystemEnum.getByCode((String)warehouse.getWarehouseCorrespondingSystem());
        E3BSOtherAddReqDto e3BSOtherAddReqDto = new E3BSOtherAddReqDto();
        e3BSOtherAddReqDto.setDjbh(respDto.getDocumentNo());
        e3BSOtherAddReqDto.setLxdj(transferOrder.getTransferOrderNo());
        e3BSOtherAddReqDto.setCkdm(transferOrder.getInLogicWarehouseCode());
        e3BSOtherAddReqDto.setGhsdm(warehouse.getCargoEscheatageId());
        e3BSOtherAddReqDto.setZdr(transferOrder.getCreatePerson());
        e3BSOtherAddReqDto.setZdrq(DateUtil.format((Date)transferOrder.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        e3BSOtherAddReqDto.setBz(transferOrder.getRemark());
        e3BSOtherAddReqDto.setDetail(this.externalE3ParamsBuild.buildDetailList(transferOrderItems, systemEnum));
        switch (systemEnum) {
            case E3_BS: {
                RestResponseHelper.extractData((RestResponse)this.externalE3Api.bsOtherInAdd(e3BSOtherAddReqDto, respDto.getRelevanceNo()));
                break;
            }
            case E3_MY: {
                String myCkdm = transferOrder.getInLogicWarehouseCode().substring(transferOrder.getInLogicWarehouseCode().lastIndexOf(".") + 1);
                e3BSOtherAddReqDto.setCkdm(myCkdm);
                RestResponseHelper.extractData((RestResponse)this.externalE3Api.myOtherInAdd(e3BSOtherAddReqDto, respDto.getRelevanceNo()));
                break;
            }
            default: {
                throw new BizException("-1", "\u975eE3\u7cfb\u7edf\u6807\u8bc6");
            }
        }
    }
}

