/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.api.exception;

public enum ExceptionCode {
    SINGLE_EXPORT_MAX("1000", "\u5355\u6b21\u5bfc\u51fa\u6700\u5927\u53ea\u80fd\u5bfc1w\u6761"),
    CARD_CODE_LIST_NOT_EMPTY("1001", "\u5361\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a"),
    RIGHTS_MEMBER_EXPORT_FAIL("1002", "\u7b5b\u9009\u7ed3\u679c\u4e3a\u7a7a\uff0c\u540d\u5355\u5bfc\u51fa\u5931\u8d25"),
    USERID_IS_NOT_EXIST("1003", "\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728"),
    SHOP_CODE_IS_NOT_EXIST("1004", "\u5e97\u94fa\u7f16\u53f7\u67e5\u8be2\u4e3a\u7a7a"),
    PERIOD_IS_OUT_OF_RANGE("1005", "\u67e5\u8be2\u671f\u6570\u4e0d\u5408\u6cd5");

    private final String code;
    private final String msg;

    private ExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;
    }

    public static String getMsg(String iCode) {
        for (ExceptionCode value : ExceptionCode.values()) {
            if (!value.getCode().equals(iCode)) continue;
            return value.getMsg();
        }
        throw new RuntimeException(String.format("Err exception code:{}", iCode));
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String toString() {
        return "ExceptionCode{code='" + this.code + '\'' + ", msg='" + this.msg + '\'' + '}';
    }
}

