/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.util;

import com.dtyunxi.cis.search.api.dto.response.AddressVO;
import com.dtyunxi.cis.search.api.dto.response.PlatformOrderVO;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.JacksonUtil;
import java.util.Date;
import java.util.Map;

public class PlatformOrderRowMapper
implements RowMapper<PlatformOrderVO> {
    public PlatformOrderVO mapRow(Map<String, Object> docValue) {
        PlatformOrderVO platformOrderVO = (PlatformOrderVO)JacksonUtil.readValue((String)JacksonUtil.toJson(docValue), PlatformOrderVO.class);
        platformOrderVO.setCreateTime(this.builderFormatTime(docValue, "createTime"));
        platformOrderVO.setUpdateTime(this.builderFormatTime(docValue, "updateTime"));
        AddressVO orderAddress = new AddressVO();
        orderAddress.setDetailAddress(this.builderFormatStr(docValue, "detailAddress"));
        orderAddress.setProvince(this.builderFormatStr(docValue, "province"));
        orderAddress.setProvinceCode(this.builderFormatStr(docValue, "provinceCode"));
        orderAddress.setCity(this.builderFormatStr(docValue, "city"));
        orderAddress.setCityCode(this.builderFormatStr(docValue, "cityCode"));
        orderAddress.setDistrict(this.builderFormatStr(docValue, "county"));
        orderAddress.setDistrictCode(this.builderFormatStr(docValue, "countyCode"));
        platformOrderVO.setOrderAddress(orderAddress);
        platformOrderVO.setDeliveryName(this.builderFormatStr(docValue, "receiveName"));
        platformOrderVO.setDeliveryPhone(this.builderFormatStr(docValue, "receivePhone"));
        return platformOrderVO;
    }

    private String builderFormatStr(Map<String, Object> docValue, String reqParam) {
        if (docValue.get(reqParam) != null) {
            return docValue.get(reqParam).toString();
        }
        return null;
    }

    private String builderFormatTime(Map<String, Object> docValue, String timeLong) {
        if (docValue.get(timeLong) != null) {
            long deliveryTimeLong = Long.parseLong(docValue.get(timeLong).toString());
            if (deliveryTimeLong != 0L) {
                return DateUtil.format((Date)new Date(deliveryTimeLong), (String)DatePattern.DATETIME_PATTERN.getPattern());
            }
            return null;
        }
        return null;
    }
}

