/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.inventory;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.basedto.BasePlannedReqDto;
import com.dtyunxi.cis.search.api.dto.request.InPlannedOrderPageParams;
import com.dtyunxi.cis.search.api.dto.request.OutPlannedOrderPageParams;
import com.dtyunxi.cis.search.api.dto.response.InPlannedOrderVO;
import com.dtyunxi.cis.search.api.dto.response.OutPlannedOrderVO;
import com.dtyunxi.cis.search.api.query.inventory.EsPlannedOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.util.InPlannedOrderRowMapper;
import com.dtyunxi.cis.search.biz.util.OutPlannedOrderRowMapper;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderRespDto;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsPlannedOrderServiceImpl
extends BaseEsService
implements EsPlannedOrderQueryApi {
    String inPlannedOrderIndexName = "cs_in_planned_order";
    String outPlannedOrderIndexName = "cs_out_planned_order";
    private static final Logger logger = LoggerFactory.getLogger(EsPlannedOrderServiceImpl.class);
    @Resource
    private ICsInPlannedOrderQueryApi inPlannedOrderQueryApi;
    private static final String[] ORDER_NOS = new String[]{"platformOrderNo", "orderNo"};
    private static final String[] RECEIVE_WAREHOUSES = new String[]{"receiveWarehouseCode", "receiveWarehouseName"};
    private static final String[] DELIVERY_WAREHOUSES = new String[]{"deliveryWarehouseCode", "deliveryWarehouseName"};

    @PostConstruct
    private void init() {
        this.inPlannedOrderIndexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.inPlannedOrderIndexName;
        this.outPlannedOrderIndexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.outPlannedOrderIndexName;
    }

    private OSSearchVo initSearchVo(BasePlannedReqDto reqDto) {
        String orderNo;
        OSSearchVo queryVo = new OSSearchVo();
        queryVo.setPage(reqDto.getPageNum().intValue());
        queryVo.setPageSize(reqDto.getPageSize().intValue());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrdeType())) {
            queryVo.addEqualFilter("orderType", reqDto.getOrdeType());
        }
        if (StringUtils.isNotBlank((CharSequence)(orderNo = reqDto.getOrderNo()))) {
            String[] orderNos = RptUtil.regExSplit((String)orderNo);
            if (orderNos.length > 1) {
                queryVo.addInFilter(ORDER_NOS[0], orderNos, LogicalSymbol.OR);
                queryVo.addInFilter(ORDER_NOS[1], orderNos, LogicalSymbol.OR);
            } else {
                queryVo.addWildcardFilter(ORDER_NOS, this.wildcard(orderNo.toUpperCase()), LogicalSymbol.OR);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderStatus())) {
            queryVo.addEqualFilter("orderStatus", reqDto.getOrderStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBusinessType())) {
            queryVo.addEqualFilter("businessType", reqDto.getBusinessType());
        }
        String startTime = reqDto.getStartTime();
        String endTime = reqDto.getEndTime();
        if (StringUtils.isNotBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            queryVo.addRangeFilter("createTime", this.beginTimeLong(startTime), this.endTimeLong(endTime));
        }
        queryVo.addSort("createTime", SortOrder.DESC);
        logger.info("\u8ba1\u5212\u7c7b\u5355\u636eES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<InPlannedOrderVO>> queryInPlannedOrderPage(InPlannedOrderPageParams dto) {
        SearchResultVo searchResultVo;
        OSSearchVo queryVo = this.initSearchVo((BasePlannedReqDto)dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode())) {
            queryVo.addWildcardFilter("receiveWarehouseCode", this.wildcard(dto.getWarehouseCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseName())) {
            queryVo.addWildcardFilter("receiveWarehouseName", this.wildcard(dto.getWarehouseName()));
        }
        if (null == (searchResultVo = this.searchData(this.inPlannedOrderIndexName, queryVo)) || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new PageInfo());
        }
        logger.info("\u8ba1\u5212\u7c7b\u6b63\u5411\u5165\u5e93\u5355ES[es\u8fd4\u56deDocValues]:{}", (Object)JSON.toJSONString((Object)searchResultVo.getDocValues()));
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        List dtoList = searchResultVo.getDocValues((RowMapper)new InPlannedOrderRowMapper());
        List idList = dtoList.stream().map(InPlannedOrderVO::getId).collect(Collectors.toList());
        try {
            List respDtos = (List)this.inPlannedOrderQueryApi.queryByIds(idList).getData();
            if (CollUtil.isNotEmpty((Collection)respDtos)) {
                Map respDtoMap = respDtos.stream().collect(Collectors.toMap(CsInPlannedOrderRespDto::getOrderNo, Function.identity()));
                for (InPlannedOrderVO orderVO : dtoList) {
                    if (!respDtoMap.containsKey(orderVO.getOrderNo())) continue;
                    CsInPlannedOrderRespDto respDto = (CsInPlannedOrderRespDto)respDtoMap.get(orderVO.getOrderNo());
                    orderVO.setOrderStatus(respDto.getOrderStatus());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u8ba1\u5212\u7c7b\u5355\u636e\u5931\u8d25:{}", (Object)e.getMessage());
        }
        pageInfo.setList(dtoList);
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<PageInfo<OutPlannedOrderVO>> queryOutPlannedOrderPage(OutPlannedOrderPageParams dto) {
        OSSearchVo queryVo = this.initSearchVo((BasePlannedReqDto)dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode())) {
            queryVo.addWildcardFilter("deliveryWarehouseCode", this.wildcard(dto.getWarehouseCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseName())) {
            queryVo.addWildcardFilter("deliveryWarehouseName", this.wildcard(dto.getWarehouseName()));
        }
        queryVo.setPage(dto.getPageNum().intValue());
        queryVo.setPageSize(dto.getPageSize().intValue());
        SearchResultVo searchResultVo = this.searchData(this.outPlannedOrderIndexName, queryVo);
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new PageInfo());
        }
        logger.info("\u8ba1\u5212\u7c7b\u9006\u5411\u51fa\u5e93\u5355ES[es\u8fd4\u56deDocValues]:{}", (Object)JSON.toJSONString((Object)searchResultVo.getDocValues()));
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        List dtoList = searchResultVo.getDocValues((RowMapper)new OutPlannedOrderRowMapper());
        pageInfo.setList(dtoList);
        return new RestResponse((Object)pageInfo);
    }
}

