/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.source;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.request.EsSourceOrderListPageParams;
import com.dtyunxi.cis.search.api.dto.response.EsSourceOrderVO;
import com.dtyunxi.cis.search.api.query.source.EsSourceOrderQueryApi;
import com.dtyunxi.cis.search.biz.anno.ExecutorHandler;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.constant.ExecutorEnum;
import com.dtyunxi.cis.search.biz.util.EsParamUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ExecutorHandler(executorName={ExecutorEnum.SG_ORDER})
public class EsSourceOrderQueryServiceImpl
extends BaseEsService
implements EsSourceOrderQueryApi {
    private static final Logger log = LoggerFactory.getLogger(EsSourceOrderQueryServiceImpl.class);

    private OSSearchVo initSearchVo(EsSourceOrderListPageParams reqDto) throws Exception {
        String[] codes;
        OSSearchVo queryVo = EsParamUtils.newInstance().getSearchVo(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getLinkOrderChannelCodeList())) {
            codes = reqDto.getLinkOrderChannelCodeList().toArray(new String[reqDto.getLinkOrderChannelCodeList().size()]);
            queryVo.addInFilter("linkOrderChannelCode", codes, LogicalSymbol.OR);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getLinkOrderLogicWarehouseCodeList())) {
            codes = reqDto.getLinkOrderLogicWarehouseCodeList().toArray(new String[reqDto.getLinkOrderLogicWarehouseCodeList().size()]);
            queryVo.addInFilter("linkOrderLogicWarehouseCode", codes, LogicalSymbol.OR);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getKeywordList())) {
            codes = reqDto.getKeywordList().toArray(new String[reqDto.getKeywordList().size()]);
            queryVo.addInFilter("sgOrderNo", codes, LogicalSymbol.OR);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getKeywordList())) {
            codes = reqDto.getKeywordList().toArray(new String[reqDto.getKeywordList().size()]);
            queryVo.addInFilter("linkOrderNo", codes, LogicalSymbol.OR);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getKeywordList())) {
            codes = reqDto.getKeywordList().toArray(new String[reqDto.getKeywordList().size()]);
            queryVo.addInFilter("linkPlatformOrderNo", codes, LogicalSymbol.OR);
        }
        log.info("{}ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)this.mainExecutor.getDesc(), (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<EsSourceOrderVO>> querySourceOrderListPage(EsSourceOrderListPageParams dto) {
        PageInfo pageInfo = new PageInfo();
        try {
            List<String> strings;
            if (StringUtils.isNotEmpty((CharSequence)dto.getKeyword()) && (strings = Arrays.asList(dto.getKeyword().replace("\uff0c", ",").split(","))).size() > 1) {
                dto.setKeywordList(strings);
                dto.setKeyword(null);
            }
            OSSearchVo queryVo = this.initSearchVo(dto);
            queryVo.setPage(dto.getPageNum().intValue());
            queryVo.setPageSize(dto.getPageSize().intValue());
            SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            pageInfo = this.searchResultPage(searchResultVo);
            pageInfo.setList(this.baseRowMapper(searchResultVo, EsSourceOrderVO.class));
        }
        catch (Exception e) {
            log.error("{}ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", new Object[]{this.mainExecutor.getDesc(), e.getMessage(), e});
            throw new BizException(this.mainExecutor.getDesc() + "ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)pageInfo);
    }
}

