/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.source;

import com.dtyunxi.cis.search.api.dto.request.WarehouseProvideGoodsRangeReqParams;
import com.dtyunxi.cis.search.api.dto.response.WarehouseProvideGoodsRangeRespVo;
import com.dtyunxi.cis.search.api.query.source.EsWarehouseProvideGoodsRangeQueryApi;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.util.WarehouseProvideGoodsRangeRowMapper;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsWarehouseProvideGoodsRangeQueryServiceImpl
extends BaseEsService
implements EsWarehouseProvideGoodsRangeQueryApi {
    String indexName = "sg_warehouse_provide_goods_range";
    private static final Logger logger = LoggerFactory.getLogger(EsWarehouseProvideGoodsRangeQueryServiceImpl.class);

    @PostConstruct
    private void init() {
        this.indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.indexName;
    }

    private OSSearchVo initSearchVo(WarehouseProvideGoodsRangeReqParams reqDto) {
        OSSearchVo queryVo = new OSSearchVo();
        queryVo.setPage(reqDto.getPageNum().intValue());
        queryVo.setPageSize(reqDto.getPageSize().intValue());
        queryVo.addEqualFilter("dr", "0");
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getPhysicsWarehouseCode())) {
            queryVo.addWildcardFilter("physicsWarehouseCode", this.wildcard(reqDto.getPhysicsWarehouseCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAreaCode())) {
            queryVo.addEqualFilter("areaCode", reqDto.getAreaCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getProvinceCode())) {
            queryVo.addEqualFilter("provinceCode", reqDto.getProvinceCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCityCode())) {
            queryVo.addEqualFilter("cityCode", reqDto.getCityCode());
        }
        queryVo.addSort("id", SortOrder.DESC);
        return queryVo;
    }

    public RestResponse<PageInfo<WarehouseProvideGoodsRangeRespVo>> queryWarehouseProvideGoodsRangePage(WarehouseProvideGoodsRangeReqParams dto) {
        OSSearchVo queryVo = this.initSearchVo(dto);
        queryVo.setPage(dto.getPageNum().intValue());
        queryVo.setPageSize(dto.getPageSize().intValue());
        SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new PageInfo());
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        List dtoList = searchResultVo.getDocValues((RowMapper)new WarehouseProvideGoodsRangeRowMapper());
        pageInfo.setList(dtoList);
        return new RestResponse((Object)pageInfo);
    }
}

