/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.request.EsOtherStorageOrderListPageParams;
import com.dtyunxi.cis.search.api.dto.response.CsOtherStorageOrderRespVo;
import com.dtyunxi.cis.search.api.query.inventory.EsOtherStorageOrderQueryApi;
import com.dtyunxi.cis.search.biz.anno.ExecutorHandler;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.constant.ExecutorEnum;
import com.dtyunxi.cis.search.biz.util.EsParamUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ExecutorHandler(executorName={ExecutorEnum.CS_OTHER_STORAGE_ORDER})
public class EsOtherStorageOrderServiceImpl
extends BaseEsService
implements EsOtherStorageOrderQueryApi {
    private static final Logger log = LoggerFactory.getLogger(EsOtherStorageOrderServiceImpl.class);

    private OSSearchVo initSearchVo(EsOtherStorageOrderListPageParams reqDto) throws Exception {
        OSSearchVo queryVo = EsParamUtils.newInstance().getSearchVo(reqDto);
        String startTime = reqDto.getCreateBeginTime();
        String endTime = reqDto.getCreateEndTime();
        if (StringUtils.isNotBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            queryVo.addRangeFilter("createTime", this.beginTimeLong(startTime), this.endTimeLong(endTime));
        }
        log.info("{}ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)this.mainExecutor.getDesc(), (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<CsOtherStorageOrderRespVo>> queryOtherStorageOrderInListPage(EsOtherStorageOrderListPageParams dto) {
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            queryVo.setPage(dto.getPageNum().intValue());
            queryVo.setPageSize(dto.getPageSize().intValue());
            queryVo.addEqualFilter("type", "other_in");
            SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            pageInfo = this.searchResultPage(searchResultVo);
            pageInfo.setList(this.baseRowMapper(searchResultVo, CsOtherStorageOrderRespVo.class));
        }
        catch (Exception e) {
            log.error("{}ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", new Object[]{this.mainExecutor.getDesc(), e.getMessage(), e});
            throw new BizException(this.mainExecutor.getDesc() + "ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<PageInfo<CsOtherStorageOrderRespVo>> queryOtherStorageOrderOutListPage(EsOtherStorageOrderListPageParams dto) {
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            queryVo.setPage(dto.getPageNum().intValue());
            queryVo.setPageSize(dto.getPageSize().intValue());
            queryVo.addEqualFilter("type", "other_out");
            SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            pageInfo = this.searchResultPage(searchResultVo);
            pageInfo.setList(this.baseRowMapper(searchResultVo, CsOtherStorageOrderRespVo.class));
        }
        catch (Exception e) {
            log.error("{}ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", new Object[]{this.mainExecutor.getDesc(), e.getMessage(), e});
            throw new BizException(this.mainExecutor.getDesc() + "ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)pageInfo);
    }
}

