/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.delivery;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.request.EsReceiveNoticeOrderReqParams;
import com.dtyunxi.cis.search.api.dto.response.EsReceiveNoticeOrderRespVo;
import com.dtyunxi.cis.search.api.query.delivery.EsReceiveNoticeOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.util.ReceiveNoticeOrderRowMapper;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsReceiveNoticeOrderQueryServiceImpl
extends BaseEsService
implements EsReceiveNoticeOrderQueryApi {
    String indexName = "cs_delivery_notice_order";
    private static final Logger logger = LoggerFactory.getLogger(EsReceiveNoticeOrderQueryServiceImpl.class);
    private static final String[] ORDER_NOS = new String[]{"documentNo", "relevanceNo", "externalOrderNo"};
    private static final String[] DELLIVERY_WAREHOUSES = new String[]{"deliveryLogicWarehouseCode", "deliveryLogicWarehouseName"};
    private static final String[] RECEIVE_WAREHOUSES = new String[]{"receiveLogicWarehouseCode", "receiveLogicWarehouseName"};

    @PostConstruct
    private void init() {
        this.indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.indexName;
    }

    private OSSearchVo initSearchVo(EsReceiveNoticeOrderReqParams reqDto) {
        OSSearchVo queryVo = new OSSearchVo();
        queryVo.setPage(reqDto.getPageNum().intValue());
        queryVo.setPageSize(reqDto.getPageSize().intValue());
        queryVo.addEqualFilter("dr", "0");
        queryVo.addEqualFilter("version", "2");
        if (Objects.nonNull(reqDto.getOrderNo())) {
            String[] orderNos = RptUtil.regExSplit((String)reqDto.getOrderNo());
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : orderNos) {
                this.addWildcardFilter(filter, ORDER_NOS, this.wildcard(orderNo));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBusinessType())) {
            queryVo.addWildcardFilter("businessType", "*" + reqDto.getBusinessType() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderStatus())) {
            queryVo.addWildcardFilter("orderStatus", "*" + reqDto.getOrderStatus() + "*");
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getDocumentStatusList())) {
            queryVo.addInFilter("orderStatus", reqDto.getDocumentStatusList().toArray(new String[0]));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBusinessTypeList())) {
            queryVo.addInFilter("businessType", reqDto.getBusinessTypeList().toArray(new String[0]));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getNotBusinessTypeList())) {
            queryVo.addNonInFilter("businessType", reqDto.getNotBusinessTypeList().toArray(new String[0]));
        }
        String startTime = reqDto.getCreateBeginTime();
        String endTime = reqDto.getCreateEndTime();
        if (StringUtils.isNotBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            queryVo.addRangeFilter("createTime", this.beginTimeLong(startTime), this.endTimeLong(endTime));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryLogicalWarehouseName())) {
            queryVo.addWildcardFilter(DELLIVERY_WAREHOUSES, this.wildcard(reqDto.getDeliveryLogicalWarehouseName()), LogicalSymbol.OR);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getReceiveLogicalWarehouseName())) {
            queryVo.addWildcardFilter(RECEIVE_WAREHOUSES, this.wildcard(reqDto.getReceiveLogicalWarehouseName()), LogicalSymbol.OR);
        }
        queryVo.addEqualFilter("orderType", "receive");
        queryVo.addSort("createTime", SortOrder.DESC);
        logger.info("\u6536\u8d27\u901a\u77e5\u5355ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<EsReceiveNoticeOrderRespVo>> queryReceiveNoticeOrderPage(EsReceiveNoticeOrderReqParams dto) {
        OSSearchVo queryVo = this.initSearchVo(dto);
        queryVo.setPage(dto.getPageNum().intValue());
        queryVo.setPageSize(dto.getPageSize().intValue());
        SearchResultVo searchNoticeVo = this.searchData(this.indexName, queryVo);
        if (null == searchNoticeVo || searchNoticeVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new PageInfo());
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchNoticeVo.getTotalSize());
        pageInfo.setPageSize(searchNoticeVo.getPageSize());
        pageInfo.setPageNum(searchNoticeVo.getCurrentPage());
        pageInfo.setPages(searchNoticeVo.getTotalPageNum().intValue());
        List dtoList = searchNoticeVo.getDocValues((RowMapper)new ReceiveNoticeOrderRowMapper());
        pageInfo.setList(dtoList);
        return new RestResponse((Object)pageInfo);
    }
}

