/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.request.GetPlatformOrderListPageParams;
import com.dtyunxi.cis.search.api.dto.response.EsPlatformOrderCountVO;
import com.dtyunxi.cis.search.api.dto.response.PlatformOrderVO;
import com.dtyunxi.cis.search.api.query.trade.EsPlatformOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.util.PlatformOrderRowMapper;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.AggFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.AggResult;
import com.dtyunxi.huieryun.opensearch.vo.AggResultItem;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsPlatformOrderQueryServiceImpl
extends BaseEsService
implements EsPlatformOrderQueryApi {
    private static final Logger log = LoggerFactory.getLogger(EsPlatformOrderQueryServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(EsPlatformOrderQueryServiceImpl.class);
    String indexName = "tr_platform_order";
    private static final String[] ORDER_NOS = new String[]{"platformOrderNo", "saleOrderNo", "transformOrderNo"};

    @PostConstruct
    private void init() {
        this.indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.indexName;
    }

    private OSSearchVo initSearchVo(GetPlatformOrderListPageParams reqDto) {
        OSSearchVo queryVo = new OSSearchVo();
        queryVo.setPage(reqDto.getPageNum().intValue());
        queryVo.setPageSize(reqDto.getPageSize().intValue());
        queryVo.addEqualFilter("dr", "0");
        if (Objects.nonNull(reqDto.getOrderNo())) {
            String orderNo = reqDto.getOrderNo();
            String[] orderNos = RptUtil.regExSplit((String)orderNo);
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : orderNos) {
                this.addWildcardFilter(filter, ORDER_NOS, this.wildcard(o));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSourceOrderNo())) {
            queryVo.addWildcardFilter("sourceOrderNo", "*" + reqDto.getSourceOrderNo() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTransformOrderNo())) {
            queryVo.addWildcardFilter("transformOrderNo", "*" + reqDto.getTransformOrderNo() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getReTransformOrderNo())) {
            queryVo.addWildcardFilter("reTransformOrderNo", "*" + reqDto.getReTransformOrderNo() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getShopName())) {
            queryVo.addWildcardFilter("shopName", "*" + reqDto.getShopName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformCreateTimeStart())) {
            reqDto.setPlatformCreateTimeStartDate(DateUtil.parse((String)(reqDto.getPlatformCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformCreateTimeEnd())) {
            reqDto.setPlatformCreateTimeEndDate(DateUtil.parse((String)(reqDto.getPlatformCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderCreateTimeStart())) {
            reqDto.setSaleOrderCreateTimeStartDate(DateUtil.parse((String)(reqDto.getSaleOrderCreateTimeStart() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderCreateTimeEnd())) {
            reqDto.setSaleOrderCreateTimeEndDate(DateUtil.parse((String)(reqDto.getSaleOrderCreateTimeEnd() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (Objects.nonNull(reqDto.getPlatformCreateTimeStartDate()) && Objects.nonNull(reqDto.getPlatformCreateTimeEndDate())) {
            queryVo.addRangeFilter("platformCreateTime", String.valueOf(reqDto.getPlatformCreateTimeStartDate().getTime()), String.valueOf(reqDto.getPlatformCreateTimeEndDate().getTime()));
        }
        if (Objects.nonNull(reqDto.getSaleOrderCreateTimeStartDate()) && Objects.nonNull(reqDto.getSaleOrderCreateTimeEndDate())) {
            queryVo.addRangeFilter("saleCreateTime", String.valueOf(reqDto.getSaleOrderCreateTimeStartDate().getTime()), String.valueOf(reqDto.getSaleOrderCreateTimeEndDate().getTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryName())) {
            queryVo.addWildcardFilter("receiveName", "*" + reqDto.getDeliveryName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDeliveryPhone())) {
            queryVo.addWildcardFilter("receivePhone", "*" + reqDto.getDeliveryPhone() + "*");
        }
        if (Objects.nonNull(reqDto.getOrderType())) {
            queryVo.addEqualFilter("orderType", reqDto.getOrderType());
        }
        if (Objects.nonNull(reqDto.getTransferOrderStatus())) {
            queryVo.addEqualFilter("transferOrderStatus", reqDto.getTransferOrderStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName())) {
            queryVo.addWildcardFilter("customerName", "*" + reqDto.getCustomerName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformOrderCreatePerson())) {
            queryVo.addWildcardFilter("platformOrderCreatePerson", "*" + reqDto.getPlatformOrderCreatePerson() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleChannel())) {
            queryVo.addWildcardFilter("saleChannel", "*" + reqDto.getSaleChannel() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChannelWarehouseCode())) {
            queryVo.addEqualFilter("channelWarehouseCode", reqDto.getChannelWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDefaultLogicalWarehouseName())) {
            queryVo.addWildcardFilter("defaultLogicalWarehouseName", this.wildcard(reqDto.getDefaultLogicalWarehouseName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformParentOrderNo())) {
            queryVo.addWildcardFilter("platformParentOrderNo", this.wildcard(reqDto.getPlatformParentOrderNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRegionName())) {
            queryVo.addFilters(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"regionName", (String)this.wildcard(reqDto.getRegionName()))});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerCode())) {
            queryVo.addEqualFilter("customerCode", reqDto.getCustomerCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderChannelName())) {
            queryVo.addWildcardFilter("orderChannelName", "*" + reqDto.getOrderChannelName() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOrderChannelCode())) {
            queryVo.addEqualFilter("orderChannelCode", reqDto.getOrderChannelCode());
        }
        queryVo.addSort("id", SortOrder.DESC);
        logger.info("\u5e73\u53f0\u8ba2\u5355ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<PlatformOrderVO>> queryPlatformOrderListPage(GetPlatformOrderListPageParams dto) {
        OSSearchVo queryVo = this.initSearchVo(dto);
        queryVo.setPage(dto.getPageNum().intValue());
        queryVo.setPageSize(dto.getPageSize().intValue());
        SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new PageInfo());
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        List dtoList = searchResultVo.getDocValues((RowMapper)new PlatformOrderRowMapper());
        pageInfo.setList(dtoList);
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<EsPlatformOrderCountVO> queryByCount(GetPlatformOrderListPageParams dto) {
        List aggResults;
        EsPlatformOrderCountVO orderCountVO = new EsPlatformOrderCountVO();
        OSSearchVo queryVo = this.initSearchVo(dto);
        ArrayList<AggFieldVo> aggFieldVoList = new ArrayList<AggFieldVo>();
        AggFieldVo saleOrderStatus = AggFieldVo.terms((String)"transferOrderStatus");
        aggFieldVoList.add(saleOrderStatus);
        queryVo.setAggFields(aggFieldVoList);
        SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
        log.info("queryByCount-searchResultVo:{}", (Object)JSON.toJSONString((Object)searchResultVo));
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)orderCountVO);
        }
        if (searchResultVo != null && CollectionUtils.isNotEmpty((Collection)(aggResults = searchResultVo.getAggResults()))) {
            for (AggResult aggResult : aggResults) {
                List aggResultItems = aggResult.getAggResultItems();
                log.info("transferOrderStatus-aggResultItems:{}", (Object)JSON.toJSONString((Object)aggResultItems));
                if (!Objects.equals("transferOrderStatus", aggResult.getFieldName()) || !CollectionUtils.isNotEmpty((Collection)aggResultItems)) continue;
                BigDecimal allCount = BigDecimal.ZERO;
                for (AggResultItem aggResultItem : aggResultItems) {
                    String fieldValue = aggResultItem.getFieldValue();
                    if (Objects.equals("0", fieldValue)) {
                        orderCountVO.setNormalCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals("1", fieldValue)) {
                        orderCountVO.setAbnormalCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    } else if (Objects.equals("2", fieldValue)) {
                        orderCountVO.setInvalidCount(BigDecimal.valueOf(aggResultItem.getDocCount()));
                    }
                    allCount = allCount.add(BigDecimal.valueOf(aggResultItem.getDocCount()));
                }
                orderCountVO.setAllCount(allCount);
            }
        }
        return new RestResponse((Object)orderCountVO);
    }
}

