/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.rest;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.module.bitem.api.IBCategoryService;
import com.dtyunxi.yundt.module.bitem.biz.impl.BItemModuleHelper;
import com.dtyunxi.yundt.module.bitem.bo.CategoryBo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ToB\u5546\u54c1\u7ec4\u4ef6\uff1a\u7c7b\u76ee\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/bitem/category"})
public class BCategoryRest {
    @Resource
    private IBCategoryService categoryService;
    @Autowired
    private BItemModuleHelper BItemModuleHelper;

    @ApiOperation(value="\u6839\u636e\u7c7b\u76ee\u7c7b\u578b\u67e5\u8be2\u7c7b\u76ee\u6811", notes="dirUsage:back \u540e\u53f0\u7c7b\u76ee,front \u524d\u53f0\u7c7b\u76ee,shop \u5e97\u94fa\u7c7b\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dirUsage", paramType="path", dataType="String", required=true, value="\u7c7b\u76ee\u7c7b\u578b\uff1aback \u540e\u53f0\u7c7b\u76ee,front \u524d\u53f0\u7c7b\u76ee,shop \u5e97\u94fa\u7c7b\u76ee"), @ApiImplicitParam(name="shopId", paramType="query", dataType="Long", value="\u5e97\u94faid\uff0c\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u9700\u4f20\u4e00\u4e2a\uff0c\u4f18\u5148\u6309\u5e97\u94faid\u67e5"), @ApiImplicitParam(name="customerId", paramType="query", dataType="Long", value="\u5ba2\u6237id\uff0c\u5f53\u4e1a\u52a1\u5458\u7aef\u65f6\u9700\u4f20"), @ApiImplicitParam(name="cityStation", paramType="query", dataType="String", value="\u57ce\u5e02\u7ad9\u540d\u79f0\uff0c\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u9700\u4f20\u4e00\u4e2a"), @ApiImplicitParam(name="showDisable", paramType="query", dataType="Integer", value="\u662f\u5426\u663e\u793a\u7981\u7528\u7c7b\u76ee:1\u663e\u793a 0\u4e0d\u663e\u793a \u9ed8\u8ba4\u4e0d\u663e\u793a")})
    @GetMapping(value={"/{dirUsage}/tree"})
    RestResponse<Map<String, Object>> queryCategoryTree(@PathVariable(value="dirUsage") String dirUsage, @RequestParam(value="shopId", required=false) Long shopId, @RequestParam(value="customerId", required=false) Long customerId, @RequestParam(value="cityStation", required=false) String cityStation, @RequestParam(value="showDisable", required=false) Integer showDisable) {
        if ("shop".equals(dirUsage) && shopId == null) {
            if (StringUtils.isBlank((CharSequence)cityStation)) {
                throw new BizException("\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\uff0c\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u540d\u79f0\u81f3\u5c11\u9700\u4f20\u4e00\u4e2a");
            }
            shopId = this.BItemModuleHelper.getByShopName(cityStation);
        }
        RootDirectoryReqDto rootDirectoryReqDto = new RootDirectoryReqDto();
        rootDirectoryReqDto.setDirUsage(dirUsage);
        rootDirectoryReqDto.setShopId(shopId);
        return new RestResponse((Object)this.categoryService.queryList(rootDirectoryReqDto, showDisable, customerId));
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u76eeid\u67e5\u8be2\u7c7b\u76ee")
    @ApiImplicitParam(name="categoryId", paramType="path", dataType="Long", required=true, value="\u7c7b\u76eeid")
    @GetMapping(value={"/{categoryId}"})
    RestResponse<CategoryBo> getById(@PathVariable(value="categoryId") Long categoryId) {
        return new RestResponse((Object)this.categoryService.getById(categoryId));
    }

    @GetMapping(value={"/getParentById"})
    public RestResponse getDirParent(@RequestParam(value="dirId") Long dirId) {
        return new RestResponse((Object)this.categoryService.getDirParent(dirId));
    }
}

