/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.IReturnGiftActivity;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivitySkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.GItem;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.ReturnGiftActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.ReturnGiftRuleContent;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.impl.AbstractActivityService;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReturnGiftActivityImpl
extends AbstractActivityService
implements IReturnGiftActivity {
    @Autowired
    private IContext context;
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IActivityService activityService;
    @Resource
    private IShopQueryApi shopQueryApi;

    public Long add(ReturnGiftActivityDto activityReqDto) {
        this.validate(activityReqDto);
        String prifix = null;
        prifix = ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)activityReqDto.getActivityType()) ? "MF" : "MZ";
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode(prifix));
        if (activityReqDto.getSelectType() == 0 || activityReqDto.getSelectType() == 2) {
            List activityItems = this.activityService.queryAllItemByCondition(activityReqDto.getShopId(), activityReqDto.getBrandIds(), activityReqDto.getDirIds(), activityReqDto.getSelectType(), activityReqDto.getBlackItems());
            activityReqDto.setActivityItems(activityItems);
        }
        return this.addActivity(activityReqDto);
    }

    public void modify(ReturnGiftActivityDto activityReqDto) {
        Assert.notNull((Object)activityReqDto.getId(), (String)"\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)activityReqDto.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validate(activityReqDto);
        if (activityReqDto.getSelectType() == 0 || activityReqDto.getSelectType() == 2) {
            List activityItems = this.activityService.queryAllItemByCondition(activityReqDto.getShopId(), activityReqDto.getBrandIds(), activityReqDto.getDirIds(), activityReqDto.getSelectType(), activityReqDto.getBlackItems());
            activityReqDto.setActivityItems(activityItems);
        }
        this.addActivity(activityReqDto);
    }

    private void validate(ReturnGiftActivityDto activityReqDto) {
        if (activityReqDto.getActivityType() == null) {
            throw new BizException("\u6d3b\u52a8\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (activityReqDto.getPromotionType() == 3) {
            if (activityReqDto.getSelectType() == 1) {
                HashSet shopIds = Sets.newHashSet();
                for (ReturnGiftRuleContent content : activityReqDto.getPromotionContents()) {
                    if (content.getThreshold() == null) {
                        throw new BizException("\u4fc3\u9500\u6761\u4ef6\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    HashSet giftShopIds = Sets.newHashSet();
                    if (content.getSelfItem().booleanValue() && CollectionUtils.isEmpty((Collection)content.getGiftItems())) {
                        return;
                    }
                    for (GItem gItem : content.getGiftItems()) {
                        if (gItem.getNum() == null) {
                            throw new BizException("\u6bcf\u6b21\u8d60\u9001\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        giftShopIds.add(gItem.getShopId());
                    }
                    if (giftShopIds.size() != 1) {
                        throw new BizException("\u8d60\u54c1\u548c\u6d3b\u52a8\u5546\u54c1\u6240\u5c5e\u5e97\u94fa\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4");
                    }
                    shopIds.addAll(giftShopIds);
                }
                if (shopIds.size() != 1) {
                    throw new BizException("\u8d60\u54c1\u548c\u6d3b\u52a8\u5546\u54c1\u6240\u5c5e\u5e97\u94fa\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4");
                }
                Set itemShopIds = activityReqDto.getActivityItems().stream().map(PromotionActivityItemDto::getShopId).collect(Collectors.toSet());
                if (itemShopIds.size() != 1 || !shopIds.containsAll(itemShopIds)) {
                    throw new BizException("\u8d60\u54c1\u548c\u6d3b\u52a8\u5546\u54c1\u6240\u5c5e\u5e97\u94fa\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4");
                }
            }
        } else {
            activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("MF"));
        }
    }

    public ReturnGiftActivityDto getDetail(Long id) {
        RestResponse shopBaseDtoRestResponse;
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        ReturnGiftActivityDto returnGiftActivityDto = new ReturnGiftActivityDto();
        CubeBeanUtils.copyProperties((Object)returnGiftActivityDto, (Object)activityRespDto, (String[])new String[0]);
        Long shopId = returnGiftActivityDto.getShopId();
        if (Objects.nonNull(shopId) && Objects.nonNull(shopBaseDtoRestResponse = this.shopQueryApi.queryBaseById(shopId)) && Objects.nonNull(shopBaseDtoRestResponse.getData())) {
            returnGiftActivityDto.setShopName(((ShopBaseDto)shopBaseDtoRestResponse.getData()).getName());
        }
        returnGiftActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(returnGiftActivityDto.getActivityType());
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), returnGiftActivityDto));
        return returnGiftActivityDto;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        ReturnGiftActivityDto activityDto = (ReturnGiftActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        if (activityDto.getSelectType() == 1) {
            activityDto.getActivityItems().stream().forEach(itemDto -> {
                ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                activityItemReqDto.setActivityPrice(BigDecimal.ZERO);
                activityItemReqDto.setItemId(itemDto.getItemId());
                activityItemReqDto.setItemName(itemDto.getItemName());
                activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                activityItemReqDto.setRemainingStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setOriginalStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setActivityStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setSkuDesc(itemDto.getSkuDesc());
                activityItemReqDto.setInstanceId(this.context.instanceId());
                activityItemReqDto.setTenantId(this.context.tenantId());
                activityItemReqDto.setShopId(itemDto.getShopId());
                if (CollectionUtils.isNotEmpty((Collection)itemDto.getSkus())) {
                    activityItemReqDto.setSkuId(((PromotionActivitySkuDto)itemDto.getSkus().get(0)).getSkuId());
                }
                activityItemReqDtos.add(activityItemReqDto);
            });
        }
        return activityItemReqDtos;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getUserIds(T activityReqDto) {
        ReturnGiftActivityDto activityDto = (ReturnGiftActivityDto)activityReqDto;
        if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityCustomers())) {
            List<Long> customerIds = activityDto.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            return customerIds;
        }
        return null;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getCustomerTypes(T activityReqDto) {
        ReturnGiftActivityDto activityDto = (ReturnGiftActivityDto)activityReqDto;
        return activityDto.getCustomerTypeIds();
    }

    @Override
    protected <T extends BaseActivityTobDto> List<String> getCustomerAreaCodes(T activityReqDto) {
        ReturnGiftActivityDto activityDto = (ReturnGiftActivityDto)activityReqDto;
        return activityDto.getCustomerAreaCodes();
    }
}

