package com.dtyunxi.yundt.module.customer.api.dto.request;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "VerifyCustomerByExcelReqDto", description = "批量校验三要素ByExcel")
public class VerifyCustomerByExcelReqDto {

    @Excel(name = "客户编号")
    @ApiModelProperty(value = "客户编号")
    private String code;

    @Excel(name = "公司名称")
    @ApiModelProperty(value = "公司名称")
    private String orgName;

    @Excel(name = "统一社会信用代码")
    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @Excel(name = "法定代表人")
    @ApiModelProperty(value = "法定代表人")
    private String legalName;

    @ApiModelProperty(value = "返回结果 boolean")
    private boolean verify;

    @ApiModelProperty(value = "返回结果信息")
    private String verifyResult;

    @ApiModelProperty(value = "后台处理的dto")
    private VerifyCustomerByOrgIdReqDto verifyDto;

    /**************** 其他无关字段 **************************/

    @ApiModelProperty(value = "主体类型")
    private String str1;
    @ApiModelProperty(value = "执照类型")
    private String str2;
    @ApiModelProperty(value = "营业期限类型")
    private String str3;
    @ApiModelProperty(value = "营业期限起")
    private String str4;
    @ApiModelProperty(value = "营业期限止")
    private String str5;
    @ApiModelProperty(value = "公司所属省份")
    private String str6;
    @ApiModelProperty(value = "公司所属城市")
    private String str7;
    @ApiModelProperty(value = "公司所属地区")
    private String str8;
    @ApiModelProperty(value = "公司详细地址")
    private String str9;

    /**************** table处理字段 **************************/
    @ApiModelProperty(value = "处理状态 默认-1(未处理),0处理失败,1处理成功")
    private String processStatus;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty(value = "处理时间")
    private String processTime;
}
