/**
 * @(#)IItemProcess.java 1.0 2019/10/12
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api.user;

import com.dtyunxi.yundt.module.customer.api.user.dto.response.OrganizationPackageDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.UserInfoRespDto;

/**
 * 用户服务
 *
 * @author xuhuaqiang
 */
public interface IUserService {

    /**
     * 查询用户的个人信息
     * @param userId
     * @return
     */
    UserInfoRespDto queryUserInfo(Long userId,Integer srcType);

    /**
     * 查询用于回显的用户组织id集合
     *
     * @return List<OrganizationDto> 组织id集合
     **/
    OrganizationPackageDto showOrgIds(Long orgId);

    Long getCurrentUserOrgId(Long userId);
}
