/**
 * @(#)IItemProcess.java 1.0 2019/10/12
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api;

import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.CheckCreditByCustomerCodeReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.github.pagehelper.PageInfo;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.multipart.MultipartFile;

/**
 * 客户信息服务
 *
 * @author xuhuaqiang
 */
public interface ICustomerV4Service {

    PageInfo<CustomerListRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize);

    @Async
    StoreSellerGovernExcelRespDto verifyCustomerByExcelAsyn(MultipartFile file, Long recordId);

    /**
     * 校验customer在同一租户下credit唯一
     */
    void checkCreditByCustomerCode(CheckCreditByCustomerCodeReqDto dto);

    StoreSellerGovernExcelRespDto verifyCustomerByExcel(MultipartFile file);

    Void verifyCustomerByTable();
}
