/**
 * @(#)ILogin.java 1.0 2019年7月12日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api.user;

import com.dtyunxi.yundt.module.customer.api.dto.request.ResetPasswordReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.TenantGuideRespDto;
import com.dtyunxi.yundt.module.customer.bo.LoginInfo;
import com.dtyunxi.yundt.module.customer.bo.TokenInfo;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 认证服务
 *
 * @author wu.sheng
 * @time 2019年7月12日 上午10:09:23
 */
@Validated
public interface IAuthentication {

    /**
     * 用户登录
     * <p>
     * 提供7种登录方式loginType:
     * <ul>
     * <li>(0, 手机号/用户名/邮箱+密码)
     * <li>(1, 用户名+密码)
     * <li>(2, 手机+密码)
     * <li>(3, 手机+验证码)
     * <li>(4, 邮箱+密码)
     * <li>(5, 身份证+密码)
     * <li>(6, 用户名+密码+验证码)
     * </ul>
     *
     * @param loginInfo
     * @return 认证中心token令牌
     * @author wu.sheng
     * @time 2019年7月9日 上午10:54:37
     * @version
     */
    TokenInfo login(@Valid LoginInfo loginInfo);

    /**
     * 注销
     *
     * @param userId 用户id
     * @author wu.sheng
     * @time 2019年7月17日 上午10:38:33
     * @version
     */
    void logout(@NotNull Long userId);

    /**
     * 修改密码
     * <p>
     * 根据(用户名+原密码)方式修改
     *
     * @param userName    用户名
     * @param password    旧密码
     * @param newPassword 新密码
     * @author wu.sheng
     * @time 2019年7月19日 下午4:38:37
     * @version
     */
    void modifyPassword(@NotNull String userName, @NotNull String password, @NotNull String newPassword);

    /**
     * 重置密码
     * @author wu.sheng
     * @time 2019年7月19日 下午4:42:59
     * @version
     */
    void resetPassword(ResetPasswordReqDto resetPasswordReqDto);

    /**
     * 重置密码
     * <p>
     * 根据用户id重置密码
     * </p>
     *
     * @param userId      用户id
     * @param newPassword 新密码
     * @author wu.sheng
     * @time 2019年8月15日 下午3:05:53
     * @version 1.0
     */
    void resetPassword(@NotNull Long userId, @NotNull String newPassword);

    /**
     * 手机号码绑定
     *
     * @param userId 用户id
     * @param phone  手机号码
     * @author wu.sheng
     * @time 2019/8/31 15:09
     * @version 1.0
     */
    void bindPhone(@NotNull Long userId, @NotNull String phone);

    /**
     * 手机号码解绑
     *
     * @param userId 用户id
     * @param phone  手机号码
     * @author wu.sheng
     * @time 2019/8/31 15:09
     * @version 1.0
     */
    void unbindPhone(@NotNull Long userId, @NotNull String phone);

    /**
     * 密码指引
     */
    TenantGuideRespDto tenantGuide(@NotNull Long tenantId);

    /**
     * 用户登录
     * <p>
     * 提供7种登录方式loginType:
     * <ul>
     * <li>(0, 手机号/用户名/邮箱+密码)
     * <li>(1, 用户名+密码)
     * <li>(2, 手机+密码)
     * <li>(3, 手机+验证码)
     * <li>(4, 邮箱+密码)
     * <li>(5, 身份证+密码)
     * <li>(6, 用户名+密码+验证码)
     * </ul>
     *
     * @param loginInfo
     * @return 认证中心token令牌
     * @author wu.sheng
     * @time 2019年7月9日 上午10:54:37
     * @version
     */
    TokenInfo newLogin( LoginInfo loginInfo);
}
