package com.dtyunxi.yundt.module.customer.api.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author jiejun
 * @Description 员工信息ExcelVo
 * @since 1.0.0
 */
@Data
public class EmployeeExcelExtVo {

    @Excel(name = "类型")
    private String type; // 新增/修改

    @Excel(name = "工号")
    private String employeeCode;

    @Excel(name = "*登录账号", isImportField = "true")
    private String account;

    @Excel(name = "*角色", isImportField = "true")
    private String roleName;

    @Excel(name = "*姓名", isImportField = "true")
    private String userName;

    @Excel(name = "*职位", isImportField = "true")
    private String position;

    //@Excel(name = "所属部门")
    //private String department;

    @Excel(name = "*人员类型", isImportField = "true")
    private String employeeType;

    @Excel(name = "*手机号码", isImportField = "true")
    private String phoneNumber;

    @Excel(name = "*管理类型", isImportField = "true")
    private String governType;

    @Excel(name = "销售区")
    private String saleArea;

    @Excel(name = "大区")
    private String bigArea;

    @Excel(name = "区域")
    private String district;

    @Excel(name = "管理客户（客户编号）")
    private String governCustomer;

    //@Excel(name = "管理区域（区域名称）")
    //private String governArea;

    @Excel(name = "管理黑名单（客户编号）")
    private String blacklist;

    @Excel(name = "*开始日期", importFormat = "yyyy-MM-dd")
    private Date startDate;

    @Excel(name = "结束日期", importFormat = "yyyy-MM-dd")
    private Date endDate;

    @Excel(name = "备注")
    private String remark;

    /**
     * 账号id
     */
    private Long userId;

    /**
     * 角色名称
     */
    private EmployeeRoleReqDto role;

    /**
     * 角色集合
     */
    private List<EmployeeRoleReqDto> roleList;

    /**
     * 区域对象
     */
    private EmployeeRegionReqDto area;

    //销售区对象
    private EmployeeRegionReqDto saleAreaDto;

    //大区对象
    private EmployeeRegionReqDto bigAreaDto;

    //区域对象
    private EmployeeRegionReqDto districtDto;

    /**
     * 区域集合
     */
    private List<EmployeeRegionReqDto> areaList;

    /**
     * 客户对象
     */
    private EmployeeCustomerReqDto customerDto;

    /**
     * 客户集合
     */
    private List<EmployeeCustomerReqDto> customerInfoList;

    /**
     * 客户黑名单
     */
    private EmployeeCustomerBlacklistReqDto customerBlackDto;

    /**
     * 客户黑名单集合
     */
    private List<EmployeeCustomerBlacklistReqDto> customerBlackList;

    /**
     * 是否主数据，登录账号进行合并角色、管理区域、管理客户、管理黑名单的数据，是为处理，否为被合并
     */
    private Integer ifMain;

    /**
     * 组织id
     */
    private Long orgId;

    private String errorMsg;

    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getEmployeeType() {
        return employeeType;
    }

    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getGovernType() {
        return governType;
    }

    public void setGovernType(String governType) {
        this.governType = governType;
    }

    public String getSaleArea() {
        return saleArea;
    }

    public void setSaleArea(String saleArea) {
        this.saleArea = saleArea;
    }

    public String getBigArea() {
        return bigArea;
    }

    public void setBigArea(String bigArea) {
        this.bigArea = bigArea;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getGovernCustomer() {
        return governCustomer;
    }

    public void setGovernCustomer(String governCustomer) {
        this.governCustomer = governCustomer;
    }

    public String getBlacklist() {
        return blacklist;
    }

    public void setBlacklist(String blacklist) {
        this.blacklist = blacklist;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public EmployeeRoleReqDto getRole() {
        return role;
    }

    public void setRole(EmployeeRoleReqDto role) {
        this.role = role;
    }

    public List<EmployeeRoleReqDto> getRoleList() {
        return roleList;
    }

    public void setRoleList(List<EmployeeRoleReqDto> roleList) {
        this.roleList = roleList;
    }

    public EmployeeRegionReqDto getArea() {
        return area;
    }

    public void setArea(EmployeeRegionReqDto area) {
        this.area = area;
    }

    public List<EmployeeRegionReqDto> getAreaList() {
        return areaList;
    }

    public void setAreaList(List<EmployeeRegionReqDto> areaList) {
        this.areaList = areaList;
    }

    public EmployeeCustomerReqDto getCustomerDto() {
        return customerDto;
    }

    public void setCustomerDto(EmployeeCustomerReqDto customerDto) {
        this.customerDto = customerDto;
    }

    public List<EmployeeCustomerReqDto> getCustomerInfoList() {
        return customerInfoList;
    }

    public void setCustomerInfoList(List<EmployeeCustomerReqDto> customerInfoList) {
        this.customerInfoList = customerInfoList;
    }

    public EmployeeCustomerBlacklistReqDto getCustomerBlackDto() {
        return customerBlackDto;
    }

    public void setCustomerBlackDto(EmployeeCustomerBlacklistReqDto customerBlackDto) {
        this.customerBlackDto = customerBlackDto;
    }

    public List<EmployeeCustomerBlacklistReqDto> getCustomerBlackList() {
        return customerBlackList;
    }

    public void setCustomerBlackList(List<EmployeeCustomerBlacklistReqDto> customerBlackList) {
        this.customerBlackList = customerBlackList;
    }

    public Integer getIfMain() {
        return ifMain;
    }

    public void setIfMain(Integer ifMain) {
        this.ifMain = ifMain;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public EmployeeRegionReqDto getSaleAreaDto() {
        return saleAreaDto;
    }

    public void setSaleAreaDto(EmployeeRegionReqDto saleAreaDto) {
        this.saleAreaDto = saleAreaDto;
    }

    public EmployeeRegionReqDto getBigAreaDto() {
        return bigAreaDto;
    }

    public void setBigAreaDto(EmployeeRegionReqDto bigAreaDto) {
        this.bigAreaDto = bigAreaDto;
    }

    public EmployeeRegionReqDto getDistrictDto() {
        return districtDto;
    }

    public void setDistrictDto(EmployeeRegionReqDto districtDto) {
        this.districtDto = districtDto;
    }
}
