package com.dtyunxi.yundt.module.customer.api.dto.request.user;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 角色查询请求DTO
 *
 * @author yourname
 * @date 2024-05-27
 */
@ApiModel(value = "RoleQueryReqDto", description = "角色查询请求DTO")
public class RoleQueryReqDto implements Serializable {

    @ApiModelProperty(value = "角色代码")
    private String code;

    @ApiModelProperty(value = "角色名称")
    private String name;
    private Integer status;

    @ApiModelProperty(value = "组织ID列表")
    private List<Long> orgIds;

    @ApiModelProperty(value = "是否计算关联用户和用户组数量")
    private Boolean countRelationUserAndGroupNum;

    @ApiModelProperty(value = "页码")
    private Integer pageNum = 1;

    @ApiModelProperty(value = "每页条数")
    private Integer pageSize = 10;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Long> getOrgIds() {
        return orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public Boolean getCountRelationUserAndGroupNum() {
        return countRelationUserAndGroupNum;
    }

    public void setCountRelationUserAndGroupNum(Boolean countRelationUserAndGroupNum) {
        this.countRelationUserAndGroupNum = countRelationUserAndGroupNum;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}