package com.dtyunxi.yundt.module.customer.api.dto.response;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author xuhuaqiang
 * @version 1.0.0
 * @description
 * @date 2020/10/9 19:28
 */
@ApiModel(value = "CustomerListRespDto", description = "客户列表对象信息响应Dto")
public class CustomerListRespDto extends BaseRespDto {

    /**
     * 组织信息ID
     */
    @ApiModelProperty(name = "orgInfoId", value = "组织信息ID")
    private Long orgInfoId;
    /**
     * 父客户ID
     */
    @ApiModelProperty(name = "parentCustomerId", value = "父客户ID")
    private Long parentCustomerId;
    /**
     * 父客户名称
     */
    @ApiModelProperty(name = "parentCustomerName", value = "父客户名称")
    private String parentCustomerName;
    /**
     * 管理员ID
     */
    @ApiModelProperty(name = "userId", value = "管理员ID")
    private Long userId;

    /**
     * 用户名/登录名/登录账号
     */
    @ApiModelProperty(value = "用户名/登录名/登录账号,必填")
    private String userName;


    /**
     *  名称
     */
    @ApiModelProperty(name="name",value = "名称")
    private String name;

    /**
     *  编号
     */
    @ApiModelProperty(name="code",value = "编号")
    private String code;

    /**
     *  客户类型ID
     */
    @ApiModelProperty(name="customerTypeId",value = "客户类型ID")
    private Long customerTypeId;
    /**
     *  客户类型名称
     */
    @ApiModelProperty(name="customerTypeName",value = "客户类型名称")
    private String customerTypeName;

    /**
     *  区域ID
     */
    @ApiModelProperty(name="regionId",value = "区域ID")
    private Long regionId;

    /**
     *  所属区域
     */
    @ApiModelProperty(name="region",value = "所属区域")
    private String region;

    /**
     *  省份编码
     */
    @ApiModelProperty(name="provinceCode",value = "省份编码")
    private String provinceCode;

    /**
     *  省份
     */
    @ApiModelProperty(name="province",value = "省份")
    private String province;

    /**
     *  地市编码
     */
    @ApiModelProperty(name="cityCode",value = "地市编码")
    private String cityCode;

    /**
     *  地市
     */
    @ApiModelProperty(name="city",value = "地市")
    private String city;

    /**
     *  区编码
     */
    @ApiModelProperty(name="countyCode",value = "区编码")
    private String countyCode;

    /**
     *  区
     */
    @ApiModelProperty(name="county",value = "区")
    private String county;

    /**
     *  详细地址
     */
    @ApiModelProperty(name="address",value = "详细地址")
    private String address;

    /**
     *  业务员
     */
    @ApiModelProperty(name="salesmanId",value = "业务员")
    private Long salesmanId;

    /**
     *  备注
     */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    /**
     *  状态
     */
    @ApiModelProperty(name="statusId",value = "状态")
    private Long statusId;
    /**
     *  客户账号状态
     */
    @ApiModelProperty(name="accountStatus",value = "客户账号状态")
    private Integer accountStatus;
    /**
     *  客户状态名称
     */
    @ApiModelProperty(name="statusName",value = "客户状态名称")
    private String statusName;

    /**
     *  区域编码
     */
    @ApiModelProperty(name="regionCode",value = "区域编码")
    private String regionCode;

    /**
     *  区域编码
     */
    @ApiModelProperty(name="regionCodes",value = "区域编码 多个用英文逗号隔开")
    private String regionCodes;

    /**
     *  区域名称
     */
    @ApiModelProperty(name="regionNames",value = "区域名称 多个用英文逗号隔开")
    private String regionNames;

    /**
     * 分组id
     */
    @ApiModelProperty(name = "customerGroupId", value = "客户分组id")
    private Long customerGroupId;

    @ApiModelProperty(
            name = "customerGroupName",
            value = "客户分组名"
    )
    private String customerGroupName;

    /**
     *  记录状态（0.停用，1.启用）
     */
    @ApiModelProperty(name="recordStatus",value = "记录状态（0.停用，1.启用）")
    private Integer recordStatus;

    /**
     *  代客下单按钮是否显示，0：否；1：是
     */
    @ApiModelProperty(name = "valetFlag", value = "代客下单按钮是否显示，0：否；1：是")
    private Integer valetFlag;

    @ApiModelProperty(name = "lastOrderTime",value = "最后下单时间")
    private Date lastOrderTime;

    /**
     * 订单数
     */
    @ApiModelProperty(name = "num", value = "订单数")
    private Integer num;

    /**
     * 客户级别id
     */
    @ApiModelProperty(name = "levelId", value = "客户级别id")
    private Long levelId;

    /**
     * 客户级别名称
     */
    @ApiModelProperty(name = "levelName", value = "客户级别名称")
    private String levelName;

    @ApiModelProperty(
            name = "merchantId",
            value = "所属商家（实际存的是所属商家对应的组织即上游组织）"
    )
    private Long merchantId;

    @ApiModelProperty(
            name = "merchantName",
            value = "所属商家名称（实际存的是所属商家对应的组织即上游组织）"
    )
    private String merchantName;

    @ApiModelProperty("组织名称(公司名称)")
    private String orgName;

    /**
     * 是否已授权指定SKU
     */
    @ApiModelProperty(name = "isAuthorized", value = "是否已授权指定SKU")
    private Boolean isAuthorized;

    public Boolean getIsAuthorized() {
        return isAuthorized;
    }

    public void setIsAuthorized(Boolean isAuthorized) {
        this.isAuthorized = isAuthorized;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public Long getLevelId() {
        return levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public String getRegionCodes() {
        return regionCodes;
    }

    public void setRegionCodes(String regionCodes) {
        this.regionCodes = regionCodes;
    }

    public String getRegionNames() {
        return regionNames;
    }

    public void setRegionNames(String regionNames) {
        this.regionNames = regionNames;
    }

    public Date getLastOrderTime() {
        return lastOrderTime;
    }

    public void setLastOrderTime(Date lastOrderTime) {
        this.lastOrderTime = lastOrderTime;
    }

    public Integer getRecordStatus() {
        return recordStatus;
    }

    public void setRecordStatus(Integer recordStatus) {
        this.recordStatus = recordStatus;
    }

    public Integer getValetFlag() {
        return valetFlag;
    }

    public void setValetFlag(Integer valetFlag) {
        this.valetFlag = valetFlag;
    }

    public Long getCustomerGroupId() {
        return customerGroupId;
    }

    public void setCustomerGroupId(Long customerGroupId) {
        this.customerGroupId = customerGroupId;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getParentCustomerId() {
        return parentCustomerId;
    }

    public void setParentCustomerId(Long parentCustomerId) {
        this.parentCustomerId = parentCustomerId;
    }

    public String getParentCustomerName() {
        return parentCustomerName;
    }

    public void setParentCustomerName(String parentCustomerName) {
        this.parentCustomerName = parentCustomerName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getCustomerTypeId() {
        return customerTypeId;
    }

    public void setCustomerTypeId(Long customerTypeId) {
        this.customerTypeId = customerTypeId;
    }

    public String getCustomerTypeName() {
        return customerTypeName;
    }

    public void setCustomerTypeName(String customerTypeName) {
        this.customerTypeName = customerTypeName;
    }

    public Long getRegionId() {
        return regionId;
    }

    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getCounty() {
        return county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getSalesmanId() {
        return salesmanId;
    }

    public void setSalesmanId(Long salesmanId) {
        this.salesmanId = salesmanId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getStatusId() {
        return statusId;
    }

    public void setStatusId(Long statusId) {
        this.statusId = statusId;
    }

    public Integer getAccountStatus() {
        return accountStatus;
    }

    public void setAccountStatus(Integer accountStatus) {
        this.accountStatus = accountStatus;
    }

    public String getCustomerGroupName() {
        return customerGroupName;
    }

    public void setCustomerGroupName(String customerGroupName) {
        this.customerGroupName = customerGroupName;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
