package com.dtyunxi.yundt.module.customer.biz.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;
import java.util.regex.Pattern;

/**
 * @author xitao
 * 文件导入处理类
 */
public class EasyPoiExportUtil {

    private static final Logger logger = LoggerFactory.getLogger(EasyPoiExportUtil.class);

    private static IObjectStorageService objectStorageService;

    private static String bucketName;
    private static String dir;

    public static <T> ExcelImportResult<T> importExcel(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows);
        params.setHeadRows(headerRows);
        // 需要验证
        params.setNeedVerfiy(true);
        ExcelImportResult<T> result = null;
        try {
            result = ExcelImportUtil.importExcelMore(inputStream, pojoClass, params);
        } catch (NoSuchElementException e) {
            throw new BusinessRuntimeException("excel文件不能为空");
        } catch (Exception e) {
            logger.error("解析excel异常：", e);
            throw new BusinessRuntimeException(e.getMessage());
        }
        return result;
    }

    public static <T> ExcelImportResult<T> getImportResult(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows);
        params.setHeadRows(headerRows);
        params.setKeyIndex(null);
        ExcelImportResult<T> result = null;
        try {
            result = ExcelImportUtil.importExcelMore(inputStream, pojoClass, params);
        } catch (NoSuchElementException e) {
            throw new BusinessRuntimeException("excel文件不能为空");
        } catch (Exception e) {
            throw new BusinessRuntimeException(e.getMessage());
        }
        return result;
    }

    public static <T> ExcelImportResult<T> getImportResult(InputStream inputStream, Integer titleRows, Integer headerRows, Integer count, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows);
        params.setHeadRows(headerRows);
        params.setReadRows(count);
        params.setKeyIndex(null);
        ExcelImportResult<T> result = null;
        try {
            result = ExcelImportUtil.importExcelMore(inputStream, pojoClass, params);
        } catch (NoSuchElementException e) {
            throw new BusinessRuntimeException("excel文件不能为空");
        } catch (Exception e) {
            throw new BusinessRuntimeException(e.getMessage());
        }
        return result;
    }


    public static <T> String getExportUrl(List<T> excelRespDtos, Class<T> tClass, String title, String excelName, String suffix) {
        //初始化
        if (objectStorageService == null) {
            objectStorageService = SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }

        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }

        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        ExportParams params = new ExportParams(title, "", ExcelType.HSSF);
        Workbook workbook = ExcelExportUtil.exportExcel(params, tClass, excelRespDtos);
        String url = getFileUrl(title, downloadUrl, workbook, fos, fileName);
        return url;
    }

    /**
     * 根据模板导出文件
     *
     * @param templateUrl
     * @param excelRespDtos
     * @param excelName
     * @param suffix
     * @param title
     * @param <T>
     * @return
     */
    public static <T> String exportByTemplate(String templateUrl, List<T> excelRespDtos, String excelName, String suffix, String title) {
        if (objectStorageService == null) {
            objectStorageService = SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }

        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        TemplateExportParams params = new TemplateExportParams(
                templateUrl);
        Map<String, Object> map = new HashMap<String, Object>();

        List<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
        excelRespDtos.forEach(dto -> {
            try {
                Map<String, String> describe = org.apache.commons.beanutils.BeanUtils.describe(dto);
                listMap.add(describe);
            } catch (Exception e) {
                logger.error("对象转换成map异常");
                e.printStackTrace();
            }
        });

        map.put("maplist", listMap);

        Workbook workbook = ExcelExportUtil.exportExcel(params, map);
        String url = "";
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        url = getFileUrl(title, downloadUrl, workbook, fos, fileName);

        return url;
    }

    public static String exportByMap(String fileName, ExportParams params, List<ExcelExportEntity> entityList, List<Map<String, Object>> list) {
        if (objectStorageService == null) {
            objectStorageService = SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        Workbook workbook = ExcelExportUtil.exportExcel(params, entityList, list);
        return getFileUrl(fileName, downloadUrl, workbook, null, fileName);
    }

    private static String getFileUrl(String title, String downloadUrl, Workbook workbook, ByteArrayOutputStream fos, String fileName) {
        String url;
        if (dir == null) {
            dir = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.dir");
        }
        try {
            fos = new ByteArrayOutputStream();
            workbook.write(fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            objectStorageService.put(bucketName, fileName, byteArrayInputStream);
            url = downloadUrl + "/" + dir + fileName;
        } catch (IOException e) {
            logger.error(title + "导出excel异常", e.getMessage(), e);
            throw new BusinessRuntimeException(title + "导出excel异常");

        } finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            } catch (IOException e) {
                logger.error("关闭流出现异常：{}", e);
            }
        }
        return url;
    }

    /**
     * 创建文件url
     *
     * @param excelName
     * @param suffix
     * @return
     */
    public static String createFileUrl(String excelName, String suffix) {
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        String fileName = excelName + "." + suffix;
        return downloadUrl + "/" + fileName;
    }

    /**
     * 检查文件是否存在oss
     *
     * @param fileName
     * @return
     */
    public static Boolean checkExists(String fileName) {
        //初始化
        if (objectStorageService == null) {
            objectStorageService = SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        return objectStorageService.exists(bucketName, fileName);
    }

    /**
     * 根据url获取文件流
     * @param fileUrl
     * @return
     * @throws IOException
     */
    public static InputStream getInputStream(String fileUrl) throws IOException {
        logger.info("根据url获取文件流==>{}",JSON.toJSONString(fileUrl));
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        return conn.getInputStream();
    }



}
