package com.dtyunxi.yundt.module.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.StoreReqTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.CustomerStoreReqDto;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerStoreResponseDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSalesmanRelationRespDto;
import com.dtyunxi.tcbj.api.dto.response.TbPersonPartnerRelRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.ITbPersonPartnerRelQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerCheckPatternConfigApi;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerCheckRelationApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationShowHistoryFlagEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationSourceOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.*;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.*;
import com.dtyunxi.yundt.cube.center.customer.api.query.*;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.PersonPartnerReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreCheckService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.biz.vo.CustomerCheckRelationExportVo;
import com.dtyunxi.yundt.module.customer.biz.vo.PatternConfigExportVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 门店考核
 * @author ghosn
 * @create 2023/4/6 14:27
 */
@Slf4j
@Service
public class IStoreCheckServiceImpl implements IStoreCheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;

    @Resource
    private ICustomerCheckRelationQueryApi customerCheckRelationQueryApi;

    @Resource
    private ICustomerCheckPatternQueryApi customerCheckPatternQueryApi;

    @Resource
    private ITbPersonPartnerRelQueryApi tbPersonPartnerRelQueryApi;

    @Resource
    private ICustomerCheckRelationApi customerCheckRelationApi;

    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;

    @Resource
    private IContext context;

	@Resource
    private ICustomerCheckPatternConfigApi customerCheckPatternConfigApi;

    @Resource
    private ICustomerCheckPatternConfigQueryApi customerCheckPatternConfigQueryApi;

    @Resource
    private IStoreSellerGovernContentQueryApi storeSellerGovernContentQueryApi;

    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;

    @Override
    public PageInfo<CustomerStoreResponseDto> queryCustomerStorePage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo<CustomerStoreResponseDto> customerStoreResponseDtoPageInfo;
        CustomerStoreReqDto customerStoreReqDto = JSON.parseObject(filter, CustomerStoreReqDto.class);

        Long orgId = RestResponseHelper.extractData(customerExtQueryApi.queryCurrentUserOrgId());
        BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode(String.valueOf(orgId));
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(bizChannelEnum)) {
            log.info("查询门店列表 (品牌方) params => {} ", JSON.toJSONString(customerStoreReqDto));
            customerStoreResponseDtoPageInfo = RestResponseHelper.extractData(customerDistributorsQueryApi.queryCustomerStorePage(JSON.toJSONString(customerStoreReqDto), pageNum, pageSize));
        } else {
            //获取客户信息
            CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerExtQueryApi.queryOneByOrgId(orgId));
            customerStoreReqDto.setOrgId(orgId);
            customerStoreReqDto.setMerchantId(customerRespDto.getMerchantId());
            log.info("查询门店列表 (经销商) params => {} ", JSON.toJSONString(customerStoreReqDto));
            customerStoreResponseDtoPageInfo = RestResponseHelper.extractData(customerDistributorsQueryApi.queryCustomerStorePage(JSON.toJSONString(customerStoreReqDto), pageNum, pageSize));
        }
        // 门店列表不存在,直接返回
        if (CollectionUtils.isEmpty(customerStoreResponseDtoPageInfo.getList())) {
            return customerStoreResponseDtoPageInfo;
        }

        List<CustomerStoreResponseDto> respList = customerStoreResponseDtoPageInfo.getList();
        Map<Long, List<CustomerStoreResponseDto>> respMap = respList.stream().collect(Collectors.groupingBy(c -> c.getMerchantId()));
        if (respMap.entrySet().size() > 0) {
            respMap.forEach(
                    (orgIdKey, value) -> {
                        List<String> storeIds = value.stream().map(c -> c.getStoreId()).distinct().collect(Collectors.toList());
                        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerExtQueryApi.queryOneByOrgId(orgIdKey));
                        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
                        customerCheckRelationReqDto.setStoreIds(storeIds);
                        customerCheckRelationReqDto.setOrgId(orgIdKey);
                        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                        List<CustomerCheckRelationRespDto> customerCheckRelationRespDtos = RestResponseHelper.extractData(customerCheckRelationQueryApi.queryByStoreIds(customerCheckRelationReqDto));

                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(customerCheckRelationRespDtos)) {
                            List<String> salesmanIds = customerCheckRelationRespDtos.stream().map(c -> c.getSalesmanId()).collect(Collectors.toList());
                            TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
                            tbPersonPartnerRelReqDto.setRowIds(salesmanIds);
                            tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
                            PageInfo<TbPersonPartnerRelRespDto> tbPersonPartnerRelRespDtoPageInfo = RestResponseHelper.extractData(tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString(tbPersonPartnerRelReqDto), 1, Integer.MAX_VALUE));
                            List<String> rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(c -> c.getRowId() + c.getCustomerId()).collect(Collectors.toList());
                            log.info("经销商IDs => {} 全量业务员校验结果 => {}", customerRespDto.getThirdPartyId(), JSON.toJSONString(rowIds));
                            Map<String, String> personMessageMap = tbPersonPartnerRelRespDtoPageInfo.getList().stream().collect(Collectors.toMap(TbPersonPartnerRelRespDto::getRowId, TbPersonPartnerRelRespDto::getFullName, (k1, k2) -> k1));

                            //存在多条关系记录单状态不冲突选择时间最大  （即最新） 的赋值
                            Map<String, CustomerCheckRelationRespDto> customerCheckRelationRespDtoMap = customerCheckRelationRespDtos.stream()
                                    .collect(Collectors.toMap(key2 -> key2.getStoreId(), val -> val, (k1, k2) -> k1.getCreateTime().compareTo(k2.getCreateTime()) != 0 ? k1 : k2));
                            value.forEach(c -> {
                                CustomerCheckRelationRespDto orDefault = customerCheckRelationRespDtoMap.getOrDefault(c.getStoreId(), null);
                                if (null != orDefault) {
                                    //校验当前经销商业务员设置状态  【当经销商业务员删除时规避生效状态】
                                    orDefault.setStatus(rowIds.contains(orDefault.getSalesmanId() + c.getCustomerId()) ? CustomerCheckStatusEnum.BOUND.getStatus() : CustomerCheckStatusEnum.DISABLE.getStatus());
                                    //关联同步更新的人员数据
                                    orDefault.setSalesmanName(personMessageMap.getOrDefault(orDefault.getSalesmanId(), orDefault.getSalesmanName()));
                                    c.setCustomerCheckRelationRespDto(orDefault);
                                }
                            });

                            //查询是否显示修改记录字段
                            CustomerCheckRelationReqDto reqDto = new CustomerCheckRelationReqDto();
                            reqDto.setOrgId(orgIdKey);
                            reqDto.setStoreIds(storeIds);
                            reqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                            List<CustomerCheckRelationRespDto> historyList = RestResponseHelper.extractData(customerCheckRelationQueryApi.queryByStoreIds(reqDto));
                            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(historyList)) {
                                Map<String, List<CustomerCheckRelationRespDto>> storeIdHistoryMap = historyList.stream().collect(Collectors.groupingBy(h -> h.getStoreId()));
                                value.forEach(c -> {
                                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(storeIdHistoryMap.get(c.getStoreId()))) {
                                        c.setShowHistoryFlag(CustomerCheckRelationShowHistoryFlagEnum.YES_SHOW.getType());
                                    }
                                });
                            }
                        }
                    });
        }


        /*
         *  //wsr注释

        //查询当前数据门店考核关系并设置
        List<String> storeIds = customerStoreResponseDtoPageInfo.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toList());
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setStoreIds(storeIds);
        customerCheckRelationReqDto.setOrgId(orgId);
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        List<CustomerCheckRelationRespDto> customerCheckRelationRespDtos = RestResponseHelper.extractData(customerCheckRelationQueryApi.queryByStoreIds(customerCheckRelationReqDto));

        if(!CollectionUtils.isEmpty(customerCheckRelationRespDtos)){
            //查询同步视图是否存在业务员变更回显状态
            List<String> salesmanIds = customerCheckRelationRespDtos.stream().map(c -> c.getSalesmanId()).collect(Collectors.toList());
            TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
            tbPersonPartnerRelReqDto.setRowIds(salesmanIds);
            tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
            PageInfo<TbPersonPartnerRelRespDto> tbPersonPartnerRelRespDtoPageInfo = RestResponseHelper.extractData(tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString(tbPersonPartnerRelReqDto), 1, Integer.MAX_VALUE));
            List<String> rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(c -> c.getRowId() + c.getCustomerId()).collect(Collectors.toList());
            log.info("经销商ID => {} 全量业务员校验结果 => {}", customerRespDto.getThirdPartyId(), JSON.toJSONString(rowIds));
            Map<String, String> personMessageMap = tbPersonPartnerRelRespDtoPageInfo.getList().stream().collect(Collectors.toMap(TbPersonPartnerRelRespDto::getRowId, TbPersonPartnerRelRespDto::getFullName, (k1, k2) -> k1));

            //存在多条关系记录单状态不冲突选择时间最大  （即最新） 的赋值
            Map<String, CustomerCheckRelationRespDto> customerCheckRelationRespDtoMap = customerCheckRelationRespDtos.stream()
                    .collect(Collectors.toMap(key -> key.getStoreId(), val -> val, (k1, k2) ->  k1.getCreateTime().compareTo(k2.getCreateTime()) != 0 ? k1 : k2));
            customerStoreResponseDtoPageInfo.getList().stream().forEach(c -> {
                CustomerCheckRelationRespDto orDefault = customerCheckRelationRespDtoMap.getOrDefault(c.getStoreId(), null);
                if(null != orDefault){
                    //校验当前经销商业务员设置状态  【当经销商业务员删除时规避生效状态】
                    orDefault.setStatus(rowIds.contains(orDefault.getSalesmanId()+c.getCustomerId()) ? CustomerCheckStatusEnum.BOUND.getStatus() : CustomerCheckStatusEnum.DISABLE.getStatus());
                    //关联同步更新的人员数据
                    orDefault.setSalesmanName(personMessageMap.getOrDefault(orDefault.getSalesmanId(),orDefault.getSalesmanName()));
                    c.setCustomerCheckRelationRespDto(orDefault);
                }
            });
        }

        //查询是否显示修改记录字段
        CustomerCheckRelationReqDto reqDto = new CustomerCheckRelationReqDto();
        reqDto.setOrgId(orgId);
        reqDto.setStoreIds(storeIds);
        reqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
        List<CustomerCheckRelationRespDto> historyList = RestResponseHelper.extractData(customerCheckRelationQueryApi.queryByStoreIds(reqDto));
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(historyList)) {
            Map<String, List<CustomerCheckRelationRespDto>> storeIdHistoryMap = historyList.stream().collect(Collectors.groupingBy(h -> h.getStoreId()));
            customerStoreResponseDtoPageInfo.getList().stream().forEach(c -> {
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(storeIdHistoryMap.get(c.getStoreId()))) {
                    c.setShowHistoryFlag(CustomerCheckRelationShowHistoryFlagEnum.YES_SHOW.getType());
                }
            });
        }
         */

        return customerStoreResponseDtoPageInfo;
    }

    @Override
    public PageInfo<StoreSalesmanRelationRespDto> queryPersonPartnerPage(String filter, Integer pageNum, Integer pageSize) {
        log.info("查询业务员列表 req params : {} .", filter);
        PersonPartnerReqDto personPartnerReqDto = JSON.parseObject(filter, PersonPartnerReqDto.class);

        Assert.isTrue(org.apache.commons.lang3.ObjectUtils.isNotEmpty(personPartnerReqDto.getOrgId()), "0001", "请求参数orgId为空!");
        Long customerOrgId = personPartnerReqDto.getOrgId();
        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerExtQueryApi.queryOneByOrgId(customerOrgId));
        Assert.isTrue(org.apache.commons.lang3.ObjectUtils.isNotEmpty(customerRespDto), "0001", "当前客户不存在!请求参数orgId:" + customerOrgId);

        TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        StoreReqTypeEnum storeReqTypeEnum = StoreReqTypeEnum.enumOfCode(personPartnerReqDto.getCustomerType());
        switch (storeReqTypeEnum){
            case STORE :
            case PARENT_STORE :
                CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
                customerExtReqDto.setCreditCode(personPartnerReqDto.getCustomerCommon());
                customerExtReqDto.setOrgInfoId(String.valueOf(customerOrgId));
                List<CustomerExtRespDto> customerExtRespDtos = RestResponseHelper.extractData(customerDistributorsQueryApi.queryCustomer(customerExtReqDto));
                Optional<CustomerExtRespDto> optionalCustomerExtRespDto = customerExtRespDtos.stream().filter(c -> c.getMerchantId().equals(customerOrgId) && CustomerStatusExtEnum.ENABLED.getCode().equals(c.getStatusId())).findAny();
                Assert.isTrue(optionalCustomerExtRespDto.isPresent(),"0001","当前门店不存在");

                CustomerExtRespDto customerExtRespDto = optionalCustomerExtRespDto.get();
                Assert.isTrue(StringUtils.isNotBlank(customerExtRespDto.getThirdPartyId()),"0001","客户数据存在异常");
                tbPersonPartnerRelReqDto.setCustomerId(customerExtRespDto.getThirdPartyId());
                break;
            case DISTRIBUTION :
                CustomerRespDto distribution = RestResponseHelper.extractData(customerQueryApi.queryByCode(personPartnerReqDto.getCustomerCommon()));
                Assert.isTrue(!ObjectUtils.isEmpty(distribution),"0001","分销商数据不存在");
                Assert.isTrue(StringUtils.isNotBlank(distribution.getThirdPartyId()),"0001","客户数据存在异常");
                Assert.isTrue(CustomerStatusExtEnum.ENABLED.getCode().equals(distribution.getStatusId()),"0001","客户非合法状态");
                tbPersonPartnerRelReqDto.setCustomerId(distribution.getThirdPartyId());
                break;
        }
        tbPersonPartnerRelReqDto.setStoreId(personPartnerReqDto.getStoreId());
        tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
        tbPersonPartnerRelReqDto.setOrgId(customerOrgId);
        PageInfo<StoreSalesmanRelationRespDto> storeSalesmanRelationRespDtoPageInfo = RestResponseHelper.extractData(
                tbPersonPartnerRelQueryApi.querySalesmanByPage(JSON.toJSONString(tbPersonPartnerRelReqDto), pageNum, pageSize)
        );
        return storeSalesmanRelationRespDtoPageInfo;
    }

    @Override
    public void bindStoreAndSalesmanRelation(CustomerCheckRelationReqDto customerCheckRelationReqDto) {
//        Long orgId = RestResponseHelper.extractData(customerExtQueryApi.queryCurrentUserOrgId());
//        customerCheckRelationReqDto.setOrgId(orgId);
        //FIXME: 需要从前端带入orgid / 导入的时候通过code获取到orgId
        RestResponseHelper.extractData(customerCheckRelationApi.bindStoreAndSalesmanRelation(customerCheckRelationReqDto));
    }

    /**
     * 人店考核关系数据导入变更
     *
     * @param file file
     * @return RestResponse<BizImportRespDto>
     */
    @Override
    public RestResponse<BizImportRespDto> exportCustomerCheckRelationByExcel(MultipartFile file) throws Exception {

        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        String userName = context.userName();


        ExcelImportResult<CustomerCheckRelationExportVo> result = ExcelImportUtil.importExcelMore(file.getInputStream(), CustomerCheckRelationExportVo.class, importParams);
        //导入数据
        List<CustomerCheckRelationExportVo> importList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(importList)) {
            return new RestResponse<>(new BizImportRespDto());
        }

        List<CustomerCheckRelationExportVo> errorList = Lists.newArrayList();
        List<CustomerCheckRelationReqDto> customerAddDtoList = Lists.newArrayList();
        List<CustomerCheckRelationReqDto> brandAddDtoList = Lists.newArrayList();

        //FIXME: 通过当前登录uset获取orgId,判断是否为经销商还是品牌方操作
        Long orgId = RestResponseHelper.extractData(customerExtQueryApi.queryCurrentUserOrgId());
        BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode(String.valueOf(orgId));
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(bizChannelEnum)) {
            log.info("门店列表 (品牌方) 批量导入人店考核关系 params => {} ", JSON.toJSONString(importList));
            brandAddDtoList = getBrandCustomerImport(importList, errorList);
        } else {
            log.info("门店列表 (经销商) 批量导入人店考核关系 params => {} ", JSON.toJSONString(importList));
            //获取客户信息
            CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerExtQueryApi.queryOneByOrgId(orgId));
            Assert.isTrue(org.apache.commons.lang3.ObjectUtils.isNotEmpty(customerRespDto), "0001", "当前客户信息不存在！");
            //前置校验
            List<CustomerCheckRelationExportVo> list  = checkBeforeImportList(customerRespDto, importList, errorList);
            //获取返回
            customerAddDtoList = getAddDtoAndErrorList(orgId, customerRespDto, errorList, list);
        }

        List<CustomerCheckRelationReqDto> batchAddDtoList = Lists.newArrayList();
        batchAddDtoList.addAll(customerAddDtoList);
        batchAddDtoList.addAll(brandAddDtoList);
        //批量插入
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(batchAddDtoList)) {
            logger.info("【{}】触发分批人店考核关系数据导入 count:{},content:{}", userName, batchAddDtoList.size(), JSON.toJSONString(batchAddDtoList));
            for (CustomerCheckRelationReqDto addReqDto : batchAddDtoList) {
                //FIXME:当前操作方式类型Excel
                if (CustomerCheckStatusEnum.NOT_BOUND.getStatus().equals(addReqDto.getStatus())) {
                    addReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                } else {
                    addReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
                }
            }

            //FIXME: 请求批量绑定api
            RestResponse<List<CustomerCheckRelationBindErrorRespDto>> response = customerCheckRelationApi.batchBindStoreAndSalesmanRelation(batchAddDtoList);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(response)) {
                List<CustomerCheckRelationBindErrorRespDto> respList = response.getData();
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(respList)) {
                    for (CustomerCheckRelationBindErrorRespDto respDto : respList) {
                        CustomerCheckRelationExportVo errorVo = new CustomerCheckRelationExportVo();
                        errorVo.setStoreNo(respDto.getStoreNo());
                        errorVo.setSalesmanCode(respDto.getSalesmanCode());
                        errorVo.setReason(respDto.getResultMsg());
                        errorList.add(errorVo);
                    }
                }
            }
        }



        logger.info("【导入->人店考核关系数据导入结果】 总条数：{}，导入失败{}条，导入成功{}条", importList.size(), errorList.size(), importList.size() - errorList.size());
        Integer importFailTotal = errorList.size(), importSuccessTotal = importList.size() - errorList.size(), total = importList.size();
        String url = "";
        logger.info("校验异常数据：{}", JSON.toJSONString(errorList));
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(errorList)) {
            String excelName = "cube/" + "人店考核关系数据失败文件_" + DateUtil.getDateFormat(new Date(), "yyyyMMddHHmmss");
            url = EasyPoiExportUtil.getExportUrl(errorList, CustomerCheckRelationExportVo.class, (String) null, excelName, "xls");
        }
        return new RestResponse<>(new BizImportRespDto(total, importSuccessTotal, importFailTotal, url));
    }

    private List<CustomerCheckRelationReqDto> getBrandCustomerImport(List<CustomerCheckRelationExportVo> importList,
                                                                     List<CustomerCheckRelationExportVo> errorList) {

        List<CustomerCheckRelationReqDto> addDtoList = Lists.newArrayList();
        
        brandCustomerImportCheckBefore(importList, errorList);

        Map<Long, List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto>> customerOrgIdMap = brandCustomerImportCheckBefore_V2(importList, errorList);


        List<CustomerCheckRelationExportVo> voList = importList.stream().filter(a ->
                StringUtils.isNotBlank(a.getCustomerCode())
                && StringUtils.isNotBlank(a.getStoreNo())
                && StringUtils.isNotBlank(a.getSalesmanCode())
                && StringUtils.isNotBlank(a.getOperateType())
                && StringUtils.isNotBlank(a.getReason())).collect(Collectors.toList());

        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(voList)) {
            Map<Long, List<CustomerCheckRelationExportVo>> orgIdMap = voList.stream().collect(Collectors.groupingBy(c -> c.getOrgId()));
            Map<Long, List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto>> finalCustomerOrgIdMap = customerOrgIdMap;
            orgIdMap.forEach(
                    (key, value) -> {
                        List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto> respDtoList = finalCustomerOrgIdMap.get(key);
                        com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto customerExtRespDto = respDtoList.get(0);
                        CustomerRespDto customerRespDto = new CustomerRespDto();
                        BeanUtils.copyProperties(customerExtRespDto, customerRespDto);
                        addDtoList.addAll(getAddDtoAndErrorList(key, customerRespDto, errorList, value));
                    }

            );
        }

        return addDtoList;
    }

    @NotNull
    private Map<Long, List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto>> brandCustomerImportCheckBefore_V2(List<CustomerCheckRelationExportVo> importList,
                                                                                                                               List<CustomerCheckRelationExportVo> errorList) {
        List<CustomerCheckRelationExportVo> relationExportVoList = importList.stream().filter(a ->
                        StringUtils.isNotBlank(a.getCustomerCode())
                        && StringUtils.isNotBlank(a.getStoreNo())
                        && StringUtils.isNotBlank(a.getSalesmanCode())
                        && StringUtils.isNotBlank(a.getOperateType()))
                .collect(Collectors.toList());
        List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto> customerExtRespDtoList = Lists.newArrayList();
        if(org.apache.commons.collections4.CollectionUtils.isNotEmpty(relationExportVoList)){
            List<String> codeList = relationExportVoList.stream().map(c -> c.getCustomerCode()).distinct().collect(Collectors.toList());
            customerExtRespDtoList = RestResponseHelper.extractData(customerExtThreeQueryApi.queryByCodeList(codeList));
        }
        Map<String, List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto>> customerMap = new HashMap<>(16);
        Map<Long, List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto>> customerOrgIdMap = new HashMap<>(16);
        //判断品牌方导入的`经销商编码`都是存在的客户
        if(org.apache.commons.collections4.CollectionUtils.isEmpty(customerExtRespDtoList)){
            relationExportVoList.forEach(r -> r.setReason("客户信息不存在！"));
        }else{
            customerMap = customerExtRespDtoList.stream().collect(Collectors.groupingBy(c -> c.getCode()));
            customerOrgIdMap = customerExtRespDtoList.stream().collect(Collectors.groupingBy(c -> c.getOrgInfoId()));
        }
        Map<String, List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto>> finalCustomerMap = customerMap;
        importList.stream().filter(a -> StringUtils.isNotBlank(a.getCustomerCode())
                        && StringUtils.isNotBlank(a.getStoreNo())
                        && StringUtils.isNotBlank(a.getSalesmanCode())
                        && StringUtils.isNotBlank(a.getOperateType())
                        && StringUtils.isNotBlank(a.getReason()))
                .forEach(i -> {
                    List<com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto> customerExtRespDtos = finalCustomerMap.get(i.getCustomerCode());
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty(customerExtRespDtos)) {
                        i.setReason("客户信息不存在！");
                    } else {
                        i.setOrgId(customerExtRespDtos.get(0).getOrgInfoId());
                    }
                });


        //过滤,根据门店编码分组->重复的写失败原因
        Map<String, List<CustomerCheckRelationExportVo>> importListMap = importList.stream()
                .filter(a -> StringUtils.isNotBlank(a.getCustomerCode())
                        && StringUtils.isNotBlank(a.getStoreNo())
                        && StringUtils.isNotBlank(a.getSalesmanCode())
                        && StringUtils.isNotBlank(a.getOperateType())
                        && StringUtils.isNotBlank(a.getReason()))
                .collect(Collectors.groupingBy(CustomerCheckRelationExportVo::getStoreNo));
        if (importListMap.entrySet().size() > 0) {
            importListMap.forEach(
                    (key, value) -> {
                        if (value.size() > 1) {
                            for (CustomerCheckRelationExportVo exportVo : value) {
                                exportVo.setReason("导入人店考核关系数据重复，请重新确认!门店编码:" + key);
                                errorList.add(exportVo);
                            }
                        }

                    });
        }
        return customerOrgIdMap;
    }

    private static void brandCustomerImportCheckBefore(List<CustomerCheckRelationExportVo> importList, List<CustomerCheckRelationExportVo> errorList) {
        //去重两端空格
        for (CustomerCheckRelationExportVo vo : importList) {
            if (StringUtils.isNotBlank(vo.getCustomerCode())) {
                vo.setCustomerCode(vo.getCustomerCode().trim());
            } else {
                vo.setReason("请填写经销商编码");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank(vo.getStoreNo())) {
                vo.setStoreNo(vo.getStoreNo().trim());
            } else {
                vo.setReason("请填写门店编码");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank(vo.getSalesmanCode())) {
                vo.setSalesmanCode(vo.getSalesmanCode().trim());
            } else {
                vo.setReason("请填写人员编码");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank(vo.getOperateType())) {
                vo.setOperateType(vo.getOperateType().trim());
            } else {
                vo.setReason("请填操作方式");
                errorList.add(vo);
            }
        }
    }

    private  List<CustomerCheckRelationReqDto> getAddDtoAndErrorList(Long orgId, CustomerRespDto customerRespDto,
                                                                     List<CustomerCheckRelationExportVo> errorList,
                                                                     List<CustomerCheckRelationExportVo> list) {
        List<CustomerCheckRelationReqDto> addDtoList = Lists.newArrayList();

        List<CustomerCheckRelationExportVo> exportVoList = list.stream()
                .filter(a -> StringUtils.isEmpty(a.getReason()) && StringUtils.isNotBlank(a.getStoreNo()) && StringUtils.isNotBlank(a.getSalesmanCode()) && StringUtils.isNotBlank(a.getOperateType()))
                .collect(Collectors.toList());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(exportVoList)) {
            //查询门店列表
            List<CustomerStoreResponseDto> customerStoreResponseDtoList = queryCustomerStoreList(orgId, exportVoList,customerRespDto);

            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(customerStoreResponseDtoList)) {
                Map<String, List<CustomerStoreResponseDto>> customerMap = customerStoreResponseDtoList.stream().collect(Collectors.groupingBy(CustomerStoreResponseDto::getStoreNo));
                //查询当前经销商绑定的人员列表
                Map<String, List<TbPersonPartnerRelRespDto>> personPartnerMap = queryPersonPartnerMap(customerRespDto, exportVoList, errorList);

                //根据当前组织id+门店编码列表->查询门店组织绑定关系
                List<CustomerCheckRelationRespDto> customerCheckRelationRespDtoList = getCustomerCheckRelationRespDtoList(orgId, customerStoreResponseDtoList);

                //FIXME: 处理导入需要删除的数据
                doHandleDeleteImportList(orgId, errorList, exportVoList, customerMap, personPartnerMap, customerCheckRelationRespDtoList);

                //处理导入数据(返回成功list,失败list)
                List<CustomerCheckRelationReqDto> doHandleImportList = doHandleImportList(errorList, orgId, exportVoList, customerMap, personPartnerMap, customerCheckRelationRespDtoList);
                addDtoList.addAll(doHandleImportList);
            } else {
                for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                    exportVo.setReason("无当前门店数据，请重新确认");
                    errorList.add(exportVo);
                }
            }
        }
        return addDtoList;
    }

    private void doHandleDeleteImportList(Long orgId, List<CustomerCheckRelationExportVo> errorList,
                                          List<CustomerCheckRelationExportVo> exportVoList,
                                          Map<String, List<CustomerStoreResponseDto>> customerMap,
                                          Map<String, List<TbPersonPartnerRelRespDto>> personPartnerMap,
                                          List<CustomerCheckRelationRespDto> customerCheckRelationRespDtoList) {

        List<CustomerCheckRelationExportVo> deleteExportList = exportVoList.stream().filter(a -> CustomerCheckRelationExportOperateTypeEnum.DELETE.getName().equals(a.getOperateType())).collect(Collectors.toList());

        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(deleteExportList)) {
           /* if (org.apache.commons.collections4.CollectionUtils.isEmpty(customerCheckRelationRespDtoList)) {
                deleteExportList.forEach(deleteVo -> {
                    deleteVo.setReason("无当前人店考核绑定数据，请重新确认");
                    errorList.add(deleteVo);
                });

            } else {*/
                Map<String, List<CustomerCheckRelationRespDto>> orgIdStoreIdSaleManCodeRelMap = Optional.of(customerCheckRelationRespDtoList).orElse(Lists.newArrayList())
                        .stream().collect(Collectors.groupingBy(c -> c.getOrgId() + "|" + c.getStoreId() + "|" + c.getSalesmanCode()));

                for (CustomerCheckRelationExportVo deleteVo : deleteExportList) {
                    if (StringUtils.isEmpty(deleteVo.getReason())
                            && StringUtils.isNotBlank(deleteVo.getStoreNo())
                            && StringUtils.isNotBlank(deleteVo.getSalesmanCode())
                            && StringUtils.isNotBlank(deleteVo.getOperateType())
                            && deleteVo.getOperateType().equals(CustomerCheckRelationExportOperateTypeEnum.DELETE.getName())) {

                        List<CustomerStoreResponseDto> customerStoreInfoList = customerMap.get(deleteVo.getStoreNo());
                        if (org.apache.commons.collections4.CollectionUtils.isEmpty(customerStoreInfoList)) {
                            deleteVo.setReason("无当前门店数据，请重新确认");
                            errorList.add(deleteVo);
                            continue;
                        }

                        List<TbPersonPartnerRelRespDto> personPartnerInfoList = personPartnerMap.get(deleteVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                        if (org.apache.commons.collections4.CollectionUtils.isEmpty(personPartnerInfoList)) {
                            deleteVo.setReason("未维护该业务员人店关系，请维护后再做人店考核关系绑定");
                            errorList.add(deleteVo);
                            continue;
                        }
                        //获取门店信息,人员信息
                        CustomerStoreResponseDto customerStoreInfo = customerStoreInfoList.get(0);
                        TbPersonPartnerRelRespDto personPartnerInfo = personPartnerInfoList.get(0);
                        List<CustomerCheckRelationRespDto> relationRespDtoList = orgIdStoreIdSaleManCodeRelMap.get(orgId + "|" + customerStoreInfo.getStoreId() + "|" + personPartnerInfo.getEmpNo());
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(relationRespDtoList)) {
                            for (CustomerCheckRelationRespDto respDto : relationRespDtoList) {
                                CustomerCheckRelationReqDto notBoundReqDto = new CustomerCheckRelationReqDto();
                                notBoundReqDto.setOrgId(respDto.getOrgId());
                                notBoundReqDto.setStoreId(respDto.getStoreId());
                                notBoundReqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                                notBoundReqDto.setSalesmanId(respDto.getSalesmanId());
                                notBoundReqDto.setThirdPartyId(customerStoreInfo.getCustomerId());
                                notBoundReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                                log.info("人店考核关系数据导入操作方式:删除,当前orgId+门店id, 存在则[解绑].请求参数:" + JSON.toJSONString(notBoundReqDto));
                                customerCheckRelationApi.bindStoreAndSalesmanRelation(notBoundReqDto);
                            }
                        } else {
                            deleteVo.setReason("无当前人店考核绑定数据，请重新确认");
                            errorList.add(deleteVo);
                        }
                    }
                }
            //}
        }
    }


    private List<CustomerCheckRelationReqDto> doHandleImportList(List<CustomerCheckRelationExportVo> errorList,Long orgId,
                                                                 List<CustomerCheckRelationExportVo> exportVoList,
                                                                 Map<String, List<CustomerStoreResponseDto>> customerMap,
                                                                 Map<String, List<TbPersonPartnerRelRespDto>> personPartnerMap,
                                                                 List<CustomerCheckRelationRespDto> customerCheckRelationRespDtoList) {

        List<CustomerCheckRelationReqDto> addDtoList = Lists.newArrayList();

        if (org.apache.commons.collections4.CollectionUtils.isEmpty(customerCheckRelationRespDtoList)) {
            for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                if (StringUtils.isEmpty(exportVo.getReason()) && StringUtils.isNotBlank(exportVo.getStoreNo()) && StringUtils.isNotBlank(exportVo.getSalesmanCode())
                        && StringUtils.isNotBlank(exportVo.getOperateType())
                        && exportVo.getOperateType().equals(CustomerCheckRelationExportOperateTypeEnum.ADD_OR_UPDATE.getName())) {
                    List<CustomerStoreResponseDto> customerStoreInfoList = customerMap.get(exportVo.getStoreNo());
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty(customerStoreInfoList)) {
                        exportVo.setReason("无当前门店数据，请重新确认");
                        errorList.add(exportVo);
                        continue;
                    }
                    List<TbPersonPartnerRelRespDto> personPartnerInfoList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty(personPartnerInfoList)) {
                        exportVo.setReason("未维护该业务员人店关系，请维护后再做人店考核关系绑定");
                        errorList.add(exportVo);
                        continue;
                    }

                    CustomerStoreResponseDto customerStoreInfo = customerStoreInfoList.get(0);
                    TbPersonPartnerRelRespDto personPartnerInfo = personPartnerInfoList.get(0);
                    addDtoList.add(getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
                }
            }
        } else {

            Map<String, List<CustomerCheckRelationRespDto>> orgIdStoreIdRelMap = customerCheckRelationRespDtoList.stream().collect(Collectors.groupingBy(c -> c.getOrgId() + "|" + c.getStoreId()) );

            for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                if (StringUtils.isEmpty(exportVo.getReason()) && StringUtils.isNotBlank(exportVo.getStoreNo()) && StringUtils.isNotBlank(exportVo.getSalesmanCode())
                        && StringUtils.isNotBlank(exportVo.getOperateType())
                        && exportVo.getOperateType().equals(CustomerCheckRelationExportOperateTypeEnum.ADD_OR_UPDATE.getName())
                ) {
                    List<CustomerStoreResponseDto> customerStoreInfoList = customerMap.get(exportVo.getStoreNo());
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty(customerStoreInfoList)) {
                        exportVo.setReason("无当前门店数据，请重新确认");
                        errorList.add(exportVo);
                        continue;
                    }

                    List<TbPersonPartnerRelRespDto> personPartnerInfoList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty(personPartnerInfoList)) {
                        exportVo.setReason("未维护该业务员人店关系，请维护后再做人店考核关系绑定 ");
                        errorList.add(exportVo);
                        continue;
                    }


                    //获取门店信息,人员信息
                    CustomerStoreResponseDto customerStoreInfo = customerStoreInfoList.get(0);
                    TbPersonPartnerRelRespDto personPartnerInfo = personPartnerInfoList.get(0);

                    //FIXME: 当前orgId+门店id, 存在则覆盖.(如xx经销商xx店. 本来考核 '张三' , 现在导入是'李四' ,那么李四直接覆盖张三 ),不存在则直接新增李四
                    List<CustomerCheckRelationRespDto> orgStoreSaleRelationList = orgIdStoreIdRelMap.get(orgId + "|" + customerStoreInfo.getStoreId());
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(orgStoreSaleRelationList)) {
                        //先解绑,后新增
                        for (CustomerCheckRelationRespDto dto : orgStoreSaleRelationList) {
                            CustomerCheckRelationReqDto notBoundReqDto = new CustomerCheckRelationReqDto();
                            notBoundReqDto.setOrgId(orgId);
                            notBoundReqDto.setStoreId(dto.getStoreId());
                            notBoundReqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                            notBoundReqDto.setSalesmanId(dto.getSalesmanId());
                            notBoundReqDto.setThirdPartyId(customerStoreInfo.getCustomerId());
                            notBoundReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                            log.info("人店考核关系数据导入,当前orgId+门店id, 存在则覆盖.请求参数:"+JSON.toJSONString(notBoundReqDto));

                            customerCheckRelationApi.bindStoreAndSalesmanRelation(notBoundReqDto);
                            //再新增
                            addDtoList.add(getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
                        }
                    }else{
                        List<TbPersonPartnerRelRespDto> personList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(personList)) {
                            addDtoList.add(getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
                        } else {
                            exportVo.setReason("人员信息已经失效，请重新确认;");
                            errorList.add(exportVo);
                        }
                    }
                }
            }
        }

        return addDtoList;
    }

    private Map<String, List<TbPersonPartnerRelRespDto>> queryPersonPartnerMap(CustomerRespDto customerRespDto,
                                                                               List<CustomerCheckRelationExportVo> exportVoList,
                                                                               List<CustomerCheckRelationExportVo> errorList) {
        List<String> salesmanCodeList = exportVoList.stream().map(CustomerCheckRelationExportVo::getSalesmanCode).collect(Collectors.toList());
        TbPersonPartnerRelReqDto personPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        personPartnerRelReqDto.setEmpNos(salesmanCodeList);
        personPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
//        RestResponse<PageInfo<TbPersonPartnerRelRespDto>> personPartnerRestResponse = tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString(personPartnerRelReqDto), 1, Integer.MAX_VALUE);
//        List<TbPersonPartnerRelRespDto> personPartnerList = RestResponseHelper.extractData(personPartnerRestResponse).getList();
        List<TbPersonPartnerRelRespDto> personPartnerList = RestResponseHelper.extractData(tbPersonPartnerRelQueryApi.queryByPost(personPartnerRelReqDto));
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(personPartnerList)) {
            return personPartnerList.stream().collect(Collectors.groupingBy(p -> p.getEmpNo() + "-" + p.getCustomerId()));
        } else {
            for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                exportVo.setReason("未维护该业务员人店关系，请维护后再做人店考核关系绑定");
                errorList.add(exportVo);
            }

        }
        return new HashMap<>(16);
    }

    private List<CustomerStoreResponseDto> queryCustomerStoreList(Long orgId,
                                                                  List<CustomerCheckRelationExportVo> exportVoList,
                                                                  CustomerRespDto customerRespDto ) {
        List<String> storeNoList = exportVoList.stream().map(CustomerCheckRelationExportVo::getStoreNo).collect(Collectors.toList());
        CustomerStoreReqDto customerStoreReqDto = new CustomerStoreReqDto();
        customerStoreReqDto.setStoreNos(storeNoList);
        customerStoreReqDto.setOrgId(orgId);
        customerStoreReqDto.setMerchantId(customerRespDto.getMerchantId());

        //RestResponse<PageInfo<CustomerStoreResponseDto>> customerStoreResponse = customerDistributorsQueryApi.queryCustomerStorePage(JSON.toJSONString(customerStoreReqDto), 1, Integer.MAX_VALUE);
        //return RestResponseHelper.extractData(customerStoreResponse).getList();

        return RestResponseHelper.extractData(customerDistributorsQueryApi.queryCustomerStoreByPost(customerStoreReqDto));
    }

    /**
     * 导入数据->前置校验
     *
     * @param importList 导入数据
     * @param errorList  errorList
     * @return List<CustomerCheckRelationExportVo>
     */
    private List<CustomerCheckRelationExportVo> checkBeforeImportList(CustomerRespDto customerRespDto,
                                                                      List<CustomerCheckRelationExportVo> importList,
                                                                      List<CustomerCheckRelationExportVo> errorList) {


        CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
        customerCheckPatternReqDto.setCustomerCodes(Lists.newArrayList(customerRespDto.getCode()));
        List<CustomerCheckPatternRespDto> customerCheckPatternEos = RestResponseHelper.extractData(customerCheckPatternQueryApi.selectCustomerCheckPatternByCode(customerCheckPatternReqDto));
        Assert.isTrue(!CollectionUtils.isEmpty(customerCheckPatternEos), "0001", "当前客户未指定考核方式！");

        importList.forEach(vo->  Assert.isTrue(StringUtils.isNotBlank(vo.getOperateType()), "0001", "操作方式必填！"));


        //去重两端空格
        for (CustomerCheckRelationExportVo vo : importList) {
            if (StringUtils.isNotBlank(vo.getStoreNo())) {
                vo.setStoreNo(vo.getStoreNo().trim());
            } else {
                vo.setReason("请填写门店编码");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank(vo.getSalesmanCode())) {
                vo.setSalesmanCode(vo.getSalesmanCode().trim());
            } else {
                vo.setReason("请填写人员编码");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank(vo.getOperateType())) {
                vo.setOperateType(vo.getOperateType().trim());
            } else {
                vo.setReason("请填操作方式");
                errorList.add(vo);
            }
        }
        //过滤,根据门店编码分组->重复的写失败原因
        Map<String, List<CustomerCheckRelationExportVo>> importListMap = importList.stream()
                .filter(a -> StringUtils.isNotBlank(a.getStoreNo()) && StringUtils.isNotBlank(a.getSalesmanCode()))
                .collect(Collectors.groupingBy(CustomerCheckRelationExportVo::getStoreNo));
        if (importListMap.entrySet().size() > 0) {
            importListMap.forEach(
                    (key, value) -> {
                        if (value.size() > 1) {
                            for (CustomerCheckRelationExportVo exportVo : value) {
                                exportVo.setReason("导入人店考核关系数据重复，请重新确认");
                                errorList.add(exportVo);
                            }
                        }
                    });
        }
        return importList;
    }


    private List<CustomerCheckRelationRespDto> getCustomerCheckRelationRespDtoList(Long orgId, List<CustomerStoreResponseDto> customerList) {
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(customerList)) {
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            List<String> storeIds = customerList.stream().map(CustomerStoreResponseDto::getStoreId).collect(Collectors.toList());
            customerCheckRelationReqDto.setStoreIds(storeIds);
            customerCheckRelationReqDto.setOrgId(orgId);
            customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
            return RestResponseHelper.extractData(customerCheckRelationQueryApi.queryByStoreIds(customerCheckRelationReqDto));
        }
        return Lists.newArrayList();
    }

    private CustomerCheckRelationReqDto getCustomerCheckRelationReqDto(Long orgId,
                                                                       CustomerStoreResponseDto customerStoreInfo,
                                                                       TbPersonPartnerRelRespDto personPartnerInfo) {
        CustomerCheckRelationReqDto addDto = new CustomerCheckRelationReqDto();
        addDto.setStoreId(customerStoreInfo.getStoreId());
        addDto.setStoreNo(customerStoreInfo.getStoreNo());
        addDto.setSalesmanId(personPartnerInfo.getRowId());
        addDto.setSalesmanName(personPartnerInfo.getFullName());
        addDto.setSalesmanCode(personPartnerInfo.getEmpNo());
        addDto.setSalesmanType(personPartnerInfo.getRoleTypeName());
        addDto.setSalesmanPhone(personPartnerInfo.getPhoneNumber());
        addDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        addDto.setOrgId(orgId);
        addDto.setThirdPartyId(personPartnerInfo.getCustomerId());
        return addDto;
    }

    @Override
    public PageInfo<CustomerCheckRelationRespDto> queryStoreAndSalesmanRelationBindHistoryPage(String filter, Integer pageNum, Integer pageSize) {

        Long orgId = RestResponseHelper.extractData(customerExtQueryApi.queryCurrentUserOrgId());
        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerExtQueryApi.queryOneByOrgId(orgId));
        Assert.isTrue(org.apache.commons.lang3.ObjectUtils.isNotEmpty(customerRespDto), "0001", "当前客户信息不存在！");

        CustomerCheckRelationReqDto reqDto = JSON.parseObject(filter, CustomerCheckRelationReqDto.class);
        Assert.isTrue(StringUtils.isNotBlank(reqDto.getStoreId()), "0001", "当前门店ID为空！");


        //FIXME:判断是否是品牌方还是经销商查询修改记录,品牌方则需要多传一个当前记录的经销商orgId.
        BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode(String.valueOf(orgId));
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(bizChannelEnum)) {
            Assert.isTrue(org.apache.commons.lang3.ObjectUtils.isNotEmpty(reqDto.getOrgId()), "0001", "当前经销商ID为空！");
            reqDto.setOrgId(reqDto.getOrgId());
        }else{
            reqDto.setOrgId(orgId);
        }

        reqDto.setStoreId(reqDto.getStoreId());
        reqDto.setStatusList(Lists.newArrayList(CustomerCheckStatusEnum.NOT_BOUND.getStatus(),CustomerCheckStatusEnum.DISABLE.getStatus()));
        log.info("人店考核关系历史绑定列表查询 req params : {} .", JSON.toJSONString(reqDto));
        return RestResponseHelper.extractData(customerCheckRelationQueryApi.queryByPage(JSON.toJSONString(reqDto), pageNum, pageSize));
    }

    @Override
    public void saveOrUpdateCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto) {
        //addReqDto.setOrganizationId(RestResponseHelper.extractData(customerExtQueryApi.queryCurrentUserOrgId()));
        customerCheckPatternConfigApi.saveOrUpdateCustomerCheckPatternConfig(addReqDto);
    }

    @Override
    public PageInfo<CustomerCheckPatternConfigRespDto> queryPatternConfigByPage(String filter, Integer pageNum, Integer pageSize) {
        // CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = JSON.parseObject(filter, CustomerCheckPatternConfigReqDto.class);
       // customerCheckPatternConfigReqDto.setOrganizationId(RestResponseHelper.extractData(customerExtQueryApi.queryCurrentUserOrgId()));
        return RestResponseHelper.extractData(customerCheckPatternConfigQueryApi.queryByPage(filter, pageNum, pageSize));
    }

    @Override
    public BizImportRespDto exportPatternConfig(String customerCode, MultipartFile file) throws Exception {
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);

        ExcelImportResult<PatternConfigExportVo> result = ExcelImportUtil.importExcelMore(file.getInputStream(), PatternConfigExportVo.class, importParams);
        //导入数据
        List<PatternConfigExportVo> importList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());

        Map<String, List<PatternConfigExportVo>> patternConfigRecord = importList.stream().collect(Collectors.groupingBy(PatternConfigExportVo::getConfigType));

        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerQueryApi.queryByCode(customerCode));

        //校验数据
        verifyPatternConfig(patternConfigRecord, customerRespDto);

        List<PatternConfigExportVo> collect = patternConfigRecord.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<PatternConfigExportVo> errorList = collect.stream().filter(c -> StringUtils.isNotBlank(c.getReason())).collect(Collectors.toList());
        List<PatternConfigExportVo> successList = collect.stream().filter(c -> !StringUtils.isNotBlank(c.getReason())).collect(Collectors.toList());

        logger.info("【导入 -> 考核白名单配置数据】 总条数：{}，导入失败{}条，导入成功{}条", importList.size(), errorList.size(), importList.size() - errorList.size());
        Integer importFailTotal = errorList.size(), importSuccessTotal = importList.size() - errorList.size(), total = importList.size();
        String url = "";
        logger.info("校验异常数据：{}", JSON.toJSONString(errorList));
        if (!CollectionUtils.isEmpty(errorList)) {
            String excelName = "cube/" + "考核白名单配置数据失败文件_" + DateUtil.getDateFormat(new Date(), "yyyyMMddHHmmss");
            url = EasyPoiExportUtil.getExportUrl(errorList, PatternConfigExportVo.class, (String) null, excelName, "xls");
        }

        if(!CollectionUtils.isEmpty(successList)){
            Map<String, List<PatternConfigExportVo>> patternConfigRecords = successList.stream().collect(Collectors.groupingBy(PatternConfigExportVo::getConfigType));
            patternConfigRecords.forEach((k, v) -> {
                CustomerCheckPatternConfigReqDto addReqDto = new CustomerCheckPatternConfigReqDto();
                addReqDto.setConfigType(k);
                addReqDto.setOrganizationId(customerRespDto.getOrgInfoId());
                addReqDto.setConfigContentLists(v.stream().map(c->c.getConfigCode()).collect(Collectors.toList()));
                customerCheckPatternConfigApi.saveOrUpdateCustomerCheckPatternConfig(addReqDto);
            });
        }

        return new BizImportRespDto(total, importSuccessTotal, importFailTotal, url);
    }

    /**
     * 校验导入数据是否合法
     * @param collect
     * @param customerExtRespDto
     */
    private void verifyPatternConfig(Map<String, List<PatternConfigExportVo>> collect, CustomerRespDto customerExtRespDto) {
        collect.forEach((k, v) -> {
            if (k.equals(StoreGovernTypeEnum.AREA.getCode())) {
                List<StoreAreaRespDto> storeAreaRespDto = RestResponseHelper.extractData(storeSellerGovernContentQueryApi.querySellerGovernAreaByOrgId(customerExtRespDto.getOrgInfoId()));
                if (CollectionUtils.isEmpty(storeAreaRespDto)) {
                    v.stream().forEach(c -> c.setReason("当前区域不存在经销商管辖范围内"));
                    return;
                }
                List<StoreAreaRespDto> areaTree = RestResponseHelper.extractData(storeAreaQueryApi.queryTree());
                v.stream().forEach(dto -> {

                    //解析关联关系
                    List<String> configCodes = Lists.newArrayList();
                    getStoreParentAreaRespDto(dto.getConfigCode(), configCodes);
                    getStoreAreaRespDto(dto.getConfigCode() , configCodes , areaTree);

                    long count = storeAreaRespDto.stream().map(c -> configCodes.contains(c.getCode())).count();
                    if (count == 0L) {
                        dto.setReason("当前区域不存在经销商管辖范围内");
                    }
                });
            } else {
                PageInfo<StoreRespDto> storeRespDtoPageInfo = RestResponseHelper.extractData(
                        storeSellerGovernContentQueryApi.querySellerGovern(customerExtRespDto.getOrgInfoId(), k, 1, Integer.MAX_VALUE)
                );
                List<String> socialCreditNums = CollectionUtils.isEmpty(storeRespDtoPageInfo.getList()) ? Lists.newArrayList() :
                        storeRespDtoPageInfo.getList().stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
                v.stream().filter(c -> !socialCreditNums.contains(c.getConfigCode())).forEach(dto -> dto.setReason("门店不存在当前经销商管辖范围"));
            }
        });
    }

    @Nullable
    private List<String> getStoreParentAreaRespDto(String configCode , List<String> configCodes) {
        StoreAreaRespDto areaRespDto = RestResponseHelper.extractData(storeAreaQueryApi.queryByCode(configCode));
        if(ObjectUtils.isEmpty(areaRespDto)){
            return Lists.newArrayList();
        }

        if (!ObjectUtils.isEmpty(areaRespDto) && 0 != Integer.parseInt(areaRespDto.getParentCode())) {
            getStoreParentAreaRespDto(areaRespDto.getParentCode(), configCodes);
        }
        configCodes.add(areaRespDto.getCode());
        return configCodes;
    }

    @Nullable
    private List<String> getStoreAreaRespDto(String configCode , List<String> configCodes , List<StoreAreaRespDto> areaTree) {
        StoreAreaRespDto areaRespDto = RestResponseHelper.extractData(storeAreaQueryApi.queryByCode(configCode));
        if(ObjectUtils.isEmpty(areaRespDto)){
            return Lists.newArrayList();
        }

        List<String> collect = areaTree.stream().filter(c -> c.getParentCode().equals(areaRespDto.getCode())).map(c->c.getCode()).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(collect)) {
            collect.forEach(c -> getStoreAreaRespDto(c, collect, areaTree));
        }
        configCodes.addAll(collect);
        return configCodes;
    }


}

