/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.StoreReqTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.CustomerStoreReqDto;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerStoreResponseDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSalesmanRelationRespDto;
import com.dtyunxi.tcbj.api.dto.response.TbPersonPartnerRelRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.ITbPersonPartnerRelQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerCheckPatternConfigApi;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerCheckRelationApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationExportOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationShowHistoryFlagEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationSourceOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryGovernReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationBindErrorRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerCheckPatternConfigQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerCheckPatternQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerCheckRelationQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreSellerGovernContentQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.PersonPartnerReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreCheckService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.biz.vo.CustomerCheckRelationExportVo;
import com.dtyunxi.yundt.module.customer.biz.vo.PatternConfigExportVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IStoreCheckServiceImpl
implements IStoreCheckService {
    private static final Logger log = LoggerFactory.getLogger(IStoreCheckServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private ICustomerCheckRelationQueryApi customerCheckRelationQueryApi;
    @Resource
    private ICustomerCheckPatternQueryApi customerCheckPatternQueryApi;
    @Resource
    private ITbPersonPartnerRelQueryApi tbPersonPartnerRelQueryApi;
    @Resource
    private ICustomerCheckRelationApi customerCheckRelationApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICustomerCheckPatternConfigApi customerCheckPatternConfigApi;
    @Resource
    private ICustomerCheckPatternConfigQueryApi customerCheckPatternConfigQueryApi;
    @Resource
    private IStoreSellerGovernContentQueryApi storeSellerGovernContentQueryApi;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;
    @Resource
    private IStoreQueryApi storeQueryApi;

    @Override
    public PageInfo<CustomerStoreResponseDto> queryCustomerStorePage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo customerStoreResponseDtoPageInfo;
        CustomerStoreReqDto customerStoreReqDto = (CustomerStoreReqDto)JSON.parseObject((String)filter, CustomerStoreReqDto.class);
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode((String)String.valueOf(orgId));
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)bizChannelEnum)) {
            log.info("\u67e5\u8be2\u95e8\u5e97\u5217\u8868 (\u54c1\u724c\u65b9) params => {} ", (Object)JSON.toJSONString((Object)customerStoreReqDto));
            customerStoreResponseDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerStorePage(JSON.toJSONString((Object)customerStoreReqDto), pageNum, pageSize));
        } else {
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(orgId));
            customerStoreReqDto.setOrgId(orgId);
            customerStoreReqDto.setMerchantId(customerRespDto.getMerchantId());
            log.info("\u67e5\u8be2\u95e8\u5e97\u5217\u8868 (\u7ecf\u9500\u5546) params => {} ", (Object)JSON.toJSONString((Object)customerStoreReqDto));
            customerStoreResponseDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerStorePage(JSON.toJSONString((Object)customerStoreReqDto), pageNum, pageSize));
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerStoreResponseDtoPageInfo.getList())) {
            return customerStoreResponseDtoPageInfo;
        }
        List respList = customerStoreResponseDtoPageInfo.getList();
        Map<Long, List<CustomerStoreResponseDto>> respMap = respList.stream().collect(Collectors.groupingBy(c -> c.getMerchantId()));
        if (respMap.entrySet().size() > 0) {
            respMap.forEach((orgIdKey, value) -> {
                List storeIds = value.stream().map(c -> c.getStoreId()).distinct().collect(Collectors.toList());
                CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(orgIdKey));
                CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
                customerCheckRelationReqDto.setStoreIds(storeIds);
                customerCheckRelationReqDto.setOrgId(orgIdKey);
                customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                List customerCheckRelationRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByStoreIds(customerCheckRelationReqDto));
                if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationRespDtos)) {
                    List salesmanIds = customerCheckRelationRespDtos.stream().map(c -> c.getSalesmanId()).collect(Collectors.toList());
                    TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
                    tbPersonPartnerRelReqDto.setRowIds(salesmanIds);
                    tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
                    PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
                    List rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(c -> c.getRowId() + c.getCustomerId()).collect(Collectors.toList());
                    log.info("\u7ecf\u9500\u5546IDs => {} \u5168\u91cf\u4e1a\u52a1\u5458\u6821\u9a8c\u7ed3\u679c => {}", (Object)customerRespDto.getThirdPartyId(), (Object)JSON.toJSONString(rowIds));
                    Map<String, String> personMessageMap = tbPersonPartnerRelRespDtoPageInfo.getList().stream().collect(Collectors.toMap(TbPersonPartnerRelRespDto::getRowId, TbPersonPartnerRelRespDto::getFullName, (k1, k2) -> k1));
                    Map<String, CustomerCheckRelationRespDto> customerCheckRelationRespDtoMap = customerCheckRelationRespDtos.stream().collect(Collectors.toMap(key2 -> key2.getStoreId(), val -> val, (k1, k2) -> k1.getCreateTime().compareTo(k2.getCreateTime()) != 0 ? k1 : k2));
                    value.forEach(c -> {
                        CustomerCheckRelationRespDto orDefault = customerCheckRelationRespDtoMap.getOrDefault(c.getStoreId(), null);
                        if (null != orDefault) {
                            orDefault.setStatus(rowIds.contains(orDefault.getSalesmanId() + c.getCustomerId()) ? CustomerCheckStatusEnum.BOUND.getStatus() : CustomerCheckStatusEnum.DISABLE.getStatus());
                            orDefault.setSalesmanName(personMessageMap.getOrDefault(orDefault.getSalesmanId(), orDefault.getSalesmanName()));
                            c.setCustomerCheckRelationRespDto(orDefault);
                        }
                    });
                    CustomerCheckRelationReqDto reqDto = new CustomerCheckRelationReqDto();
                    reqDto.setOrgId(orgIdKey);
                    reqDto.setStoreIds(storeIds);
                    reqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                    List historyList = (List)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByStoreIds(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)historyList)) {
                        Map<String, List<CustomerCheckRelationRespDto>> storeIdHistoryMap = historyList.stream().collect(Collectors.groupingBy(h -> h.getStoreId()));
                        value.forEach(c -> {
                            if (CollectionUtils.isNotEmpty((Collection)((Collection)storeIdHistoryMap.get(c.getStoreId())))) {
                                c.setShowHistoryFlag(CustomerCheckRelationShowHistoryFlagEnum.YES_SHOW.getType());
                            }
                        });
                    }
                }
            });
        }
        return customerStoreResponseDtoPageInfo;
    }

    @Override
    public PageInfo<StoreSalesmanRelationRespDto> queryPersonPartnerPage(String filter, Integer pageNum, Integer pageSize) {
        log.info("\u67e5\u8be2\u4e1a\u52a1\u5458\u5217\u8868 req params : {} .", (Object)filter);
        PersonPartnerReqDto personPartnerReqDto = (PersonPartnerReqDto)JSON.parseObject((String)filter, PersonPartnerReqDto.class);
        Assert.isTrue((boolean)org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)personPartnerReqDto.getOrgId()), (String)"0001", (String)"\u8bf7\u6c42\u53c2\u6570orgId\u4e3a\u7a7a!");
        Long customerOrgId = personPartnerReqDto.getOrgId();
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(customerOrgId));
        Assert.isTrue((boolean)org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customerRespDto), (String)"0001", (String)("\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728!\u8bf7\u6c42\u53c2\u6570orgId:" + customerOrgId));
        TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        StoreReqTypeEnum storeReqTypeEnum = StoreReqTypeEnum.enumOfCode((Integer)personPartnerReqDto.getCustomerType());
        switch (storeReqTypeEnum) {
            case STORE: 
            case PARENT_STORE: {
                CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
                customerExtReqDto.setCreditCode(personPartnerReqDto.getCustomerCommon());
                customerExtReqDto.setOrgInfoId(String.valueOf(customerOrgId));
                List customerExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomer(customerExtReqDto));
                Optional<com.dtyunxi.tcbj.api.dto.response.CustomerExtRespDto> optionalCustomerExtRespDto = customerExtRespDtos.stream().filter(c -> c.getMerchantId().equals(customerOrgId) && CustomerStatusExtEnum.ENABLED.getCode().equals(c.getStatusId())).findAny();
                Assert.isTrue((boolean)optionalCustomerExtRespDto.isPresent(), (String)"0001", (String)"\u5f53\u524d\u95e8\u5e97\u4e0d\u5b58\u5728");
                com.dtyunxi.tcbj.api.dto.response.CustomerExtRespDto customerExtRespDto = optionalCustomerExtRespDto.get();
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerExtRespDto.getThirdPartyId()), (String)"0001", (String)"\u5ba2\u6237\u6570\u636e\u5b58\u5728\u5f02\u5e38");
                tbPersonPartnerRelReqDto.setCustomerId(customerExtRespDto.getThirdPartyId());
                break;
            }
            case DISTRIBUTION: {
                CustomerRespDto distribution = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByCode(personPartnerReqDto.getCustomerCommon()));
                Assert.isTrue((!ObjectUtils.isEmpty((Object)distribution) ? 1 : 0) != 0, (String)"0001", (String)"\u5206\u9500\u5546\u6570\u636e\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)distribution.getThirdPartyId()), (String)"0001", (String)"\u5ba2\u6237\u6570\u636e\u5b58\u5728\u5f02\u5e38");
                Assert.isTrue((boolean)CustomerStatusExtEnum.ENABLED.getCode().equals(distribution.getStatusId()), (String)"0001", (String)"\u5ba2\u6237\u975e\u5408\u6cd5\u72b6\u6001");
                tbPersonPartnerRelReqDto.setCustomerId(distribution.getThirdPartyId());
            }
        }
        tbPersonPartnerRelReqDto.setStoreId(personPartnerReqDto.getStoreId());
        tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
        tbPersonPartnerRelReqDto.setOrgId(customerOrgId);
        PageInfo storeSalesmanRelationRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.querySalesmanByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), pageNum, pageSize));
        return storeSalesmanRelationRespDtoPageInfo;
    }

    @Override
    public void bindStoreAndSalesmanRelation(CustomerCheckRelationReqDto customerCheckRelationReqDto) {
        RestResponseHelper.extractData((RestResponse)this.customerCheckRelationApi.bindStoreAndSalesmanRelation(customerCheckRelationReqDto));
    }

    @Override
    public RestResponse<BizImportRespDto> exportCustomerCheckRelationByExcel(MultipartFile file) throws Exception {
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        String userName = this.context.userName();
        ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), CustomerCheckRelationExportVo.class, (ImportParams)importParams);
        List<CustomerCheckRelationExportVo> importList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(importList)) {
            return new RestResponse((Object)new BizImportRespDto());
        }
        ArrayList errorList = Lists.newArrayList();
        List<Object> customerAddDtoList = Lists.newArrayList();
        List<Object> brandAddDtoList = Lists.newArrayList();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode((String)String.valueOf(orgId));
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)bizChannelEnum)) {
            log.info("\u95e8\u5e97\u5217\u8868 (\u54c1\u724c\u65b9) \u6279\u91cf\u5bfc\u5165\u4eba\u5e97\u8003\u6838\u5173\u7cfb params => {} ", (Object)JSON.toJSONString(importList));
            brandAddDtoList = this.getBrandCustomerImport(importList, errorList);
        } else {
            log.info("\u95e8\u5e97\u5217\u8868 (\u7ecf\u9500\u5546) \u6279\u91cf\u5bfc\u5165\u4eba\u5e97\u8003\u6838\u5173\u7cfb params => {} ", (Object)JSON.toJSONString(importList));
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(orgId));
            Assert.isTrue((boolean)org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customerRespDto), (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            List<CustomerCheckRelationExportVo> list = this.checkBeforeImportList(customerRespDto, importList, errorList);
            customerAddDtoList = this.getAddDtoAndErrorList(orgId, customerRespDto, errorList, list);
        }
        ArrayList batchAddDtoList = Lists.newArrayList();
        batchAddDtoList.addAll(customerAddDtoList);
        batchAddDtoList.addAll(brandAddDtoList);
        if (CollectionUtils.isNotEmpty((Collection)batchAddDtoList)) {
            List respList;
            this.logger.info("\u3010{}\u3011\u89e6\u53d1\u5206\u6279\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5bfc\u5165 count:{},content:{}", new Object[]{userName, batchAddDtoList.size(), JSON.toJSONString((Object)batchAddDtoList)});
            for (CustomerCheckRelationReqDto addReqDto : batchAddDtoList) {
                if (CustomerCheckStatusEnum.NOT_BOUND.getStatus().equals(addReqDto.getStatus())) {
                    addReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                    continue;
                }
                addReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
            }
            RestResponse response = this.customerCheckRelationApi.batchBindStoreAndSalesmanRelation((List)batchAddDtoList);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)response) && CollectionUtils.isNotEmpty((Collection)(respList = (List)response.getData()))) {
                for (CustomerCheckRelationBindErrorRespDto respDto : respList) {
                    CustomerCheckRelationExportVo errorVo = new CustomerCheckRelationExportVo();
                    errorVo.setStoreNo(respDto.getStoreNo());
                    errorVo.setSalesmanCode(respDto.getSalesmanCode());
                    errorVo.setReason(respDto.getResultMsg());
                    errorList.add(errorVo);
                }
            }
        }
        this.logger.info("\u3010\u5bfc\u5165->\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5bfc\u5165\u7ed3\u679c\u3011 \u603b\u6761\u6570\uff1a{}\uff0c\u5bfc\u5165\u5931\u8d25{}\u6761\uff0c\u5bfc\u5165\u6210\u529f{}\u6761", new Object[]{importList.size(), errorList.size(), importList.size() - errorList.size()});
        Integer importFailTotal = errorList.size();
        Integer importSuccessTotal = importList.size() - errorList.size();
        Integer total = importList.size();
        String url = "";
        this.logger.info("\u6821\u9a8c\u5f02\u5e38\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)errorList));
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            String excelName = "cube/\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            url = EasyPoiExportUtil.getExportUrl((List)errorList, CustomerCheckRelationExportVo.class, (String)null, (String)excelName, (String)"xls");
        }
        return new RestResponse((Object)new BizImportRespDto(total, importSuccessTotal, importFailTotal, url));
    }

    private List<CustomerCheckRelationReqDto> getBrandCustomerImport(List<CustomerCheckRelationExportVo> importList, List<CustomerCheckRelationExportVo> errorList) {
        ArrayList addDtoList = Lists.newArrayList();
        IStoreCheckServiceImpl.brandCustomerImportCheckBefore(importList, errorList);
        Map<Long, List<CustomerExtRespDto>> customerOrgIdMap = this.brandCustomerImportCheckBefore_V2(importList, errorList);
        List voList = importList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)a.getStoreNo()) && StringUtils.isNotBlank((CharSequence)a.getSalesmanCode()) && StringUtils.isNotBlank((CharSequence)a.getOperateType()) && StringUtils.isNotBlank((CharSequence)a.getReason())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(voList)) {
            Map<Long, List<CustomerCheckRelationExportVo>> orgIdMap = voList.stream().collect(Collectors.groupingBy(c -> c.getOrgId()));
            Map<Long, List<CustomerExtRespDto>> finalCustomerOrgIdMap = customerOrgIdMap;
            orgIdMap.forEach((key, value) -> {
                List respDtoList = (List)finalCustomerOrgIdMap.get(key);
                CustomerExtRespDto customerExtRespDto = (CustomerExtRespDto)respDtoList.get(0);
                CustomerRespDto customerRespDto = new CustomerRespDto();
                BeanUtils.copyProperties((Object)customerExtRespDto, (Object)customerRespDto);
                addDtoList.addAll(this.getAddDtoAndErrorList((Long)key, customerRespDto, errorList, (List<CustomerCheckRelationExportVo>)value));
            });
        }
        return addDtoList;
    }

    @NotNull
    private Map<Long, List<CustomerExtRespDto>> brandCustomerImportCheckBefore_V2(List<CustomerCheckRelationExportVo> importList, List<CustomerCheckRelationExportVo> errorList) {
        List<CustomerCheckRelationExportVo> relationExportVoList = importList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)a.getStoreNo()) && StringUtils.isNotBlank((CharSequence)a.getSalesmanCode()) && StringUtils.isNotBlank((CharSequence)a.getOperateType())).collect(Collectors.toList());
        List customerExtRespDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(relationExportVoList)) {
            List codeList = relationExportVoList.stream().map(c -> c.getCustomerCode()).distinct().collect(Collectors.toList());
            customerExtRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtThreeQueryApi.queryByCodeList(codeList));
        }
        Map<Object, Object> customerMap = new HashMap(16);
        HashMap<Long, List<CustomerExtRespDto>> customerOrgIdMap = new HashMap(16);
        if (CollectionUtils.isEmpty((Collection)customerExtRespDtoList)) {
            relationExportVoList.forEach(r -> r.setReason("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01"));
        } else {
            customerMap = customerExtRespDtoList.stream().collect(Collectors.groupingBy(c -> c.getCode()));
            customerOrgIdMap = customerExtRespDtoList.stream().collect(Collectors.groupingBy(c -> c.getOrgInfoId()));
        }
        HashMap finalCustomerMap = customerMap;
        importList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)a.getStoreNo()) && StringUtils.isNotBlank((CharSequence)a.getSalesmanCode()) && StringUtils.isNotBlank((CharSequence)a.getOperateType()) && StringUtils.isNotBlank((CharSequence)a.getReason())).forEach(i -> {
            List customerExtRespDtos = (List)finalCustomerMap.get(i.getCustomerCode());
            if (CollectionUtils.isEmpty((Collection)customerExtRespDtos)) {
                i.setReason("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            } else {
                i.setOrgId(((CustomerExtRespDto)customerExtRespDtos.get(0)).getOrgInfoId());
            }
        });
        Map<String, List<CustomerCheckRelationExportVo>> importListMap = importList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)a.getStoreNo()) && StringUtils.isNotBlank((CharSequence)a.getSalesmanCode()) && StringUtils.isNotBlank((CharSequence)a.getOperateType()) && StringUtils.isNotBlank((CharSequence)a.getReason())).collect(Collectors.groupingBy(CustomerCheckRelationExportVo::getStoreNo));
        if (importListMap.entrySet().size() > 0) {
            importListMap.forEach((key, value) -> {
                if (value.size() > 1) {
                    for (CustomerCheckRelationExportVo exportVo : value) {
                        exportVo.setReason("\u5bfc\u5165\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4!\u95e8\u5e97\u7f16\u7801:" + key);
                        errorList.add(exportVo);
                    }
                }
            });
        }
        return customerOrgIdMap;
    }

    private static void brandCustomerImportCheckBefore(List<CustomerCheckRelationExportVo> importList, List<CustomerCheckRelationExportVo> errorList) {
        for (CustomerCheckRelationExportVo vo : importList) {
            if (StringUtils.isNotBlank((CharSequence)vo.getCustomerCode())) {
                vo.setCustomerCode(vo.getCustomerCode().trim());
            } else {
                vo.setReason("\u8bf7\u586b\u5199\u7ecf\u9500\u5546\u7f16\u7801");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getStoreNo())) {
                vo.setStoreNo(vo.getStoreNo().trim());
            } else {
                vo.setReason("\u8bf7\u586b\u5199\u95e8\u5e97\u7f16\u7801");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getSalesmanCode())) {
                vo.setSalesmanCode(vo.getSalesmanCode().trim());
            } else {
                vo.setReason("\u8bf7\u586b\u5199\u4eba\u5458\u7f16\u7801");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getOperateType())) {
                vo.setOperateType(vo.getOperateType().trim());
                continue;
            }
            vo.setReason("\u8bf7\u586b\u64cd\u4f5c\u65b9\u5f0f");
            errorList.add(vo);
        }
    }

    private List<CustomerCheckRelationReqDto> getAddDtoAndErrorList(Long orgId, CustomerRespDto customerRespDto, List<CustomerCheckRelationExportVo> errorList, List<CustomerCheckRelationExportVo> list) {
        ArrayList addDtoList = Lists.newArrayList();
        List<CustomerCheckRelationExportVo> exportVoList = list.stream().filter(a -> StringUtils.isEmpty((CharSequence)a.getReason()) && StringUtils.isNotBlank((CharSequence)a.getStoreNo()) && StringUtils.isNotBlank((CharSequence)a.getSalesmanCode()) && StringUtils.isNotBlank((CharSequence)a.getOperateType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(exportVoList)) {
            List<CustomerStoreResponseDto> customerStoreResponseDtoList = this.queryCustomerStoreList(orgId, exportVoList, customerRespDto);
            if (CollectionUtils.isNotEmpty(customerStoreResponseDtoList)) {
                Map<String, List<CustomerStoreResponseDto>> customerMap = customerStoreResponseDtoList.stream().collect(Collectors.groupingBy(CustomerStoreResponseDto::getStoreNo));
                Map<String, List<TbPersonPartnerRelRespDto>> personPartnerMap = this.queryPersonPartnerMap(customerRespDto, exportVoList, errorList);
                List<CustomerCheckRelationRespDto> customerCheckRelationRespDtoList = this.getCustomerCheckRelationRespDtoList(orgId, customerStoreResponseDtoList);
                this.doHandleDeleteImportList(orgId, errorList, exportVoList, customerMap, personPartnerMap, customerCheckRelationRespDtoList);
                List<CustomerCheckRelationReqDto> doHandleImportList = this.doHandleImportList(errorList, orgId, exportVoList, customerMap, personPartnerMap, customerCheckRelationRespDtoList);
                addDtoList.addAll(doHandleImportList);
            } else {
                for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                    exportVo.setReason("\u65e0\u5f53\u524d\u95e8\u5e97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                    errorList.add(exportVo);
                }
            }
        }
        return addDtoList;
    }

    private void doHandleDeleteImportList(Long orgId, List<CustomerCheckRelationExportVo> errorList, List<CustomerCheckRelationExportVo> exportVoList, Map<String, List<CustomerStoreResponseDto>> customerMap, Map<String, List<TbPersonPartnerRelRespDto>> personPartnerMap, List<CustomerCheckRelationRespDto> customerCheckRelationRespDtoList) {
        List deleteExportList = exportVoList.stream().filter(a -> CustomerCheckRelationExportOperateTypeEnum.DELETE.getName().equals(a.getOperateType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteExportList)) {
            Map<String, List<CustomerCheckRelationRespDto>> orgIdStoreIdSaleManCodeRelMap = Optional.of(customerCheckRelationRespDtoList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(c -> c.getOrgId() + "|" + c.getStoreId() + "|" + c.getSalesmanCode()));
            for (CustomerCheckRelationExportVo deleteVo : deleteExportList) {
                if (!StringUtils.isEmpty((CharSequence)deleteVo.getReason()) || !StringUtils.isNotBlank((CharSequence)deleteVo.getStoreNo()) || !StringUtils.isNotBlank((CharSequence)deleteVo.getSalesmanCode()) || !StringUtils.isNotBlank((CharSequence)deleteVo.getOperateType()) || !deleteVo.getOperateType().equals(CustomerCheckRelationExportOperateTypeEnum.DELETE.getName())) continue;
                List<CustomerStoreResponseDto> customerStoreInfoList = customerMap.get(deleteVo.getStoreNo());
                if (CollectionUtils.isEmpty(customerStoreInfoList)) {
                    deleteVo.setReason("\u65e0\u5f53\u524d\u95e8\u5e97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                    errorList.add(deleteVo);
                    continue;
                }
                List<TbPersonPartnerRelRespDto> personPartnerInfoList = personPartnerMap.get(deleteVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                if (CollectionUtils.isEmpty(personPartnerInfoList)) {
                    deleteVo.setReason("\u672a\u7ef4\u62a4\u8be5\u4e1a\u52a1\u5458\u4eba\u5e97\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u505a\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u7ed1\u5b9a");
                    errorList.add(deleteVo);
                    continue;
                }
                CustomerStoreResponseDto customerStoreInfo = customerStoreInfoList.get(0);
                TbPersonPartnerRelRespDto personPartnerInfo = personPartnerInfoList.get(0);
                List<CustomerCheckRelationRespDto> relationRespDtoList = orgIdStoreIdSaleManCodeRelMap.get(orgId + "|" + customerStoreInfo.getStoreId() + "|" + personPartnerInfo.getEmpNo());
                if (CollectionUtils.isNotEmpty(relationRespDtoList)) {
                    for (CustomerCheckRelationRespDto respDto : relationRespDtoList) {
                        CustomerCheckRelationReqDto notBoundReqDto = new CustomerCheckRelationReqDto();
                        notBoundReqDto.setOrgId(respDto.getOrgId());
                        notBoundReqDto.setStoreId(respDto.getStoreId());
                        notBoundReqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                        notBoundReqDto.setSalesmanId(respDto.getSalesmanId());
                        notBoundReqDto.setThirdPartyId(customerStoreInfo.getCustomerId());
                        notBoundReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                        log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5bfc\u5165\u64cd\u4f5c\u65b9\u5f0f:\u5220\u9664,\u5f53\u524dorgId+\u95e8\u5e97id, \u5b58\u5728\u5219[\u89e3\u7ed1].\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)notBoundReqDto));
                        this.customerCheckRelationApi.bindStoreAndSalesmanRelation(notBoundReqDto);
                    }
                    continue;
                }
                deleteVo.setReason("\u65e0\u5f53\u524d\u4eba\u5e97\u8003\u6838\u7ed1\u5b9a\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                errorList.add(deleteVo);
            }
        }
    }

    private List<CustomerCheckRelationReqDto> doHandleImportList(List<CustomerCheckRelationExportVo> errorList, Long orgId, List<CustomerCheckRelationExportVo> exportVoList, Map<String, List<CustomerStoreResponseDto>> customerMap, Map<String, List<TbPersonPartnerRelRespDto>> personPartnerMap, List<CustomerCheckRelationRespDto> customerCheckRelationRespDtoList) {
        ArrayList addDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(customerCheckRelationRespDtoList)) {
            for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                if (!StringUtils.isEmpty((CharSequence)exportVo.getReason()) || !StringUtils.isNotBlank((CharSequence)exportVo.getStoreNo()) || !StringUtils.isNotBlank((CharSequence)exportVo.getSalesmanCode()) || !StringUtils.isNotBlank((CharSequence)exportVo.getOperateType()) || !exportVo.getOperateType().equals(CustomerCheckRelationExportOperateTypeEnum.ADD_OR_UPDATE.getName())) continue;
                List<CustomerStoreResponseDto> customerStoreInfoList = customerMap.get(exportVo.getStoreNo());
                if (CollectionUtils.isEmpty(customerStoreInfoList)) {
                    exportVo.setReason("\u65e0\u5f53\u524d\u95e8\u5e97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                    errorList.add(exportVo);
                    continue;
                }
                List<TbPersonPartnerRelRespDto> personPartnerInfoList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                if (CollectionUtils.isEmpty(personPartnerInfoList)) {
                    exportVo.setReason("\u672a\u7ef4\u62a4\u8be5\u4e1a\u52a1\u5458\u4eba\u5e97\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u505a\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u7ed1\u5b9a");
                    errorList.add(exportVo);
                    continue;
                }
                CustomerStoreResponseDto customerStoreInfo = customerStoreInfoList.get(0);
                TbPersonPartnerRelRespDto personPartnerInfo = personPartnerInfoList.get(0);
                addDtoList.add(this.getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
            }
        } else {
            Map<String, List<CustomerCheckRelationRespDto>> orgIdStoreIdRelMap = customerCheckRelationRespDtoList.stream().collect(Collectors.groupingBy(c -> c.getOrgId() + "|" + c.getStoreId()));
            for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                if (!StringUtils.isEmpty((CharSequence)exportVo.getReason()) || !StringUtils.isNotBlank((CharSequence)exportVo.getStoreNo()) || !StringUtils.isNotBlank((CharSequence)exportVo.getSalesmanCode()) || !StringUtils.isNotBlank((CharSequence)exportVo.getOperateType()) || !exportVo.getOperateType().equals(CustomerCheckRelationExportOperateTypeEnum.ADD_OR_UPDATE.getName())) continue;
                List<CustomerStoreResponseDto> customerStoreInfoList = customerMap.get(exportVo.getStoreNo());
                if (CollectionUtils.isEmpty(customerStoreInfoList)) {
                    exportVo.setReason("\u65e0\u5f53\u524d\u95e8\u5e97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                    errorList.add(exportVo);
                    continue;
                }
                List<TbPersonPartnerRelRespDto> personPartnerInfoList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                if (CollectionUtils.isEmpty(personPartnerInfoList)) {
                    exportVo.setReason("\u672a\u7ef4\u62a4\u8be5\u4e1a\u52a1\u5458\u4eba\u5e97\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u505a\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u7ed1\u5b9a ");
                    errorList.add(exportVo);
                    continue;
                }
                CustomerStoreResponseDto customerStoreInfo = customerStoreInfoList.get(0);
                TbPersonPartnerRelRespDto personPartnerInfo = personPartnerInfoList.get(0);
                List<CustomerCheckRelationRespDto> orgStoreSaleRelationList = orgIdStoreIdRelMap.get(orgId + "|" + customerStoreInfo.getStoreId());
                if (CollectionUtils.isNotEmpty(orgStoreSaleRelationList)) {
                    for (CustomerCheckRelationRespDto dto : orgStoreSaleRelationList) {
                        CustomerCheckRelationReqDto notBoundReqDto = new CustomerCheckRelationReqDto();
                        notBoundReqDto.setOrgId(orgId);
                        notBoundReqDto.setStoreId(dto.getStoreId());
                        notBoundReqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                        notBoundReqDto.setSalesmanId(dto.getSalesmanId());
                        notBoundReqDto.setThirdPartyId(customerStoreInfo.getCustomerId());
                        notBoundReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                        log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5bfc\u5165,\u5f53\u524dorgId+\u95e8\u5e97id, \u5b58\u5728\u5219\u8986\u76d6.\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)notBoundReqDto));
                        this.customerCheckRelationApi.bindStoreAndSalesmanRelation(notBoundReqDto);
                        addDtoList.add(this.getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
                    }
                    continue;
                }
                List<TbPersonPartnerRelRespDto> personList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                if (CollectionUtils.isNotEmpty(personList)) {
                    addDtoList.add(this.getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
                    continue;
                }
                exportVo.setReason("\u4eba\u5458\u4fe1\u606f\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4;");
                errorList.add(exportVo);
            }
        }
        return addDtoList;
    }

    private Map<String, List<TbPersonPartnerRelRespDto>> queryPersonPartnerMap(CustomerRespDto customerRespDto, List<CustomerCheckRelationExportVo> exportVoList, List<CustomerCheckRelationExportVo> errorList) {
        List salesmanCodeList = exportVoList.stream().map(CustomerCheckRelationExportVo::getSalesmanCode).collect(Collectors.toList());
        TbPersonPartnerRelReqDto personPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        personPartnerRelReqDto.setEmpNos(salesmanCodeList);
        personPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
        List personPartnerList = (List)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPost(personPartnerRelReqDto));
        if (CollectionUtils.isNotEmpty((Collection)personPartnerList)) {
            return personPartnerList.stream().collect(Collectors.groupingBy(p -> p.getEmpNo() + "-" + p.getCustomerId()));
        }
        for (CustomerCheckRelationExportVo exportVo : exportVoList) {
            exportVo.setReason("\u672a\u7ef4\u62a4\u8be5\u4e1a\u52a1\u5458\u4eba\u5e97\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u505a\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u7ed1\u5b9a");
            errorList.add(exportVo);
        }
        return new HashMap<String, List<TbPersonPartnerRelRespDto>>(16);
    }

    private List<CustomerStoreResponseDto> queryCustomerStoreList(Long orgId, List<CustomerCheckRelationExportVo> exportVoList, CustomerRespDto customerRespDto) {
        List storeNoList = exportVoList.stream().map(CustomerCheckRelationExportVo::getStoreNo).collect(Collectors.toList());
        CustomerStoreReqDto customerStoreReqDto = new CustomerStoreReqDto();
        customerStoreReqDto.setStoreNos(storeNoList);
        customerStoreReqDto.setOrgId(orgId);
        customerStoreReqDto.setMerchantId(customerRespDto.getMerchantId());
        return (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerStoreByPost(customerStoreReqDto));
    }

    private List<CustomerCheckRelationExportVo> checkBeforeImportList(CustomerRespDto customerRespDto, List<CustomerCheckRelationExportVo> importList, List<CustomerCheckRelationExportVo> errorList) {
        CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
        customerCheckPatternReqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List customerCheckPatternEos = (List)RestResponseHelper.extractData((RestResponse)this.customerCheckPatternQueryApi.selectCustomerCheckPatternByCode(customerCheckPatternReqDto));
        Assert.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckPatternEos) ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u672a\u6307\u5b9a\u8003\u6838\u65b9\u5f0f\uff01");
        importList.forEach(vo -> Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getOperateType()), (String)"0001", (String)"\u64cd\u4f5c\u65b9\u5f0f\u5fc5\u586b\uff01"));
        for (CustomerCheckRelationExportVo vo2 : importList) {
            if (StringUtils.isNotBlank((CharSequence)vo2.getStoreNo())) {
                vo2.setStoreNo(vo2.getStoreNo().trim());
            } else {
                vo2.setReason("\u8bf7\u586b\u5199\u95e8\u5e97\u7f16\u7801");
                errorList.add(vo2);
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getSalesmanCode())) {
                vo2.setSalesmanCode(vo2.getSalesmanCode().trim());
            } else {
                vo2.setReason("\u8bf7\u586b\u5199\u4eba\u5458\u7f16\u7801");
                errorList.add(vo2);
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOperateType())) {
                vo2.setOperateType(vo2.getOperateType().trim());
                continue;
            }
            vo2.setReason("\u8bf7\u586b\u64cd\u4f5c\u65b9\u5f0f");
            errorList.add(vo2);
        }
        Map<String, List<CustomerCheckRelationExportVo>> importListMap = importList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getStoreNo()) && StringUtils.isNotBlank((CharSequence)a.getSalesmanCode())).collect(Collectors.groupingBy(CustomerCheckRelationExportVo::getStoreNo));
        if (importListMap.entrySet().size() > 0) {
            importListMap.forEach((key, value) -> {
                if (value.size() > 1) {
                    for (CustomerCheckRelationExportVo exportVo : value) {
                        exportVo.setReason("\u5bfc\u5165\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                        errorList.add(exportVo);
                    }
                }
            });
        }
        return importList;
    }

    private List<CustomerCheckRelationRespDto> getCustomerCheckRelationRespDtoList(Long orgId, List<CustomerStoreResponseDto> customerList) {
        if (CollectionUtils.isNotEmpty(customerList)) {
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            List storeIds = customerList.stream().map(CustomerStoreResponseDto::getStoreId).collect(Collectors.toList());
            customerCheckRelationReqDto.setStoreIds(storeIds);
            customerCheckRelationReqDto.setOrgId(orgId);
            customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
            return (List)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByStoreIds(customerCheckRelationReqDto));
        }
        return Lists.newArrayList();
    }

    private CustomerCheckRelationReqDto getCustomerCheckRelationReqDto(Long orgId, CustomerStoreResponseDto customerStoreInfo, TbPersonPartnerRelRespDto personPartnerInfo) {
        CustomerCheckRelationReqDto addDto = new CustomerCheckRelationReqDto();
        addDto.setStoreId(customerStoreInfo.getStoreId());
        addDto.setStoreNo(customerStoreInfo.getStoreNo());
        addDto.setSalesmanId(personPartnerInfo.getRowId());
        addDto.setSalesmanName(personPartnerInfo.getFullName());
        addDto.setSalesmanCode(personPartnerInfo.getEmpNo());
        addDto.setSalesmanType(personPartnerInfo.getRoleTypeName());
        addDto.setSalesmanPhone(personPartnerInfo.getPhoneNumber());
        addDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        addDto.setOrgId(orgId);
        addDto.setThirdPartyId(personPartnerInfo.getCustomerId());
        return addDto;
    }

    @Override
    public PageInfo<CustomerCheckRelationRespDto> queryStoreAndSalesmanRelationBindHistoryPage(String filter, Integer pageNum, Integer pageSize) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(orgId));
        Assert.isTrue((boolean)org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customerRespDto), (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        CustomerCheckRelationReqDto reqDto = (CustomerCheckRelationReqDto)JSON.parseObject((String)filter, CustomerCheckRelationReqDto.class);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getStoreId()), (String)"0001", (String)"\u5f53\u524d\u95e8\u5e97ID\u4e3a\u7a7a\uff01");
        BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode((String)String.valueOf(orgId));
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)bizChannelEnum)) {
            Assert.isTrue((boolean)org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)reqDto.getOrgId()), (String)"0001", (String)"\u5f53\u524d\u7ecf\u9500\u5546ID\u4e3a\u7a7a\uff01");
            reqDto.setOrgId(reqDto.getOrgId());
        } else {
            reqDto.setOrgId(orgId);
        }
        reqDto.setStoreId(reqDto.getStoreId());
        reqDto.setStatusList((List)Lists.newArrayList((Object[])new Integer[]{CustomerCheckStatusEnum.NOT_BOUND.getStatus(), CustomerCheckStatusEnum.DISABLE.getStatus()}));
        log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u5386\u53f2\u7ed1\u5b9a\u5217\u8868\u67e5\u8be2 req params : {} .", (Object)JSON.toJSONString((Object)reqDto));
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), pageNum, pageSize));
    }

    @Override
    public void saveOrUpdateCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto) {
        this.customerCheckPatternConfigApi.saveOrUpdateCustomerCheckPatternConfig(addReqDto);
    }

    @Override
    public PageInfo<CustomerCheckPatternConfigRespDto> queryPatternConfigByPage(String filter, Integer pageNum, Integer pageSize) {
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerCheckPatternConfigQueryApi.queryByPage(filter, pageNum, pageSize));
    }

    @Override
    public BizImportRespDto exportPatternConfig(String customerCode, MultipartFile file) throws Exception {
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), PatternConfigExportVo.class, (ImportParams)importParams);
        List importList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
        Map<String, List<PatternConfigExportVo>> patternConfigRecord = importList.stream().collect(Collectors.groupingBy(PatternConfigExportVo::getConfigType));
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByCode(customerCode));
        this.logger.info("\u5bfc\u5165\u660e\u7ec6 data : {} .", (Object)JSON.toJSONString(patternConfigRecord));
        this.verifyPatternConfig(patternConfigRecord, customerRespDto);
        List collect = patternConfigRecord.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List errorList = collect.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getReason())).collect(Collectors.toList());
        List successList = collect.stream().filter(c -> !StringUtils.isNotBlank((CharSequence)c.getReason())).collect(Collectors.toList());
        this.logger.info("\u3010\u5bfc\u5165 -> \u8003\u6838\u767d\u540d\u5355\u914d\u7f6e\u6570\u636e\u3011 \u603b\u6761\u6570\uff1a{}\uff0c\u5bfc\u5165\u5931\u8d25{}\u6761\uff0c\u5bfc\u5165\u6210\u529f{}\u6761", new Object[]{importList.size(), errorList.size(), importList.size() - errorList.size()});
        Integer importFailTotal = errorList.size();
        Integer importSuccessTotal = importList.size() - errorList.size();
        Integer total = importList.size();
        String url = "";
        this.logger.info("\u6821\u9a8c\u5f02\u5e38\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(errorList));
        if (!org.springframework.util.CollectionUtils.isEmpty(errorList)) {
            String excelName = "cube/\u8003\u6838\u767d\u540d\u5355\u914d\u7f6e\u6570\u636e\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            url = EasyPoiExportUtil.getExportUrl(errorList, PatternConfigExportVo.class, (String)null, (String)excelName, (String)"xls");
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(successList)) {
            Map<String, List<PatternConfigExportVo>> patternConfigRecords = successList.stream().collect(Collectors.groupingBy(PatternConfigExportVo::getConfigType));
            patternConfigRecords.forEach((k, v) -> {
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)v)) {
                    CustomerCheckPatternConfigReqDto addReqDto = new CustomerCheckPatternConfigReqDto();
                    addReqDto.setConfigType(k);
                    addReqDto.setOrganizationId(customerRespDto.getOrgInfoId());
                    if (GovernTypeEnum.AREA.getCode().equals(k)) {
                        addReqDto.setConfigContentLists(v.stream().map(c -> c.getConfigCode()).collect(Collectors.toList()));
                    } else {
                        List creditCodes = v.stream().map(c -> c.getConfigCode()).collect(Collectors.toList());
                        List storeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.querySocialCreditNums(creditCodes));
                        List storeIds = storeRespDtos.stream().map(c -> c.getStoreId()).collect(Collectors.toList());
                        addReqDto.setConfigContentLists(storeIds);
                    }
                    this.customerCheckPatternConfigApi.saveOrUpdateCustomerCheckPatternConfig(addReqDto);
                }
            });
        }
        return new BizImportRespDto(total, importSuccessTotal, importFailTotal, url);
    }

    private void verifyPatternConfig(Map<String, List<PatternConfigExportVo>> collect, CustomerRespDto customerExtRespDto) {
        collect.forEach((k, v) -> {
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)v)) {
                return;
            }
            if (k.equals(StoreGovernTypeEnum.AREA.getCode())) {
                List storeAreaRespDto = (List)RestResponseHelper.extractData((RestResponse)this.storeSellerGovernContentQueryApi.querySellerGovernAreaByOrgId(customerExtRespDto.getOrgInfoId()));
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)storeAreaRespDto)) {
                    v.stream().forEach(c -> c.setReason("\u5f53\u524d\u533a\u57df\u4e0d\u5b58\u5728\u7ecf\u9500\u5546\u7ba1\u8f96\u8303\u56f4\u5185"));
                    return;
                }
                List areaTree = (List)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryTree());
                v.stream().forEach(dto -> {
                    ArrayList configCodes = Lists.newArrayList();
                    this.getStoreParentAreaRespDto(dto.getConfigCode(), configCodes);
                    this.getStoreAreaRespDto(dto.getConfigCode(), configCodes, areaTree);
                    long count = storeAreaRespDto.stream().map(c -> configCodes.contains(c.getCode())).count();
                    if (count == 0L) {
                        dto.setReason("\u5f53\u524d\u533a\u57df\u4e0d\u5b58\u5728\u7ecf\u9500\u5546\u7ba1\u8f96\u8303\u56f4\u5185");
                    }
                });
            } else {
                StoreQueryGovernReqDto storeQueryGovernReqDto = new StoreQueryGovernReqDto();
                storeQueryGovernReqDto.setOrgId(customerExtRespDto.getOrgInfoId());
                storeQueryGovernReqDto.setDataType(k);
                PageInfo storeRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.storeSellerGovernContentQueryApi.querySellerGovern(JSON.toJSONString((Object)storeQueryGovernReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
                ArrayList socialCreditNums = org.springframework.util.CollectionUtils.isEmpty((Collection)storeRespDtoPageInfo.getList()) ? Lists.newArrayList() : storeRespDtoPageInfo.getList().stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
                v.stream().filter(c -> !socialCreditNums.contains(c.getConfigCode())).forEach(dto -> dto.setReason("\u95e8\u5e97\u4e0d\u5b58\u5728\u5f53\u524d\u7ecf\u9500\u5546\u7ba1\u8f96\u8303\u56f4"));
            }
        });
    }

    @Nullable
    private List<String> getStoreParentAreaRespDto(String configCode, List<String> configCodes) {
        StoreAreaRespDto areaRespDto = (StoreAreaRespDto)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryByCode(configCode));
        if (ObjectUtils.isEmpty((Object)areaRespDto) || BeanPropertyNullUtil.isAllFieldNull(areaRespDto)) {
            return Lists.newArrayList();
        }
        if (!ObjectUtils.isEmpty((Object)areaRespDto) && !"0".equals(areaRespDto.getParentCode())) {
            this.getStoreParentAreaRespDto(areaRespDto.getParentCode(), configCodes);
        }
        configCodes.add(areaRespDto.getCode());
        return configCodes;
    }

    @Nullable
    private List<String> getStoreAreaRespDto(String configCode, List<String> configCodes, List<StoreAreaRespDto> areaTree) {
        StoreAreaRespDto areaRespDto = (StoreAreaRespDto)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryByCode(configCode));
        if (ObjectUtils.isEmpty((Object)areaRespDto) || BeanPropertyNullUtil.isAllFieldNull(areaRespDto)) {
            return Lists.newArrayList();
        }
        List<String> collect = areaTree.stream().filter(c -> c.getParentCode().equals(areaRespDto.getCode())).map(c -> c.getCode()).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(collect)) {
            collect.forEach(c -> this.getStoreAreaRespDto((String)c, collect, areaTree));
        }
        configCodes.addAll(collect);
        return configCodes;
    }
}

