package com.dtyunxi.yundt.module.customer.biz.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICustomerInfoApi;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.QueryCustomerOrgInfoReqDto;
import com.dtyunxi.tcbj.api.dto.response.QueryCustomerOrgInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.QueryCustomerVerifyTaskRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityApi;
import com.dtyunxi.yundt.cube.center.customer.api.IImportRecordApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.*;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ImportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryProvinceReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryTobApi;
import com.dtyunxi.yundt.cube.center.user.api.*;
import com.dtyunxi.yundt.cube.center.user.api.dto.*;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.*;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.ICustomerV4Service;
import com.dtyunxi.yundt.module.customer.api.dto.request.CheckCreditByCustomerCodeReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.VerifyCustomerByExcelReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.VerifyCustomerByOrgIdReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.CompanyVerifyEnum;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.biz.mq.producer.CustomerChangeProducer;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.ICustomerSyncCreditApi;
import com.yx.tcbj.center.customer.api.dto.request.ComputeCustomerNameRateReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service("customerV4Service")
@Slf4j
public class CustomerServiceV4Impl implements ICustomerV4Service {

    private static Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;
    @Resource
    private ICustomerApi customerApi;
    @Autowired
    private IUserApi userApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private ICustomerUserQueryApi customerUserQueryApi;
    @Resource
    private ICustomerUserApi customerUserApi;
    @Resource
    private ICustomerOrgInfoQueryApi customerOrgInfoQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private OssRegistryVo ossRegistryVo;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderQueryTobApi orderQueryTobApi;
    @Resource
    private CustomerChangeProducer customerChangeProducer;
    @Resource
    private ICreditEntityApi iCreditEntityApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerInfoApi customerInfoApi;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    @Resource
    private com.yx.tcbj.center.customer.api.query.ICustomerQueryApi customerQueryApi2;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private IOrganizationThreeApi organizationThreeApi;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private IImportRecordApi importRecordApi;
    @Resource
    private ExportService exportService;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;
    @Resource
    private ICustomerSyncCreditApi customerSyncCreditApi;

    @Override
    public PageInfo<CustomerListRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerSearchExtThreeReqDto searchReqDto = new CustomerSearchExtThreeReqDto();
        logger.info("queryByPage params:{}",filter);
        if (StringUtils.isNotBlank(filter)) {
            searchReqDto = JSONObject.parseObject(filter, CustomerSearchExtThreeReqDto.class);
        }
//        searchReqDto.setInstanceId(context.instanceId());
        searchReqDto.setTenantId(context.tenantId());
        this.settingUserIdsForSearch(searchReqDto);
        if (Objects.nonNull(searchReqDto.getUserFlag()) && !searchReqDto.getUserFlag()) {
            return new PageInfo<>();
        }
        //默认查询审核通过的客户
        searchReqDto.setListFlag(true);
        //判断是否是来源于业务员小程序端，是的话需要设置业务员id
        if (SrcTypeEnum.SALESMAN.getCode().equals(searchReqDto.getSrcType())){
            searchReqDto.setSalesmanUserId(context.userId());
            //如果是业务员小程序端，分页时需要特殊处理
            // 1.客户搜索支持：客户名称和联系人模糊搜索
            //2.客户列表排序规则：a、按客户最后下单时间倒序排列；b、下单时间 相同时，按客户新增时间倒序排列
            RestResponse<PageInfo<CustomerRespDto>> pageInfoRestResponse = customerQueryApi.queryByPage(JSON.toJSONString(searchReqDto), pageNum, pageSize);
            PageInfo<CustomerRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
            //如果是业务员端，需要根据客户名称模糊搜索，有结果就直接返回，没结果则需要根据联系人模糊搜索
            //todo 新版业务员端只需根据客户名称/编号模糊搜索，不再根据联系人模糊搜索，所以注释掉以下代码
//            List<Long> customerIds = this.getCustomerIdsBySalesmanId(context.userId());
//            if (StringUtils.isNotEmpty(searchReqDto.getKeyword()) && pageInfo.getTotal() == 0){
//                List<Long> newCustomerIds = Lists.newArrayList();
//                if (CollectionUtils.isNotEmpty(customerIds)){
//                    RestResponse<List<ContactsInfoDto>> listRestResponse = customerUserQueryApi.queryContactsInfoListByOrgInfoIdList(customerIds);
//                    List<ContactsInfoDto> contactsInfoDtos = RestResponseHelper.extractData(listRestResponse);
//                    for (ContactsInfoDto contactsInfoDto : contactsInfoDtos) {
//                        String linkName = contactsInfoDto.getLinkName();
//                        if (StringUtils.isNotEmpty(linkName) && linkName.contains(searchReqDto.getKeyword())){
//                            newCustomerIds.add(contactsInfoDto.getOrgInfoId());
//                        }
//                    }
//                }
//                if (CollectionUtils.isNotEmpty(newCustomerIds)){
//                    CustomerSearchReqDto reqDto = new CustomerSearchReqDto();
//                    reqDto.setSalesmanId(context.userId());
//                    reqDto.setTenantId(context.tenantId());
//                    reqDto.setIdList(newCustomerIds);
//                    RestResponse<PageInfo<CustomerRespDto>> newPageInfoRestResp = customerQueryApi.queryByPage(JSON.toJSONString(reqDto), 1, Integer.MAX_VALUE);
//                    pageInfo = RestResponseHelper.extractData(newPageInfoRestResp);
//                }
//
//            }
            //查询客户最后下单时间
//            Map<String, Date> timeMap = new HashMap<>();
            //查询客户订单量
            //todo 有性能问题，暂时去掉
//            Map<String, Integer> numMap = new HashMap<>();
//            if (CollectionUtils.isNotEmpty(pageInfo.getList())){
//                OrderStatisticsReqDto orderStatisticsReqDto = new OrderStatisticsReqDto();
//                orderStatisticsReqDto.setCustomerIds(pageInfo.getList().stream().map(e -> String.valueOf(e.getId())).collect(Collectors.toList()));
//                orderStatisticsReqDto.setSalesmanId(context.userId().toString());
//                orderStatisticsReqDto.setInstanceId(context.instanceId());
//                orderStatisticsReqDto.setTenantId(context.tenantId());
//                orderStatisticsReqDto.setType("1");
//                orderStatisticsReqDto.setPageNum(1);
//                orderStatisticsReqDto.setPageSize(Integer.MAX_VALUE);
//                orderStatisticsReqDto.setSortFiled("1");
//                //设置开始时间和结束时间
//                Calendar c = Calendar.getInstance();//获得一个日历的实例
//                c.setTime(new Date());
//                c.add(Calendar.MONTH,-6);
//                orderStatisticsReqDto.setStartTime(c.getTime());
//                orderStatisticsReqDto.setEndTime(new Date());
//                //根据客户ids统计订单信息以获取最后下单时间
//                //todo 根据客户ids统计订单信息以获取每个客户的订单数
//                RestResponse<PageInfo<OrderStatisticsRespDto>> orderPageInfoRestResp = orderQueryTobApi.statisticsOrder(orderStatisticsReqDto);
//                PageInfo<OrderStatisticsRespDto> orderPageInfo = RestResponseHelper.extractData(orderPageInfoRestResp);
//                if (Objects.nonNull(orderPageInfo) && CollectionUtils.isNotEmpty(orderPageInfo.getList())){
////                    timeMap = orderPageInfo.getList().stream()
////                            .collect(Collectors.toMap(OrderStatisticsRespDto::getCustomerId, OrderStatisticsRespDto::getLastOrderTime, (e1, e2) -> e1));
//                    numMap = orderPageInfo.getList().stream()
//                            .collect(Collectors.toMap(OrderStatisticsRespDto::getCustomerId, OrderStatisticsRespDto::getNum, (e1, e2) -> e1));
//                }
//            }

            List<CustomerListRespDto> listRespDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(pageInfo.getList())) {
                // 获取所属商家
                List<Long> customerIds = customerExtQueryApi.queryCustomerIdByOrgId(pageInfo.getList().stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList())).getData();
                List<CustomerRespDto> customerList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty(customerIds)) {
                    customerList = customerExtQueryApi.queryListByCustomerIds(customerIds).getData();
                }
                logger.info("获取所属商家 customerIds = {}, customerList = {}", JSONObject.toJSONString(customerIds), JSONObject.toJSONString(customerList));

                //获取所有orgId
                List<Long> orgInfoIds = pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
                List<OrgAndOrgInfoRespDto> orgAndOrgInfoByIds = RestResponseHelper.extractData(organizationQueryApi.queryOrgAndOrgInfoByIds(orgInfoIds));
                logger.info("获取所属orgInfo orgInfoIds = {}, orgAndOrgInfoList = {}", JSONObject.toJSONString(orgInfoIds), JSONObject.toJSONString(orgAndOrgInfoByIds));
//增加一行备注打包用，忽略
                CustomerListRespDto listRespDto;
                for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                    listRespDto = new CustomerListRespDto();
                    CubeBeanUtils.copyProperties(listRespDto, customerRespDto);
                    if (CollectionUtils.isNotEmpty(customerList)) {
                        for (CustomerRespDto customer : customerList) {
                            if (Objects.equals(customerRespDto.getMerchantId(), customer.getOrgInfoId())) {
                                //拷贝属性到CustomerListRespDto
                                listRespDto.setMerchantName(customer.getName());
                                break;
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty(orgAndOrgInfoByIds)){
                        for (OrgAndOrgInfoRespDto orgAndOrgInfoRespDto : orgAndOrgInfoByIds) {
                            if (Objects.equals(customerRespDto.getOrgInfoId(), orgAndOrgInfoRespDto.getOrganizationDto().getId())) {
                                //拷贝属性到CustomerListRespDto
                                listRespDto.setOrgName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
                                break;
                            }
                        }
                    }
                    listRespDtoList.add(listRespDto);
                }

//                //上游卖家组织id_name关系map
//                Map<Long, String> marchantOrgMap = RestResponseHelper.extractData(bizOrganizationQueryApi.getOrganizationsByIds(pageInfo.getList().stream()
//                        .map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList())))
//                        .stream().collect(Collectors.toMap(OrganizationDto::getId, OrganizationDto::getName));
//                CustomerListRespDto listRespDto;
//                for (CustomerRespDto customerRespDto : pageInfo.getList()) {
//                    listRespDto = new CustomerListRespDto();
//                    //拷贝属性到CustomerListRespDto
//                    CubeBeanUtils.copyProperties(listRespDto, customerRespDto);
//                    listRespDto.setMerchantName(marchantOrgMap.get(listRespDto.getMerchantId()));
//                    //设置最后下单时间
////                    Date lastOrderTime = timeMap.get(customerRespDto.getId().toString());
////                    if (Objects.nonNull(lastOrderTime)){
////                        listRespDto.setLastOrderTime(lastOrderTime);
////                    }
//                    //设置每个客户的订单数
////                    Integer num = numMap.get(customerRespDto.getId().toString());
////                    listRespDto.setNum(num);
//                    listRespDtoList.add(listRespDto);
//                }
            }

            logger.info("业务员端listRespDtoList>>>>{}",JSON.toJSONString(listRespDtoList));

            PageInfo<CustomerListRespDto> listRespDtoPageInfo = new PageInfo<>();
            CubeBeanUtils.copyProperties(listRespDtoPageInfo, pageInfo, "list", "navigatepageNums");
            listRespDtoPageInfo.setList(listRespDtoList);
            return listRespDtoPageInfo;

            //客户列表排序规则：a、按客户最后下单时间倒序排列；b、下单时间相同时，按客户新增时间倒序排列
//            List<CustomerListRespDto> newListRespDtoList = listRespDtoList.stream().
//                    sorted(Comparator.comparing(CustomerListRespDto::getLastOrderTime,Comparator.nullsFirst(Date::compareTo)).
//                            thenComparing(CustomerListRespDto::getCreateTime).reversed()).
//                    collect(Collectors.toList());
            //todo 客户列表排序规则改为：a、按客户订单量倒序排列；b、订单量相同时，按客户新增时间倒序排列
            //todo 有性能问题，暂时去掉
//            List<CustomerListRespDto> newListRespDtoList = listRespDtoList.stream().
//                    sorted(Comparator.comparing(CustomerListRespDto::getNum,Comparator.nullsFirst(Integer::compareTo)).
//                            thenComparing(CustomerListRespDto::getCreateTime).reversed()).
//                    collect(Collectors.toList());
//
//            //分页返回
//            int startPage = (pageNum - 1) * pageSize + 1;
//            List<CustomerListRespDto> respDtoList = new ArrayList<>(pageSize);
//            for (int i = startPage; i <= pageNum * pageSize; i++) {
//                if (newListRespDtoList.size() >= i && (i - 1) >= 0) {
//                    respDtoList.add(newListRespDtoList.get(i - 1));
//                }
//            }
//            PageInfo<CustomerListRespDto> listPageInfo = new PageInfo();
//            listPageInfo.setList(respDtoList);
//            listPageInfo.setTotal(newListRespDtoList.size());
//            listPageInfo.setPageSize(pageSize);
//            listPageInfo.setPageNum(pageNum);
//            return listPageInfo;

        }


        if("Y".equalsIgnoreCase(searchReqDto.getIsHaveCreditAccount())){
            //查询已加入信用的账号
            RestResponse<List<Long>> enableCustomerIds = iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdList(enableCustomerIds.getData());
        }

        // 修改BUG#fmcg-2165-ideb-2267:过滤已授信准入的客户，不会显示在选择列表里
        if (Objects.equals(searchReqDto.getIsFilterCreditEntity(), "Y")){
            RestResponse<List<Long>> enableCustomerIds = iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdNotInList(enableCustomerIds.getData());
            logger.info("[客商客户] >>> 过滤掉已信用准入的客户id:{}", searchReqDto.getIdNotInList());
        }

        searchReqDto.setIsFilterDownstreamCustomersByCurrentUser(true);

        // 传入 {"channel": 1, "type": 3} 则可查询到品牌方下面经销商的小b。
        if(searchReqDto.getType() == null){
            searchReqDto.setType(CustomerTypeEnum.DEALER.getCode());
        }
        if(searchReqDto.getChannel() == null){
            searchReqDto.setChannel(CustomerTypeEnum.DEALER.getCode());
        }
        if(searchReqDto.getOrganizationId() != null){
            searchReqDto.setMerchantIds(Arrays.asList(searchReqDto.getOrganizationId()));

        }
        RestResponse<PageInfo<CustomerExtRespDto>> pageInfoRestResponse = customerExtThreeQueryApi.queryByPage(JSON.toJSONString(searchReqDto), pageNum, pageSize);

        PageInfo<CustomerExtRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);


        PageInfo<CustomerListRespDto> listRespDtoPageInfo = new PageInfo<>();
        CubeBeanUtils.copyProperties(listRespDtoPageInfo, pageInfo, "list", "navigatepageNums");
        List<CustomerListRespDto> listRespDtoList = Lists.newArrayList();
        //根据区域id和userId查询用户中心返回登录账号和所属区域
        if (CollectionUtils.isNotEmpty(pageInfo.getList())) {
            //获取userId集合和regionCode集合
//            Set<Long> userIdList = Sets.newHashSet();
//            Set<String> regionCodeList = Sets.newHashSet();

            CustomerListRespDto listRespDto;
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                listRespDto = new CustomerListRespDto();
                //拷贝属性到CustomerListRespDto
                CubeBeanUtils.copyProperties(listRespDto, customerRespDto);
                listRespDtoList.add(listRespDto);
//                if (Objects.nonNull(customerRespDto.getUserId())) {
//                    userIdList.add(customerRespDto.getUserId());
//                }
            }
            //查询登录账号信息
//            Map<Long, String> userNameMap = new HashMap<>();
//            if (CollectionUtils.isNotEmpty(userIdList)) {
//                RestResponse<List<UserDto>> salesmanRestResp = userQueryApi.queryByIdList(StringUtils.join(userIdList, ","), "{}");
//                List<UserDto> userList = RestResponseHelper.extractData(salesmanRestResp);
//                userNameMap = userList.stream().collect(Collectors.toMap(UserDto::getId, UserDto::getUserName));
//            }
//
//            for (CustomerListRespDto respDto : listRespDtoList) {
//                //设置登录账号名称
//                if (Objects.nonNull(respDto.getUserId())) {
//                    respDto.setUserName(userNameMap.get(respDto.getUserId()));
//                }
//            }


        }
//        CubeBeanUtils.copyCollection(listRespDtoList,pageInfo.getList(),CustomerListRespDto.class);
        listRespDtoPageInfo.setList(listRespDtoList);
        return listRespDtoPageInfo;
    }

    private void settingUserIdsForSearch(CustomerSearchReqDto searchReqDto) {
        if (StringUtils.isNotEmpty(searchReqDto.getUserName())) {
            //请求用户中心根据userName模糊搜索
            List<SqlFilter> userFilters = Lists.newArrayList();
            userFilters.add(SqlFilter.like("userName", "%" + searchReqDto.getUserName() + "%"));
            Map<String, Object> filterMap = Maps.newHashMap();
            filterMap.put("filters", userFilters);
            filterMap.put("tenantId", searchReqDto.getTenantId());
            filterMap.put("instanceId", searchReqDto.getInstanceId());
            String queryFilter = JSONObject.toJSONString(filterMap);
            RestResponse<PageInfo<UserDto>> pageInfoRestResponse = userQueryApi.queryByPage(queryFilter, 1, Integer.MAX_VALUE);
            PageInfo<UserDto> userDtoPageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
            List<Long> userIdList = Lists.newArrayList();
            if (Objects.nonNull(userDtoPageInfo) && CollectionUtils.isNotEmpty(userDtoPageInfo.getList())) {
                for (UserDto userDto : userDtoPageInfo.getList()) {
                    userIdList.add(userDto.getId());
                }
            }
            if (CollectionUtils.isEmpty(userIdList)) {
                searchReqDto.setUserFlag(false);
            }
            searchReqDto.setUserIds(userIdList);
        }
    }

    /***************************************************************************************/

    @Override
    public StoreSellerGovernExcelRespDto verifyCustomerByExcel(MultipartFile file) {
        //插入一条任务记录
        Long recordId = exportService.init(file.getOriginalFilename(), ExportTypeEnum.VERIFY_CUSTOMER_BATCH);

        //异步调用
        applicationContext.getBean(ICustomerV4Service.class).verifyCustomerByExcelAsyn(file, recordId);
        return null;
    }

    @Async
    @Override
    public StoreSellerGovernExcelRespDto verifyCustomerByExcelAsyn(MultipartFile file, Long recordId) {
        boolean isSuccess = false;
        StoreSellerGovernExcelRespDto result = new StoreSellerGovernExcelRespDto();
        try {
            //处理excel
            result = verifyCustomerByExcelAsyn0(file);
            isSuccess = true;
        }catch (Exception e){
            logger.error("批量三要素认证失败 任务id:" + recordId);
            e.printStackTrace();
            //修改任务记录状态为异常
            exportService.fail(recordId,
                    String.format("文件名：%s , 任务id：%s , 认证失败原因：%s",
                            file.getOriginalFilename(), recordId, e)
            );

        }
        if(isSuccess){
            //修改任务记录状态为已完成
            exportService.success(recordId, result.getErrorFile(),
                    String.format("总认证：%s条，成功：%s条，失败：%s条",
                            result.getNum(), result.getSuccessNum(), result.getFailNum())
            );
        }
        return null;
    }

    public StoreSellerGovernExcelRespDto verifyCustomerByExcelAsyn0(MultipartFile file) {
        StoreSellerGovernExcelRespDto respDto = new StoreSellerGovernExcelRespDto();
        respDto.setNum(0);
        respDto.setSuccessNum(0);
        respDto.setFailNum(0);

        // 解析excel
        ImportParams importParams = new ImportParams();
        importParams.setTitleRows(0);//表格标题行数,默认0
        importParams.setHeadRows(1);//表头行数,默认1

        List<VerifyCustomerByExcelReqDto> excelDtos = null;
        try {
            ExcelImportResult<VerifyCustomerByExcelReqDto> result = ExcelImportUtil.importExcelMore(
                    file.getInputStream(), VerifyCustomerByExcelReqDto.class, importParams);
            excelDtos = result.getList();
        } catch (Exception e) {
            throw new BizException("解析excel异常" + e);
        }
        if(excelDtos == null){
            throw new BizException("解析excel失败 解析结果为空");
        }
        if(excelDtos.size() > 1000){
            throw new BizException("解析excel失败 数据不能超过1000条");
        }

        // 三要素认证
        // - 拼参数
        List<VerifyCustomerByOrgIdReqDto> verifyDtos = excelDtos.stream()
                .map(e -> {
                    e.setVerifyDto(VerifyCustomerByOrgIdReqDto.builder()
                            .code(e.getCode())
                            .orgName(e.getOrgName())
                            .creditCode(e.getCreditCode())
                            .legalName(e.getLegalName())
                            .province(e.getProvince())
                            .city(e.getCity())
                            .district(e.getDistrict())
                            .build());
                    return e.getVerifyDto();
                }).collect(Collectors.toList());
        // - 认证三要素
        verifyCustomerByCustomerCode(verifyDtos);
        // - 回写认证结果
        excelDtos.forEach(e -> {
            e.setVerify(e.getVerifyDto().isSuccess());
            e.setVerifyResult(e.getVerifyDto().getMsg());
        });

        // excelDtos处理结果，回写excel结果文件
        int successNum = (int) excelDtos.stream().filter(VerifyCustomerByExcelReqDto::isVerify).count();

        if (CollectionUtils.isNotEmpty(excelDtos)) {
            try {
                String fileName = "客户批量三要素认证";
                if(StringUtils.isNotEmpty(file.getOriginalFilename())){
                    fileName = file.getOriginalFilename().substring(0,file.getOriginalFilename().lastIndexOf("."));
                }

                List<VerifyCustomerByExcelReqDto> excelTempDtos = new ArrayList<>(excelDtos);//浅拷贝一个list做excel导出参数，excel生成后，该数组会被清空...。
                String exportUrl = EasyPoiExportUtil.getExportUrl(//excel上传路径，自带cube/
                        excelTempDtos, VerifyCustomerByExcelReqDto.class, null,
                        "cube/" + fileName + "-认证结果-" + DateUtil.getDateFormat(new Date(), DateUtil.YMDSTRING_DATA),
                        "xls"
                );
                respDto.setErrorFile(exportUrl);
                respDto.setFailNum(excelDtos.size() - successNum);
            } catch (Exception e) {
                throw new BizException("处理明细excel生成失败：" + e);
            }
        }

        respDto.setNum(excelDtos.size());
        respDto.setSuccessNum(successNum);
        return respDto;
    }

    private void verifyCustomerByCustomerCode(List<VerifyCustomerByOrgIdReqDto> dtos) {
        for (VerifyCustomerByOrgIdReqDto dto : dtos) {
//            if (dto.getCode() == null && dto.getThirdPartyId() == null && dto.getThirdParentPartyId() == null) {
//                dto.setMsg("[客户编号],[第三方客户ID],[第三方客户父级ID]3个参数不能都为空");
//                continue;
//            }
//            if (dto.getCode() == null && dto.getThirdParentPartyId() == null) {
//                dto.setMsg("不能只有 第三方客户父级ID");
//                continue;
//            }
            if (StringUtils.isEmpty(dto.getCode())) {
                dto.setMsg("数据异常：[客户编号]字段缺失，无法认证");
                continue;
            }
            if (StringUtils.isEmpty(dto.getOrgName())) {
                dto.setMsg("数据异常：客户三要素上传不全，[公司名称]字段缺失，无法认证");
                continue;
            }
            if (StringUtils.isEmpty(dto.getCreditCode())) {
                dto.setMsg("数据异常：客户三要素上传不全，[统一社会信用代码]字段缺失，无法认证");
                continue;
            }
            if (StringUtils.isEmpty(dto.getLegalName())) {
                dto.setMsg("数据异常：客户三要素上传不全，[法定代表人]字段缺失，无法认证");
                continue;
            }
            if (StringUtils.isEmpty(dto.getLegalName())) {
                dto.setMsg("数据异常：客户三要素上传不全，[公司所属省份]字段缺失，无法认证");
                continue;
            }
            if (StringUtils.isEmpty(dto.getLegalName())) {
                dto.setMsg("数据异常：客户三要素上传不全，[公司所属城市]字段缺失，无法认证");
                continue;
            }
            if (StringUtils.isEmpty(dto.getLegalName())) {
                dto.setMsg("数据异常：客户三要素上传不全，[公司所属地区]字段缺失，无法认证");
                continue;
            }
            //trim
            dto.setCode(dto.getCode().trim());
            dto.setCreditCode(dto.getCreditCode().trim());
            dto.setOrgName(dto.getOrgName().trim());
            dto.setLegalName(dto.getLegalName().trim());
            // 查询
            List<QueryCustomerOrgInfoRespDto> customerOrgInfos = RestResponseHelper.extractData(
                    customerInfoApi.queryCustomerOrgInfo(QueryCustomerOrgInfoReqDto.builder()
                    .code(dto.getCode())
//                    .thirdPartyId(dto.getThirdPartyId())
//                    .thirdParentPartyId(dto.getThirdPartyId())
                    .build()));
            if (customerOrgInfos == null || customerOrgInfos.isEmpty()) {
                dto.setMsg("数据异常：[客户编号]查询客户信息为空");
                continue;
            }
            if (customerOrgInfos.size() != 1) {
                dto.setMsg("数据异常：[客户编号]查询客户信息为多条，无法处理["
                        + customerOrgInfos.stream()
                        .map(e -> e.getCusCode() + "-" + e.getOrgName()).collect(Collectors.toList()) + "]");
                continue;
            }

            QueryCustomerOrgInfoRespDto customer = customerOrgInfos.get(0);
            if(customer.getIfCertification().equals("1") && customer.getExistOrgInfo().equals("1")){
                dto.setMsg("无需处理：客户三要素已认证，无需重复认证");
                continue;
            }

            // -- dto省市区code转换
            String provinceCode = getStoreAreaCodeByName(dto.getProvince(), null, String.valueOf(StoreAreaLevelEnum.PROVINCE.getCode()));
            if(provinceCode == null){
                dto.setMsg("数据异常：[公司所属省份]编码无法映射，请检查名称是否正确");
                continue;
            }
            dto.setProvinceCode(provinceCode);

            String cityCode = getStoreAreaCodeByName(dto.getCity(), provinceCode, String.valueOf(StoreAreaLevelEnum.CITY.getCode()));
            if(cityCode == null){
                dto.setMsg("数据异常：[公司所属城市]编码无法映射，请检查名称是否正确");
                continue;
            }
            dto.setCityCode(cityCode);

            String districtCode = getStoreAreaCodeByName(dto.getDistrict(), cityCode, String.valueOf(StoreAreaLevelEnum.DISTRICT.getCode()));
            if(districtCode == null){
                dto.setMsg("数据异常：[公司所属地区]编码无法映射，请检查名称是否正确");
                continue;
            }
            dto.setDistrictCode(districtCode);
            // -- dto省市区code转换 结束

            boolean verifyResult = false;
            try {
                // 三要素校验
                CompanyVerifyReqDto CompanyVerifyReqDto = new CompanyVerifyReqDto();
                CompanyVerifyReqDto.setCode(dto.getCreditCode());
                CompanyVerifyReqDto.setName(dto.getOrgName());
                CompanyVerifyReqDto.setLegalPersonName(dto.getLegalName());
                // -- 额外省市校验
                CompanyVerifyReqDto.setProvinceCode(dto.getProvinceCode());
                CompanyVerifyReqDto.setCityCode(dto.getCityCode());

                CompanyVerifyRespDto companyVerifyRespDto = customerExtService.verifyCompany(CompanyVerifyReqDto);
                if (!Objects.equals(companyVerifyRespDto.getResult(), CompanyVerifyEnum.SUCCESS.getCode())) {
                    dto.setMsg("客户三要素认证失败(药店表)，失败原因：" + companyVerifyRespDto.getRemark());
                    continue;
                }

                // 租户下信用代码唯一、名称匹配校验
                checkCreditByCustomerCode(CheckCreditByCustomerCodeReqDto.builder()
                        .cusCode(dto.getCode())
                        .creditCode(dto.getCreditCode())
                        .orgName(dto.getOrgName())
                        .build());

                verifyResult = true;
            } catch (Exception e) {
                dto.setMsg("客户三要素认证失败(天眼查)，失败原因：" + e);
                //try catch里面不能continue
            }
            if(!verifyResult){
                continue;
            }

            dto.setSuccess(true);
            dto.setMsg("三要素认证成功");

            // 更新认证成功的客户
            // - 更新customer.if_certification
            CustomerReqExtDto updateCusReq = new CustomerReqExtDto();
            updateCusReq.setId(Long.valueOf(customer.getCusId()));
            updateCusReq.setIfCertification(1);//已认证
            customerExtThreeApi.updateCustomerByDto(updateCusReq);

            // - 更新org_info表的三要素及其他信息
            //add or update
            organizationThreeApi.saveOrUpdateOrgInfo(ModifyOrganizationInfoReqDto.builder()
                    .orgId(Long.valueOf(customer.getOrgId()))
                    .creditCode(dto.getCreditCode())
                    .orgName(dto.getOrgName())
                    .legalName(dto.getLegalName())
                    .build());

            // - 更新cs_address表的省份信息
            customerSyncCreditApi.updateOrgAddress(StoreReqDto.builder()
                            .province(dto.getProvince())
                            .provinceCode(dto.getProvinceCode())
                            .city(dto.getCity())
                            .cityCode(dto.getCityCode())
                            .district(dto.getDistrict())
                            .districtCode(dto.getDistrictCode())
                    .build(), customer.getOrgId());
        }
    }

    private String getStoreAreaCodeByName(String name, String parentCode, String level) {
        log.info("根据区域名称获取区域code参数 ==> 区域名称: {}; 区域parentCode {}; level {}", name, parentCode, level);
        if (parentCode == null) {
            return null;
        }
        StoreAreaRespDto storeAreaRespDto = RestResponseHelper.extractData(storeAreaQueryApi.queryByProvince(StoreQueryProvinceReqDto.builder()
                .parentCode(parentCode)
                .level(level)
                .name(name)
                .build()));
        log.info("根据区域名称获取区域code结果 ==> 区域code: {}", storeAreaRespDto.getCode());
        return storeAreaRespDto.getCode();
    }


    @Override
    public void checkCreditByCustomerCode(CheckCreditByCustomerCodeReqDto dto) {
        //校验信用代码是否为一级经销商
        RestResponse<StoreRespDto> storeRespDtoRestResponse = storeQueryApi.queryStoreRespDtoByCreditNum(dto.getCreditCode());
        StoreRespDto storeRespDto = RestResponseHelper.extractData(storeRespDtoRestResponse);
        logger.info("药店【{}】详细信息：{}", dto.getCreditCode(), JSON.toJSONString(storeRespDto));
        if(ObjectUtil.isAllNotEmpty(storeRespDto) || storeRespDto.getId() == null){
            Assert.isTrue(
                    //不允许为大客户
                    storeRespDto.getIsCustomer().equals(IsCustomerEnum.NOT_CUSTOMER.getCode()),
                    "0001",
                    "当前信用代码为大客户!!!"
            );
            Assert.isTrue(
                    storeRespDto.getIsFirstPartner().equals(StoreIsFirstParentEnum.NOT_FIRST_PARENT.getCode()),
                    "0001",
                    "当前信用代码为一级经销商!!!"
            );
            Assert.isTrue(
                    !StoreStatusEnum.findCustomerStatus(storeRespDto.getState()).equals(CustomerStatusExtEnum.CANCEL),
                    "0001",
                    "当前信用代码已注销!!!"
            );
        }

        // 校验当前商家是否存在相同信用代码注册用户
        RestResponse<CustomerRespDto> customer = customerQueryApi2.queryCustomerByCode(dto.getCusCode());
        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customer);
        logger.info("当前校验客户信息：{}", JSON.toJSONString(customerRespDto));

        CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
        customerExtReqDto.setCreditCode(dto.getCreditCode());
        customerExtReqDto.setMerchantId(customerRespDto.getMerchantId());
        List<CustomerRespDto> customerRespDtoList = RestResponseHelper.extractData(customerDistributorsQueryApi.queryCustomerList(customerExtReqDto));
        List<String> customerCodes = customerRespDtoList.stream()
                .filter(c -> c.getType().equals(CustomerTypeEnum.RETAILER.getCode()))
                .map(CustomerRespDto::getCode)
                .filter(code -> !code.equals(dto.getCusCode())).collect(Collectors.toList());
        logger.info("校验信用代码查询客户结果集：{}", JSON.toJSONString(customerCodes));
        Assert.isTrue(
                CollectionUtils.isEmpty(customerCodes),
                "0001",
                "商家已存在该零售商客户[" + StringUtils.join(customerCodes, " | ") + "],请检查统一信用代码"
        );

        // 校验名称匹配50%
        customerExtThreeApi.computeCustomerNameRate(ComputeCustomerNameRateReqDto.builder()
                        .OrgName(dto.getOrgName())
                        .CusName(customerRespDto.getName())
                .build());
    }

    @Override
    public Void verifyCustomerByTable() {
        // 查表
        List<QueryCustomerVerifyTaskRespDto> customerVerifyTasks = RestResponseHelper.extractData(
                customerInfoApi.queryCustomerVerifyTask());
        if (customerVerifyTasks == null || customerVerifyTasks.isEmpty()) {
            return null;
        }
        // 传入参数处理
        // - 拼参数
        List<VerifyCustomerByOrgIdReqDto> verifyDtos = customerVerifyTasks.stream()
                .map(e -> VerifyCustomerByOrgIdReqDto.builder()
                        .taskId(e.getId())
                        .code(e.getCode())
                        .orgName(e.getOrgName())
                        .creditCode(e.getCreditCode())
                        .legalName(e.getLegalName())
                .build()).collect(Collectors.toList());

        // - 认证三要素
        verifyCustomerByCustomerCode(verifyDtos);

        // 回写处理结果到表
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (VerifyCustomerByOrgIdReqDto verifyDto : verifyDtos) {
            QueryCustomerVerifyTaskRespDto updateParam = QueryCustomerVerifyTaskRespDto.builder()
                    .id(verifyDto.getTaskId())
                    .verify(String.valueOf(verifyDto.isSuccess()))
                    .verifyResult(verifyDto.getMsg())
                    .processStatus(verifyDto.isSuccess() ? "1" : "0")
                    .updateTime(sdf.format(new Date()))
                    .build();
            customerInfoApi.updateVerifyTask(updateParam);
        }

        return null;
    }

}


















