/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.yundt.module.customer.api.IFileService;
import com.dtyunxi.yundt.module.customer.api.dto.request.UploadFileReqDto;
import com.dtyunxi.yundt.module.customer.api.exception.CustomerModuleExceptionCode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import javax.annotation.Resource;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fileService")
public class FileServiceImpl
implements IFileService {
    private static Logger logger = LoggerFactory.getLogger(FileServiceImpl.class);
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private OssRegistryVo ossRegistryVo;

    public String uploadFile(UploadFileReqDto reqDto) {
        long startTime1 = new Date().getTime();
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)reqDto.getFileData());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        logger.info("\u6587\u4ef6\uff1a{}\u5f00\u59cb\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668...", (Object)(this.ossRegistryVo.getEndpoint() + "/" + reqDto.getFileName()));
        try {
            this.objectStorageService.put(this.ossRegistryVo.getBucketName(), reqDto.getFileName(), (InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20oss\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BizException(CustomerModuleExceptionCode.CUSTOMER_UPLOAD_OSS_ERROR.getCode(), CustomerModuleExceptionCode.CUSTOMER_UPLOAD_OSS_ERROR.getMsg());
        }
        finally {
            try {
                long startTime2 = new Date().getTime();
                logger.info("\u6587\u4ef6\u8fdb\u884c\u6574\u7406\u5b8c\u6bd5,\u82b1\u8d39[{}]\u8c6a\u79d2", (Object)(startTime2 - startTime1));
                inputStream.close();
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38");
            }
        }
        logger.info("\u6587\u4ef6\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668\u5b8c\u6bd5,\u4e0b\u8f7d\u94fe\u63a5\uff1a{},\u4e0a\u4f20\u6587\u4ef6\u5165\u53c2\uff1a{}", (Object)(this.ossRegistryVo.getEndpoint() + "/" + reqDto.getFileName()), (Object)JSON.toJSONString((Object)reqDto));
        String downloadUrl = this.ossRegistryVo.getEndpoint() + "/" + reqDto.getFileName();
        return downloadUrl;
    }
}

