package com.dtyunxi.yundt.module.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.IMapApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MapTextRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.SettlementAccountRegisterRelationService;
import com.dtyunxi.yundt.cube.center.customer.api.IImportRecordApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizImportEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ImportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.enums.BizChannelEnum;
import com.dtyunxi.yundt.module.customer.api.enums.CompanyVerifyEnum;
import com.dtyunxi.yundt.module.customer.api.enums.DefaultSettingEnum;
import com.dtyunxi.yundt.module.customer.biz.constant.StoreConstant;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.biz.vo.StoreExportVo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.ICustomerSyncCreditApi;
import com.yx.tcbj.center.customer.api.IStoreApi;
import com.yx.tcbj.center.customer.api.dto.request.FindCustomerByCreditReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Service
public class StoreServiceImpl implements IStoreService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Resource
    private IStoreApi storeApi;

    @Resource
    private ICustomerSyncCreditApi customerSyncCreditApi;

    @Resource
    private IStoreQueryApi storeQueryApi;

    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;

    @Resource
    private IMapApi mapApi;

    @Resource
    private IContext context;

    @Resource
    private IImportRecordApi importRecordApi;

    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private SettlementAccountRegisterRelationService settlementAccountRegisterRelationService;

    AtomicInteger counter = new AtomicInteger(1);

    /**
     * 处理药店数据导入
     */
    private final ThreadPoolExecutor importExecutor = new ThreadPoolExecutor(
            Runtime.getRuntime().availableProcessors(),
            Runtime.getRuntime().availableProcessors() * 4,
            60 * 2,
            TimeUnit.SECONDS,
            new ArrayBlockingQueue<>(3, true),
            (r) -> new Thread(r, "Thread-import[" + counter.addAndGet(1) + "]"),
            new ThreadPoolExecutor.CallerRunsPolicy()
    );

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RestResponse<Void> saveOrUpdateStore(StoreReqDto reqDto) {
        logger.info("saveOrUpdateStore 请求开始 reqDto={}", JSONObject.toJSONString(reqDto));
        // 参数校验
        this.checkSaveOrUpdateStoreParam(reqDto);
        // 参数处理
        this.processSaveOrUpdateStoreParam(reqDto);

        // id不为空时，更新药店
        if (!ObjectUtils.isEmpty(reqDto.getId())) {
            logger.info("saveOrUpdateStore 入参id存在，更新药店 reqDto={}", JSONObject.toJSONString(reqDto));
            RestResponse<Void> voidRestResponse = storeApi.updateStoreBatch(Lists.newArrayList(reqDto));
            RestResponseHelper.extractData(voidRestResponse);
        }
        // id为空时，新增药店
        else {
            logger.info("saveOrUpdateStore 入参id不存在，新增药店 reqDto={}", JSONObject.toJSONString(reqDto));

            RestResponse<StoreRespDto> storeRespDtoResp = storeQueryApi.queryStoreRespDtoByCreditNum(reqDto.getSocialCreditNum());
            StoreRespDto respDto = RestResponseHelper.extractData(storeRespDtoResp);
            Assert.isTrue(!reqDto.getSocialCreditNum().equals(respDto.getSocialCreditNum()), "0003", "已存在相同信用代码药店！！！");

            RestResponse<Void> voidRestResponse = storeApi.addStore(reqDto);
            RestResponseHelper.extractData(voidRestResponse);
        }

        // 更新药店后的关联表/字段处理
        this.processSaveOrUpdateStoreRelation(reqDto);

        logger.info("saveOrUpdateStore 请求结束 reqDto={}", JSONObject.toJSONString(reqDto));
        return RestResponse.VOID;
    }

    private void processSaveOrUpdateStoreParam(StoreReqDto reqDto) {
        logger.info("saveOrUpdateStore 参数处理开始 reqDto={}", JSONObject.toJSONString(reqDto));

        //社会信用代码 全部转大写 剔除前后空格
        reqDto.setSocialCreditNum(reqDto.getSocialCreditNum().trim().toUpperCase(Locale.ROOT));

        //处理药店经纬度。 根据药店省市区+地址，从高德地图api获取经纬度，set到请求参数中
        StoreExportVo storeExportVo = new StoreExportVo();
        CubeBeanUtils.copyProperties(storeExportVo, reqDto);
        this.extractedAddress(storeExportVo);
        reqDto.setLog(storeExportVo.getLog());
        reqDto.setLat(storeExportVo.getLat());

        logger.info("saveOrUpdateStore 参数处理结束 reqDto={}", JSONObject.toJSONString(reqDto));
    }

    private void processSaveOrUpdateStoreRelation(StoreReqDto reqDto) {
        logger.info("saveOrUpdateStore 更新药店后的关联表/字段处理开始 reqDto={}", JSONObject.toJSONString(reqDto));

        // 同步小b状态。  药店状态有更改时，同步转换后的状态到小b(小b需为启用、注销状态)
        logger.info("同步药店状态到小b客户状态 reqDto={}", reqDto);
        applicationContext.getBean(IStoreService.class).syncStoreState2Customer(reqDto);

        // 关联历史信用代码。  关联store的旧信用代码时，查询旧信用代码对应的customer-小b，同步store表的新信用代码及其他字段到customer-小b
        if(StringUtils.isNotEmpty(reqDto.getOldSocialCreditNum())){// todo test 新增药店时，选择旧社会信用代码会怎么样？
            logger.info("同步store的新信用代码及其他字段到该小b零售商 reqDto={}", JSONObject.toJSONString(reqDto));
            RestResponseHelper.extractData(customerSyncCreditApi.syncStoreNewCredit2Customer(reqDto));
        }

        // - 关联上级门店字段。 是否大客户、屏蔽业务线、客户系统类型、经营模式、上级门店名称
        //   传入的修改内容也会被覆盖，以上级为准
        this.processParentStoreInfo(reqDto);

        logger.info("saveOrUpdateStore 更新药店后的关联表/字段处理结束 reqDto={}", JSONObject.toJSONString(reqDto));
    }

    private void processParentStoreInfo(StoreReqDto reqDto) {
        // -- 更新药店时，若当前门店(上级门店)存在下级门店，则用当前药店的数据，同步覆盖所有的下级门店。
        logger.info("更新药店时，若当前门店(上级门店)存在下级门店，则用当前药店的数据，同步覆盖所有的下级门店。 reqDto={}", JSONObject.toJSONString(reqDto));
        // 获取当前修改门店的下级门店
        List<StoreRespDto> subStoreRespDtos = RestResponseHelper.extractData(storeQueryApi.queryStoreByParentSocialCreditNum(reqDto.getSocialCreditNum()));
        if(subStoreRespDtos != null && !subStoreRespDtos.isEmpty()){
            //当前门店(上级门店)的所有下级门店，都要从上级门店同步下面这些字段
            for (StoreRespDto subStoreDto : subStoreRespDtos) {
                StoreReqDto updateStoreReqDto = new StoreReqDto();

                // update条件 查询到的下级门店store_id
                updateStoreReqDto.setStoreId(subStoreDto.getStoreId());
                // update字段
                updateStoreReqDto.setIsCustomer(reqDto.getIsCustomer());//是否大客户
                updateStoreReqDto.setBizChannel(reqDto.getBizChannel());//屏蔽业务线
                updateStoreReqDto.setCustomerSystem(reqDto.getCustomerSystem());//客户系统类型
                updateStoreReqDto.setBusinessPattern(reqDto.getBusinessPattern());//经营模式
                updateStoreReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());// 是否业务处理标识。此处下级门店被关联修改 设置为是
                updateStoreReqDto.setUpdatePerson(context.userName());

                //update cs_store set col = 'col' where store_id = 'xxx'
                logger.info("更新下级门店 updateStoreReqDto={}", JSONObject.toJSONString(updateStoreReqDto));
                storeApi.updateStore(updateStoreReqDto);
            }
        }

        // -- 更新药店时，若当前药店(下级门店)存在上级门店，则用上级门店的数据，覆盖该下级门店。
        logger.info("更新药店时，若当前药店(下级门店)存在上级门店，则用上级门店的数据，覆盖该下级门店。 reqDto={}", JSONObject.toJSONString(reqDto));
        // 获取当前修改门店的上级门店（若存在）
        if(StringUtils.isBlank(reqDto.getParentSocialCreditNum())){
            return;
        }
        List<StoreRespDto> parentStoreRespDtos = RestResponseHelper.extractData(storeQueryApi.querySocialCreditNums(Lists.newArrayList(reqDto.getParentSocialCreditNum())));
        if(parentStoreRespDtos != null && !parentStoreRespDtos.isEmpty()){
            //该上级门店的所有下级门店，都要从上级门店同步下面这些字段
            StoreRespDto parentStore = parentStoreRespDtos.get(0);
            StoreReqDto updateStoreReqDto = new StoreReqDto();

            // update条件 传入的social_credit_num
            updateStoreReqDto.setSocialCreditNum(reqDto.getSocialCreditNum());
            // update字段
            updateStoreReqDto.setIsCustomer(parentStore.getIsCustomer());//是否大客户
            updateStoreReqDto.setBizChannel(parentStore.getBizChannel());//屏蔽业务线
            updateStoreReqDto.setCustomerSystem(parentStore.getCustomerSystem());//客户系统类型
            updateStoreReqDto.setBusinessPattern(parentStore.getBusinessPattern());//经营模式
            updateStoreReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());// 是否业务处理标识。此处下级门店被关联修改 设置为是
            updateStoreReqDto.setUpdatePerson(context.userName());

            //update cs_store set col = 'col' where social_credit_num = 'xxx'
            logger.info("用上级门店数据覆盖当前门店 updateStoreReqDto={}", JSONObject.toJSONString(updateStoreReqDto));
            storeApi.updateStore(updateStoreReqDto);
        }
    }

    private void checkSaveOrUpdateStoreParam(StoreReqDto reqDto) {
        logger.info("saveOrUpdateStore 参数校验 reqDto={}", JSONObject.toJSONString(reqDto));

        // 校验：若存在上级门店，则[是否大客户]、[客户系统类型]、[屏蔽业务线]字段需与上级门店保持一致
        // 取消校验，你都要从上级同步过来了，还校验个球
//        this.checkParentParam(reqDto);

        // 校验：若关联旧信用代码，则需判断当前信用代码(新)对旧代码对应的小b是否可用。
        this.checkSyncStoreInfo2Customer(reqDto);
    }

    private void checkParentParam(StoreReqDto reqDto) {
        if (StringUtils.isBlank(reqDto.getParentSocialCreditNum())) {
            return;
        }
        // 查询上级门店
        RestResponse<StoreRespDto> storeRespDtoRestResponse = storeQueryApi.queryStoreRespDtoByCreditNum(reqDto.getParentSocialCreditNum());
        StoreRespDto storeRespDto = RestResponseHelper.extractData(storeRespDtoRestResponse);
        Assert.isTrue(!ObjectUtils.isEmpty(storeRespDto), "0001", "当前上级门店不存在！！！");
        logger.info("当前门店{}上级门店详细信息：{}", StringUtils.defaultString(reqDto.getStoreName(), ""), JSON.toJSONString(storeRespDto));
        // 参数校验
        Assert.isTrue(storeRespDto.getIsCustomer().equals(reqDto.getIsCustomer()),
                "0002", "与当前上级[是否大客户]类型不一致，无法变更当前门店[是否大客户]类型");
        Assert.isTrue(storeRespDto.getCustomerSystem().equals(reqDto.getCustomerSystem()),
                "0002", "与当前上级[客户系统类型]类型不一致，无法变更当前门店[客户系统类型]类型");
        Assert.isTrue(storeRespDto.getBizChannel().equals(reqDto.getBizChannel()),
                "0002", "与当前上级[屏蔽业务线]类型不一致，无法变更当前门店[屏蔽业务线]类型");
    }

    /**
     *
     */
    private void checkSyncStoreInfo2Customer(StoreReqDto reqDto) {
//        if(ObjectUtils.isEmpty(reqDto.getId()) || StringUtils.isEmpty(reqDto.getOldSocialCreditNum())){
//            return;
//        }
        if(StringUtils.isEmpty(reqDto.getOldSocialCreditNum())){// todo test 新增药店时，选择旧社会信用代码会怎么样？
            return;
        }

        //校验: 关联旧信用代码不能与当前信用代码相同
        if(reqDto.getOldSocialCreditNum().equals(reqDto.getSocialCreditNum())){
            throw new BizException("关联旧信用代码不能与当前信用代码相同");
        }

        //校验一: 校验新药店的三要素
        CompanyVerifyReqDto CompanyVerifyReqDto = new CompanyVerifyReqDto();
        CompanyVerifyReqDto.setCode(reqDto.getSocialCreditNum());
        CompanyVerifyReqDto.setName(reqDto.getStoreName());
        CompanyVerifyReqDto.setLegalPersonName(reqDto.getLegalPersonName());
        //ICustomerExtService、IStoreService会循环依赖
        CompanyVerifyRespDto companyVerifyRespDto = applicationContext.getBean(ICustomerExtService.class)
                .verifyCompany(CompanyVerifyReqDto);//需同步返回错误信息，不能异步
        if(!Objects.equals(companyVerifyRespDto.getResult(), CompanyVerifyEnum.SUCCESS.getCode())){
            throw new BizException(companyVerifyRespDto.getRemark());
        }

        //校验二: 客商中心修改保存前调取查验是否存在进件账户，在进件的情况下社会信用代码不允许修改
        checkCreditCodeChangeByCredit(reqDto.getOldSocialCreditNum());

        //校验三: 见customerSyncCreditApi.syncStoreNewCredit2Customer
        // - 校验同一商户是否已存在零售商。
        // - 名称50%匹配校验
    }

    private void checkCreditCodeChangeByCredit(String oldSocialCreditNum) {
        List<CustomerRespDto> CustomerRespDtos = RestResponseHelper.extractData(customerSyncCreditApi.findCustomerByCredit(FindCustomerByCreditReqDto.builder()
                .socialCreditNum(oldSocialCreditNum)
                .customerType(CustomerTypeEnum.RETAILER.getCode())
                .build()));

        if(CustomerRespDtos == null || CustomerRespDtos.isEmpty()){
            logger.info("check 同步全量库药店状态(转换后)到小b零售商 CustomerRespDtos == null. end");
            return;
        }
        for (CustomerRespDto customerRespDto : CustomerRespDtos) {
            // 客商中心修改保存前调取查验是否存在进件账户，在进件的情况下社会信用代码不允许修改
            // 原校验接口 settlementAccountRegisterRelation/checkCreditCodeChage  这个change就是原来打错了，就这样用吧。
            //  warn: customerDto.getId() 能拿到customer表的id，但customerDto.getCustomerId()就是空的
            settlementAccountRegisterRelationService.checkCreditCodeChage(customerRespDto.getId(),null,oldSocialCreditNum);
        }
    }

    @Async
    @Override
    public void syncStoreState2Customer(StoreReqDto reqDto){
        //药店状态有更改时，同步转换后的状态到小b(小b需为启用、注销状态)
        logger.info("药店状态有更改时，同步转换后的状态到小b(小b需为启用、注销状态) reqDto={}", JSON.toJSONString(reqDto));
        RestResponseHelper.extractData(customerSyncCreditApi.syncStoreState2Customer(reqDto));
    }

    @Async
    @Override
    public void syncStoreState2CustomerBatch(List<StoreReqDto> reqDtos){
        //药店状态有更改时，同步转换后的状态到小b(小b需为启用、注销状态)
        logger.info("药店状态有更改时，同步转换后的状态到小b(小b需为启用、注销状态) reqDto={}", JSON.toJSONString(reqDtos));
        for (StoreReqDto reqDto : reqDtos) {
            RestResponseHelper.extractData(customerSyncCreditApi.syncStoreState2Customer(reqDto));
        }
    }

    /**
     * 解析药店地址经纬度
     *
     * @param storeExportVo
     */
    private void extractedAddress(StoreExportVo storeExportVo) {
        StringBuffer storeParesAddress = new StringBuffer(StringUtils.defaultString(storeExportVo.getProvince(), ""));
        storeParesAddress.append(StringUtils.defaultString(storeExportVo.getCity(), ""))
                .append(StringUtils.defaultString(storeExportVo.getDistrict(), ""))
                .append(StringUtils.defaultString(storeExportVo.getStoreAddr(), ""));
        RestResponse<MapTextRespDto> mapRespDtoRestResponse = mapApi.parserText(storeParesAddress.toString());
        MapTextRespDto mapTextRespDto = RestResponseHelper.extractData(mapRespDtoRestResponse);
        if (ObjectUtils.isNotEmpty(mapTextRespDto)) {
            logger.info("【高德地图】获取门店详细地址经纬度 response : {}", JSON.toJSONString(mapTextRespDto));
            if (CollectionUtils.isNotEmpty(mapTextRespDto.getPois())) {
                MapTextRespDto.Pois pois = mapTextRespDto.getPois().stream().findFirst().get();
                //地址经纬度
                List<String> location = Arrays.asList(pois.getLocation().split(","));
                storeExportVo.setLog(location.stream().findFirst().get());
                storeExportVo.setLat(location.stream().skip(location.size() - 1).findFirst().get());
            }
        }
    }

    /**
     * 处理药店区域数据
     *
     * @param reqDto
     * @param storeAreaRespDtos
     */
    private void extractedArea(StoreExportVo reqDto, List<StoreAreaRespDto> storeAreaRespDtos) {
        StoreAreaRespDto province = !StringUtils.isNotBlank(reqDto.getProvince()) ? null : this.getStoreAreaRespDtos(reqDto.getProvince(), storeAreaRespDtos);

        StoreAreaRespDto city = !StringUtils.isNotBlank(reqDto.getCity()) ? null : this.getStoreAreaRespDtos(reqDto.getCity(),
                ObjectUtils.isEmpty(province) ? Lists.newArrayList() : province.getChildren());

        StoreAreaRespDto district = !StringUtils.isNotBlank(reqDto.getDistrict()) ? null : this.getStoreAreaRespDtos(reqDto.getDistrict(),
                ObjectUtils.isEmpty(city) ? Lists.newArrayList() : city.getChildren());

        //设置区域信息
        reqDto.setProvinceCode(ObjectUtils.isEmpty(province) ? "" : province.getCode());
        reqDto.setProvince(ObjectUtils.isEmpty(province) ? reqDto.getProvince() : province.getName());

        reqDto.setCityCode(ObjectUtils.isEmpty(city) ? "" : city.getCode());
        reqDto.setCity(ObjectUtils.isEmpty(city) ? reqDto.getCity() : city.getName());

        //特殊处理当区域信息不存在区域信息
        if (!ObjectUtils.isEmpty(city) && CollectionUtils.isEmpty(city.getChildren())) {
            reqDto.setDistrictCode("-");
            reqDto.setDistrict("-");
        } else {
            reqDto.setDistrictCode(ObjectUtils.isEmpty(district) ? "" : district.getCode());
            reqDto.setDistrict(ObjectUtils.isEmpty(district) ? reqDto.getDistrict() : district.getName());
        }
    }

    private StoreAreaRespDto getStoreAreaRespDtos(String name, List<StoreAreaRespDto> storeAreaRespDtos) {
        if (CollectionUtils.isNotEmpty(storeAreaRespDtos)) {
            List<StoreAreaRespDto> collect = storeAreaRespDtos.stream().filter(c -> name.indexOf(c.getName()) != -1).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                return collect.stream().findFirst().get();
            }
        }
        return null;
    }


    /**
     * @param storeExportVos
     * @param parentStoreExportList
     */
    private void getParentStore(List<StoreExportVo> storeExportVos, Map<String, StoreExportVo> parentStoreExportList) {
        if (CollectionUtils.isNotEmpty(storeExportVos)) {
            for (StoreExportVo storeExportVo : storeExportVos) {
                List<StoreExportVo> children = storeExportVo.getChildren();
                StoreExportVo orDefault = parentStoreExportList.getOrDefault(storeExportVo.getSocialCreditNum(), null);
                if (null != orDefault) {
                    parentStoreExportList.remove(storeExportVo.getSocialCreditNum());
                    children.add(orDefault);
                    getParentStore(storeExportVo.getChildren(), parentStoreExportList);
                    storeExportVo.setChildren(children);
                }

            }
        }
    }

    /**
     * 取子集数据
     *
     * @param parentStoreExportVo
     * @param storeExportList
     */
    public void returnStore(List<StoreExportVo> parentStoreExportVo, List<StoreExportVo> storeExportList) {
        if (CollectionUtils.isNotEmpty(parentStoreExportVo)) {
            for (StoreExportVo storeExportVo : parentStoreExportVo) {
                storeExportList.addAll(storeExportVo.getChildren());
                returnStore(storeExportVo.getChildren(), storeExportList);
            }
        }
    }

    @Override
    public RestResponse<Void> saveOrUpdateStoreByExcel(MultipartFile file) {
        ImportRecordReqDto importRecordReqDto = new ImportRecordReqDto();
        importRecordReqDto.setCode(BizImportEnum.STORE_IMPORT.getCode());
        importRecordReqDto.setName(BizImportEnum.STORE_IMPORT.getImportName());
        importRecordReqDto.setStatus(ImportStatusEnum.LOADING.getCode());
        Long recordId = RestResponseHelper.extractData(importRecordApi.addImportRecord(importRecordReqDto));

        CompletableFuture.runAsync(() -> {
            ImportParams importParams = new ImportParams();
            importParams.setHeadRows(1);
            importParams.setTitleRows(0);
            importRecordReqDto.setId(recordId);
            try {
                ExcelImportResult<StoreExportVo> result = ExcelImportUtil.importExcelMore(file.getInputStream(), StoreExportVo.class, importParams);
                List<StoreExportVo> list = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
                if (!CollectionUtils.isNotEmpty(list)) {
                    importRecordReqDto.setStatus(ImportStatusEnum.EMPTY.getCode());
                } else {
                    List<StoreExportVo> notLegalList = Lists.newArrayList();
                    if (CollectionUtils.isNotEmpty(list)) {
                        //去重
                        Map<String, StoreExportVo> storeExportMap = list.stream().collect(Collectors.toMap(StoreExportVo::getSocialCreditNum, val -> val, (v1, v2) -> v1));

                        //校验处理数据
                        List<StoreExportVo> storeExportVoResult = verifyStoreExport(Lists.newArrayList(storeExportMap.values()));
                        List<StoreExportVo> legalList = storeExportVoResult.stream().filter(storeExportVo -> !StringUtils.isNotBlank(storeExportVo.getReason())).collect(Collectors.toList());
                        notLegalList.addAll(storeExportVoResult.stream().filter(storeExportVo -> StringUtils.isNotBlank(storeExportVo.getReason())).collect(Collectors.toList()));
                        //校验并处理药店信息以及区分新增修改数据
                        getStoreRespDtos(legalList, context.userName());
                    }
                    importRecordReqDto.setStatus(!ObjectUtils.isEmpty(notLegalList) ? ImportStatusEnum.ERROR.getCode() : ImportStatusEnum.SUCCESS.getCode());
                    importRecordReqDto.setImportDesc(String.format(BizImportEnum.STORE_IMPORT.getDescModel(), file.getOriginalFilename(), list.size(), notLegalList.size(), list.size() - notLegalList.size()));
                    if (!ObjectUtils.isEmpty(notLegalList)) {
                        String excelName = "cube/" + "导入药店数据失败文件_" + DateUtil.getDateFormat(new Date(), "yyyyMMddHHmmss");
                        importRecordReqDto.setErrorUrl(EasyPoiExportUtil.getExportUrl(notLegalList, StoreExportVo.class, (String) null, excelName, "xls"));
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
                importRecordReqDto.setStatus(ImportStatusEnum.ERROR.getCode());
                importRecordReqDto.setImportDesc("药店数据导入失败，系统异常：" + e.getMessage());
            }
            RestResponseHelper.extractData(importRecordApi.modifyImportRecord(importRecordReqDto));
        }, importExecutor);
        return RestResponse.SUCCESS;
    }

    /**
     * 处理导入药店数据补充信息
     *
     * @param list
     * @param userName 触发人
     */
    private void getStoreRespDtos(List<StoreExportVo> list, String userName) {
        if(userName == null || userName.isEmpty()){
            userName = "updateByExcel";//异步处理 导入等
        }
        String finalUserName = userName;
        logger.info("【{}】触发分批处理药店数据导入 count:{},content:{}", userName, list.size(), JSON.toJSONString(list));
        //校验导入数据

        List<StoreReqDto> storeReqDtoList = list.stream().map(c -> {
            StoreReqDto storeReqDto = new StoreReqDto();
            CubeBeanUtils.copyProperties(storeReqDto, c);
            return storeReqDto;
        }).collect(Collectors.toList());

        Map<String, StoreReqDto> storeExportMap = storeReqDtoList.stream().collect(Collectors.toMap(StoreReqDto::getSocialCreditNum, c -> c, (k1, k2) -> k1));

        //查询导入药店数据区分药店数据
        List<String> creditNumLists = Lists.newArrayList(storeExportMap.keySet());
        RestResponse<List<StoreRespDto>> listRestResponse = storeQueryApi.querySocialCreditNums(creditNumLists);
        List<StoreRespDto> storeRespDtoList = RestResponseHelper.extractData(listRestResponse);

        Map<String, StoreRespDto> storeRespDtoMap = storeRespDtoList.stream().collect(
                Collectors.toMap(k -> k.getSocialCreditNum().toUpperCase(Locale.ROOT), val -> val, (k1, k2) -> k2));

        //过滤新增数据
        List<String> creditNumExit = storeRespDtoList.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
        creditNumLists.removeAll(creditNumExit);
        logger.info("分批导入药店新增药店信用代码：{}", JSON.toJSONString(creditNumLists));



        if(CollectionUtils.isNotEmpty(creditNumLists)){
            List<StoreReqDto> notExitList = creditNumLists.stream().map(c -> {
                StoreReqDto storeReqDto = storeExportMap.get(c);
                storeReqDto.setCreatePerson(finalUserName);
                //默认变更大写
                storeReqDto.setSocialCreditNum(storeReqDto.getSocialCreditNum().toUpperCase(Locale.ROOT));

                // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
                storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());

                //药店表数据来源: 手动录入（包含导入）
                storeReqDto.setDataOrigin(StoreDataOriginEnum.MANUALLY_ENTER.getCode());

                return storeReqDto;
            }).collect(Collectors.toList());

            logger.info("门店新增数据：{}",JSON.toJSONString(notExitList));
            if (CollectionUtils.isNotEmpty(notExitList)) {
                storeApi.addStoreBatch(notExitList);
            }
        }

        if(CollectionUtils.isNotEmpty(creditNumExit)){
            List<StoreReqDto> isExitList = creditNumExit.stream().map(c -> {
                StoreReqDto storeReqDto = storeExportMap.get(c);
                storeReqDto.setUpdatePerson(finalUserName);
                //默认变更大写
                String socialCreditNum = storeReqDto.getSocialCreditNum().toUpperCase(Locale.ROOT);
                storeReqDto.setSocialCreditNum(socialCreditNum);
                StoreRespDto orDefault = storeRespDtoMap.getOrDefault(socialCreditNum, null);
                storeReqDto.setStoreId(ObjectUtils.isNotEmpty(orDefault) ? orDefault.getStoreId() : "");

                // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
                storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
                return storeReqDto;
            }).collect(Collectors.toList());

            logger.info("门店更新数据：{}",JSON.toJSONString(isExitList));
            if (CollectionUtils.isNotEmpty(isExitList)) {
                //批量修改企业信息
                storeApi.updateStoreBatch(isExitList);
                //根据批量修改的药店的状态，同步客户的启用禁用状态
                applicationContext.getBean(IStoreService.class).syncStoreState2CustomerBatch(isExitList);//异步提升效率 传入社会信用代码，状态。
            }
        }

        //直接按照导入的数据为大客户的更新
        List<StoreReqDto> collect = storeReqDtoList.stream().filter(c ->
                StoreConstant.IS_CUSTOMER.equals(c.getIsCustomer())).collect(Collectors.toList());
        collect.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setIsCustomer(StoreConstant.IS_CUSTOMER);
            storeReq.setUpdatePerson(finalUserName);
            // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            storeApi.updateStore(storeReq);
        });

        //获取所有上级门店
        List<String> parentSocialCreditNumList = storeReqDtoList.stream()
                .map(c -> c.getParentSocialCreditNum())
                .filter(c -> StringUtils.isNotBlank(c))
                .distinct()
                .collect(Collectors.toList());

        List<StoreRespDto> storeRespDtos = RestResponseHelper.extractData(storeQueryApi.querySocialCreditNums(parentSocialCreditNumList));
        storeRespDtos.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setCustomerSystem(c.getCustomerSystem());
            storeReq.setBusinessPattern(c.getBusinessPattern());
            storeReq.setBizChannel(c.getBizChannel());
            storeReq.setUpdatePerson(finalUserName);
            // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            storeApi.updateStore(storeReq);
        });


        //客户系统类型以及经营模式跟随上级变更
        storeReqDtoList.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setCustomerSystem(c.getCustomerSystem());
            storeReq.setBusinessPattern(c.getBusinessPattern());
            storeReq.setBizChannel(c.getBizChannel());
            storeReq.setUpdatePerson(finalUserName);
            // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            storeApi.updateStore(storeReq);
        });
    }

    /**
     * 校验导入数据并解析
     *
     * @param list
     * @return
     */
    private List<StoreExportVo> verifyStoreExport(List<StoreExportVo> list) {
        Map<String, StoreExportVo> collect = list.stream().collect(Collectors.toMap(StoreExportVo::getSocialCreditNum, c -> c, (key1, key2) -> key2));
        for (StoreExportVo c : list) {
            //校验当前门店类型与上级门店是否大客户类型
            if (StringUtils.isNotBlank(c.getParentSocialCreditNum())) {
                StoreExportVo orDefault = collect.getOrDefault(c.getParentSocialCreditNum(), null);
                if (null == orDefault) {
                    RestResponse<StoreRespDto> storeRespDtoRestResponse = storeQueryApi.queryStoreRespDtoByCreditNum(c.getParentSocialCreditNum());
                    StoreRespDto storeRespDto = RestResponseHelper.extractData(storeRespDtoRestResponse);
                    logger.info("当前父级门店信息：{}", JSON.toJSONString(storeRespDto));
                    if (BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
                        c.setReason("不存在当前上级门店");
                        continue;
                    }
                }
            }

            //标识当前导入填写了 解析省市区
            if (StringUtils.isNotBlank(c.getProvince()) || StringUtils.isNotBlank(c.getDistrict()) || StringUtils.isNotBlank(c.getCity())) {
                //区域信息
                List<StoreAreaRespDto> storeAreaRespDtos = RestResponseHelper.extractData(storeAreaQueryApi.queryTree());
                this.extractedArea(c, storeAreaRespDtos);
                if (!StringUtils.isNotBlank(c.getProvinceCode()) || !StringUtils.isNotBlank(c.getDistrictCode()) || !StringUtils.isNotBlank(c.getCityCode())) {
                    c.setReason("省市区解析异常");
                    continue;
                }
            }

            //解析地址
            /** 20230110 当导入经纬度已填写时，无需自动解析获取经纬度 **/
            if (StringUtils.isNotBlank(c.getStoreAddr()) && StringUtils.isAllBlank(c.getLog()) && StringUtils.isAllBlank(c.getLat())) {
                this.extractedAddress(c);
                if (!StringUtils.isNotBlank(c.getLog()) || !StringUtils.isNotBlank(c.getLat())) {
                    c.setReason("经纬度解析异常");
                    continue;
                }
            }

            //excel导入解析   客户为大客户并且屏蔽业务线不为空时，则解析
            if (StringUtils.isNotBlank(c.getBizChannel()) && c.getIsCustomer().equals(IsCustomerEnum.IS_CUSTOMER.getCode())) {
                //处理业务线转化
                List<String> bizChannel = Arrays.asList(c.getBizChannel().split("\\+"));
                if (ObjectUtils.isNotEmpty(bizChannel)) {
                    List<String> bizChannelCodes = bizChannel.stream().map(biz -> BizChannelEnum.fromName(biz).getCode()).collect(Collectors.toList());
                    c.setBizChannel(StringUtils.join(bizChannelCodes,","));
                }
            }

            //导入字段非空校验
            if (StringUtils.isBlank(c.getStoreName())) {
                c.setReason("* 药店名称（公司名称）不能为空");
                continue;
            }
            if (StringUtils.isBlank(c.getSocialCreditNum())) {
                c.setReason("* 统一社会信用代码不能为空");
                continue;
            }
            if (StringUtils.isBlank(c.getStoreType())) {
                c.setReason("* 机构类型不能为空");
                continue;
            }
            if (StringUtils.isBlank(c.getProvince())) {
                c.setReason("* 机构所属省份不能为空");
                continue;
            }
            if (StringUtils.isBlank(c.getCity())) {
                c.setReason("* 机构所属城市不能为空");
                continue;
            }
            if (StringUtils.isBlank(c.getDistrict())) {
                c.setReason("* 机构所属区县不能为空");
                continue;
            }
            if (StringUtils.isBlank(c.getStoreAddr())) {
                c.setReason("* 机构详细地址不能为空");
                continue;
            }
            if (StringUtils.isBlank(c.getState())) {
                c.setReason("* 状态不能为空");
                continue;
            }
            if (StringUtils.isBlank(c.getLegalPersonName())) {
                c.setReason("* 法人不能为空");
                continue;
            }
            if (c.getIsFlag() == null) {
                c.setReason("* 是否信用代码注册不能为空");
                continue;
            }

            if(!StringUtils.isBlank(c.getStoreType())){
                List<String> validStoreTypes = Arrays.asList(
                        "经销商",
                        "单体药店",
                        "连锁总部",
                        "连锁门店",
                        "连锁加盟店",
                        "第三终端",
                        "连锁旗舰店",
                        "其他"
                );
                if (!validStoreTypes.contains(c.getStoreType())) {
                    c.setReason("无效的机构类型: " + c.getStoreType());
                    continue;
                }
            }

            if(!StringUtils.isBlank(c.getState())){
                List<String> validStoreTypes = Arrays.asList(
                        "存续",
                        "注销",
                        "正常",
                        "在业"
                );
                if (!validStoreTypes.contains(c.getState())) {
                    c.setReason("无效的状态: " + c.getState());
                    continue;
                }
            }

            // trim
            if (!StringUtils.isBlank(c.getStoreName())) {
                c.setStoreName(c.getStoreName().trim());
            }
            if (!StringUtils.isBlank(c.getSocialCreditNum())) {
                c.setSocialCreditNum(c.getSocialCreditNum().trim());
            }

        }
        return list;
    }
}
